/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMBillBaseInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.BizReplyBillInfo;
import com.kingdee.eas.fm.ecore.BusinessNotificationCollection;
import com.kingdee.eas.fm.ecore.DishonorCodeEnum;
import com.kingdee.eas.fm.ecore.DraftReplyTypeEnum;
import com.kingdee.eas.fm.ecore.ECoreQueryServiceFacadeFactory;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ProxySignatureEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.SignUpEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftSignUpCollection;
import com.kingdee.eas.fm.edrafent.DraftSignUpFactory;
import com.kingdee.eas.fm.edrafent.DraftSignUpInfo;
import com.kingdee.eas.fm.edrafent.EdrafBillException;
import com.kingdee.eas.fm.edrafent.IDraftSignUp;
import com.kingdee.eas.fm.edrafent.OperatStatusEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftSignUpControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftSignUpControllerBean
extends AbstractDraftSignUpControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftSignUpControllerBean");

    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    protected void _commitECDS(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._commitECDS(ctx, model);
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("commercialDraft.*");
        sic.add("replyBankNumber.*");
        sic.add("replyBank.*");
        sic.add("replyAccount.*");
        sic.add("replyName.*");
        return sic;
    }

    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DraftSignUpInfo billInfo = (DraftSignUpInfo)model;
        BizReplyBillInfo bizReplyBillInfo = new BizReplyBillInfo();
        bizReplyBillInfo.setNumber(billInfo.getNumber());
        CommercialDraftInfo commDraft = billInfo.getCommercialDraft();
        bizReplyBillInfo.setDraftNumber(commDraft.getDraftNumber());
        bizReplyBillInfo.setDraftAmount(commDraft.getDraftAmount());
        if (billInfo.isClientSgntr()) {
            bizReplyBillInfo.setProxySignature(ProxySignatureEnum.PS01);
        } else {
            bizReplyBillInfo.setProxySignature(ProxySignatureEnum.PS00);
        }
        bizReplyBillInfo.setReplyRemark(billInfo.getReplyRemark());
        bizReplyBillInfo.setReplyDate(ECoreQueryServiceFacadeFactory.getLocalInstance((Context)ctx).getSystemDate());
        if (billInfo.getReplyAttitude().getValue().equals("1")) {
            bizReplyBillInfo.setReplySignUp(SignUpEnum.SU00);
        } else {
            bizReplyBillInfo.setReplySignUp(SignUpEnum.SU01);
        }
        bizReplyBillInfo.setReplierRole(RoleEnum.RC01);
        bizReplyBillInfo.setReplierOrgCode(billInfo.getReplyCmonId());
        bizReplyBillInfo.setReplierElecSign("0");
        if (billInfo.getReplyAccount() == null) {
            bizReplyBillInfo.setReplierAccount("0");
        } else {
            bizReplyBillInfo.setReplierAccount(billInfo.getReplyAccount().getBankAccountNumber());
        }
        bizReplyBillInfo.setReplierBank(billInfo.getReplyBankNumber().getNumber());
        bizReplyBillInfo.setAcceptorCredit(billInfo.getCdtRatgs());
        bizReplyBillInfo.setAcceptorRater(billInfo.getCdtRatgAgcy());
        bizReplyBillInfo.setAcceptorDueDate(billInfo.getCdtRatgDueDt());
        bizReplyBillInfo.setGuarnteeAddress(billInfo.getAdr());
        if (billInfo.getAccptncAgrmtNb() != null && !"".equals(billInfo.getAccptncAgrmtNb())) {
            bizReplyBillInfo.setAgreementNumber(billInfo.getAccptncAgrmtNb());
        } else if (billInfo.getProtocolNumber() != null && !"".equals(billInfo.getProtocolNumber())) {
            bizReplyBillInfo.setAgreementNumber(billInfo.getProtocolNumber());
        }
        bizReplyBillInfo.setReplyType(billInfo.getReplyType());
        if (billInfo.getReplyType().getValue() == 24 || billInfo.getReplyType().getValue() == 25) {
            bizReplyBillInfo.setReplyType(DraftReplyTypeEnum.TIEXIAN);
        }
        if (billInfo.getReplyType().getValue() == 26 || billInfo.getReplyType().getValue() == 27) {
            bizReplyBillInfo.setReplyType(DraftReplyTypeEnum.ZHUANTIEXIAN);
        }
        bizReplyBillInfo.setUncondlPromise(billInfo.isUcondlPrmsMrk() ? "CC00" : "CC01");
        if (billInfo.getDshnrCd() != null) {
            bizReplyBillInfo.setDishonorCode(DishonorCodeEnum.getEnum((String)billInfo.getDshnrCd().getValue()));
            bizReplyBillInfo.setDishonorReason(billInfo.getReplyRemark());
        }
        bizReplyBillInfo.setId(billInfo.getId());
        bizReplyBillInfo.setBizPromoterOrgCode(billInfo.getReplyCmonId());
        BusinessNotificationCollection busCollection = ECoreQueryServiceFacadeFactory.getLocalInstance((Context)ctx).getBusinessNotionficationByOrgCode(billInfo.getReplyCmonId(), commDraft.getDraftNumber(), false, ElecDraftActionEnum.RECEIVE_WAIT_REPLY);
        bizReplyBillInfo.setOriMessageID(busCollection.get(0).getMessageID());
        bizReplyBillInfo.setOriMessageTime(busCollection.get(0).getMessageTime());
        return bizReplyBillInfo;
    }

    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.TYHF;
    }

    @Override
    public void _audit(Context ctx, Set idSet) throws BOSException, EASBizException, EdrafBillException {
        Object[] idArray;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operatStatus", (Object)OperatStatusEnum.SUBMIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftSignUpCollection billCol = DraftSignUpFactory.getLocalInstance(ctx).getDraftSignUpCollection(env);
        if (billCol.size() > 0) {
            idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
                DraftSignUpInfo draftSignUpInfo = billCol.get(i);
                this._audit4WF(ctx, (IObjectPK)new ObjectUuidPK(draftSignUpInfo.getId()), (IObjectValue)draftSignUpInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6"});
        }
        String sql = "update T_EDT_DraftSignUp set FOperatStatus=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer("2")});
    }

    @Override
    protected void _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException, EdrafBillException {
        Object[] idArray;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operatStatus", (Object)OperatStatusEnum.AUDITED, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftSignUpCollection billCol = DraftSignUpFactory.getLocalInstance(ctx).getDraftSignUpCollection(env);
        if (billCol.size() > 0) {
            idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
                DraftSignUpInfo draftSignUpInfo = billCol.get(i);
                this.unAudit4WF(ctx, (IObjectValue)draftSignUpInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6"});
        }
        String sql = "update T_EDT_DraftSignUp set FOperatStatus=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer("0")});
    }

    public void checkDraftApplyBill(IObjectValue model) throws BOSException, EASBizException {
        DraftSignUpInfo info = (DraftSignUpInfo)model;
        if (!(info.getReplyType().getValue() != 16 && info.getOperatStatus().getValue().toString().equals("2".toString()) && !info.isIsOtherCancel() || info.getOperatStatus().getValue().toString().equals(OperatStatusEnum.SUBMITEDTOBANK.toString()) && (info.getCommunicationStatus().toString().equals(ECDSCommunicationStatusEnum.SUBMIT_FAIL.toString()) || info.getCommunicationStatus().toString().equals(ECDSCommunicationStatusEnum.PROCESS_FAIL.toString())))) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\uff08\u56de\u590d\u7c7b\u578b\u4e0d\u7b49\u4e8e\u201c\u8ffd\u7d22\u901a\u77e5\u56de\u590d\u201d\uff0c\u4e14 \u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u5ba1\u6279\uff0c\u4e14\u201c\u5bf9\u65b9\u64a4\u9500\u201d\u4e3a\u5426\uff09\uff0c\u6216\uff08\u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u4eba\u884c\uff0c\u4e14\u4e0e\u4eba\u884c\u4ea4\u4e92\u7ed3\u679c\u4e3a\u63d0\u4ea4\u5931\u8d25\u3001\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff09\u7684\u7b7e\u6536\u5355\u624d\u53ef\u63d0\u4ea4\u4eba\u884c"});
        }
    }

    @Override
    protected void _draftsumbit(Context ctx, Set idSet) throws BOSException, EASBizException, EASDBException {
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operatStatus", (Object)new Integer("0"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("replyAttitude", (Object)new Integer("0"), CompareType.NOTEQUALS));
        env.setFilter(filter);
        DraftSignUpCollection col = DraftSignUpFactory.getLocalInstance(ctx).getDraftSignUpCollection(env);
        if (col.size() > 0) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                set.add(col.get(i).getId());
                super.submit(ctx, (CoreBaseInfo)col.get(i));
            }
            if (set.size() > 0) {
                String sql = "update T_EDT_DraftSignUp set FoperatStatus=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer("1")});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u5b58\u72b6\u6001\u548c\u975e\u5f85\u7b7e\u6536\u7684\u5355\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\uff01"});
        }
    }

    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection registerCol = DraftSignUpFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (registerCol == null || registerCol.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return registerCol;
    }

    protected void _audit4WF(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DraftSignUpInfo baseInfo = (DraftSignUpInfo)model;
        baseInfo.setOperatStatus(OperatStatusEnum.AUDITED);
        baseInfo.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        baseInfo.setAuditDate(new Date());
        IDraftSignUp draftSignUp = (IDraftSignUp)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(baseInfo.getBOSType());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operatStatus"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        draftSignUp.updatePartial((CoreBaseInfo)baseInfo, sic);
    }

    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected void updateBillOperateState(Context ctx, DraftApplyBillBaseInfo billInfo) throws EASBizException, BOSException {
        DraftSignUpInfo signUp = (DraftSignUpInfo)billInfo;
        signUp.setOperatStatus(OperatStatusEnum.SUBMITEDTOBANK);
        signUp.setSubmitDate(DateHelper.getTime());
        signUp.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_SUCCESS);
        signUp.setOperateState(FCOperateStateEnum.submit);
        signUp.setSubmitCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        signUp.setSubmitter(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        SelectorItemCollection sicv = new SelectorItemCollection();
        sicv.add("operatStatus");
        sicv.add("communicationStatus");
        sicv.add("operateState");
        sicv.add("submitCompany");
        sicv.add("submitter");
        DraftSignUpFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)signUp, sicv);
    }

    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            super.initInfo(ctx, model);
        }
        catch (Exception e) {
            FMBillBaseInfo info = (FMBillBaseInfo)model;
            info.setNumber("");
        }
    }

    protected void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMBillBaseInfo info = (FMBillBaseInfo)model;
        if (info.getNumber() != null || !info.getNumber().equals("")) {
            super.checkBeforeAddNew(ctx, model);
        }
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectValue model) throws BOSException {
    }

    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }
}

