/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftKindEnum;
import com.kingdee.eas.fm.edrafent.DraftStockBillCollection;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftStockBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftStockBillControllerBean
extends AbstractDraftStockBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftStockBillControllerBean");

    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        DraftStockBillInfo stockBill = (DraftStockBillInfo)model;
        if (stockBill != null && stockBill.getId() != null) {
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("draftTime"));
            selColl.add(new SelectorItemInfo("assurerAddress"));
            selColl.add(new SelectorItemInfo("assurDate"));
            selColl.add(new SelectorItemInfo("drawerBank"));
            selColl.add(new SelectorItemInfo("payeeBank"));
            selColl.add(new SelectorItemInfo("isAcceptor"));
            selColl.add(new SelectorItemInfo("contractNumber"));
            selColl.add(new SelectorItemInfo("batchNumber"));
            selColl.add(new SelectorItemInfo("isAttorn"));
            selColl.add(new SelectorItemInfo("acceptorCdtBody"));
            selColl.add(new SelectorItemInfo("acceptorCreditRat"));
            selColl.add(new SelectorItemInfo("acceptorCdtDate"));
            selColl.add(new SelectorItemInfo("assurersName"));
            selColl.add(new SelectorItemInfo("assurerAccount"));
            selColl.add(new SelectorItemInfo("assurerBankNumber"));
            selColl.add(new SelectorItemInfo("remark"));
            selColl.add(new SelectorItemInfo("draftKind"));
            selColl.add(new SelectorItemInfo("deliverName"));
            selColl.add(new SelectorItemInfo("deliverAccount"));
            selColl.add(new SelectorItemInfo("deliverBankNum"));
            selColl.add(new SelectorItemInfo("collateral"));
            selColl.add(new SelectorItemInfo("present"));
            selColl.add(new SelectorItemInfo("recourse"));
            selColl.add(new SelectorItemInfo("draftStockOperate"));
            selColl.add(new SelectorItemInfo("discount"));
            selColl.add(new SelectorItemInfo("turnDiscount"));
            selColl.add(new SelectorItemInfo("againPostedRegister"));
            selColl.add(new SelectorItemInfo("intrustCollectionRegister"));
            selColl.add(new SelectorItemInfo("sourceSignType"));
            pk = new ObjectUuidPK(stockBill.getId());
            DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockBill, selColl);
        } else {
            pk = DraftStockBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)stockBill);
        }
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DraftStockBillInfo stockBill = (DraftStockBillInfo)model;
        DraftStockBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)stockBill);
    }

    @Override
    protected Set _endorsement(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("*"));
        selColl.add(new SelectorItemInfo("holderAccount.*"));
        selColl.add(new SelectorItemInfo("holderBankNumber.*"));
        selColl.add(new SelectorItemInfo("commercialDraft.*"));
        selColl.add(new SelectorItemInfo("drawerBank.*"));
        selColl.add(new SelectorItemInfo("drawerName.*"));
        selColl.add(new SelectorItemInfo("drawerBankNumber.*"));
        envi.setSelector(selColl);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftStockBillCollection stockBillColl = this.getDraftStockBillCollection(ctx, envi);
        HashSet<DraftStockBillInfo> stockSet = new HashSet<DraftStockBillInfo>();
        for (int i = 0; i < stockBillColl.size(); ++i) {
            stockSet.add(stockBillColl.get(i));
        }
        return stockSet;
    }

    @Override
    protected boolean _isShowEndorsement(Context ctx, Set set) throws BOSException, EASBizException {
        boolean flag = false;
        Set stockBillSet = this._endorsement(ctx, set);
        Iterator iterator = stockBillSet.iterator();
        HashSet<BOSUuid> holderAccountSet = new HashSet<BOSUuid>();
        HashSet<BOSUuid> holderBankNumSet = new HashSet<BOSUuid>();
        while (iterator.hasNext()) {
            ECDSBillStatusEnum eCDSBillStatus;
            DraftStockBillInfo stockInfo = (DraftStockBillInfo)iterator.next();
            if (stockInfo.getDraftKind() == DraftKindEnum.PAPERDRAFT) {
                return false;
            }
            if (stockInfo.getHolderAccount() != null) {
                holderAccountSet.add(stockInfo.getHolderAccount().getId());
            }
            if (stockInfo.getHolderBankNumber() != null) {
                holderBankNumSet.add(stockInfo.getHolderBankNumber().getId());
            }
            if (stockInfo.getCommercialDraft().getDraftECDSStatus() == null || !(eCDSBillStatus = stockInfo.getCommercialDraft().getDraftECDSStatus()).toString().equals(ECDSBillStatusEnum.TSSPYQS.toString()) && !eCDSBillStatus.toString().equals(ECDSBillStatusEnum.BSYQS.toString()) && !eCDSBillStatus.toString().equals(ECDSBillStatusEnum.ZYJCYQS.toString()) && !eCDSBillStatus.toString().equals(ECDSBillStatusEnum.HGSTXSHYQS.toString()) || stockInfo.getDraftStockOperate().getValue() != DraftStockBillOperateEnum.REGISTER.getValue() || stockInfo.isCollateral() || stockInfo.isRecourse() || stockInfo.isPresent() || !stockInfo.isIsAttorn()) continue;
            flag = true;
        }
        if (holderAccountSet.size() > 1) {
            flag = false;
        }
        if (holderBankNumSet.size() > 1) {
            flag = false;
        }
        return flag;
    }

    @Override
    protected Set _toPromptPayment(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<DraftStockBillInfo> stockeSet = new HashSet<DraftStockBillInfo>();
        HashSet<String> hasSet = new HashSet<String>();
        hasSet.add("030006");
        hasSet.add("100006");
        hasSet.add("110106");
        hasSet.add("120006");
        hasSet.add("110218");
        hasSet.add("130106");
        hasSet.add("140006");
        hasSet.add("130218");
        hasSet.add("150106");
        hasSet.add("160006");
        hasSet.add("150218");
        hasSet.add("190006");
        hasSet.add("180020");
        hasSet.add("200512");
        hasSet.add("200412");
        hasSet.add("250006");
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("draftStockOperate", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", hasSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        env.setFilter(filter);
        env.setSelector(sic);
        DraftStockBillCollection billCol = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillCollection(env);
        if (billCol.size() > 0) {
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                int days;
                CommercialDraftInfo draftInfo;
                Date dueDate;
                DraftStockBillInfo stockInfo = billCol.get(i);
                if (stockInfo.isPresent() || stockInfo.isRecourse() || stockInfo.isCollateral() || (dueDate = (draftInfo = stockInfo.getCommercialDraft()).getDueDate()) == null || (days = (int)((new Date().getTime() - dueDate.getTime()) / 86400000L)) - 10 > 0) continue;
                stockeSet.add(stockInfo);
            }
        }
        return stockeSet;
    }

    @Override
    protected Set _discountRegister(Context ctx, Set set, String billType) throws BOSException, EASBizException {
        HashSet<DraftStockBillInfo> stockeSet = new HashSet<DraftStockBillInfo>();
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("draftStockOperate", (Object)new Integer(0), CompareType.EQUALS));
        if (billType.equals("DiscountRegisterBill")) {
            filter.getFilterItems().add(new FilterItemInfo("discount", (Object)Boolean.FALSE, CompareType.EQUALS));
        } else if (billType.equals("TransDistRegisterBill")) {
            filter.getFilterItems().add(new FilterItemInfo("turnDiscount", (Object)Boolean.FALSE, CompareType.EQUALS));
        } else if (billType.equals("ReDistRegisterBill")) {
            filter.getFilterItems().add(new FilterItemInfo("againPostedRegister", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("draftKind", (Object)new Integer(1), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accpetorAccount.*"));
        sic.add(new SelectorItemInfo("accpetorBank.*"));
        sic.add(new SelectorItemInfo("acceptorCompany.*"));
        sic.add(new SelectorItemInfo("accpetorBankNumber.*"));
        sic.add(new SelectorItemInfo("accpetorBankName.*"));
        sic.add(new SelectorItemInfo("submitCompany.*"));
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("submitter.*"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        filter.setMaskString("#0 and #1 and #2 and #3)");
        env.setFilter(filter);
        env.setSelector(sic);
        DraftStockBillCollection billCol = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillCollection(env);
        Iterator iterator = billCol.iterator();
        while (iterator.hasNext()) {
            DraftStockBillInfo stockInfo = (DraftStockBillInfo)iterator.next();
            stockeSet.add(stockInfo);
        }
        return stockeSet;
    }

    @Override
    protected Set _overdueClewPayment(Context ctx, Set idSet) throws BOSException {
        HashSet<DraftStockBillInfo> stockeSet = new HashSet<DraftStockBillInfo>();
        HashSet<ECDSBillStatusEnum> hasSet = new HashSet<ECDSBillStatusEnum>();
        hasSet.add(ECDSBillStatusEnum.TSSPYQS);
        hasSet.add(ECDSBillStatusEnum.BSYQS);
        hasSet.add(ECDSBillStatusEnum.MDSTXYQS);
        hasSet.add(ECDSBillStatusEnum.HGSTXSHYQS);
        hasSet.add(ECDSBillStatusEnum.HGSTXYYSHJZR);
        hasSet.add(ECDSBillStatusEnum.MDSZHTXYQS);
        hasSet.add(ECDSBillStatusEnum.HGSZHTXSHYQS);
        hasSet.add(ECDSBillStatusEnum.HGSZHTXYYSHJZR);
        hasSet.add(ECDSBillStatusEnum.MDSZTXYQS);
        hasSet.add(ECDSBillStatusEnum.HGSZTXSHYQS);
        hasSet.add(ECDSBillStatusEnum.HGSZTXYYSHJZR);
        hasSet.add(ECDSBillStatusEnum.ZYJCYQS);
        hasSet.add(ECDSBillStatusEnum.ZYYZPJDQR);
        hasSet.add(ECDSBillStatusEnum.TSFKYJF3);
        hasSet.add(ECDSBillStatusEnum.TSFKYJF2);
        hasSet.add(ECDSBillStatusEnum.YHMPYQS);
        hasSet.add(ECDSBillStatusEnum.YQTSFKYJF1);
        hasSet.add(ECDSBillStatusEnum.YQTSFKYJF2);
        hasSet.add(ECDSBillStatusEnum.TSFKYJF1);
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("draftStockOperate", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("present", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", hasSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("recourse", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("collateral", (Object)Boolean.FALSE, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        env.setFilter(filter);
        env.setSelector(sic);
        DraftStockBillCollection billCol = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillCollection(env);
        if (billCol.size() > 0) {
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                int days;
                DraftStockBillInfo stockInfo = billCol.get(i);
                CommercialDraftInfo draftInfo = stockInfo.getCommercialDraft();
                Date dueDate = draftInfo.getDueDate();
                if (dueDate == null || (days = (int)((new Date().getTime() - dueDate.getTime()) / 86400000L)) - 10 > 0) continue;
                stockeSet.add(stockInfo);
            }
        }
        return stockeSet;
    }

    @Override
    protected boolean _isShowRecourse(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean flag = false;
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("*"));
        selColl.add(new SelectorItemInfo("commercialDraft.draftECDSStatus"));
        DraftStockBillInfo stockInfo = this.getDraftStockBillInfo(ctx, pk, selColl);
        if (stockInfo.getDraftStockOperate() == DraftStockBillOperateEnum.REGISTER) {
            ECDSBillStatusEnum state = stockInfo.getCommercialDraft().getDraftECDSStatus();
            ArrayList<ECDSBillStatusEnum> list = new ArrayList<ECDSBillStatusEnum>();
            list.add(ECDSBillStatusEnum.TSFKYJF2);
            list.add(ECDSBillStatusEnum.TSFKYJF1);
            list.add(ECDSBillStatusEnum.YQTSFKYJF2);
            list.add(ECDSBillStatusEnum.YQTSFKYJF1);
            list.add(ECDSBillStatusEnum.JFZSDQC);
            list.add(ECDSBillStatusEnum.JFZSTYQCYQS);
            list.add(ECDSBillStatusEnum.TSSPYQS);
            list.add(ECDSBillStatusEnum.BSYQS);
            list.add(ECDSBillStatusEnum.MDSTXYQS);
            list.add(ECDSBillStatusEnum.HGSTXYQS);
            list.add(ECDSBillStatusEnum.HGSTXYZSHKFR);
            list.add(ECDSBillStatusEnum.HGSTXYYSHJZR);
            list.add(ECDSBillStatusEnum.HGSTXSHYQS);
            list.add(ECDSBillStatusEnum.MDSZHTXYQS);
            list.add(ECDSBillStatusEnum.HGSZHTXYQS);
            list.add(ECDSBillStatusEnum.HGSZHTXYZSHKFR);
            list.add(ECDSBillStatusEnum.HGSZHTXYYSHJZR);
            list.add(ECDSBillStatusEnum.HGSZHTXSHYQS);
            list.add(ECDSBillStatusEnum.MDSZTXYQS);
            list.add(ECDSBillStatusEnum.HGSZTXYQS);
            list.add(ECDSBillStatusEnum.HGSZTXYZSHKFR);
            list.add(ECDSBillStatusEnum.HGSZTXYYSHJZR);
            list.add(ECDSBillStatusEnum.HGSZTXSHYQS);
            list.add(ECDSBillStatusEnum.ZYYQS);
            list.add(ECDSBillStatusEnum.ZYJCYQS);
            list.add(ECDSBillStatusEnum.ZYYZPJDQR);
            list.add(ECDSBillStatusEnum.FJFZSYCX);
            list.add(ECDSBillStatusEnum.FJFZSDQC);
            list.add(ECDSBillStatusEnum.FJFZSTYQCYQS);
            list.add(ECDSBillStatusEnum.YHMPYQS);
            list.add(ECDSBillStatusEnum.TSFKYJF3);
            if (list.contains(state)) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected Set _collectRegister(Context ctx, Set set, String billType) throws BOSException, EASBizException {
        HashSet<DraftStockBillInfo> stockeSet = new HashSet<DraftStockBillInfo>();
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("draftStockOperate", (Object)new Integer(0), CompareType.EQUALS));
        if (billType.equals("CollectAccessionBill")) {
            filter.getFilterItems().add(new FilterItemInfo("intrustCollectionRegister", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("draftKind", (Object)new Integer(1), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accpetorAccount.*"));
        sic.add(new SelectorItemInfo("accpetorBank.*"));
        sic.add(new SelectorItemInfo("acceptorCompany.*"));
        sic.add(new SelectorItemInfo("accpetorBankNumber.*"));
        sic.add(new SelectorItemInfo("accpetorBankName.*"));
        sic.add(new SelectorItemInfo("submitCompany.*"));
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("submitter.*"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        filter.setMaskString("#0 and #1 and #2 and #3)");
        env.setFilter(filter);
        env.setSelector(sic);
        DraftStockBillCollection billCol = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillCollection(env);
        Iterator iterator = billCol.iterator();
        while (iterator.hasNext()) {
            DraftStockBillInfo stockInfo = (DraftStockBillInfo)iterator.next();
            stockeSet.add(stockInfo);
        }
        return stockeSet;
    }

    @Override
    protected Set _toRpdDiscount(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<DraftStockBillInfo> stockeSet = new HashSet<DraftStockBillInfo>();
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("draftStockOperate", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", (Object)ECDSBillStatusEnum.HGSTXYZSHKFR, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("draftKind", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        env.setFilter(filter);
        env.setSelector(sic);
        DraftStockBillCollection billCol = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillCollection(env);
        if (billCol != null && billCol.size() > 0) {
            String holderAccount = null;
            String holderBankNumber = null;
            String deliverName = null;
            String deliverAccount = null;
            String deliverBankNumber = null;
            DraftKindEnum draftKind = null;
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                DraftStockBillInfo stockInfo = billCol.get(i);
                if (draftKind == null) {
                    draftKind = stockInfo.getDraftKind();
                } else if (!draftKind.equals((Object)stockInfo.getDraftKind())) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u7968\u636e\u79cd\u7c7b\u5fc5\u987b\u76f8\u540c\uff01"});
                }
                if (stockInfo.getHolderAccount() != null) {
                    if (holderAccount == null) {
                        holderAccount = stockInfo.getHolderAccount().getBankAccountNumber();
                    } else if (!holderAccount.equals(stockInfo.getHolderAccount().getBankAccountNumber())) {
                        throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u6301\u7968\u4eba\u8d26\u53f7\u5fc5\u987b\u76f8\u540c\uff01"});
                    }
                }
                if (stockInfo.getHolderBankNumber() != null) {
                    if (holderBankNumber == null) {
                        holderBankNumber = stockInfo.getHolderBankNumber().getNumber();
                    } else if (!holderBankNumber.equals(stockInfo.getHolderBankNumber().getNumber())) {
                        throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u6301\u7968\u4eba\u5f00\u6237\u884c\u884c\u53f7\u5fc5\u987b\u76f8\u540c\uff01"});
                    }
                }
                if (deliverName == null) {
                    deliverName = stockInfo.getDeliverName();
                } else if (!deliverName.equals(stockInfo.getDeliverName())) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4ea4\u7968\u4eba\u540d\u79f0\u5fc5\u987b\u76f8\u540c\uff01"});
                }
                if (deliverAccount == null) {
                    deliverAccount = stockInfo.getDeliverAccount();
                } else if (!deliverAccount.equals(stockInfo.getDeliverAccount())) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4ea4\u7968\u4eba\u8d26\u53f7\u5fc5\u987b\u76f8\u540c\uff01"});
                }
                if (deliverBankNumber == null) {
                    deliverBankNumber = stockInfo.getDeliverBankNum();
                } else if (!deliverBankNumber.equals(stockInfo.getDeliverBankNum())) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4ea4\u7968\u4eba\u5f00\u6237\u884c\u884c\u53f7\u5fc5\u987b\u76f8\u540c\uff01"});
                }
                if (stockInfo.isPresent() || stockInfo.isRecourse() || stockInfo.isCollateral()) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u56de\u8d2d\u5f0f\u8d34\u73b0\u8d4e\u56de\u7533\u8bf7\u6761\u4ef6\uff01"});
                }
                stockeSet.add(stockInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u56de\u8d2d\u5f0f\u8d34\u73b0\u8d4e\u56de\u7533\u8bf7\u6761\u4ef6\uff01"});
        }
        return stockeSet;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        return null;
    }
}

