/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fee.BusinessFeeFactory;
import com.kingdee.eas.fm.fee.BusinessFeeInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class BusinessFeeBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        BusinessFeeInfo info = this.getBusinessFeeInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfoCredit = this.createJournalInfoAmtCredit(ctx, info);
        journalColl.add(journalInfoCredit);
        return journalColl;
    }

    private JournalInfo createJournalInfoAmtCredit(Context ctx, BusinessFeeInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getAccountBank());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(new Date());
        int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        int val104 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS104", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (val == 0) {
            if (val104 == 1) {
                journalInfo.setCreateDate(new Date());
            } else if (val104 == 0) {
                journalInfo.setCreateDate(info.getBizDate());
            }
        }
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(info.getFeeAmount());
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(info.getBizDate());
        journalInfo.setAccountView(info.getAccountBank().getAccount());
        journalInfo.setOppAccountView(info.getAccountView());
        journalInfo.setBillType(BillTypeEnum.businessFee);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        String des = "";
        if (ctx != null) {
            des = ResourceBase.getString((String)"com.kingdee.eas.fm.fee.FeeResource", (String)"feeBook", (Locale)ctx.getLocale());
        }
        journalInfo.setDescription(des);
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private BusinessFeeInfo getBusinessFeeInfo(Context ctx, String billId) throws EASBizException, BOSException {
        BusinessFeeInfo info = BusinessFeeFactory.getLocalInstance(ctx).getBusinessFeeInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accountBank.account.*");
        return sic;
    }
}

