/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee;

import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.fee.AbstractFeeTariffInfo;
import com.kingdee.eas.fm.fee.FeeTariffEntryCollection;
import com.kingdee.eas.fm.fee.FeeTariffEntryInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class FeeTariffInfo
extends AbstractFeeTariffInfo
implements Serializable {
    public FeeTariffInfo() {
    }

    protected FeeTariffInfo(String pkField) {
        super(pkField);
    }

    public void calcDeduction() {
        if (this == null || this.getEntries() == null) {
            return;
        }
        FeeTariffEntryCollection entries = this.getEntries();
        List lst = FeeTariffInfo.convertToOrderedList(entries);
        BigDecimal deduction = SysConstant.BIGZERO;
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            FeeTariffEntryInfo entryInfo = (FeeTariffEntryInfo)lst.get(i);
            if (i == 0) {
                entryInfo.setDeduction(SysConstant.BIGZERO);
                continue;
            }
            FeeTariffEntryInfo preEntry = (FeeTariffEntryInfo)lst.get(i - 1);
            deduction = preEntry.getDeduction();
            BigDecimal incrAmt = null;
            incrAmt = this.getType().getValue() == 1 ? entryInfo.getProportion().subtract(preEntry.getProportion()) : entryInfo.getCharge().subtract(preEntry.getCharge());
            deduction = deduction.add(new BigDecimal(preEntry.getLevelValue()).multiply(incrAmt));
            entryInfo.setDeduction(deduction);
        }
    }

    protected static List convertToOrderedList(FeeTariffEntryCollection entries) {
        ArrayList<FeeTariffEntryInfo> orderedList = new ArrayList<FeeTariffEntryInfo>();
        int n = entries.size();
        block0: for (int i = 0; i < n; ++i) {
            FeeTariffEntryInfo entryInfo = entries.get(i);
            BigDecimal curLevelVal = new BigDecimal(entryInfo.getLevelValue());
            if (orderedList.size() == 0 || curLevelVal == null) {
                orderedList.add(entryInfo);
                continue;
            }
            int lstSize = orderedList.size();
            for (int j = 0; j < lstSize; ++j) {
                FeeTariffEntryInfo otherEntry = (FeeTariffEntryInfo)orderedList.get(j);
                BigDecimal otherLevelVal = new BigDecimal(otherEntry.getLevelValue());
                if (otherLevelVal == null) continue;
                if (curLevelVal.compareTo(otherLevelVal) >= 0) {
                    if (j + 1 < lstSize) continue;
                    orderedList.add(entryInfo);
                    continue block0;
                }
                if (curLevelVal.compareTo(otherLevelVal) >= 0) continue;
                orderedList.add(j, entryInfo);
                continue block0;
            }
        }
        return orderedList;
    }
}

