/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.TreeMap;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fee.FeeBillCollection;
import com.kingdee.eas.fm.fee.FeeBillEntryInfo;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fee.FeeException;
import com.kingdee.eas.fm.fee.FeeJournalBookNotifyBuilder;
import com.kingdee.eas.fm.fee.FeeTariffFactory;
import com.kingdee.eas.fm.fee.FeeTariffInfo;
import com.kingdee.eas.fm.fee.FeeTariffsForBillCollection;
import com.kingdee.eas.fm.fee.FeeTariffsForBillInfo;
import com.kingdee.eas.fm.fee.FeeTypeEnum;
import com.kingdee.eas.fm.fee.app.AbstractFeeBillControllerBean;
import com.kingdee.eas.fm.fee.app.FeeCalculateHelper;
import com.kingdee.eas.fm.fee.app.FeeSubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FeeBillControllerBean
extends AbstractFeeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fee.app.FeeBillControllerBean");
    private static final String resourcePath = "com.kingdee.eas.fm.fee.FeeResource";

    private boolean checkFeeBill(Context ctx, String innerAccountId, String currencyId, Date period, FeeBillInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)innerAccountId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)DateTimeUtils.truncateDate((Date)period), CompareType.EQUALS));
        if (info != null && info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        return this.exists(ctx, filterInfo);
    }

    @Override
    protected List _calculateFeeAmounts(Context ctx, String innerAccountId, String currencyId, Date period, List feeTariffIdList) throws EASBizException, BOSException {
        ArrayList<TreeMap> feeAmountList = new ArrayList<TreeMap>();
        TreeMap map = new TreeMap();
        for (int i = 0; i < feeTariffIdList.size(); ++i) {
            String id = (String)feeTariffIdList.get(i);
            BigDecimal feeAmount = this.calculateFeeAmount(ctx, innerAccountId, currencyId, period, id);
            if (feeAmount.compareTo(Constants.ZERO) == 0) continue;
            FeeTariffInfo feeTariffInfo = (FeeTariffInfo)FeeTariffFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id), this.getFeeTariffSelector());
            String expense = feeTariffInfo.getExpenseType().toString();
            if (map.containsKey(expense)) {
                BigDecimal amount = (BigDecimal)map.get(expense);
                amount = amount.add(feeAmount);
                map.put(expense, amount);
                continue;
            }
            map.put(expense, feeAmount);
        }
        feeAmountList.add(map);
        return feeAmountList;
    }

    @Override
    protected BigDecimal _calculateFeeAmount(Context ctx, String innerAccountId, String currencyId, Date period, String feeTariffId) throws BOSException, EASBizException {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("entries.levelValue"));
        FeeTariffInfo feeTariffInfo = (FeeTariffInfo)FeeTariffFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(feeTariffId), this.getFeeTariffSelector(), sorter);
        FeeCalculateHelper feeCalculateHelper = new FeeCalculateHelper(ctx, innerAccountId, currencyId, period, feeTariffInfo);
        BigDecimal feeAmount = feeCalculateHelper.getFeeAmount();
        return feeAmount;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FeeBillInfo info = (FeeBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((FeeBillInfo)model));
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            FeeBillInfo oldInfo = this.getFeeBillInfo(ctx, "select * where id='" + info.getId().toString() + "'");
            if (oldInfo != null) {
                FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
            }
            if (!EmptyUtil.isEmpty((Object)oldInfo.getAcceptedDate())) {
                FMHelper.throwFMCommonException((String)(info.getNumber().toString() + ResourceBase.getString((String)resourcePath, (String)"canNotSub", (Locale)ctx.getLocale())));
            }
        }
        if (info.getType() == FeeTypeEnum.INNER) {
            return this.submitInner(ctx, (IObjectValue)info);
        }
        return this.submitOuter(ctx, (IObjectValue)info);
    }

    private IObjectPK submitOuter(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BigDecimal net;
        FeeBillInfo info = (FeeBillInfo)model;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateTimeUtils.truncateDate((Date)info.getBizDate()));
        GregorianCalendar period = new GregorianCalendar();
        period.set(cal.get(1), cal.get(2), 1, 0, 0, 0);
        period.set(14, 0);
        info.setPeriod(period.getTime());
        BigDecimal amount = info.getAmount();
        BigDecimal remission = info.getRemission();
        if (remission != null) {
            net = amount.subtract(remission);
            info.setNet(net);
        } else {
            remission = SysConstant.BIGZERO;
        }
        net = amount.subtract(remission);
        info.setNet(net);
        if (info.getCompany() == null && info.getAccountBank() != null) {
            AccountBankInfo accountBankInfo = (AccountBankInfo)AccountBankFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(info.getAccountBank().getId().toString()));
            info.setCompany(accountBankInfo.getCompany());
        }
        info.setApplyUnit(null);
        IObjectPK iobjectpk = super._submit(ctx, (IObjectValue)info);
        if (info.getType().getValue() == 2) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            bookNotifyFacade.book(FeeJournalBookNotifyBuilder.class.getName(), iobjectpk.toString());
        }
        FeeBillInfo sumbittedInfo = this.getFeeBillInfo(ctx, "select * where id='" + iobjectpk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)iobjectpk, (IFMBgUsed)sumbittedInfo);
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)iobjectpk, null);
        return iobjectpk;
    }

    private IObjectPK submitInner(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FeeBillInfo info = (FeeBillInfo)model;
        info.setRemission(SysConstant.BIGZERO);
        info.setAmount(SysConstant.BIGZERO);
        info.setNet(SysConstant.BIGZERO);
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()));
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
        String total = ResourceBase.getString((String)resourcePath, (String)"total", (Locale)ctx.getLocale());
        for (int i = 0; i < info.getFeeBillEntry().size(); ++i) {
            FeeBillEntryInfo feeBillEntryInfo = info.getFeeBillEntry().get(i);
            if (total.equals(feeBillEntryInfo.getExpenseType())) {
                info.setRemission(this.processScale(ctx, currency, feeBillEntryInfo.getRemission(), companyInfo));
                info.setAmount(this.processScale(ctx, currency, feeBillEntryInfo.getAmount(), companyInfo));
                info.setNet(this.processScale(ctx, currency, feeBillEntryInfo.getAmount().subtract(feeBillEntryInfo.getRemission()), companyInfo));
            }
            feeBillEntryInfo.setAmount(this.processScale(ctx, currency, feeBillEntryInfo.getAmount(), companyInfo));
            feeBillEntryInfo.setRemission(this.processScale(ctx, currency, feeBillEntryInfo.getRemission(), companyInfo));
        }
        info.setApplyUnit(info.getInnerAccount().getApplyUnit());
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"applyUnit");
        if (this.checkFeeBill(ctx, info.getInnerAccount().getId().toString(), info.getCurrency().getId().toString(), info.getPeriod(), info)) {
            throw new FeeException(FeeException.BILL_INNERREPEATED);
        }
        IObjectPK objectPK = super._submit(ctx, model);
        if (info.getType() == FeeTypeEnum.INNER && info.getNet().signum() > 0) {
            boolean val;
            CompanyOrgUnitInfo clearingHouseCompany = FSHelper.getClearingHouseInfo((Context)ctx, null).getRelatedCompany();
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            if (currentCompany.getId().toString().equals(clearingHouseCompany.getId().toString()) && (val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM004", (IObjectPK)new ObjectUuidPK(currentCompany.getId())))) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(objectPK.toString());
                this._accept(ctx, ids);
            }
        }
        FeeBillInfo sumbittedInfo = this.getFeeBillInfo(ctx, "select * where id='" + objectPK.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)objectPK, (IFMBgUsed)sumbittedInfo);
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)objectPK, null);
        return objectPK;
    }

    private SelectorItemCollection getFeeTariffSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("entries.*");
        selector.add("expenseType.*");
        return selector;
    }

    private InnerAccountCollection getInnerAcctColl(Context ctx, Set innerAcctIdSet) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)innerAcctIdSet, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("company.id");
        ev.setFilter(filter);
        InnerAccountCollection innerAccountInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountCollection(ev);
        return innerAccountInfo;
    }

    private void fillInnerAcctIds(Context ctx, Set innerAcctIdSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
        evi.setFilter(filter);
        IInnerAccount iInnerAccount = InnerAccountFactory.getLocalInstance((Context)ctx);
        InnerAccountCollection innerAccountColl = iInnerAccount.getInnerAccountCollection(evi);
        int length = innerAccountColl.size();
        for (int i = 0; i < length; ++i) {
            innerAcctIdSet.add(innerAccountColl.get(i).getId().toString());
        }
    }

    private CurrencyInfo getCurrencyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(strId));
        return currency;
    }

    @Override
    protected void _accept(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        FeeBillCollection feeBills = this.getAcceptFeeBills(ctx, idList, false);
        this.checkBeforeAccept(feeBills);
        Date acceptDate = null;
        BankInfo clrHouseInfo = FSHelper.getClearingHouseInfo((Context)ctx, null);
        acceptDate = clrHouseInfo.getSettleDate();
        SubsidiaryLedgerCollection subsidiaries = new SubsidiaryLedgerCollection();
        FeeSubsidiaryBookProvider feeBookProvider = new FeeSubsidiaryBookProvider();
        for (int i = 0; i < feeBills.size(); ++i) {
            subsidiaries.addCollection(feeBookProvider.getCollection(ctx, feeBills.get(i).getId().toString()));
            if (!EmptyUtil.isEmpty((CoreBaseInfo)feeBills.get(i).getTransAccount())) {
                subsidiaries.addCollection(feeBookProvider.getTransCollection(ctx, feeBills.get(i).getId().toString()));
            }
            if (acceptDate != null && feeBills.get(i).getBizDate() != null && feeBills.get(i).getBizDate().after(acceptDate)) {
                acceptDate = feeBills.get(i).getBizDate();
            }
            this.signAccept(ctx, feeBills.get(i).getId().toString(), curUser, acceptDate);
        }
        ISubsidiaryLedger iSubsidiaryLedger = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx);
        iSubsidiaryLedger.book(subsidiaries);
        CompanyOrgUnitInfo curInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean CS086 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS086", (IObjectPK)new ObjectUuidPK(curInfo.getId()));
        if (CS086) {
            this.rePayBill(ctx, feeBills, curUser);
        }
    }

    private void checkBeforeAccept(FeeBillCollection feeBills) throws EASBizException {
        if (feeBills == null || feeBills.size() == 0) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        int n = feeBills.size();
        for (int i = 0; i < n; ++i) {
            FeeBillInfo feeInfo = feeBills.get(i);
            if (feeInfo.getAcceptedDate() != null) {
                throw new FeeException(FeeException.BILL_ACCEPTED);
            }
            if (feeInfo.getInnerAccount() != null) continue;
            throw new FeeException(FeeException.CHECK_INNERACC);
        }
    }

    private void signAccept(Context ctx, String id, UserInfo curUser, Date acceptDate) throws BOSException {
        PreparedStatement pstmt;
        Connection cn;
        block5: {
            Timestamp acceptDay = new Timestamp(acceptDate.getTime());
            cn = null;
            pstmt = null;
            CompanyOrgUnitInfo curInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean CS086 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS086", (IObjectPK)new ObjectUuidPK(curInfo.getId()));
            try {
                if (CS086) {
                    String sql = "update t_fe_feebill set FAcceptorID = ? , FAcceptedDate = ? , FIsPayBill = ? where fid = ?";
                    cn = this.getConnection(ctx);
                    pstmt = cn.prepareStatement(sql);
                    pstmt.setString(1, curUser.getId().toString());
                    pstmt.setTimestamp(2, acceptDay);
                    pstmt.setString(4, id);
                    pstmt.setInt(3, 1);
                    pstmt.addBatch();
                    pstmt.executeBatch();
                    break block5;
                }
                String sql = "update t_fe_feebill set FAcceptorID = ? , FAcceptedDate = ?  where fid = ?";
                cn = this.getConnection(ctx);
                pstmt = cn.prepareStatement(sql);
                pstmt.setString(1, curUser.getId().toString());
                pstmt.setTimestamp(2, acceptDay);
                pstmt.setString(3, id);
                pstmt.addBatch();
                pstmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)cn);
    }

    private FeeBillCollection getAcceptFeeBills(Context ctx, List idList, boolean fAccepted) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add("id");
        selectors.add("company");
        selectors.add("company.name");
        selectors.add("type");
        selectors.add("currency.*");
        selectors.add("net");
        selectors.add("acceptedDate");
        selectors.add("innerAccount.id");
        selectors.add("innerAccount.name");
        selectors.add("innerAccount.applyUnit.*");
        selectors.add("accountBank.id");
        selectors.add("accountBank.name");
        selectors.add("bizDate");
        selectors.add("number");
        selectors.add("isPayBill");
        selectors.add("transAccount.id");
        selectors.add("transAccount.name");
        if (fAccepted) {
            selectors.add("fiVouchered");
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        HashSet idSet = new HashSet(idList);
        items.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("net", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        view.setFilter(filter);
        FeeBillCollection bills = this.getFeeBillCollection(ctx, view);
        int size = bills.size();
        for (int i = 0; i < size; ++i) {
            AccountBankInfo accountBankInfo;
            InnerAccountInfo innerAccountInfo = bills.get(i).getInnerAccount();
            if (innerAccountInfo != null) {
                IInnerAccount iInnerAccount = InnerAccountFactory.getLocalInstance((Context)ctx);
                InnerAccountInfo info = iInnerAccount.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountInfo.getId()));
                innerAccountInfo.setCompany(info.getCompany());
            }
            if ((accountBankInfo = bills.get(i).getAccountBank()) == null) continue;
            IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
            AccountBankInfo info = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()));
            accountBankInfo.setCompany(info.getCompany());
        }
        return bills;
    }

    @Override
    protected void _cancelAccept(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        FeeBillCollection feeBills = this.getAcceptFeeBills(ctx, idList, true);
        this.checkBeforeCancelAccept(ctx, feeBills);
        this.removeSubsidiaryByFee(ctx, idList);
        this.removePayBill(ctx, idList);
        this.signCancelAccept(ctx, idList);
    }

    private void checkBeforeCancelAccept(Context ctx, FeeBillCollection feeBills) throws BOSException, EASBizException {
        if (feeBills == null || feeBills.size() == 0) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        Date curAccptDate = null;
        BankInfo clrHouseInfo = FSHelper.getClearingHouseInfo((Context)ctx, null);
        if (clrHouseInfo == null) {
            throw new FSException(FSException.CLEARINGHOUSENOTSETTED);
        }
        curAccptDate = clrHouseInfo.getSettleDate();
        int n = feeBills.size();
        for (int i = 0; i < n; ++i) {
            FeeBillInfo feeInfo = feeBills.get(i);
            if (feeInfo.getAcceptedDate() == null) {
                throw new FeeException(FeeException.BILL_NOTACCEPTED);
            }
            if (feeInfo.getAcceptedDate().before(curAccptDate)) {
                throw new FeeException(FeeException.BILL_DAYSETTLED);
            }
            if (!feeInfo.isFiVouchered()) continue;
            throw new FeeException(FeeException.BILL_VOUCHERED);
        }
    }

    private void removeSubsidiaryByFee(Context ctx, List idList) throws BOSException, EASBizException {
        ISubsidiaryLedger iSubsidiaryLedger = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < idList.size(); ++i) {
            iSubsidiaryLedger.cancelBook((String)idList.get(i));
        }
    }

    private void signCancelAccept(Context ctx, List idList) throws BOSException {
        Connection cn = null;
        PreparedStatement pstmt = null;
        String sql = "";
        try {
            sql = "update t_fe_feebill set FAcceptorID = null , FAcceptedDate = null , FIsPayBill = 0 where fid = ?";
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            int n = idList.size();
            for (int i = 0; i < n; ++i) {
                pstmt.setString(1, idList.get(i).toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)cn);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FeeBillInfo feeBillInfo = (FeeBillInfo)model;
        FeeTypeEnum feeType = feeBillInfo.getType();
        feeBillInfo.setCreateTime(DateUtil.transformTimestamp((Date)new Date()));
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)feeBillInfo, (AbstractCoreBaseControllerBean)this);
        if (feeType.getValue() == 1 && this.checkFeeBill(ctx, feeBillInfo.getInnerAccount().getId().toString(), feeBillInfo.getCurrency().getId().toString(), feeBillInfo.getPeriod(), feeBillInfo)) {
            throw new FeeException(FeeException.BILL_INNERREPEATED);
        }
        IObjectPK iobjectpk = super._addnew(ctx, (IObjectValue)feeBillInfo);
        if (feeType.getValue() == 2) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            bookNotifyFacade.book(FeeJournalBookNotifyBuilder.class.getName(), iobjectpk.toString());
        }
        return iobjectpk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FeeBillInfo feeBillInfo = (FeeBillInfo)this._getValue(ctx, pk);
        if (feeBillInfo.getAcceptedDate() != null || feeBillInfo.getAcceptor() != null) {
            throw new FeeException(FeeException.BILL_DEL_ACCEPTED);
        }
        if (feeBillInfo.getType().equals((Object)FeeTypeEnum.OUTER)) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            bookNotifyFacade.antiBook(pk.toString());
        }
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)feeBillInfo, (String)feeBillInfo.getCompany().getId().toString());
        NTHelper.cancelFpItem((Context)ctx, (String)pk.toString());
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _isExistSameFeeTariff(Context ctx, List columnKeys, List feeTariffID) throws BOSException {
        if (feeTariffID == null || feeTariffID.size() <= 0 || columnKeys == null || columnKeys.size() <= 0) {
            return false;
        }
        boolean isExistSame = false;
        StringBuffer columns = new StringBuffer("DISTINCT ");
        for (int j = 0; j < columnKeys.size(); ++j) {
            if (j != columnKeys.size() - 1) {
                columns.append(columnKeys.get(j)).append(",");
                continue;
            }
            columns.append(columnKeys.get(j)).append(" ");
        }
        StringBuffer SQL = new StringBuffer("SELECT COUNT(*) FROM (");
        SQL.append("SELECT ");
        SQL.append(columns);
        SQL.append("FROM T_FE_FEETARIFF WHERE FID IN ");
        SQL.append(FMHelper.setTran2String(new HashSet(feeTariffID)));
        SQL.append(" AS A)");
        IRowSet result = null;
        try {
            result = DbUtil.executeQuery((Context)ctx, (String)SQL.toString());
            int count = 0;
            while (result.next()) {
                count = result.getInt(1);
            }
            if (feeTariffID.size() != count) {
                isExistSame = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)result);
        return isExistSame;
    }

    @Override
    protected Set _processBatchFeeAmount(Context ctx, Set innerAcctIdSet, String currencyId, Date period, FeeTariffInfo[] feeTariffInfo, String transAccountId) throws BOSException, EASBizException {
        int size = innerAcctIdSet.size();
        if (size == 0) {
            this.fillInnerAcctIds(ctx, innerAcctIdSet);
        }
        if (innerAcctIdSet.size() == 0) {
            throw new FeeException(FeeException.INNERACCOUT_ISNULL);
        }
        HashSet<FeeTariffInfo> feeTariffSet = new HashSet<FeeTariffInfo>();
        for (int i = 0; i < feeTariffInfo.length; ++i) {
            feeTariffSet.add(feeTariffInfo[i]);
        }
        ArrayList feeTariffList = new ArrayList(feeTariffSet);
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        InnerAccountCollection innerAcctColl = this.getInnerAcctColl(ctx, innerAcctIdSet);
        for (int i = 0; i < innerAcctColl.size(); ++i) {
            InnerAccountInfo info = innerAcctColl.get(i);
            CurrencyInfo currencyInfo = this.getCurrencyById(ctx, currencyId);
            UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            FeeBillInfo feeBillInfo = new FeeBillInfo();
            feeBillInfo.setInnerAccount(info);
            feeBillInfo.setCompany(info.getCompany());
            feeBillInfo.setApplyUnit(info.getApplyUnit());
            feeBillInfo.setType(FeeTypeEnum.INNER);
            feeBillInfo.setCreator(currentUser);
            feeBillInfo.setCreateDate(DateUtil.getTimeStampDayBegin());
            feeBillInfo.setCurrency(currencyInfo);
            feeBillInfo.setPeriod(period);
            feeBillInfo.setBizDate(DateTimeUtils.truncateDate((Date)DateUtil.getTimeStampDayBegin()));
            feeBillInfo.setRemission(SysConstant.BIGZERO);
            feeBillInfo.setCreateTime(DateUtil.transformTimestamp((Date)new Date()));
            this.setFeeTariff(feeTariffList, feeBillInfo);
            feeBillInfo = this.calculateAmount(ctx, feeBillInfo);
            if (feeBillInfo.getNet() == null || feeBillInfo.getNet().compareTo(Constants.ZERO) == 0) continue;
            if (!FMHelper.isEmpty((String)transAccountId)) {
                InnerAccountInfo transInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(transAccountId));
                feeBillInfo.setTransAccount(transInfo);
            }
            FMHelper.initNumber((Context)ctx, (BillBaseInfo)feeBillInfo, (AbstractCoreBaseControllerBean)this);
            IObjectPK id = super._addnew(ctx, (IObjectValue)feeBillInfo);
            idSet.add(id);
        }
        return idSet;
    }

    private FeeBillInfo calculateAmount(Context ctx, FeeBillInfo feeBillInfo) throws EASBizException, BOSException {
        FeeTariffsForBillCollection collenction = feeBillInfo.getFeeTariffs();
        if (this.checkFeeBill(ctx, feeBillInfo.getInnerAccount().getId().toString(), feeBillInfo.getCurrency().getId().toString(), feeBillInfo.getPeriod(), null)) {
            return feeBillInfo;
        }
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(feeBillInfo.getCurrency().getId()));
        ArrayList<String> feeTariffList = new ArrayList<String>();
        Iterator iterator = collenction.iterator();
        while (iterator.hasNext()) {
            feeTariffList.add(((FeeTariffsForBillInfo)iterator.next()).getFeeTairffs().getId().toString());
        }
        List list = this._calculateFeeAmounts(ctx, feeBillInfo.getInnerAccount().getId().toString(), feeBillInfo.getCurrency().getId().toString(), feeBillInfo.getPeriod(), feeTariffList);
        Map map = (Map)list.get(0);
        Set set = map.keySet();
        Iterator SetIterator = set.iterator();
        BigDecimal feeAmount = Constants.ZERO;
        BigDecimal NewfeeAmount = Constants.ZERO;
        while (SetIterator.hasNext()) {
            String key = (String)SetIterator.next();
            BigDecimal amout = (BigDecimal)map.get(key);
            FeeBillEntryInfo feeBillEntryInfo = new FeeBillEntryInfo();
            feeBillEntryInfo.setAmount(this.processScale(ctx, currency, amout, companyInfo));
            feeBillEntryInfo.setExpenseType(key);
            feeBillEntryInfo.setRemission(Constants.ZERO);
            feeBillEntryInfo.setFeeBill(feeBillInfo);
            feeBillInfo.getFeeBillEntry().add(feeBillEntryInfo);
            feeAmount = feeAmount.add(amout);
        }
        NewfeeAmount = this.processScale(ctx, currency, feeAmount, companyInfo);
        feeBillInfo.setAmount(NewfeeAmount);
        feeBillInfo.setNet(NewfeeAmount);
        feeBillInfo.setRemission(Constants.ZERO);
        String total = ResourceBase.getString((String)resourcePath, (String)"total", (Locale)ctx.getLocale());
        FeeBillEntryInfo feeBillEntryInfo = new FeeBillEntryInfo();
        feeBillEntryInfo.setExpenseType(total);
        feeBillEntryInfo.setAmount(NewfeeAmount);
        feeBillEntryInfo.setRemission(SysConstant.BIGZERO);
        feeBillInfo.getFeeBillEntry().add(feeBillEntryInfo);
        return feeBillInfo;
    }

    private void setFeeTariff(List tariffs, FeeBillInfo feeBillInfo) {
        if (tariffs != null && tariffs.size() > 0) {
            feeBillInfo.getFeeTariffs().clear();
            for (int i = 0; i < tariffs.size(); ++i) {
                FeeTariffInfo info = (FeeTariffInfo)tariffs.get(i);
                FeeTariffsForBillInfo feeTariffsForBillInfo = new FeeTariffsForBillInfo();
                feeTariffsForBillInfo.setFeeTairffs(info);
                feeTariffsForBillInfo.setFeeBill(feeBillInfo);
                feeBillInfo.getFeeTariffs().add(feeTariffsForBillInfo);
            }
        }
    }

    private void rePayBill(Context ctx, FeeBillCollection feeBills, UserInfo curUser) throws BOSException, EASBizException {
        if (feeBills == null || feeBills.size() <= 0) {
            return;
        }
        CompanyOrgUnitInfo curInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        IPaymentBill payment = PaymentBillFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter3 = new FilterInfo();
        filter3.getFilterItems().add(new FilterItemInfo("number", (Object)"C01", CompareType.EQUALS));
        view.setFilter(filter3);
        CountryCollection country = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view);
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter2);
        PaymentBillTypeCollection payType = PaymentBillTypeFactory.getLocalInstance((Context)ctx).getPaymentBillTypeCollection(viewInfo);
        for (int i = 0; i < feeBills.size(); ++i) {
            IObjectPK pk;
            FeeBillInfo info = feeBills.get(i);
            if (info.isIsPayBill()) continue;
            PaymentBillInfo payInfo = new PaymentBillInfo();
            payInfo.setBizDate(new Date());
            payInfo.setCompany(info.getInnerAccount().getApplyUnit());
            payInfo.setCurrency(info.getCurrency());
            ExchangeRateInfo exInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)info.getCurrency(), (CurrencyInfo)curInfo.getBaseCurrency(), (CompanyOrgUnitInfo)curInfo, (Date)new Date());
            if (exInfo != null) {
                payInfo.setExchangeRate(exInfo.getConvertRate());
            } else {
                payInfo.setExchangeRate(new BigDecimal(1));
            }
            payInfo.setSourceType(SourceTypeEnum.FS);
            PaymentBillEntryInfo payEntrys = new PaymentBillEntryInfo();
            payEntrys.setActualAmt(info.getNet());
            payInfo.getEntries().add(payEntrys);
            payInfo.setCreator(curUser);
            payInfo.setSourceBillId(info.getId().toString());
            payInfo.setPayeeName(info.getCompany().getName().toString());
            AccountBankInfo accountBankInfo = FSHelper.getAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)info.getInnerAccount());
            if (accountBankInfo != null) {
                payInfo.setPayerAccountBank(accountBankInfo);
                BankInfo bankInfo = accountBankInfo.getBank();
                if (bankInfo != null) {
                    payInfo.setPayerBank(bankInfo);
                }
                payInfo.setPayerAccount(accountBankInfo.getAccount());
            }
            if (payType != null) {
                payInfo.setPayBillType(payType.get(0));
            }
            payInfo.setActPayAmt(info.getNet());
            payInfo.setActPayLocAmt(info.getNet().multiply(payInfo.getExchangeRate()));
            if (country != null) {
                payInfo.setFRecCountry(country.get(0));
            }
            if ((pk = payment.save((CoreBaseInfo)payInfo)) == null) continue;
            BOTRelationInfo botp = new BOTRelationInfo();
            botp.setSrcObjectID(info.getId().toString());
            botp.setSrcEntityID(info.getBOSType().toString());
            botp.setDestEntityID(payInfo.getBOSType().toString());
            botp.setDestObjectID(pk.toString());
            botp.setOperatorID(curUser.getId().toString());
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(botp);
        }
    }

    private void removePayBill(Context ctx, List feeBills) throws BOSException, EASBizException {
        if (feeBills == null || feeBills.size() <= 0) {
            return;
        }
        HashSet set = new HashSet(feeBills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new FeeBillInfo().getBOSType().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new PaymentBillInfo().getBOSType().toString(), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IBOTRelation botRel = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botp = botRel.getCollection(view);
        if (botp != null && botp.size() > 0) {
            ObjectUuidPK[] arrayPK = new ObjectUuidPK[botp.size()];
            for (int i = 0; i < botp.size(); ++i) {
                arrayPK[i] = new ObjectUuidPK(botp.get(i).getDestObjectID());
                botRel.delete((IObjectPK)new ObjectUuidPK(botp.get(i).getId().toString()));
                PaymentBillInfo info = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(botp.get(i).getDestObjectID()));
                if (info.getSourceBillId() == null || !new FeeBillInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType()) || info.getBillStatus() == null || info.getBillStatus().equals((Object)BillStatusEnum.SAVE) || info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) continue;
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.fee.FEEAutoGenerateResource", (String)"0_FeeBillControllerBean", (Locale)ctx.getLocale())));
            }
            PaymentBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK[])arrayPK);
        }
    }

    private BigDecimal processScale(Context ctx, CurrencyInfo currency, BigDecimal amount, CompanyOrgUnitInfo CURRENT_COMPANY) throws EASBizException, BOSException {
        return FMHelper.getBigDecimalByScale((Context)ctx, (BigDecimal)amount, (CurrencyInfo)currency, (CompanyOrgUnitInfo)CURRENT_COMPANY);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FeeBillInfo info = (FeeBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setFiVouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFiVouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }
}

