/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.fee.FeeBillFactory;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;

public class FeeSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    private static final BigDecimal ONE = Constants.ONE;

    private SelectorItemCollection getFeeBillSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("currency.*");
        selectors.add("innerAccount.*");
        selectors.add("innerAccount.company.*");
        selectors.add("innerAccount.applyUnit.*");
        selectors.add("transAccount.*");
        selectors.add("transAccount.company.*");
        selectors.add("transAccount.applyUnit.*");
        selectors.add("accountBank.*");
        selectors.add("accountBank.company.*");
        return selectors;
    }

    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection subLedgers = null;
        if (billId == null) {
            return null;
        }
        subLedgers = new SubsidiaryLedgerCollection();
        FeeBillInfo feeInfo = FeeBillFactory.getLocalInstance(ctx).getFeeBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)), this.getFeeBillSelector());
        if (feeInfo.getNet().signum() == 0) {
            return null;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Date acceptDate = null;
        BankInfo clrHouseInfo = FSHelper.getClearingHouseInfo((Context)ctx, null);
        acceptDate = clrHouseInfo.getSettleDate();
        if (feeInfo.getType().getValue() == 1) {
            SubsidiaryLedgerInfo subLedgerDpstInfo = FeeSubsidiaryBookProvider.convert2Subsidiary(feeInfo, userInfo, acceptDate);
            subLedgers.add(subLedgerDpstInfo);
        }
        return subLedgers;
    }

    public SubsidiaryLedgerCollection getTransCollection(Context ctx, String billId) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection subLedgers = null;
        if (billId == null) {
            return null;
        }
        subLedgers = new SubsidiaryLedgerCollection();
        FeeBillInfo feeInfo = FeeBillFactory.getLocalInstance(ctx).getFeeBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)), this.getFeeBillSelector());
        if (feeInfo.getNet().signum() == 0) {
            return null;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Date acceptDate = null;
        BankInfo clrHouseInfo = FSHelper.getClearingHouseInfo((Context)ctx, null);
        acceptDate = clrHouseInfo.getSettleDate();
        if (feeInfo.getType().getValue() == 1) {
            SubsidiaryLedgerInfo subLedgerDpstInfo = FeeSubsidiaryBookProvider.convertTrans2Subsidiary(feeInfo, userInfo, acceptDate);
            subLedgers.add(subLedgerDpstInfo);
        }
        return subLedgers;
    }

    private static SubsidiaryLedgerInfo convert2Subsidiary(FeeBillInfo feeInfo, UserInfo userInfo, Date acceptDate) throws EASBizException, BOSException {
        SubsidiaryLedgerInfo subLedgerInfo = new SubsidiaryLedgerInfo();
        subLedgerInfo.setBizType(SubsidiaryBillTypeEnum.FEEBILL);
        subLedgerInfo.setBillId(feeInfo.getId());
        subLedgerInfo.setCurrency(feeInfo.getCurrency());
        subLedgerInfo.setCpCurrency(feeInfo.getCurrency());
        subLedgerInfo.setDate(feeInfo.getBizDate());
        if (feeInfo.getBizDate() != null && acceptDate != null && acceptDate.after(feeInfo.getBizDate())) {
            subLedgerInfo.setDate(acceptDate);
        }
        String desc = "";
        if (feeInfo.getPeriod() != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(feeInfo.getPeriod());
            desc = desc + cal.get(1) + "-" + (cal.get(2) + 1) + "  ";
        }
        if (feeInfo.getDescription() != null) {
            desc = desc + feeInfo.getDescription();
        }
        subLedgerInfo.setDescription(desc);
        subLedgerInfo.setExchangeRate(ONE);
        subLedgerInfo.setBookkeeper(userInfo);
        subLedgerInfo.setLocalAmount(SysConstant.BIGZERO);
        subLedgerInfo.setCreditAmount(SysConstant.BIGZERO);
        subLedgerInfo.setDebitAmount(SysConstant.BIGZERO);
        subLedgerInfo.setBillNumber(feeInfo.getNumber());
        subLedgerInfo.setIsDownLoad(false);
        if (feeInfo.getType().getValue() == 1) {
            subLedgerInfo.setCompany(feeInfo.getInnerAccount().getCompany());
            subLedgerInfo.setApplyUnit(feeInfo.getApplyUnit());
            subLedgerInfo.setInnerAccount(feeInfo.getInnerAccount());
            subLedgerInfo.setCreditAmount(feeInfo.getNet());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)feeInfo.getTransAccount())) {
                subLedgerInfo.setCpInnerAccount(feeInfo.getTransAccount());
            }
        }
        return subLedgerInfo;
    }

    private static SubsidiaryLedgerInfo convertTrans2Subsidiary(FeeBillInfo feeInfo, UserInfo userInfo, Date acceptDate) throws EASBizException, BOSException {
        SubsidiaryLedgerInfo subLedgerInfo = new SubsidiaryLedgerInfo();
        subLedgerInfo.setBizType(SubsidiaryBillTypeEnum.FEEBILL);
        subLedgerInfo.setBillId(feeInfo.getId());
        subLedgerInfo.setCurrency(feeInfo.getCurrency());
        subLedgerInfo.setCpCurrency(feeInfo.getCurrency());
        subLedgerInfo.setDate(feeInfo.getBizDate());
        if (feeInfo.getBizDate() != null && acceptDate != null && acceptDate.after(feeInfo.getBizDate())) {
            subLedgerInfo.setDate(acceptDate);
        }
        String desc = "";
        if (feeInfo.getPeriod() != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(feeInfo.getPeriod());
            desc = desc + cal.get(1) + "-" + (cal.get(2) + 1) + "  ";
        }
        if (feeInfo.getDescription() != null) {
            desc = desc + feeInfo.getDescription();
        }
        subLedgerInfo.setDescription(desc);
        subLedgerInfo.setExchangeRate(ONE);
        subLedgerInfo.setBookkeeper(userInfo);
        subLedgerInfo.setLocalAmount(SysConstant.BIGZERO);
        subLedgerInfo.setCreditAmount(SysConstant.BIGZERO);
        subLedgerInfo.setDebitAmount(SysConstant.BIGZERO);
        subLedgerInfo.setBillNumber(feeInfo.getNumber());
        subLedgerInfo.setIsDownLoad(false);
        if (feeInfo.getType().getValue() == 1) {
            subLedgerInfo.setCompany(feeInfo.getInnerAccount().getCompany());
            subLedgerInfo.setApplyUnit(feeInfo.getApplyUnit());
            subLedgerInfo.setInnerAccount(feeInfo.getTransAccount());
            subLedgerInfo.setDebitAmount(feeInfo.getNet());
            subLedgerInfo.setCpInnerAccount(feeInfo.getInnerAccount());
        }
        return subLedgerInfo;
    }
}

