/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FetchParamHelperForFee {
    private static final Logger logger = Logger.getLogger((String)FetchParamHelperForFee.class.getName());
    private Context ctx = null;
    private FetchParamHelper fetchParamHelper = null;
    private CompanyOrgUnitInfo companyOrgUnitInfo;

    public FetchParamHelperForFee(Context ctxParam) {
        this.ctx = ctxParam;
        this.fetchParamHelper = new FetchParamHelper(this.ctx);
        this.companyOrgUnitInfo = this.getCurrentComapny();
    }

    public Map fetchParam(Map paramsMap) throws BOSException, EASBizException {
        if (paramsMap == null || paramsMap.isEmpty()) {
            throw new EASBizException(null, (Throwable)new NullPointerException());
        }
        Set paramSet = paramsMap.keySet();
        Iterator iterator = paramSet.iterator();
        HashMap map = new HashMap();
        while (iterator.hasNext()) {
            String name = iterator.next().toString();
            this.fillParamMapByParamName(map, name);
        }
        return map;
    }

    private void fillParamMapByParamName(Map map, String name) throws BOSException, EASBizException {
        if ("company".equals(name)) {
            map.put("company", this.companyOrgUnitInfo);
        } else if ("hasNumber".equals(name)) {
            FeeBillInfo feeBillInfo = new FeeBillInfo();
            boolean hasNumber = this.hasNumber(this.ctx, (CoreBaseInfo)feeBillInfo, this.companyOrgUnitInfo.getId().toString());
            map.put("hasNumber", hasNumber);
            if (hasNumber) {
                map.put("codingRuleNumber", this.getDispNumber(this.ctx, (CoreBaseInfo)feeBillInfo, this.companyOrgUnitInfo.getId().toString()));
                map.put("isModifiable", this.isModifiable((CoreBaseInfo)feeBillInfo, this.companyOrgUnitInfo.getId().toString()));
            }
        } else if ("currencyCollection".equals(name)) {
            map.put("currencyCollection", this.getCurrenyCol());
        } else if ("isClearingHouse".equals(name)) {
            map.put("isClearingHouse", new Boolean(this.isClearinghouseCompany()));
        } else if ("feeTariffs".equals(name)) {
            map.put("feeTariffs", this.getRowSet());
        } else if ("clearingHouseIsUsed".equals(name)) {
            map.put("clearingHouseIsUsed", this.clearingHouseIsUsed());
        } else if ("user".equals(name)) {
            map.put("user", this.getUserInfo());
        } else if ("baseCurrency".equals(name)) {
            map.put("baseCurrency", this.getCompanyBaseCurrency());
        } else if ("prec".equals(name)) {
            map.put("prec", new Integer(this.getPrecOfCurrency()));
        } else if ("currentCtrlUnit".equals(name)) {
            map.put("currentCtrlUnit", this.getCurrentCtrlUnit());
        }
    }

    public CompanyOrgUnitInfo getCurrentComapny() {
        return this.fetchParamHelper.getCurrentComapny();
    }

    public PeriodInfo getCurrentPeriod() throws EASBizException, BOSException {
        return this.fetchParamHelper.getCurrentPeriod();
    }

    public CurrencyCollection getCurrenyCol() throws BOSException, EASBizException {
        return this.fetchParamHelper.getCurrenyCol();
    }

    public String getParamValue_StringType(String paramName) throws EASBizException, BOSException {
        return this.fetchParamHelper.getParamValue_StringType(paramName);
    }

    public PeriodInfo getStartPeriod() throws EASBizException, BOSException {
        return this.fetchParamHelper.getStartPeriod();
    }

    public String getAcctTableId(Context ctx, Date beginDate, Date endDate) throws BOSException, EASBizException {
        return this.fetchParamHelper.getAcctTableId(ctx, beginDate, endDate);
    }

    public String getAcctTableId(Context ctx, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException, EASBizException {
        return this.fetchParamHelper.getAcctTableId(ctx, beginYear, beginMonth, endYear, endMonth);
    }

    public IRowSet getRowSet() throws BOSException {
        MetaDataPK PK = new MetaDataPK("com.kingdee.eas.fm.fee", "FeeTariffQuery");
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)PK);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)PK);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("expenseType", null, CompareType.ISNOT));
        filter.getFilterItems().add(new FilterItemInfo("balanceType", null, CompareType.ISNOT));
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("balanceType"));
        exec.setObjectView(ev);
        exec.option().isAutoTranslateEnum = true;
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    public String getDispNumber(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        String number = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
            number = codingRuleManager.getNumber((IObjectValue)info, companyId);
        }
        return number;
    }

    public Boolean isModifiable(CoreBaseInfo info, String companyId) {
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
            result = codingRuleManager.isModifiable((IObjectValue)info, companyId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new Boolean(result);
    }

    public boolean hasNumber(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        result = codingRuleManager.isExist((IObjectValue)info, companyId);
        return result;
    }

    public boolean isClearinghouseCompany() throws EASBizException, BOSException {
        return BankFactory.getLocalInstance((Context)this.ctx).isClearinghouseCompany(this.companyOrgUnitInfo.getId().toString());
    }

    public Boolean clearingHouseIsUsed() throws EASBizException, BOSException {
        if (this.getClearingHouse() == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public BankInfo getClearingHouse() throws EASBizException, BOSException {
        return BankFactory.getLocalInstance((Context)this.ctx).getClearingHouse(this.companyOrgUnitInfo.getId().toString());
    }

    public UserInfo getUserInfo() throws EASBizException, BOSException {
        return ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
    }

    public CurrencyInfo getCompanyBaseCurrency() throws EASBizException, BOSException {
        return ContextHelperFactory.getLocalInstance((Context)this.ctx).getCompanyBaseCurrency(this.companyOrgUnitInfo);
    }

    public int getPrecOfCurrency() throws EASBizException, BOSException {
        return FMHelper.getPrecOfCurrency((Context)this.ctx, (String)this.getCompanyBaseCurrency().getId().toString());
    }

    public CtrlUnitInfo getCurrentCtrlUnit() {
        return ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCtrlUnit();
    }
}

