/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.rpt.IFormulaValidate;
import com.kingdee.eas.fi.rpt.ValidatorResults;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpFormulaValidator
implements IFormulaValidate {
    private static Logger logger = Logger.getLogger((String)FpFormulaValidator.class.getName());
    protected String formulaName;
    protected Map values;
    protected ValidatorResults results;
    protected String formula;
    protected Map itemMap;
    protected Map asstItemMap;
    protected Map periodMap;
    protected Map currencyMap;
    protected Context ctx;

    public FpFormulaValidator() {
    }

    public FpFormulaValidator(Context ctx) {
        this.ctx = ctx;
        try {
            this.itemMap = FpItemFormulaHelper.getItemMap(ctx);
            this.asstItemMap = FpItemFormulaHelper.getAsstItemMap(ctx);
            this.periodMap = FpItemFormulaHelper.getPeriodMap(ctx);
            this.currencyMap = FpItemFormulaHelper.getCurrencyMap(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public void initValidator(String formulaName, Map values, ValidatorResults results) {
        this.formulaName = formulaName;
        this.values = values;
        this.results = results;
    }

    protected boolean validateFormula(String formula) {
        return true;
    }

    public boolean validateItem(String fpItem) {
        if (this.isEmpty(fpItem)) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"37_FpFormulaValidator"));
            return false;
        }
        if (this.itemMap == null) {
            try {
                this.itemMap = FpItemFormulaHelper.getItemMap(this.ctx);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        }
        if (!this.itemMap.containsKey(fpItem)) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"38_FpFormulaValidator") + fpItem + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"39_FpFormulaValidator"));
            return false;
        }
        return true;
    }

    public boolean validateAsstItemComb(String asstItemComb) {
        if (this.isEmpty(asstItemComb)) {
            return true;
        }
        String[] asstItems = FpItemFormulaParser.getAssistItems(asstItemComb);
        if (asstItems == null || asstItems.length <= 0) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"40_FpFormulaValidator") + asstItemComb + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"41_FpFormulaValidator"));
            return false;
        }
        if (this.asstItemMap == null) {
            try {
                this.asstItemMap = FpItemFormulaHelper.getAsstItemMap(this.ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        int len = asstItems.length;
        for (int i = 0; i < len; ++i) {
            if (this.asstItemMap.containsKey(asstItems[i])) continue;
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"42_FpFormulaValidator") + asstItems[i] + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"43_FpFormulaValidator"));
            return false;
        }
        String[] groups = FpItemFormulaParser.getAssistItemGroups(asstItemComb);
        HashMap<String, String> groupMap = new HashMap<String, String>();
        int len2 = groups.length;
        for (int i = 0; i < len2; ++i) {
            if (groupMap.containsKey(groups[i])) {
                this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"44_FpFormulaValidator") + asstItemComb + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"45_FpFormulaValidator"));
                return false;
            }
            groupMap.put(groups[i], groups[i]);
        }
        return true;
    }

    public boolean validatePeriod(String period) {
        if (this.isEmpty(period)) {
            return true;
        }
        if (this.periodMap == null) {
            try {
                this.periodMap = FpItemFormulaHelper.getPeriodMap(this.ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (!this.periodMap.containsKey(period)) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"46_FpFormulaValidator") + period + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"47_FpFormulaValidator"));
            return false;
        }
        return true;
    }

    public boolean validateDataType(String dataType) {
        if (this.isEmpty(dataType)) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"48_FpFormulaValidator"));
            return false;
        }
        if (!(dataType.equals("P") || dataType.equals("A") || dataType.equals(FpDataTypeEnum.A.toString()) || dataType.equals(FpDataTypeEnum.P.toString()))) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"49_FpFormulaValidator") + dataType + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"50_FpFormulaValidator"));
            return false;
        }
        return true;
    }

    public boolean validateCurrency(String currency) {
        if (this.isEmpty(currency)) {
            return true;
        }
        if (this.currencyMap == null) {
            try {
                this.currencyMap = FpItemFormulaHelper.getCurrencyMap(this.ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (!this.currencyMap.containsKey(currency)) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"51_FpFormulaValidator") + currency + EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"52_FpFormulaValidator"));
            return false;
        }
        return true;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public ValidatorResults getResults() {
        return this.results;
    }

    public Map getValues() {
        return this.values;
    }

    public boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public void setAsstItemMap(Map asstItemMap) {
        this.asstItemMap = asstItemMap;
    }

    public void setCurrencyMap(Map currencyMap) {
        this.currencyMap = currencyMap;
    }

    public void setItemMap(Map itemMap) {
        this.itemMap = itemMap;
    }

    public void setPeriodMap(Map periodMap) {
        this.periodMap = periodMap;
    }
}

