/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FpAssistItemGroupInfo;
import com.kingdee.eas.fm.fpl.FpAssistItemInfo;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class FpItemFormulaHelper {
    public static Map getItemMap(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StringBuffer sql = new StringBuffer();
            if (ctx != null) {
                sql.append("SELECT FID, FNumber , FName_" + ctx.getLocale() + " FROM T_FPL_FpItem");
            } else {
                sql.append("SELECT FID, FNumber , FName_l2 FROM T_FPL_FpItem");
            }
            IRowSet rowset = FpItemFormulaHelper.exec(ctx, sql.toString());
            while (rowset.next()) {
                map.put(rowset.getString("FNumber"), rowset.getString("FID"));
                if (ctx != null) {
                    map.put(rowset.getString("FName_" + ctx.getLocale()), rowset.getString("FNumber"));
                    continue;
                }
                map.put(rowset.getString("FName_l2"), rowset.getString("FNumber"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return map;
    }

    public static Map getItemInfoMap(Context ctx) throws BOSException {
        HashMap<String, FpItemInfo> map = new HashMap<String, FpItemInfo>();
        IFpItem iFpItem = null;
        iFpItem = ctx == null ? FpItemFactory.getRemoteInstance() : FpItemFactory.getLocalInstance((Context)ctx);
        FpItemCollection coll = iFpItem.getFpItemCollection();
        FpItemInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getNumber(), info);
            map.put(info.getName(), info);
        }
        return map;
    }

    public static Map getAsstItemMap(Context ctx) throws BOSException {
        HashMap<String, FpAssistItemInfo> map = new HashMap<String, FpAssistItemInfo>();
        FpAssistItemInfo info = null;
        try {
            StringBuffer sql = new StringBuffer();
            if (ctx == null) {
                sql.append(" SELECT itemGroup.FNumber || '|' || item.FNumber CombineNumber, itemGroup.FName_l2 || '|' || item.FName_l2 CombineName, item.FID itemFID, ");
            } else {
                sql.append(" SELECT itemGroup.FNumber || '|' || item.FNumber CombineNumber, itemGroup.FName_" + ctx.getLocale() + " || '|' || item.FName_" + ctx.getLocale() + " CombineName, item.FID itemFID, ");
            }
            sql.append(" \titem.FNumber itemFNumber, item.FRefField, item.FIsLeaf, item.FGroupID, ").append(" itemGroup.FID groupFID, itemGroup.FNumber groupFNumber ").append(" FROM T_FPL_FpAssistItem item ").append(" JOIN T_FPL_FpAssistItemGroup itemGroup ON item.FGroupID = itemGroup.FID");
            IRowSet rowset = FpItemFormulaHelper.exec(ctx, sql.toString());
            boolean isLeaf = false;
            FpAssistItemGroupInfo groupInfo = null;
            while (rowset.next()) {
                info = new FpAssistItemInfo();
                info.setId(BOSUuid.read((String)rowset.getString("itemFID")));
                info.setNumber(rowset.getString("itemFNumber"));
                info.setRefField(rowset.getString("FRefField"));
                if (rowset.getInt("FIsLeaf") == 1) {
                    isLeaf = true;
                } else if (rowset.getInt("FIsLeaf") == 0) {
                    isLeaf = false;
                }
                info.setIsLeaf(isLeaf);
                groupInfo = new FpAssistItemGroupInfo();
                groupInfo.setId(BOSUuid.read((String)rowset.getString("groupFID")));
                groupInfo.setNumber(rowset.getString("groupFNumber"));
                info.setGroup(groupInfo);
                map.put(rowset.getString("CombineNumber"), info);
                map.put(rowset.getString("CombineName"), info);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new BOSException((Throwable)ex);
        }
        return map;
    }

    public static Map getAsstItemCombMap(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID, FKey FROM T_FPL_FpAssistItemCombi");
            IRowSet rowset = FpItemFormulaHelper.exec(ctx, sql.toString());
            while (rowset.next()) {
                map.put(rowset.getString("FKey"), rowset.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return map;
    }

    public static Map getPeriodMap(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StringBuffer sql = new StringBuffer();
            if (ctx == null) {
                sql.append("SELECT FID, FNumber,FName_l2 FROM T_BG_BgPeriod");
            } else {
                sql.append("SELECT FID, FNumber,FName_" + ctx.getLocale() + " FROM T_BG_BgPeriod");
            }
            IRowSet rowset = FpItemFormulaHelper.exec(ctx, sql.toString());
            while (rowset.next()) {
                map.put(rowset.getString("FNumber"), rowset.getString("FID"));
                if (ctx == null) {
                    map.put(rowset.getString("FName_l2"), rowset.getString("FID"));
                    continue;
                }
                map.put(rowset.getString("FName_" + ctx.getLocale()), rowset.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return map;
    }

    public static Map getPeriodInfoMap(Context ctx) throws BOSException {
        HashMap<String, BgPeriodInfo> map = new HashMap<String, BgPeriodInfo>();
        IBgPeriod iBgPeriod = null;
        iBgPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)ctx);
        BgPeriodCollection coll = iBgPeriod.getBgPeriodCollection();
        BgPeriodInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getNumber(), info);
        }
        return map;
    }

    public static Map getCurrencyMap(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StringBuffer sql = new StringBuffer();
            if (ctx == null) {
                sql.append("SELECT FID, FNumber,FName_l2 FROM T_BD_Currency");
            } else {
                sql.append("SELECT FID, FNumber,FName_" + ctx.getLocale() + " FROM T_BD_Currency");
            }
            IRowSet rowset = FpItemFormulaHelper.exec(ctx, sql.toString());
            while (rowset.next()) {
                map.put(rowset.getString("FNumber"), rowset.getString("FID"));
                if (ctx == null) {
                    map.put(rowset.getString("FName_l2"), rowset.getString("FNumber"));
                    continue;
                }
                map.put(rowset.getString("FName_" + ctx.getLocale()), rowset.getString("FNumber"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return map;
    }

    public static Map getCurrencyInfoMap(Context ctx) throws BOSException {
        HashMap<String, CurrencyInfo> map = new HashMap<String, CurrencyInfo>();
        ICurrency iCurrency = null;
        iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection coll = iCurrency.getCurrencyCollection();
        CurrencyInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            map.put(info.getNumber(), info);
        }
        return map;
    }

    private static IRowSet exec(Context ctx, String sql) throws BOSException {
        ISQLExecutor exec = null;
        exec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rowset = exec.executeSQL();
        return rowset;
    }

    public static void validateItemFormula(Context ctx, ICell cell) {
        if (!FpFormHelper.hasItemFormula(cell)) {
            return;
        }
    }

    public static boolean validateAsstItemComb(Context ctx, String asstItemComb) throws BOSException {
        if (FMHelper.isEmpty((String)asstItemComb)) {
            return true;
        }
        String[] asstItems = FpItemFormulaParser.getAssistItems(asstItemComb);
        if (asstItems == null || asstItems.length <= 0) {
            return false;
        }
        Map asstItemMap = FpItemFormulaHelper.getAsstItemMap(ctx);
        int len = asstItems.length;
        for (int i = 0; i < len; ++i) {
            if (asstItemMap.containsKey(asstItems[i])) continue;
            return false;
        }
        String[] groups = FpItemFormulaParser.getAssistItemGroups(asstItemComb);
        HashMap<String, String> groupMap = new HashMap<String, String>();
        int len2 = groups.length;
        for (int i = 0; i < len2; ++i) {
            if (groupMap.containsKey(groups[i])) {
                return false;
            }
            groupMap.put(groups[i], groups[i]);
        }
        return true;
    }
}

