/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.fpl.FPItemFormulaFormat;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;

public class FpItemFormulaParser {
    private static final String REGEX = "|";
    private static final String CONVERT_REGEX = "\\|";
    private String formula = "";
    private String[] params = null;
    private Context ctx = null;
    Map itemMap = null;
    Map asstItemCombMap = null;
    Map periodMap = null;
    Map currencyMap = null;
    private FPItemFormulaFormat itemFmt = null;

    public FpItemFormulaParser(String formula) {
        this.formula = formula;
        this.itemFmt = FPItemFormulaFormat.getInstance();
    }

    public FpItemFormulaParser(Context ctx, String formula) {
        this.ctx = ctx;
        this.formula = formula;
        this.itemFmt = FPItemFormulaFormat.getInstance();
    }

    public void parse() throws ParserException {
        FormulaHint hint;
        List list;
        if (!StringUtils.isEmpty((String)this.formula) && (list = TableToolkit.parseFormula((String)this.formula, (boolean)false)) != null && (hint = (FormulaHint)list.get(0)) != null) {
            this.params = hint.getParams();
        }
    }

    public String getCommonFormula() throws ParserException {
        if (this.params == null || this.params.length != 5) {
            return null;
        }
        FpItemFormulaInfo info = new FpItemFormulaInfo();
        info.setItemNum(this.params[0]);
        info.setAsstItemCombine(this.params[1]);
        info.setPeriodNum(this.params[2]);
        info.setCurrencyNum(this.params[4]);
        return this.itemFmt.format(info);
    }

    public void setDataType(FpDataTypeEnum dataType) throws ParserException {
        if (this.params == null || this.params.length != 5) {
            return;
        }
        FpItemFormulaInfo info = new FpItemFormulaInfo();
        info.setItemNum(this.params[0]);
        info.setAsstItemCombine(this.params[1]);
        info.setPeriodNum(this.params[2]);
        info.setDataType(dataType);
        info.setCurrencyNum(this.params[4]);
        this.formula = this.itemFmt.format(info);
    }

    public FpDataTypeEnum getDataType() {
        if (this.params == null || this.params.length != 5) {
            return null;
        }
        String dataType = this.params[3];
        return FpDataTypeEnum.getEnum(dataType);
    }

    public String[] getAssistItems() {
        if (this.params[1] == null) {
            return null;
        }
        return FpItemFormulaParser.getAssistItems(this.params[1]);
    }

    public static String[] getAssistItems(String asstItemComb) {
        if (asstItemComb == null) {
            return null;
        }
        String itemCombine = asstItemComb;
        String[] temp = itemCombine.split(CONVERT_REGEX);
        int len = temp.length;
        if (len <= 0 || len % 2 != 0) {
            return null;
        }
        String[] items = new String[len / 2];
        for (int i = 0; i < len; i += 2) {
            items[i / 2] = temp[i] + REGEX + temp[i + 1];
        }
        return items;
    }

    public static String[] getAssistItemGroups(String asstItemComb) {
        if (asstItemComb == null) {
            return null;
        }
        String itemCombine = asstItemComb;
        String[] temp = itemCombine.split(CONVERT_REGEX);
        int len = temp.length;
        if (len <= 0 || len % 2 != 0) {
            return null;
        }
        String[] groups = new String[len / 2];
        for (int i = 0; i < len; i += 2) {
            groups[i / 2] = temp[i];
        }
        return groups;
    }

    public String getDetailFormula() throws BOSException {
        if (this.itemMap == null) {
            this.itemMap = FpItemFormulaHelper.getItemInfoMap(this.ctx);
        }
        if (this.asstItemCombMap == null) {
            // empty if block
        }
        if (this.periodMap == null) {
            this.periodMap = FpItemFormulaHelper.getPeriodInfoMap(this.ctx);
        }
        if (this.currencyMap == null) {
            this.currencyMap = FpItemFormulaHelper.getCurrencyInfoMap(this.ctx);
        }
        StringBuffer sb = new StringBuffer();
        FpItemInfo itemInfo = (FpItemInfo)this.itemMap.get(this.getItem());
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"53_FpItemFormulaParser")).append(itemInfo.getName()).append("\"(").append(itemInfo.getNumber()).append(")");
        BgPeriodInfo periodInfo = (BgPeriodInfo)this.periodMap.get(this.getPeriod());
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"54_FpItemFormulaParser")).append(periodInfo.getName()).append("\"(").append(periodInfo.getNumber()).append(")");
        CurrencyInfo currencyInfo = (CurrencyInfo)this.currencyMap.get(this.getCurrency());
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"64_FpItemFormulaParser")).append(currencyInfo.getName()).append("(").append(currencyInfo.getNumber()).append(")");
        return sb.toString();
    }

    public String getItem() {
        return this.params == null ? null : this.params[0];
    }

    public String getAsstItemComb() {
        return this.params == null ? null : this.params[1];
    }

    public String getPeriod() {
        return this.params == null ? null : this.params[2];
    }

    public String getCurrency() {
        return this.params == null ? null : this.params[4];
    }

    public boolean isOnlyHasItem() {
        return this.params[0] != null && this.params[0].trim().length() > 0 && (this.params[1] == null || this.params[1].trim().length() == 0);
    }

    public boolean isItemEmpty() {
        return this.params[0] == null || this.params[0].trim().length() == 0;
    }

    public boolean isAsstItemCombEmpty() {
        return this.params[1] == null || this.params[1].trim().length() == 0;
    }

    public boolean isPeriodEmpty() {
        return this.params[2] == null || this.params[2].trim().length() == 0;
    }

    public boolean isDataTypeEmpty() {
        return this.params[3] == null || this.params[3].trim().length() == 0;
    }

    public boolean isCurrencyEmpty() {
        return this.params[4] == null || this.params[4].trim().length() == 0;
    }

    public boolean isFull() {
        return !this.isItemEmpty() && !this.isDataTypeEmpty() && !this.isPeriodEmpty() && !this.isCurrencyEmpty();
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String[] getParams() {
        return this.params;
    }
}

