/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPCtrlBillTypeEnum;
import com.kingdee.eas.fm.fpl.FPCtrlParamCollection;
import com.kingdee.eas.fm.fpl.FPCtrlParamInfo;
import com.kingdee.eas.fm.fpl.FpCtrlException;
import com.kingdee.eas.fm.fpl.FpCtrlHelper;
import com.kingdee.eas.fm.fpl.FpCtrlLevelInfo;
import com.kingdee.eas.fm.fpl.FpCtrlPeriodInfo;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyInfo;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFPLCtrlHandler;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;

public class PaymentBillFPLCtrlHandler
implements IFPLCtrlHandler {
    FpCtrlHelper helper = new FpCtrlHelper();

    public FPCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)billId)) {
            return new FPCtrlParamCollection();
        }
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        PaymentBillInfo info = this.getPaymentBillCtrl(ctx).getPaymentBillInfo((IObjectPK)pk, sic);
        FPCtrlParamCollection paramColl = this.bulidParams(ctx, info);
        return paramColl;
    }

    public FPCtrlParamCollection bulidParams(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        FPCtrlParamCollection paramColl = new FPCtrlParamCollection();
        if (info == null || info.getFpItem() == null) {
            return paramColl;
        }
        String companyId = info.getCompany().getId().toString();
        boolean hasStrategy = FpCtrlHelper.hasExecutingStrategy(ctx, companyId, FPCtrlBillTypeEnum.PAYMENTBILL);
        if (!hasStrategy) {
            return paramColl;
        }
        FpCtrlStrategyInfo strategyInfo = FpCtrlHelper.getFpCtrlStrategyInfo(ctx, companyId, FPCtrlBillTypeEnum.PAYMENTBILL);
        if (strategyInfo == null) {
            return paramColl;
        }
        FPCtrlParamInfo paramInfo = new FPCtrlParamInfo();
        if (info.getId() != null) {
            paramInfo.setBillId(info.getId().toString());
        }
        paramInfo.setBillNumber(info.getNumber());
        paramInfo.setBizDate(info.getBizDate());
        paramInfo.setOrgUnitId(companyId);
        paramInfo.setReqAmount(info.getActPayAmt());
        FpItemInfo item = info.getFpItem();
        BgPeriodEnum periodEnum = BgPeriodEnum.MONTH;
        FpCtrlLevelInfo levelInfo = FpCtrlHelper.getCtrlLevelInfo(ctx, strategyInfo, item);
        FpCtrlPeriodInfo periodInfo = FpCtrlHelper.getCtrlPeriodInfo(ctx, strategyInfo, item);
        if (levelInfo == null || periodInfo == null) {
            throw new FpCtrlException(FpCtrlException.HASNOTLEVELORPERIOD, new Object[]{item.getName(), strategyInfo.getName()});
        }
        paramInfo.setIsNeedCtrl(levelInfo.isIsNeedCtrl());
        paramInfo.setCtrlLevel(levelInfo.isCtrlLevel());
        paramInfo.setCtrlPeriod(periodInfo.getCtrlPeriod());
        paramInfo.setPeriodCtrl(periodInfo.getPeriodCtrl());
        paramInfo.setCtrlItemId(item.getId().toString());
        paramInfo.setCtrlItemNumber(item.getNumber());
        if (levelInfo.isIsNeedCtrl() && !levelInfo.isCtrlLevel()) {
            FpItemInfo superItemInfo = this.helper.findValidSuperFpItem(ctx, strategyInfo, item.getNumber());
            if (superItemInfo == null) {
                paramInfo.setIsNeedCtrl(false);
            } else {
                paramInfo.setCtrlItemId(superItemInfo.getId().toString());
                paramInfo.setCtrlItemNumber(superItemInfo.getNumber());
                paramInfo.setIsNeedCtrl(true);
                paramInfo.setCtrlLevel(true);
                periodInfo = FpCtrlHelper.getCtrlPeriodInfo(ctx, strategyInfo, superItemInfo);
                paramInfo.setCtrlPeriod(periodInfo.getCtrlPeriod());
                paramInfo.setPeriodCtrl(periodInfo.getPeriodCtrl());
            }
        }
        periodEnum = periodInfo.getCtrlPeriod();
        String assistItem = null;
        BgPeriodInfo period = FpCtrlHelper.getPeriod(ctx, periodEnum, info.getBizDate());
        CurrencyInfo currency = FpCtrlHelper.getCurrency(ctx, info.getCurrency());
        String itemFormula = FpCtrlHelper.getItemFormula(item.getNumber(), assistItem, period.getNumber(), currency.getNumber());
        paramInfo.setItemFormula(itemFormula);
        paramInfo.setItemId(item.getId().toString());
        paramInfo.setItemNumber(item.getNumber());
        paramInfo.setPeriodId(period.getId().toString());
        paramInfo.setPeriodNumber(period.getNumber());
        paramInfo.setCurrencyId(currency.getId().toString());
        paramInfo.setCurrencyNumber(currency.getNumber());
        paramColl.add(paramInfo);
        return paramColl;
    }

    private IPaymentBill getPaymentBillCtrl(Context ctx) throws BOSException {
        if (ctx == null) {
            return PaymentBillFactory.getRemoteInstance();
        }
        return PaymentBillFactory.getLocalInstance((Context)ctx);
    }
}

