/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPPastDataCollection;
import com.kingdee.eas.fm.fpl.FPPastDataInfo;
import com.kingdee.eas.fm.fpl.FPPastRecordInfo;
import com.kingdee.eas.fm.fpl.FpDataInfo;
import com.kingdee.eas.fm.fpl.FpFormFacadeFactory;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormHelper;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormStateEnum;
import com.kingdee.eas.fm.fpl.FpItemFormulaHelper;
import com.kingdee.eas.fm.fpl.FpItemFormulaParser;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.FpItemShowTypeEnum;
import com.kingdee.eas.fm.fpl.IFpForm;
import com.kingdee.eas.fm.fpl.IFpFormFacade;
import com.kingdee.eas.fm.fpl.app.AbstractFPPastDataControllerBean;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FPPastDataControllerBean
extends AbstractFPPastDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FPPastDataControllerBean");

    protected void _savePastData(Context ctx, String formId, String pastRecordId) throws BOSException, EASBizException {
        FPPastDataCollection coll = this.genPastData(ctx, formId, pastRecordId);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT T_FPL_FpPastData (FID, FOldValue, FChangeValue, FPastRecordID, FFpDataID) ").append(" VALUES (?, ?, ?, ?, ?)");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            FPPastDataInfo info = null;
            int index = 0;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                index = 0;
                pstmt.setString(++index, info.getId().toString());
                pstmt.setBigDecimal(++index, info.getOldValue());
                pstmt.setBigDecimal(++index, info.getChangeValue());
                pstmt.setString(++index, info.getPastRecord().getId().toString());
                pstmt.setString(++index, info.getFpDataID());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private FPPastDataCollection genPastData(Context ctx, String formId, String pastRecordId) throws EASBizException, BOSException {
        IFpFormFacade facade = FpFormFacadeFactory.getLocalInstance(ctx);
        Map fpDataMap = facade.getFpDataMap(formId);
        FPPastRecordInfo recordInfo = new FPPastRecordInfo();
        recordInfo.setId(BOSUuid.read((String)pastRecordId));
        Collection coll = fpDataMap.values();
        FpDataInfo info2 = null;
        FPPastDataCollection pastDataColl = new FPPastDataCollection();
        FPPastDataInfo pastDataInfo = null;
        BigDecimal changeValue = Constants.ZERO;
        for (FpDataInfo info2 : coll) {
            if (info2.getAdjustValue().compareTo(info2.getFpValue()) == 0) continue;
            changeValue = info2.getAdjustValue().add(info2.getFpValue().negate());
            pastDataInfo = new FPPastDataInfo();
            pastDataInfo.setId(BOSUuid.create((BOSObjectType)pastDataInfo.getBOSType()));
            pastDataInfo.setOldValue(info2.getFpValue());
            pastDataInfo.setChangeValue(changeValue);
            pastDataInfo.setPastRecord(recordInfo);
            pastDataInfo.setFpDataID(info2.getId());
            pastDataColl.add(pastDataInfo);
        }
        return pastDataColl;
    }

    protected List _getFpPastData(Context ctx, String formId, String itemFormula) throws BOSException, EASBizException {
        ArrayList<FPPastDataInfo> list = new ArrayList<FPPastDataInfo>();
        if (FMHelper.isEmpty((String)formId)) {
            return list;
        }
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, formId);
        if (!FMHelper.isEmpty((String)info.getAdjustRootID())) {
            formId = info.getAdjustRootID();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            boolean isIncludeFpData = info.getState().equals((Object)FpFormStateEnum.ADJUSTING) || info.getState().equals((Object)FpFormStateEnum.ADJUSTSUBMITED);
            boolean isNullFormula = FMHelper.isEmpty((String)itemFormula);
            String sql = this.getPastDataSql(isNullFormula);
            if (isIncludeFpData) {
                String pastDataSql = this.getPastDataSql(isNullFormula);
                String fpDataSql = this.getFpDataSql(isNullFormula);
                sql = "SELECT * FROM (" + pastDataSql + " UNION \n" + fpDataSql + ") a";
            }
            sql = sql + " ORDER BY formula, adjustDate";
            logger.info((Object)("FpPastDataControllerBean _getFpPastData sql:" + sql + "\n" + "fpFormId = " + formId + "\nversionNo = " + info.getVersionNo() + "\nformula = " + itemFormula));
            if (!isNullFormula) {
                FpItemFormulaParser parser = new FpItemFormulaParser(itemFormula);
                parser.parse();
                itemFormula = parser.getCommonFormula();
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 0;
            pstmt.setString(++index, formId);
            pstmt.setString(++index, info.getVersionNo());
            if (!isNullFormula) {
                pstmt.setString(++index, itemFormula);
            }
            if (isIncludeFpData) {
                pstmt.setString(++index, formId);
                if (!isNullFormula) {
                    pstmt.setString(++index, itemFormula);
                }
            }
            rs = pstmt.executeQuery();
            Map itemMap = FpItemFormulaHelper.getItemInfoMap(ctx);
            while (rs.next()) {
                list.add(this.genFastDataInfo(itemMap, rs));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return list;
    }

    private String getPastDataSql(boolean isNullFormula) {
        Locale locale = ContextUtils.getLocaleFromEnv();
        String loc = LocaleUtils.getLocaleString((Locale)locale);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT b.FFormula formula, b.FCurrencyID currencyId, \n").append(" \tc.FCreateTime adjustDate, a.FOldValue oldValue, \n").append(" \ta.FChangeValue changeValue, d.FName_" + loc + " adjustUser \n").append(" FROM T_FPL_FpPastData a \n").append("  LEFT JOIN T_FPL_FpData b ON a.FFpDataId = b.FId \n").append("  LEFT JOIN T_FPL_FpPastRecord c ON a.FPastRecordId = c.FId \n").append("  LEFT JOIN T_PM_User d on c.FCreatorId = d.FId \n").append(" WHERE c.FFpFormID = ? AND c.FVersionNo <= ? \n");
        if (!isNullFormula) {
            sql.append(" AND b.FFormula = ? \n");
        }
        return sql.toString();
    }

    private String getFpDataSql(boolean isNullFormula) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FFormula formula, FCurrencyID currencyID, null adjustDate, \n").append("\tFFpValue oldValue, (FAdjustValue - FFpValue) changeValue, null adjustUser \n").append(" FROM T_FPL_FpData WHERE FAdjustValue <> FFpValue AND FFpFormID = ? \n");
        if (!isNullFormula) {
            sql.append(" AND FFormula = ? \n");
        }
        return sql.toString();
    }

    private FPPastDataInfo genFastDataInfo(Map itemMap, ResultSet rs) throws SQLException, ParserException {
        String formula = rs.getString("formula");
        FpItemFormulaParser parser = new FpItemFormulaParser(formula);
        parser.parse();
        String fpItem = parser.getItem();
        String asstItemComb = parser.getAsstItemComb();
        BigDecimal oldValue = rs.getBigDecimal("oldValue");
        BigDecimal changeValue = rs.getBigDecimal("changeValue");
        BigDecimal adjustValue = oldValue.add(changeValue);
        FPPastDataInfo info = new FPPastDataInfo();
        FpItemInfo itemInfo = (FpItemInfo)itemMap.get(fpItem);
        itemInfo.setShowType(FpItemShowTypeEnum.NUMBERANDNAME);
        info.setFpItem(itemInfo);
        info.setFpAsstItemComb(asstItemComb);
        info.setOldValue(oldValue);
        info.setChangeValue(changeValue);
        info.setAdjustValue(adjustValue);
        info.setAdjustDate(rs.getDate("adjustDate"));
        info.setAdjustUser(rs.getString("adjustUser"));
        info.setCurrencyId(rs.getString("currencyID"));
        return info;
    }

    protected Map _getFpPastDataMap(Context ctx, String formId) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (FMHelper.isEmpty((String)formId)) {
            return map;
        }
        IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
        if (!iFpForm.exists((IObjectPK)new ObjectUuidPK(formId))) {
            return map;
        }
        FpFormInfo info = FpFormHelper.getFpFormInfo(ctx, formId);
        if (!FMHelper.isEmpty((String)info.getAdjustRootID())) {
            formId = info.getAdjustRootID();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT b.FFormula ").append(" FROM T_FPL_FpPastData a \n").append("  LEFT JOIN T_FPL_FpData b ON a.FFpDataId = b.FId \n").append("  LEFT JOIN T_FPL_FpPastRecord c ON a.FPastRecordId = c.FId \n").append(" WHERE c.FFpFormID = ? ");
            logger.info((Object)("FpPastDataControllerBean _getFpPastData Map sql:" + sql.toString() + "\n" + "fpFormId = " + formId));
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 0;
            pstmt.setString(++index, formId);
            rs = pstmt.executeQuery();
            String formula = null;
            while (rs.next()) {
                formula = rs.getString("FFormula");
                map.put(formula, formula);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return map;
    }
}

