/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fpl.FpAssistItemInfo;
import com.kingdee.eas.fm.fpl.FpItemException;
import com.kingdee.eas.fm.fpl.app.AbstractFpAssistItemControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class FpAssistItemControllerBean
extends AbstractFpAssistItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FpAssistItemControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpAssistItemInfo info = (FpAssistItemInfo)model;
        if (FMHelper.isEmpty((String)info.getRefField())) {
            String id = info.getGroup().getRefField();
            info.setRefField(id);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"refField");
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        String itemNum = info.getNumber();
        String itemParentNum = null;
        String itemGroupID = null;
        itemGroupID = info.getGroup().getId().toString();
        int dot = itemNum.lastIndexOf(".");
        if (dot == -1) {
            info.setLevel(1);
            info.setIsLeaf(true);
        } else {
            itemParentNum = itemNum.substring(0, dot);
            FpAssistItemInfo parentInfo = null;
            try {
                parentInfo = this.getFpAssistItemInfo(ctx, "select id,level,displayName where number='" + itemParentNum + "' and Group.id='" + itemGroupID + "'");
            }
            catch (Exception e) {
                throw new FpItemException(FpItemException.PARENTNOTEXIST, (Object[])new String[]{itemParentNum});
            }
            if (parentInfo == null) {
                throw new FpItemException(FpItemException.PARENTNOTEXIST, (Object[])new String[]{itemParentNum});
            }
            info.setParent(parentInfo);
            info.setLevel(parentInfo.getLevel() + 1);
            info.setIsLeaf(true);
            parentInfo.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (IObjectValue)parentInfo);
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._checkIsUsed(ctx, pk.toString());
        if (this.isLeaf(ctx, pk)) {
            this.parentHaveLeaf(ctx, pk);
            super._delete(ctx, pk);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkIsUsed(ctx, pk.toString());
        super._update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parentHaveLeaf(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FpAssistItemInfo info = this.getFpAssistItemInfo(ctx, pk);
        if (info.getParent() == null) {
            return;
        }
        String parentID = info.getParent().getId().toString();
        String PKID = pk.toString();
        String sql = "select fid from t_fpl_fpAssistitem where fparentid=? and fid !=? and fid != ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, parentID);
            stmt.setString(2, parentID);
            stmt.setString(3, PKID);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                this.updateParentToLeaf(ctx, parentID);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateParentToLeaf(Context ctx, String parentID) throws BOSException {
        String sql = "update t_fpl_fpAssistitem set fisleaf=1  where fid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, parentID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private boolean isLeaf(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FpAssistItemInfo info = this.getFpAssistItemInfo(ctx, pk);
        boolean result = info.isIsLeaf();
        if (!result) {
            throw new FpItemException(FpItemException.ISNOTLEAF);
        }
        return result;
    }

    protected void _checkIsUsed(Context ctx, String id) throws BOSException, EASBizException {
        FpAssistItemInfo info = this.getFpAssistItemInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        String refField = info.getRefField();
        if (refField == null || refField.trim().length() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = null;
        try {
            conn = this.getConnection(ctx);
            sql = "SELECT fid FROM T_FPL_FpAssistItemCombi WHERE " + refField + "=?";
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                throw new FpItemException(FpItemException.ISUSE);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpAssistItemInfo info = (FpAssistItemInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        String id = info.getId() == null ? null : info.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)info, "number") + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }
}

