/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fpl.FpAssistItemGroupFactory;
import com.kingdee.eas.fm.fpl.FpAssistItemGroupInfo;
import com.kingdee.eas.fm.fpl.FpItemException;
import com.kingdee.eas.fm.fpl.IFpAssistItemGroup;
import com.kingdee.eas.fm.fpl.app.AbstractFpAssistItemGroupControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FpAssistItemGroupControllerBean
extends AbstractFpAssistItemGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FpAssistItemGroupControllerBean");

    protected void _checkIsUsed(Context ctx, String id) throws BOSException, EASBizException {
        IFpAssistItemGroup iFpItem = FpAssistItemGroupFactory.getLocalInstance(ctx);
        FpAssistItemGroupInfo info = iFpItem.getFpAssistItemGroupInfo((IObjectPK)new ObjectUuidPK(id));
        String refField = info.getRefField();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = null;
        try {
            conn = this.getConnection(ctx);
            sql = "SELECT fid FROM t_fpl_fpAssistItem WHERE  fGroupId='" + id + "'";
            ps = conn.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                throw new FpItemException(FpItemException.HASITEM);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._checkIsUsed(ctx, pk.toString());
        if (this.isLeaf(ctx, pk)) {
            this.parentHaveLeaf(ctx, pk);
            super._delete(ctx, pk);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkIsUsed(ctx, pk.toString());
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    private boolean isLeaf(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFpAssistItemGroup iFpItem = FpAssistItemGroupFactory.getLocalInstance(ctx);
        FpAssistItemGroupInfo info = iFpItem.getFpAssistItemGroupInfo(pk);
        boolean result = info.isIsLeaf();
        if (!result) {
            throw new FpItemException(FpItemException.ISNOTLEAF);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parentHaveLeaf(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFpAssistItemGroup iFpItem = FpAssistItemGroupFactory.getLocalInstance(ctx);
        FpAssistItemGroupInfo info = iFpItem.getFpAssistItemGroupInfo(pk);
        if (info.getParent() == null) {
            return;
        }
        String parentID = info.getParent().getId().toString();
        String PKID = pk.toString();
        String sql = "select fid from t_fpl_fpassistitemgroup where fparentid=? and fid !=? and fid != ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, parentID);
            stmt.setString(2, parentID);
            stmt.setString(3, PKID);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                this.updateParentToLeaf(ctx, parentID);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateParentToLeaf(Context ctx, String parentID) throws BOSException {
        String sql = "update t_fpl_fpassistitemgroup set fisleaf=1  where fid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, parentID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpAssistItemGroupInfo info = (FpAssistItemGroupInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        String id = info.getId() == null ? null : info.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, (DataBaseInfo)info, "name") + info.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpAssistItemGroupInfo info = (FpAssistItemGroupInfo)model;
        if (info.getRefField() == null || info.getRefField().trim().length() == 0) {
            info.setRefField(this.getNextRef(ctx));
        }
        if (info.getParent() != null && info.getParent().getId() == null) {
            info.setParent(null);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"reffield");
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        return super._addnew(ctx, model);
    }

    public String getNextRef(Context ctx) throws BOSException, EASBizException {
        String sql = "select freffield from T_FPL_FpAssistItemGroup ";
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        ArrayList<String> ref = new ArrayList<String>();
        try {
            while (rs.next()) {
                ref.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 1; i <= 100; ++i) {
            String temp = "F" + i;
            if (ref.contains(temp)) continue;
            return temp;
        }
        return null;
    }
}

