/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fpl.FpCtrlException;
import com.kingdee.eas.fm.fpl.FpCtrlHelper;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyCollection;
import com.kingdee.eas.fm.fpl.FpCtrlStrategyInfo;
import com.kingdee.eas.fm.fpl.FpFormCollection;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpTemplateSourceEnum;
import com.kingdee.eas.fm.fpl.IFpForm;
import com.kingdee.eas.fm.fpl.app.AbstractFpCtrlStrategyControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class FpCtrlStrategyControllerBean
extends AbstractFpCtrlStrategyControllerBean {
    private static Logger logger = Logger.getLogger((String)FpCtrlStrategyControllerBean.class.getName());

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FpCtrlStrategyInfo info = this.getFpCtrlStrategyInfo(ctx, pk);
        this.checkIsCanDelete(ctx, info);
        super._delete(ctx, pk);
    }

    private void checkIsCanDelete(Context ctx, FpCtrlStrategyInfo info) throws BOSException, FpCtrlException {
        String ouId;
        String id = info.getId().toString();
        if (this.isOnlyEnableCtrlStrategy(ctx, id, ouId = info.getOrgId())) {
            throw new FpCtrlException(FpCtrlException.CANNOTDELETEBYENABLED);
        }
        if (this.hasExecutingFpForm(ctx, ouId) && this.isOnlyEnableCtrlStrategy(ctx, id, ouId)) {
            throw new FpCtrlException(FpCtrlException.CANNOTDELETEBYEXECUTEFORM);
        }
    }

    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        FpCtrlStrategyInfo info = this.getFpCtrlStrategyInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.isEnabled()) {
            throw new FpCtrlException(FpCtrlException.STATEISENABLED);
        }
        if (this.hasEnabledStrategy(ctx, info.getOrgId())) {
            throw new FpCtrlException(FpCtrlException.CANNOTENABLEMORETHANONE);
        }
        String sql = "UPDATE T_FPL_FpCtrlStrategy SET FISENABLE = 1 WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    private boolean hasEnabledStrategy(Context ctx, String ouId) throws BOSException {
        FpCtrlStrategyCollection coll = this.getEnabledStrategyColl(ctx, ouId);
        return coll != null && !coll.isEmpty();
    }

    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        FpCtrlStrategyInfo info = this.getFpCtrlStrategyInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (!info.isEnabled()) {
            throw new FpCtrlException(FpCtrlException.STATEISDISABLED);
        }
        String sql = "UPDATE T_FPL_FpCtrlStrategy SET FISENABLE = 0 WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    private void checkIsCanDisable(Context ctx, FpCtrlStrategyInfo info) throws BOSException, FpCtrlException {
        String id = info.getId().toString();
        String ouId = info.getOrgId();
        if (this.hasExecutingFpForm(ctx, ouId) && this.isOnlyEnableCtrlStrategy(ctx, id, ouId)) {
            throw new FpCtrlException(FpCtrlException.CANNOTDISABLEBYEXECUTEFORM);
        }
    }

    private boolean isOnlyEnableCtrlStrategy(Context ctx, String id, String ouId) throws BOSException {
        FpCtrlStrategyCollection coll = this.getEnabledStrategyColl(ctx, ouId);
        return coll != null && coll.size() == 1 && coll.get(0).getId().toString().equals(id);
    }

    private FpCtrlStrategyCollection getEnabledStrategyColl(Context ctx, String ouId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgId", (Object)ouId));
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)Boolean.TRUE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FpCtrlStrategyCollection coll = this.getFpCtrlStrategyCollection(ctx, evi);
        return coll;
    }

    private boolean hasExecutingFpForm(Context ctx, String ouId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)ouId));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"executing"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IFpForm iFpForm = FpFormFactory.getLocalInstance(ctx);
        FpFormCollection coll = iFpForm.getFpFormCollection(evi);
        return coll != null && !coll.isEmpty();
    }

    protected void _assign(Context ctx, List ids, List subOuIds) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            throw new FpCtrlException(FpCtrlException.ASSIGN_STRATEGY_ISNULL);
        }
        if (subOuIds == null || subOuIds.size() <= 0) {
            throw new FpCtrlException(FpCtrlException.ASSIGN_SUBOU_ISNULL);
        }
        String id = null;
        FullOrgUnitInfo subOuInfo = null;
        FpCtrlStrategyInfo srcInfo = null;
        FpCtrlStrategyInfo destInfo = null;
        int size1 = ids.size();
        for (int i = 0; i < size1; ++i) {
            id = (String)ids.get(i);
            int size2 = subOuIds.size();
            for (int j = 0; j < size2; ++j) {
                subOuInfo = (FullOrgUnitInfo)subOuIds.get(j);
                srcInfo = this.getFpCtrlStrategyInfo(ctx, (IObjectPK)new ObjectUuidPK(id), FpCtrlHelper.getSelectors());
                destInfo = srcInfo.deepClone();
                destInfo.setOrgId(subOuInfo.getId().toString());
                destInfo.setCU(subOuInfo.getCU());
                destInfo.setSource(FpTemplateSourceEnum.ASSIGN);
                FilterInfo filter = FpCtrlStrategyControllerBean.getCheckNumberDupFilter(destInfo);
                if (this._exists(ctx, filter)) {
                    throw new FpCtrlException(FpCtrlException.NUMBERISDUP, new Object[]{subOuInfo.getName()});
                }
                this._addnew(ctx, (IObjectValue)destInfo);
            }
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FpCtrlStrategyControllerBean.getCheckNumberDupFilter((FpCtrlStrategyInfo)model);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    public static FilterInfo getCheckNumberDupFilter(FpCtrlStrategyInfo model) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgId", (Object)model.getOrgId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)model.getString("number")));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }
}

