/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.app.AbstractFpFormulaFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class FpFormulaFacadeControllerBean
extends AbstractFpFormulaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FpFormulaFacadeControllerBean");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BigDecimal _getFpValue(Context ctx, String orgNumber, String itemNumber, String asstItemCombNumber, String beginPeriodNumber, String endPeriodNumber, String valueType, String dataType, String currencyNumber) throws BOSException, EASBizException {
        BigDecimal value = Constants.ZERO;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String[] idArray = FpHelper.getFpPeriodIdsByNum(ctx, beginPeriodNumber, endPeriodNumber);
            if (idArray == null) {
                BigDecimal bigDecimal = value;
                return bigDecimal;
            }
            String ids = FpHelper.tranArray2String(idArray);
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT SUM(FFpValue) FpValue, SUM(FBizActual) Actual \n").append(" FROM T_FPL_FpData FpData \n").append(" LEFT JOIN T_FPL_FpForm Form ON FpData.FFpFormID = Form.FID \n").append(" LEFT JOIN T_ORG_BaseUnit BaseUnit ON Form.FOrgUnitID = BaseUnit.FID \n").append(" LEFT JOIN T_FPL_FpItem Item ON FpData.FFpItemID = Item.FID \n").append(" LEFT JOIN T_FPL_FpAssistItemCombi AsstItemComb ON FpData.FFpAssistItemCombID = AsstItemComb.FID \n").append(" LEFT JOIN T_BD_Currency Currency ON FpData.FCurrencyID = Currency.FID \n").append(" WHERE BaseUnit.FNumber = ? AND Item.FNumber = ? \n ").append(" \tAND FpData.FFpPeriodID IN ").append(ids).append("\n").append(" \tAND Currency.FNumber = ? \n");
            if (asstItemCombNumber == null || asstItemCombNumber.equals("")) {
                sql.append("\tAND AsstItemComb.FKey IS NULL \n");
            } else {
                sql.append("\tAND AsstItemComb.FKey = ? \n");
            }
            logger.info((Object)("getFpValue = \n" + sql.toString() + "\n orgUnit=" + orgNumber + "\n FpItem=" + itemNumber + "\n assistItemComb=" + asstItemCombNumber + "\n currency=" + currencyNumber));
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int i = 0;
            pstmt.setString(++i, orgNumber);
            pstmt.setString(++i, itemNumber);
            pstmt.setString(++i, currencyNumber);
            if (asstItemCombNumber != null && !asstItemCombNumber.equals("")) {
                pstmt.setString(++i, asstItemCombNumber);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                if (FpDataTypeEnum.P.getName().equals(dataType)) {
                    BigDecimal bigDecimal = rs.getBigDecimal("FpValue");
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                    return bigDecimal;
                }
                if (FpDataTypeEnum.A.getName().equals(dataType)) {
                    BigDecimal bigDecimal = rs.getBigDecimal("Actual");
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                    return bigDecimal;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return value;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, conn);
        }
    }

    protected String _parseFpItemCombi(Context ctx, String fpItemCombin) throws BOSException, EASBizException {
        return null;
    }
}

