/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.FpDataTypeEnum;
import com.kingdee.eas.fm.fpl.FpFormFactory;
import com.kingdee.eas.fm.fpl.FpFormInfo;
import com.kingdee.eas.fm.fpl.FpFormQueryFilterParam;
import com.kingdee.eas.fm.fpl.FpHelper;
import com.kingdee.eas.fm.fpl.FpRptAssistItemFilterParam;
import com.kingdee.eas.fm.fpl.FpRptException;
import com.kingdee.eas.fm.fpl.FpRptFilterParam;
import com.kingdee.eas.fm.fpl.FpTemplateFactory;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.app.AbstractFpRptFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpRptFacadeControllerBean
extends AbstractFpRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FpRptFacadeControllerBean");

    protected Map _getFpForm(Context ctx, FilterParam queryFilterParam) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FpFormQueryFilterParam param = (FpFormQueryFilterParam)queryFilterParam;
        FullOrgUnitInfo currentOrgUnit = FpHelper.getFullOrgUnitInfoById(ctx, param.getCurrentOrgUnitId());
        if (currentOrgUnit.isIsLeaf() || !param.isSum()) {
            FpFormInfo form = this.getFormInfoByCond(ctx, param);
            if (form != null && form.getZipData() != null) {
                result.put("byteTable", form.getZipData());
                result.put("formId", form.getId().toString());
                return result;
            }
            return null;
        }
        Map fpDataMap = this.getFpDataMapByCond(ctx, param, currentOrgUnit.getLongNumber());
        if (fpDataMap == null || fpDataMap.isEmpty()) {
            String[] filterOuIds = param.getFilterUnitIds();
            String[] currOuIds = new String[]{param.getCurrentOrgUnitId()};
            param.setFilterUnitIds(currOuIds);
            fpDataMap = this.getFpDataMapByCond(ctx, param, currentOrgUnit.getLongNumber());
            param.setFilterUnitIds(filterOuIds);
        }
        byte[] data = null;
        FpFormInfo form = this.getFormInfoByCond(ctx, param);
        if (form != null) {
            data = form.getZipData();
        } else {
            FpTemplateInfo template = FpTemplateFactory.getLocalInstance(ctx).getFpTemplateInfo((IObjectPK)new ObjectUuidPK(param.getFpTemplateID()));
            data = template.getKdtData();
        }
        result.put("byteTable", data);
        result.put("dataMap", fpDataMap);
        return result;
    }

    private FpFormInfo getFormInfoByCond(Context ctx, FpFormQueryFilterParam param) throws BOSException {
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql("select form.fid, form.fdata from t_fpl_fpform form\n");
        sqlBuilder.appendSql(" inner join t_fpl_fptemplate temp on form.ffptemplateid = temp.fid\n");
        sqlBuilder.appendSql(" where form.forgunitid =");
        sqlBuilder.appendParam((Object)param.getCurrentOrgUnitId());
        sqlBuilder.appendSql(" and form.fbgperiodid =");
        sqlBuilder.appendParam((Object)param.getBeginPeriodId());
        sqlBuilder.appendSql(" and form.fcurrencyid =");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql("\n and temp.frootid = (select frootid from t_fpl_fptemplate where fid =");
        sqlBuilder.appendParam((Object)param.getFpTemplateID());
        sqlBuilder.appendSql(")");
        String id = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = sqlBuilder.createState(conn);
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        if (id == null) {
            return null;
        }
        FpFormInfo form = null;
        try {
            form = FpFormFactory.getLocalInstance(ctx).getFpFormInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return form;
    }

    private Map getFpDataMapByCond(Context ctx, FpFormQueryFilterParam param, String currentOrgUnitNumber) throws BOSException, EASBizException {
        Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql("select data.FFormula formula, sum(data.FFpValue) fpValue, sum(data.FBizActual) acValue\n");
        sqlBuilder.appendSql(" from t_fpl_fpform form\n");
        sqlBuilder.appendSql(" inner join t_fpl_fptemplate tem on form.ffptemplateid = tem.fid\n");
        sqlBuilder.appendSql(" inner join t_fpl_fpdata data on form.fid = data.ffpformid\n");
        sqlBuilder.appendSql(" where tem.frootid = (select frootid from t_fpl_fptemplate where fid =");
        sqlBuilder.appendParam((Object)param.getFpTemplateID());
        sqlBuilder.appendSql(")\n");
        sqlBuilder.appendSql(" and form.FOrgUnitID in (");
        sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
        sqlBuilder.appendSql(")\n");
        sqlBuilder.appendSql(" and data.fCurrencyId = ");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql(" and data.FFpPeriodId in (");
        sqlBuilder.appendParam(periodIds);
        sqlBuilder.appendSql(")");
        sqlBuilder.appendSql(" group by data.FFormula");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap fpDataMap = new HashMap();
        try {
            conn = this.getConnection(ctx);
            stmt = sqlBuilder.createState(conn);
            rs = stmt.executeQuery();
            HashMap<FpDataTypeEnum, BigDecimal> valuesMap = null;
            while (rs.next()) {
                String formula = rs.getString("formula");
                BigDecimal fpValue = rs.getBigDecimal("fpValue");
                BigDecimal acValue = rs.getBigDecimal("acValue");
                valuesMap = new HashMap<FpDataTypeEnum, BigDecimal>();
                valuesMap.put(FpDataTypeEnum.P, fpValue);
                valuesMap.put(FpDataTypeEnum.A, acValue);
                fpDataMap.put(formula, valuesMap);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return fpDataMap;
    }

    protected IRowSet _getFpFormInOutAnlys(Context ctx, FilterParam filterParam) throws BOSException, EASBizException {
        return this.getFpFormInOutAnlysData(ctx, filterParam, "");
    }

    protected IRowSet _getFpFormInOutAnlysByParent(Context ctx, FilterParam filterParam, String parentId) throws BOSException, EASBizException {
        return this.getFpFormInOutAnlysData(ctx, filterParam, parentId);
    }

    private IRowSet getFpFormInOutAnlysData(Context ctx, FilterParam filterParam, String parentId) throws BOSException, EASBizException {
        FpRptFilterParam param = (FpRptFilterParam)filterParam;
        if (!param.isSum()) {
            this.checkFormExists(ctx, param);
        }
        Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql("select item.fid,item.fnumber, period.fnumber fperiodnumber, sum(data.FFpValue) FFpValue\n");
        sqlBuilder.appendSql(" from t_fpl_fpform form inner join t_fpl_fpdata data on form.fid = data.FFpFormId\n");
        sqlBuilder.appendSql(" inner join t_bg_bgperiod period on data.FFpPeriodId = period.fid\n");
        sqlBuilder.appendSql(" inner join t_fpl_fpitem item on data.FFpItemID = item.fid\n");
        sqlBuilder.appendSql(" where form.ffpcycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql(" and data.fcurrencyid = ");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql("\n and data.FFpPeriodId in (");
        sqlBuilder.appendParam(periodIds);
        sqlBuilder.appendSql(")");
        if (param.isSum()) {
            sqlBuilder.appendSql(" and form.FOrgUnitID in (");
            sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
            sqlBuilder.appendSql(")\n");
        } else {
            sqlBuilder.appendSql(" and form.FOrgUnitID =");
            sqlBuilder.appendParam((Object)param.getCurrentOrgUnitId());
        }
        sqlBuilder.appendSql(" and (data.FFpAssistItemCombID = '' or data.FFpAssistItemCombID is null) \n");
        if (!parentId.equals("")) {
            sqlBuilder.appendSql(" and item.fparentid =");
            sqlBuilder.appendParam((Object)parentId);
            sqlBuilder.appendSql(" and item.fid<>item.fparentid");
        }
        sqlBuilder.appendSql(" group by item.fid,item.fnumber,period.fnumber\n");
        sqlBuilder.appendSql(" order by item.fnumber");
        return this.getRowSet(ctx, sqlBuilder);
    }

    private String[] getPeriodIdsByBeginEnd(Context ctx, FpRptFilterParam param) throws BOSException, EASBizException {
        String[] periodIds = FpHelper.getFpPeriodIds(ctx, param.getBeginPeriodId(), param.getEndPeriodId());
        return periodIds;
    }

    protected IRowSet _getFpFormExecTrace(Context ctx, FilterParam filterParam) throws BOSException, EASBizException {
        return this.getFpFormExecTraceData(ctx, filterParam, "");
    }

    protected IRowSet _getFpFormExecTraceByParent(Context ctx, FilterParam filterParam, String parentId) throws BOSException, EASBizException {
        return this.getFpFormExecTraceData(ctx, filterParam, parentId);
    }

    private IRowSet getFpFormExecTraceData(Context ctx, FilterParam filterParam, String parentId) throws BOSException, EASBizException {
        FpRptFilterParam param = (FpRptFilterParam)filterParam;
        if (!param.isSum()) {
            this.checkFormExists(ctx, param);
        }
        Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql("select item.fnumber itemnumber, period.fnumber periodnumber, sum(data.FFpValue) FFpValue, sum(data.FBizActual) FBizActual\n");
        sqlBuilder.appendSql(" from t_fpl_fpform form inner join t_fpl_fpdata data on form.fid = data.FFpFormId\n");
        sqlBuilder.appendSql(" inner join t_bg_bgperiod period on data.FFpPeriodId = period.fid\n");
        sqlBuilder.appendSql(" inner join t_fpl_fpitem item on data.FFpItemID = item.fid\n");
        sqlBuilder.appendSql(" where form.ffpcycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql(" and data.fcurrencyid = ");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql("\n and data.FFpPeriodId in (");
        sqlBuilder.appendParam(periodIds);
        sqlBuilder.appendSql(")");
        if (param.isSum()) {
            sqlBuilder.appendSql(" and form.FOrgUnitID in (");
            sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
            sqlBuilder.appendSql(")\n");
        } else {
            sqlBuilder.appendSql(" and form.FOrgUnitID =");
            sqlBuilder.appendParam((Object)param.getCurrentOrgUnitId());
        }
        sqlBuilder.appendSql(" and (data.FFpAssistItemCombID = '' or data.FFpAssistItemCombID is null)\n");
        if (!parentId.equals("")) {
            sqlBuilder.appendSql(" and item.fparentid =");
            sqlBuilder.appendParam((Object)parentId);
            sqlBuilder.appendSql(" and item.fid<>item.fparentid");
        }
        sqlBuilder.appendSql(" group by item.fnumber, period.fnumber\n");
        sqlBuilder.appendSql(" order by item.fnumber");
        return this.getRowSet(ctx, sqlBuilder);
    }

    protected IRowSet _getFpItems(Context ctx, FPItemDirectionEnum direction) throws BOSException, EASBizException {
        SQLUtil sqlBuilder = new SQLUtil();
        String lang = ctx.getLocale().getLanguage();
        sqlBuilder.appendSql("select fname_" + lang + " fname, fnumber, fisleaf, fid, fparentid, flevel\n");
        sqlBuilder.appendSql(" from t_fpl_fpitem a\n");
        sqlBuilder.appendSql(" where fdirection = ");
        sqlBuilder.appendParam((Object)direction.getValue());
        sqlBuilder.appendSql(" and flevel = 1 ");
        sqlBuilder.appendSql("\n order by flongnumber");
        return this.getRowSet(ctx, sqlBuilder);
    }

    protected IRowSet _getFpItemsByParent(Context ctx, String parentId) throws BOSException, EASBizException {
        SQLUtil sqlBuilder = new SQLUtil();
        String lang = ctx.getLocale().getLanguage();
        sqlBuilder.appendSql("select fname_" + lang + " fname, fnumber, fisleaf, fid, fparentid, flevel\n");
        sqlBuilder.appendSql(" from t_fpl_fpitem a\n");
        sqlBuilder.appendSql(" where fparentid = ");
        sqlBuilder.appendParam((Object)parentId);
        sqlBuilder.appendSql(" and fid <>fparentid ");
        sqlBuilder.appendSql("\n order by flongnumber");
        return this.getRowSet(ctx, sqlBuilder);
    }

    private void checkFormExists(Context ctx, FpRptFilterParam param) throws BOSException, EASBizException {
        boolean isExists = false;
        Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql("select count(fid) count");
        sqlBuilder.appendSql(" from t_fpl_fpform\n");
        sqlBuilder.appendSql(" where FFpCycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql(" and FCurrencyID = ");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql("\n and FBgPeriodID in (");
        sqlBuilder.appendParam(periodIds);
        sqlBuilder.appendSql(")\n");
        sqlBuilder.appendSql(" and FOrgUnitID =");
        sqlBuilder.appendParam((Object)param.getCurrentOrgUnitId());
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = sqlBuilder.createState(conn);
            rs = stmt.executeQuery();
            rs.next();
            if (rs.getInt("count") > 0) {
                isExists = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        if (!isExists) {
            throw new FpRptException(FpRptException.FORM_NOT_EXISTS);
        }
    }

    protected IRowSet _getFpAssistInOutAnalyse(Context ctx, FilterParam filterParam) throws BOSException, EASBizException {
        SQLUtil sqlBuilder = new SQLUtil();
        FpRptAssistItemFilterParam param = (FpRptAssistItemFilterParam)filterParam;
        Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
        String lang = ctx.getLocale().getLanguage();
        String assistitemField = param.getAssistItemGroup().getRefField();
        Object[] assistitems = param.getAssistItems();
        sqlBuilder.appendSql(" select item.fnumber||assistitem.fnumber fitemassistnumber ");
        sqlBuilder.appendSql(" ,period.fnumber periodnumber,sum(dat.ffpvalue) FFpValue");
        sqlBuilder.appendSql(" from  t_fpl_fpdata dat left join t_bg_bgperiod period on dat.FFpPeriodId =period.fid");
        sqlBuilder.appendSql(" inner join t_fpl_fpitem item on dat.ffpitemid=item.fid  ");
        sqlBuilder.appendSql(" inner join t_fpl_fpassistitemcombi assist on dat.ffpassistitemcombid=assist.fid ");
        sqlBuilder.appendSql(" inner join t_fpl_fpassistitem assistitem on assist." + assistitemField + "=assistitem.fid");
        sqlBuilder.appendSql(" inner join t_fpl_fpform form on dat.ffpformid=form.fid");
        sqlBuilder.appendSql(" where form.ffpcycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql(" and dat.ffpperiodid in (");
        sqlBuilder.appendParam(periodIds);
        sqlBuilder.appendSql(")");
        if (param.isSum()) {
            sqlBuilder.appendSql(" and form.FOrgUnitID in (");
            sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
            sqlBuilder.appendSql(")\n");
        } else {
            sqlBuilder.appendSql(" and form.FOrgUnitID =");
            sqlBuilder.appendParam((Object)param.getCurrentOrgUnitId());
        }
        sqlBuilder.appendSql(" and assistitem.fisleaf=1");
        sqlBuilder.appendSql(" and (item.fdirection =");
        sqlBuilder.appendParam((Object)"in");
        sqlBuilder.appendSql(" or fdirection = ");
        sqlBuilder.appendParam((Object)"out");
        sqlBuilder.appendSql(")");
        sqlBuilder.appendSql(" and dat.fcurrencyid =");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql(" and dat.ffpassistitemcombid is not null");
        if (assistitems != null && assistitems.length > 0) {
            sqlBuilder.appendSql(" and assistitem.fid in (");
            sqlBuilder.appendParam(assistitems);
            sqlBuilder.appendSql(" )");
        }
        if (!param.isShowZeroRec()) {
            sqlBuilder.appendSql(" and dat.ffpvalue <>0 ");
        }
        sqlBuilder.appendSql("  group by   item.fname_" + lang + ",item.fnumber ,assistitem.fname_" + lang + ",assistitem.fnumber ,assistitem.fisleaf,assistitem.fid,assistitem.fparentid,assistitem.flevel,period.fnumber");
        sqlBuilder.appendSql("  order by item.fnumber,assistitem.fnumber");
        return this.getRowSet(ctx, sqlBuilder);
    }

    protected IRowSet _getFpAssistItems(Context ctx, FPItemDirectionEnum direction, FilterParam filterParam) throws BOSException, EASBizException {
        SQLUtil sqlBuilder = new SQLUtil();
        FpRptAssistItemFilterParam param = (FpRptAssistItemFilterParam)filterParam;
        String lang = ctx.getLocale().getLanguage();
        String assistitemField = param.getAssistItemGroup().getRefField();
        Object[] assistitems = param.getAssistItems();
        sqlBuilder.appendSql("select item.fname_" + lang + "||'\uff08" + ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"7_FpRptFacadeControllerBean", (Locale)ctx.getLocale()) + "\uff09' fitemname,item.fnumber fitemnumber ");
        sqlBuilder.appendSql(" ,assistitem.fname_" + lang + "||'\uff08" + ResourceBase.getString((String)"com.kingdee.eas.fm.fpl.FPLAutoGenerateResource", (String)"8_FpRptFacadeControllerBean", (Locale)ctx.getLocale()) + "\uff09' fname, assistitem.fnumber fassistnumber ");
        sqlBuilder.appendSql(" ,item.fnumber||assistitem.fnumber fitemassistnumber ");
        sqlBuilder.appendSql(" ,assistitem.fisleaf,assistitem.fid,assistitem.fparentid,assistitem.flevel");
        sqlBuilder.appendSql(" from  t_fpl_fpdata dat ");
        sqlBuilder.appendSql(" inner join t_fpl_fpitem item on dat.ffpitemid=item.fid  ");
        sqlBuilder.appendSql(" inner join t_fpl_fpassistitemcombi assist on dat.ffpassistitemcombid=assist.fid ");
        sqlBuilder.appendSql(" inner join t_fpl_fpassistitem assistitem on assist." + assistitemField + "=assistitem.fid");
        sqlBuilder.appendSql(" inner join t_fpl_fpform form on dat.ffpformid=form.fid");
        sqlBuilder.appendSql(" where form.ffpcycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql("  and dat.fcurrencyid =");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        if (param.isSum()) {
            sqlBuilder.appendSql(" and form.FOrgUnitID in (");
            sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
            sqlBuilder.appendSql(")\n");
        } else {
            sqlBuilder.appendSql(" and form.FOrgUnitID =");
            sqlBuilder.appendParam((Object)param.getCurrentOrgUnitId());
        }
        sqlBuilder.appendSql(" and dat.ffpassistitemcombid is not null");
        sqlBuilder.appendSql(" and assistitem.fisleaf=1");
        sqlBuilder.appendSql(" and item.fdirection = ");
        sqlBuilder.appendParam((Object)direction.getValue());
        if (assistitems != null && assistitems.length > 0) {
            sqlBuilder.appendSql(" and assistitem.fid in (");
            sqlBuilder.appendParam(assistitems);
            sqlBuilder.appendSql(" )");
        }
        if (!param.isShowZeroRec()) {
            sqlBuilder.appendSql(" and dat.ffpvalue <>0 ");
        }
        sqlBuilder.appendSql("  group by item.fname_" + lang + ",item.fnumber ,assistitem.fname_" + lang + ",assistitem.fnumber ,assistitem.fisleaf,assistitem.fid,assistitem.fparentid,assistitem.flevel");
        sqlBuilder.appendSql("  order by item.fnumber,assistitem.fnumber");
        return this.getRowSet(ctx, sqlBuilder);
    }

    private IRowSet getRowSet(Context ctx, SQLUtil sqlBuilder) throws BOSException {
        JdbcRowSet rowSet = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = sqlBuilder.createState(conn);
            rs = stmt.executeQuery();
            rowSet = new JdbcRowSet();
            rowSet.populate(rs);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return rowSet;
    }

    protected IRowSet _getAssistItemDataGroupByOrgi(Context ctx, FilterParam filterParam) throws BOSException, EASBizException {
        SQLUtil sqlBuilder = new SQLUtil();
        FpRptAssistItemFilterParam param = (FpRptAssistItemFilterParam)filterParam;
        Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
        String lang = ctx.getLocale().getLanguage();
        String assistitemField = param.getAssistItemGroup().getRefField();
        sqlBuilder.appendSql(" select item.fnumber||assistitem.fnumber fnumber ");
        sqlBuilder.appendSql(" ,period.fnumber periodnumber,org.fname_" + lang + " forgname,sum(dat.ffpvalue) FFpValue");
        sqlBuilder.appendSql(" from  t_fpl_fpdata dat left join t_bg_bgperiod period on dat.FFpPeriodId =period.fid");
        sqlBuilder.appendSql(" inner join t_fpl_fpitem item on dat.ffpitemid=item.fid  ");
        sqlBuilder.appendSql(" inner join t_fpl_fpassistitemcombi assist on dat.ffpassistitemcombid=assist.fid ");
        sqlBuilder.appendSql(" inner join t_fpl_fpassistitem assistitem on assist." + assistitemField + "=assistitem.fid");
        sqlBuilder.appendSql(" inner join t_fpl_fpform form on dat.ffpformid=form.fid");
        sqlBuilder.appendSql(" inner join T_ORG_BaseUnit org on form.forgunitid=org.fid");
        sqlBuilder.appendSql(" where form.ffpcycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql(" and dat.ffpperiodid in (");
        sqlBuilder.appendParam(periodIds);
        sqlBuilder.appendSql(")");
        sqlBuilder.appendSql(" and form.FOrgUnitID in (");
        sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
        sqlBuilder.appendSql(")\n");
        sqlBuilder.appendSql(" and item.fnumber || assistitem.fnumber=");
        sqlBuilder.appendParam((Object)param.getAssistAndItemNumber());
        sqlBuilder.appendSql(" and dat.fcurrencyid =");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql("  group by item.fnumber,assistitem.fnumber,org.fid, org.fname_" + lang + ",period.fnumber");
        sqlBuilder.appendSql("  order by org.fid");
        return this.getRowSet(ctx, sqlBuilder);
    }

    protected IRowSet _getItemDataGroupByOrgi(Context ctx, FilterParam filterParam) throws BOSException, EASBizException {
        SQLUtil sqlBuilder = new SQLUtil();
        FpRptFilterParam param = (FpRptFilterParam)filterParam;
        Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
        String lang = ctx.getLocale().getLanguage();
        sqlBuilder.appendSql(" select item.fnumber fnumber ");
        sqlBuilder.appendSql(" ,period.fnumber periodnumber,org.fname_" + lang + " forgname," + " sum(dat.ffpvalue) FFpValue, sum(dat.fbizactual) FBizActual, sum(dat.ffpvalue-dat.fbizactual) FDiff");
        sqlBuilder.appendSql(" from  t_fpl_fpdata dat left join t_bg_bgperiod period on dat.FFpPeriodId =period.fid");
        sqlBuilder.appendSql(" inner join t_fpl_fpitem item on dat.ffpitemid=item.fid  ");
        sqlBuilder.appendSql(" inner join t_fpl_fpform form on dat.ffpformid=form.fid");
        sqlBuilder.appendSql(" inner join T_ORG_BaseUnit org on form.forgunitid=org.fid");
        sqlBuilder.appendSql(" where form.ffpcycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql(" and  dat.ffpperiodid in (");
        sqlBuilder.appendParam(periodIds);
        sqlBuilder.appendSql(")");
        sqlBuilder.appendSql(" and form.FOrgUnitID in (");
        sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
        sqlBuilder.appendSql(")\n");
        sqlBuilder.appendSql(" and (dat.FFpAssistItemCombID = '' or dat.FFpAssistItemCombID is null)\n");
        sqlBuilder.appendSql(" and dat.fcurrencyid =");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        sqlBuilder.appendSql(" and item.fnumber=");
        sqlBuilder.appendParam((Object)param.getItemNumber());
        sqlBuilder.appendSql("  group by item.fnumber,org.fid, org.fname_" + lang + ",period.fnumber");
        sqlBuilder.appendSql("  order by org.fid");
        return this.getRowSet(ctx, sqlBuilder);
    }

    protected IRowSet _getBillByItem(Context ctx, FilterParam filterParam, String itemNumber) throws BOSException, EASBizException {
        FpRptFilterParam param = (FpRptFilterParam)filterParam;
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql("select rec.fbillid billid\n");
        sqlBuilder.appendSql(" from t_fpl_fpform form inner join t_fpl_fpdata data on form.fid = data.FFpFormId\n");
        sqlBuilder.appendSql(" inner join t_bg_bgperiod period on data.FFpPeriodId = period.fid\n");
        sqlBuilder.appendSql(" inner join t_fpl_fpitem item on data.FFpItemID = item.fid\n");
        sqlBuilder.appendSql(" inner join T_FPL_FpCtrlRecord rec on data.fid = rec.Ffpdataid\n");
        sqlBuilder.appendSql(" where form.ffpcycle = ");
        sqlBuilder.appendParam((Object)new Integer(param.getPeriodType()));
        sqlBuilder.appendSql(" and data.fcurrencyid = ");
        sqlBuilder.appendParam((Object)param.getCurrencyId());
        if (param.getBeginPeriodNumber().equals(param.getEndPeriodNumber())) {
            sqlBuilder.appendSql(" and period.fnumber =");
            sqlBuilder.appendParam((Object)param.getBeginPeriodNumber());
        } else {
            Object[] periodIds = this.getPeriodIdsByBeginEnd(ctx, param);
            sqlBuilder.appendSql("\n and period.fid in ( ");
            sqlBuilder.appendParam(periodIds);
            sqlBuilder.appendSql(")");
        }
        if (param.isSum()) {
            sqlBuilder.appendSql(" and form.FOrgUnitID in (");
            sqlBuilder.appendParam((Object[])param.getFilterUnitIds());
            sqlBuilder.appendSql(")\n");
        } else {
            sqlBuilder.appendSql(" and form.FOrgUnitID =");
            sqlBuilder.appendParam((Object)param.getCurrentOrgUnitId());
        }
        sqlBuilder.appendSql(" and item.fnumber like ");
        sqlBuilder.appendParam((Object)(itemNumber + "%"));
        sqlBuilder.appendSql(" order by item.fnumber");
        return this.getRowSet(ctx, sqlBuilder);
    }
}

