/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.AbstractFpTemplateInfo;
import com.kingdee.eas.fm.fpl.CheckTemplateItemFormulaDup;
import com.kingdee.eas.fm.fpl.FpTemplateCollection;
import com.kingdee.eas.fm.fpl.FpTemplateException;
import com.kingdee.eas.fm.fpl.FpTemplateHelper;
import com.kingdee.eas.fm.fpl.FpTemplateInfo;
import com.kingdee.eas.fm.fpl.FpTemplateSourceEnum;
import com.kingdee.eas.fm.fpl.app.AbstractFpTemplateControllerBean;
import com.kingdee.eas.ma.budget.BgTemplateException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FpTemplateControllerBean
extends AbstractFpTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)FpTemplateControllerBean.class.getName());

    protected IObjectCollection _getCollctionByOrgUnit(Context ctx, String orgId) throws BOSException, EASBizException {
        FpTemplateCollection coll = new FpTemplateCollection();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("SELECT fpTemplate.FID AS FId, fpTemplate.FNumber AS FNumber, fpTemplate.FName AS FName, fpTemplate.FIsAllowChange AS FIsAllowChange, fpTemplate.FCreatorID AS FCreatorId, tUSER.FName_L2 AS FUserName, fpTemplate.FCreateTime AS FcreateTime FROM T_FP_FpTemplate fpTemplate, T_PM_User tUSER ,T_ORG_BaseUnit unit where fpTemplate.FCreatorID = tUSER.FID and fpTemplate.FOrgUnitID = unit.FID and unit.fid = ?");
            pstmt = conn.prepareStatement(strBuffer.toString());
            pstmt.setString(1, orgId);
            strBuffer = null;
            rs = pstmt.executeQuery();
            while (rs.next()) {
                FpTemplateInfo info = new FpTemplateInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setNumber(rs.getString("FNumber"));
                info.setName(rs.getString("FName"));
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rs.getString("FCreatorId")));
                userInfo.setName(rs.getString("FUserName"));
                info.setCreator(userInfo);
                info.setCreateTime(rs.getTimestamp("FcreateTime"));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return coll;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, (FpTemplateInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, (FpTemplateInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, (FpTemplateInfo)model);
        ((FpTemplateInfo)model).setItemFormulaExt("isTemplateItemFormula", Boolean.TRUE);
        super._update(ctx, pk, model);
        try {
            FpTemplateInfo info = (FpTemplateInfo)model;
            this.saveAllFpItemFormula(ctx, info, pk.toString());
        }
        catch (KDFException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkDup(Context ctx, FpTemplateInfo info) throws BOSException, EASBizException {
        this.checkDupNumber(ctx, info);
        this.checkDupName(ctx, info);
    }

    private void checkDupNumber(Context ctx, FpTemplateInfo info) throws BOSException, EASBizException {
        String id = info.getId() == null ? null : info.getId().toString();
        String number = info.getNumber();
        String ouId = info.getOrgUnit().getId().toString();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" SELECT FID FROM T_FPL_FpTemplate WHERE FNumber = ? AND FOrgUnitId = ? ");
        if (id != null && !id.equals("")) {
            sql.append(" AND FID != ?");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, number);
            pstmt.setString(2, ouId);
            if (id != null && !id.equals("")) {
                pstmt.setString(3, id);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                throw new FpTemplateException(FpTemplateException.NUMBERDUP);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private void checkDupName(Context ctx, FpTemplateInfo info) throws BOSException, EASBizException {
        String id = info.getId() == null ? null : info.getId().toString();
        String name = info.getName();
        String ouId = info.getOrgUnit().getId().toString();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" SELECT FID FROM T_FPL_FpTemplate WHERE FName = ? AND FOrgUnitId = ? ");
        if (id != null && !id.equals("")) {
            sql.append(" AND FID != ?");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, name);
            pstmt.setString(2, ouId);
            if (id != null && !id.equals("")) {
                pstmt.setString(3, id);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                throw new FpTemplateException(FpTemplateException.NAMEDUP);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private void saveAllFpItemFormula(Context ctx, FpTemplateInfo info, String pk) throws KDFException, EASBizException, BOSException {
        if (info == null || info.getKdtData() == null) {
            return;
        }
        KDF kdf = this.getKDF(info);
        Collection collection = kdf.getAllTable();
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                KDTable tempTable = (KDTable)kdf.getTableByIndex(i);
                FpTemplateHelper.saveRefProp(ctx, pk, tempTable);
            }
        }
    }

    private KDF getKDF(FpTemplateInfo info) throws BOSException {
        KDF kdf = null;
        try {
            kdf = info.getKDF();
        }
        catch (IOException e) {
            logger.error((Object)("FpTemplateControllerBean saveAllFpItemFormula error:" + e));
            throw new BOSException((Throwable)e);
        }
        catch (KDFException e) {
            logger.error((Object)("FpTemplateControllerBean saveAllFpItemFormula error:" + (Object)((Object)e)));
            throw new BOSException((Throwable)e);
        }
        return kdf;
    }

    protected void _saveSimpleInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer(60);
        FpTemplateInfo info = (FpTemplateInfo)model;
        this.checkDup(ctx, (FpTemplateInfo)model);
        sql.append(" UPDATE T_FPL_FpTemplate SET FName = ?, FNumber = ?, FFpCycle = ?, FDescription = ? WHERE FID = ? ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int i = 0;
            pstmt.setString(++i, info.getName());
            pstmt.setString(++i, info.getNumber());
            pstmt.setInt(++i, info.getFpCycle().getValue());
            pstmt.setString(++i, info.getDescription());
            pstmt.setString(++i, info.getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("kdtData"));
        sic.add(new SelectorItemInfo("fpCycle"));
        sic.add(new SelectorItemInfo("source"));
        sic.add(new SelectorItemInfo("refFpItems.*"));
        sic.add(new SelectorItemInfo("refAssistItemCombs.*"));
        sic.add(new SelectorItemInfo("refBgPeriods.*"));
        sic.add(new SelectorItemInfo("refCurrencies.*"));
        sic.add(new SelectorItemInfo("root.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    protected IObjectValue _copy(Context ctx, BOSUuid srcId) throws BOSException, EASBizException {
        ObjectUuidPK srcPk = new ObjectUuidPK(srcId);
        FpTemplateInfo srcInfo = this.getFpTemplateInfo(ctx, (IObjectPK)srcPk, this.getSelectors());
        FpTemplateInfo copyInfo = srcInfo.copy();
        String seq = this.getCloneSeq(ctx, copyInfo.getNumber());
        copyInfo.setNumber(copyInfo.getNumber() + seq);
        copyInfo.setName(copyInfo.getName() + seq);
        copyInfo.setOrgUnit(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().castToFullOrgUnitInfo());
        if (copyInfo.getNumber().length() > 80) {
            throw new BgTemplateException(FpTemplateException.NUMBER_TOOLONG);
        }
        if (copyInfo.getName().length() > 80) {
            throw new BgTemplateException(FpTemplateException.NAME_TOOLONG);
        }
        return copyInfo;
    }

    private String getCloneSeq(Context ctx, String number) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> numList = new ArrayList<String>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FNumber FROM T_FPL_FpTemplate WHERE FNumber LIKE ? ORDER BY FNumber");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, number + "_%");
            rs = pstmt.executeQuery();
            String temp = null;
            while (rs.next()) {
                temp = rs.getString("FNumber");
                numList.add(temp.trim());
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        int seq = this.getSeq(numList, number);
        return "_" + seq;
    }

    private int getSeq(List numList, String number) {
        if (numList == null || numList.size() <= 0) {
            return 1;
        }
        int seq = 1;
        int size = numList.size();
        for (int i = 0; i < size; ++i) {
            if (!(number + "_" + seq).equals((String)numList.get(i))) continue;
            ++seq;
        }
        return seq;
    }

    protected boolean _checkIsAssigned(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null || id.equals("")) {
            throw new NullPointerException("Id should be not null!");
        }
        boolean result = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID FROM T_FPL_FpTemplate WHERE FRootID = ?  AND FID <> ? ");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                result = true;
                throw new FpTemplateException(FpTemplateException.IS_ASSIGNED);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return result;
    }

    protected boolean _checkIsRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null || id.equals("")) {
            throw new NullPointerException("Id should be not null!");
        }
        boolean result = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID FROM T_FPL_FpForm WHERE FFpTemplateID = ? ");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                result = true;
                throw new FpTemplateException(FpTemplateException.IS_REF_BYFORM);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return result;
    }

    protected String _checkFormulaDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckTemplateItemFormulaDup checkTemplate = new CheckTemplateItemFormulaDup();
        FpTemplateInfo info = (FpTemplateInfo)model;
        String msg = checkTemplate.checkItemFormulaDup((IObjectValue)info);
        if (msg != null && msg.trim().length() > 0) {
            return FMHelper.getAdjustMsg((String)msg);
        }
        FpTemplateCollection coll = FpTemplateHelper.getCollection(ctx, info.getOrgUnit().getId().toString(), info.getId().toString());
        if (coll == null || coll.size() <= 0) {
            return null;
        }
        msg = checkTemplate.checkItemFormulaDup((IObjectValue)info, (IObjectCollection)coll);
        msg = FMHelper.getAdjustMsg((String)msg);
        return msg;
    }

    protected void _assign(Context ctx, List ids, Map orgIdMap) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            throw new FpTemplateException(FpTemplateException.ASSIGN_TEMPLATE_ISNULL);
        }
        if (orgIdMap == null || orgIdMap.isEmpty()) {
            throw new FpTemplateException(FpTemplateException.ASSIGN_SUBOU_ISNULL);
        }
        String templateId = null;
        FullOrgUnitInfo subOuInfo = null;
        String orgId = null;
        boolean isModify = true;
        FpTemplateInfo srcInfo = null;
        AbstractFpTemplateInfo destInfo = null;
        IObjectPK pk = null;
        int size1 = ids.size();
        for (int i = 0; i < size1; ++i) {
            templateId = (String)ids.get(i);
            for (Map.Entry entry : orgIdMap.entrySet()) {
                orgId = (String)entry.getKey();
                subOuInfo = new FullOrgUnitInfo();
                subOuInfo.setId(BOSUuid.read((String)orgId));
                isModify = (Boolean)entry.getValue();
                this.checkAssignTemplateDup(ctx, templateId, subOuInfo);
                srcInfo = this.getFpTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(templateId), this.getSelectors());
                destInfo = srcInfo.deepClone();
                destInfo.setOrgUnit(subOuInfo);
                destInfo.setParent(srcInfo);
                destInfo.setSource(FpTemplateSourceEnum.ASSIGN);
                destInfo.setIsModify(isModify);
                if (srcInfo.getRoot() == null) {
                    destInfo.setRoot(srcInfo);
                } else {
                    destInfo.setRoot(srcInfo.getRoot());
                }
                pk = this._addnew(ctx, (IObjectValue)destInfo);
            }
        }
        pk = LogUtil.beginLog((Context)ctx, (String)"assign", (BOSObjectType)destInfo.getBOSType(), pk, (String)(destInfo.getNumber() + " - " + destInfo.getName()), (String)"fpl_tem_assign");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    private void checkAssignTemplateDup(Context ctx, String templateId, FullOrgUnitInfo subOuInfo) throws EASBizException, BOSException {
        if (templateId == null || subOuInfo == null) {
            throw new NullPointerException("TemplateId and subOuId should be not null!");
        }
        String rootId = null;
        FpTemplateInfo info = this.getFpTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(templateId), this.getSelectors());
        rootId = info.getRoot() != null ? info.getRoot().getId().toString() : info.getId().toString();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID from T_FPL_FpTemplate WHERE FRootID = ? AND FOrgUnitID = ?");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, rootId);
            pstmt.setString(2, subOuInfo.getId().toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                subOuInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(subOuInfo.getId()));
                throw new FpTemplateException(FpTemplateException.ASSIGN_TEMPLATE_DUP, new String[]{info.getName(), subOuInfo.getName()});
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        FpTemplateInfo info = null;
        try {
            info = this.getFpTemplateInfo(ctx, pk, this.getSelectors());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (info == null) {
            return;
        }
        String id = info.getId().toString();
        String rootID = info.getRoot().getId().toString();
        String parentID = info.getParent().getId().toString();
        if (id.equals(rootID) || id.equals(parentID)) {
            return;
        }
        super._isReferenced(ctx, pk, cn);
    }

    protected List _getAssignedOuIds(Context ctx, String templateId) throws BOSException, EASBizException {
        if (templateId == null) {
            throw new NullPointerException("_getAssignedOuIds TemplateId should be not null!");
        }
        String rootId = null;
        FpTemplateInfo info = this.getFpTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(templateId), this.getSelectors());
        rootId = info.getRoot() != null ? info.getRoot().getId().toString() : info.getId().toString();
        ArrayList<String> idList = new ArrayList<String>();
        String sql = "SELECT FID, FOrgUnitID from T_FPL_FpTemplate WHERE FRootID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rootId});
        try {
            while (rs.next()) {
                idList.add(rs.getString("FOrgUnitID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("_getAssignedOuIds generate error: " + e));
            throw new BOSException((Throwable)e);
        }
        return idList;
    }
}

