/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.SettleMutilTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import org.apache.log4j.Logger;

public class MutilClearHouserHelper {
    private static final Logger logger = CoreUIObject.getLogger(MutilClearHouserHelper.class);

    public static boolean isTopClearHouse(Context ctx, String companyId, SettlementBillRpcCacheInfo rpcCacheInfo) {
        boolean topCleanHouse = false;
        try {
            BankInfo bankInfo = null;
            if (rpcCacheInfo != null && rpcCacheInfo.getClearingHouse() != null) {
                bankInfo = rpcCacheInfo.getClearingHouse();
            } else {
                IBank iBank = null;
                iBank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
                bankInfo = iBank.getClearingHouse(companyId);
            }
            if (bankInfo != null) {
                topCleanHouse = bankInfo.getParentInGroup() == null;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return topCleanHouse;
    }

    public static SettleMutilTypeEnum getOtherMutilType(SettleMutilTypeEnum mutilType) {
        SettleMutilTypeEnum destType;
        switch (mutilType.getValue()) {
            case 2: {
                destType = SettleMutilTypeEnum.REC;
                break;
            }
            case 1: {
                destType = SettleMutilTypeEnum.PAY;
                break;
            }
            default: {
                destType = SettleMutilTypeEnum.PAY;
            }
        }
        return destType;
    }
}

