/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.NTNumberFormat;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;

public class Settle4ChequeMnt {
    public static boolean getTM009(Context ctx, String id) {
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM009", (IObjectPK)new ObjectUuidPK(id));
        return val;
    }

    public static AccountBankInfo getAccountBankByInnerAcct(Context ctx, InnerAccountInfo innerAcct) throws BOSException {
        AccountBankInfo info = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct", (Object)innerAcct.getId().toString()));
        evi.setFilter(filter);
        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection coll = iAccountBank.getAccountBankCollection(evi);
        if (coll != null && coll.size() == 1) {
            info = coll.get(0);
        }
        return info;
    }

    public static void autoVCCheque(Context ctx, SettlementBillInfo settleBillInfo) throws BOSException, EASBizException {
        ChequeInfo correctChequeInfo;
        boolean val = false;
        if (settleBillInfo.getPayerInnerAcct() != null) {
            val = Settle4ChequeMnt.getTM009(ctx, settleBillInfo.getPayerInnerAcct().getApplyUnit().getId().toString());
        }
        if (val && (correctChequeInfo = Settle4ChequeMnt.findCheck(ctx, settleBillInfo)) != null) {
            BigDecimal settleAmount = settleBillInfo.getAmount();
            if (correctChequeInfo.getApplyRec() != null && !FMHelper.isZERO((BigDecimal)correctChequeInfo.getApplyRec().getCeiling()) && settleAmount.compareTo(correctChequeInfo.getApplyRec().getCeiling()) > 0) {
                return;
            }
            if (!FMHelper.isZERO((BigDecimal)correctChequeInfo.getAmount()) && !correctChequeInfo.getAmount().equals(settleAmount)) {
                return;
            }
            correctChequeInfo.setCurrency(settleBillInfo.getCurrency());
            if (!FMHelper.isEmpty((String)settleBillInfo.getPayeeFullName())) {
                correctChequeInfo.setPayeeName(settleBillInfo.getPayeeFullName());
            }
            if (!FMHelper.isEmpty((String)settleBillInfo.getPayeeBank())) {
                correctChequeInfo.setPayeeAcctBank(settleBillInfo.getPayeeBank());
            }
            if (!FMHelper.isEmpty((String)settleBillInfo.getPayeeBankAcctNum())) {
                correctChequeInfo.setPayeeAcctNumber(settleBillInfo.getPayeeBankAcctNum());
            }
            correctChequeInfo.setOriVCState(correctChequeInfo.getState());
            correctChequeInfo.setIsApply(correctChequeInfo.isIsApply());
            correctChequeInfo.setSettlement(settleBillInfo);
            correctChequeInfo.setAmount(settleAmount);
            String iso = settleBillInfo.getCurrency().getIsoCode();
            NTNumberFormat f = NTNumberFormat.getInstance((String)iso);
            String amount = f.format(correctChequeInfo.getAmount());
            correctChequeInfo.setCapitalization(amount);
            if (!FMHelper.isEmpty((String)settleBillInfo.getDescription())) {
                correctChequeInfo.setUsage(settleBillInfo.getDescription());
            }
            correctChequeInfo.setVcDate(new Date());
            correctChequeInfo.setBankAcctDistr(correctChequeInfo.getBankAcct());
            AccountBankInfo accountBankInfo = Settle4ChequeMnt.getAccountBankByInnerAcct(ctx, settleBillInfo.getPayerInnerAcct());
            correctChequeInfo.setBankAcct(accountBankInfo);
            ICheque cheque = ChequeFactory.getLocalInstance((Context)ctx);
            if (correctChequeInfo.getApplyRec() == null) {
                correctChequeInfo.setApplyRec(new ChequeAppRecInfo());
            }
            correctChequeInfo.getApplyRec().setApplyCompany(settleBillInfo.getPayerInnerAcct().getApplyUnit());
            ChequeCollection chequeColl = new ChequeCollection();
            chequeColl.add(correctChequeInfo);
            cheque.reimburse((IObjectCollection)chequeColl);
        }
    }

    private static ChequeInfo findCheck(Context ctx, SettlementBillInfo settleBillInfo) throws BOSException {
        ChequeInfo correctChequeInfo = null;
        ICheque cheque = ChequeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)settleBillInfo.getInnerSettleNumber()));
        filter.getFilterItems().add(new FilterItemInfo("isVC", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isAbandon", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)settleBillInfo.getCurrency().getId()));
        ev.setFilter(filter);
        ev.getSelector().add("*");
        ev.getSelector().add("applyRec.*");
        ChequeCollection chequecoll = cheque.getChequeCollection(ev);
        if (chequecoll != null && chequecoll.size() > 0) {
            ChequeInfo info;
            int j;
            for (j = 0; j < chequecoll.size(); ++j) {
                info = chequecoll.get(j);
                if (info.getBankAcct() == null) continue;
                AccountBankInfo accountBankInfo = Settle4ChequeMnt.getAccountBankByInnerAcct(ctx, settleBillInfo.getPayerInnerAcct());
                if (!info.getBankAcct().getId().equals((Object)accountBankInfo.getId())) continue;
                correctChequeInfo = info;
                break;
            }
            if (correctChequeInfo == null) {
                for (j = 0; j < chequecoll.size(); ++j) {
                    info = chequecoll.get(j);
                    if (chequecoll.size() == 1 && info.getBankAcct() == null) {
                        correctChequeInfo = info;
                        break;
                    }
                    if (chequecoll.size() <= 1 || info.getBankAcct() != null || info.getKeepCompany() == null || !info.getKeepCompany().getId().equals((Object)settleBillInfo.getPayerInnerAcct().getApplyUnit().getId())) continue;
                    correctChequeInfo = info;
                    break;
                }
            }
        }
        return correctChequeInfo;
    }

    public static void autoCancelVCCheque(Context ctx, SettlementBillInfo settleBillInfo) throws BOSException, EASBizException {
        ICheque cheque = ChequeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("settlement.id", (Object)settleBillInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)settleBillInfo.getInnerSettleNumber()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3), CompareType.EQUALS));
        ev.setFilter(filter);
        ChequeCollection chequecoll = cheque.getChequeCollection(ev);
        if (chequecoll != null && chequecoll.size() > 0) {
            ChequeInfo info = chequecoll.get(0);
            HashSet<String> set = new HashSet<String>();
            set.add(info.getId().toString());
            ChequeFactory.getLocalInstance((Context)ctx).antiReimburse(set);
            String sql = "UPDATE T_NT_Cheque SET FSettlementID=null WHERE Fid = '" + info.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }
}

