/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.DoForRecPayEnum;
import com.kingdee.eas.fm.fs.ISendAcctBuilder;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SendAccountInfo;
import com.kingdee.eas.fm.fs.SendAcctSourceEnum;
import com.kingdee.eas.fm.fs.SendAcctStatusEnum;
import com.kingdee.eas.fm.fs.SendRecAcctTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.client.EASResource;

public class SettleBillSendAcctBuilder
implements ISendAcctBuilder {
    @Override
    public SendAccountInfo getSendAccountInfo(Context ctx, String billId) throws EASBizException, BOSException {
        SettlementBillInfo settleInfo = this.getBizInterface(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        if (settleInfo.getSettleConfirmCH() == null) {
            return null;
        }
        return this.buildeSendAcctInfo(settleInfo);
    }

    private SendAccountInfo buildeSendAcctInfo(SettlementBillInfo settleInfo) throws BOSException {
        SendAccountInfo sendInfo = new SendAccountInfo();
        sendInfo.setId(BOSUuid.create((BOSObjectType)sendInfo.getBOSType()));
        sendInfo.setCompany(settleInfo.getCompany());
        sendInfo.setIsBackBill(false);
        sendInfo.setSource(SendAcctSourceEnum.SETTLEMENTBILL);
        sendInfo.setSourceBillId(settleInfo.getId().toString());
        sendInfo.setBizDate(settleInfo.getBizDate());
        sendInfo.setType(this.getType(settleInfo.getType()));
        sendInfo.setDoForRecPay(this.getDoForRecPay(settleInfo.getType()));
        if (settleInfo.getReckoningAcct() == null) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"180_SettleBillSendAcctBuilder"));
        }
        sendInfo.setReckoningAcct(settleInfo.getReckoningAcct());
        sendInfo.setCurrency(settleInfo.getCurrency());
        sendInfo.setAmount(settleInfo.getAmount());
        sendInfo.setDescription(settleInfo.getDescription());
        sendInfo.setSettleAcceptCH(settleInfo.getSettleAcceptCH());
        sendInfo.setSubmitCH(settleInfo.getSettleAcceptCH());
        sendInfo.setReceiveCH(settleInfo.getReckoningAcct().getClearingHouse());
        sendInfo.setSettleConfirmCH(settleInfo.getSettleConfirmCH());
        sendInfo.setCreator(settleInfo.getAcceptor());
        sendInfo.setStatus(SendAcctStatusEnum.UNDEALED);
        sendInfo.setUpBillId(settleInfo.getId().toString());
        sendInfo.setDownBillId(null);
        sendInfo.setSrcSettlementBill(settleInfo);
        return sendInfo;
    }

    private SendRecAcctTypeEnum getType(SettBizTypeEnum settBizType) {
        switch (settBizType.getValue()) {
            case 1: 
            case 2: 
            case 10: {
                return SendRecAcctTypeEnum.OUTERSETTLE;
            }
            case 3: 
            case 4: {
                return SendRecAcctTypeEnum.INNERSETTLE;
            }
        }
        return SendRecAcctTypeEnum.OUTERSETTLE;
    }

    private DoForRecPayEnum getDoForRecPay(SettBizTypeEnum settBizType) {
        switch (settBizType.getValue()) {
            case 1: 
            case 3: {
                return DoForRecPayEnum.REC;
            }
            case 2: 
            case 4: 
            case 10: {
                return DoForRecPayEnum.PAY;
            }
        }
        return DoForRecPayEnum.REC;
    }

    private ISettlementBill getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return SettlementBillFactory.getRemoteInstance();
        }
        return SettlementBillFactory.getLocalInstance(ctx);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("settleAcceptCH.*");
        sic.add("settleConfirmCH.*");
        sic.add("reckoningAcct.*");
        return sic;
    }

    @Override
    public BillBaseInfo getBillBaseInfo(Context ctx, String billId) throws BOSException, EASBizException {
        return null;
    }
}

