/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.AbstractAutoMatchAcctSettingEntryInfo;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingCollection;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingEntryCollection;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingEntryInfo;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingFactory;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingInfo;
import com.kingdee.eas.fm.fs.app.AbstractAutoMatchAcctSettingControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class AutoMatchAcctSettingControllerBean
extends AbstractAutoMatchAcctSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.AutoMatchAcctSettingControllerBean");

    @Override
    protected void _setIsOnStatus(Context ctx, Set idSet, boolean isOn) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isOn"));
        view.getSelector().add(new SelectorItemInfo("company.id"));
        CoreBaseCollection colls = AutoMatchAcctSettingFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            AutoMatchAcctSettingInfo info = (AutoMatchAcctSettingInfo)colls.get(i);
            info.setIsOn(isOn);
        }
        AutoMatchAcctSettingFactory.getLocalInstance(ctx).update(colls);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AutoMatchAcctSettingInfo info = (AutoMatchAcctSettingInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoMatchAcctSettingInfo info = (AutoMatchAcctSettingInfo)model;
        this.checkNumberDup(ctx, (IObjectValue)info);
        super._update(ctx, pk, model);
    }

    @Override
    protected AccountBankInfo _getAutoMatchAcctInfo(Context ctx, String relatedCompanyId, String payId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("payeeAccountBank"));
        sic.add(new SelectorItemInfo("actPayLocAmt"));
        sic.add(new SelectorItemInfo("bankNumber"));
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(payId), sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOn", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)new Date(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateHelper.getDayBegin(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)relatedCompanyId, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("filterEntrys.*");
        view.getSelector().add("entrys.accountBank.*");
        view.getSelector().add("entrys.accountBank.bank.name");
        view.getSelector().add("entrys.accountBank.bank.accountBank.number");
        view.getSelector().add("entrys.payLimitAmt");
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = null;
        if (!EmptyUtil.isEmpty((String)info.getBankNumber())) {
            sortInfo = new SorterItemInfo("isSameFirst");
            sortInfo.setSortType(SortType.DESCEND);
        } else {
            sortInfo = new SorterItemInfo("noDefAcct");
            sortInfo.setSortType(SortType.ASCEND);
        }
        sorter.add(sortInfo);
        view.setSorter(sorter);
        AutoMatchAcctSettingCollection autoColl = AutoMatchAcctSettingFactory.getLocalInstance(ctx).getAutoMatchAcctSettingCollection(view);
        if (autoColl != null && autoColl.size() > 0) {
            AutoMatchAcctSettingInfo autoInfo = null;
            for (int i = 0; i < autoColl.size(); ++i) {
                autoInfo = autoColl.get(i);
                try {
                    AccountBankInfo bankInfo;
                    EntityViewInfo evi = autoInfo.getFilter();
                    FilterInfo fil = new FilterInfo();
                    fil.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
                    if (!EmptyUtil.isEmpty((Object)evi.getFilter())) {
                        evi.getFilter().mergeFilter(fil, "AND");
                    } else {
                        evi.setFilter(fil);
                    }
                    SelectorItemCollection sic2 = new SelectorItemCollection();
                    sic2.add(new SelectorItemInfo("id"));
                    evi.setSelector(sic2);
                    PaymentBillCollection payColl = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(evi);
                    if (payColl.size() <= 0 || (bankInfo = this.getMatchAcctBankInfo(ctx, autoInfo, info)) == null) continue;
                    return bankInfo;
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return null;
    }

    private AccountBankInfo getMatchAcctBankInfo(Context ctx, AutoMatchAcctSettingInfo autoInfo, PaymentBillInfo info) throws EASBizException, BOSException {
        AccountBankInfo bankInfo = null;
        AbstractAutoMatchAcctSettingEntryInfo tmpEntryInfo = null;
        AutoMatchAcctSettingEntryCollection entryColl = autoInfo.getEntrys();
        if (!EmptyUtil.isEmpty((String)info.getBankNumber())) {
            String comNumber = null;
            if (autoInfo.isIsSameFirst()) {
                comNumber = info.getBankNumber().substring(0, 3);
            }
            for (int j = 0; j < entryColl.size(); ++j) {
                AutoMatchAcctSettingEntryInfo entryInfo = entryColl.get(j);
                String matNumber = null;
                if (!(EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getAccountBank()) || EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getAccountBank().getBank()) || EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getAccountBank().getBank().getAccountBank()) || EmptyUtil.isEmpty((String)entryInfo.getAccountBank().getBank().getAccountBank().getNumber()) || entryInfo.getAccountBank().getBank().getAccountBank().getNumber().length() <= 3)) {
                    matNumber = entryInfo.getAccountBank().getBank().getAccountBank().getNumber().substring(0, 3);
                }
                if (comNumber != null && comNumber.equals(matNumber) && entryInfo.getPayRemainAmt(ctx).compareTo(info.getActPayLocAmt()) >= 0) {
                    tmpEntryInfo = entryInfo;
                    break;
                }
                if (tmpEntryInfo != null || entryInfo.getPayRemainAmt(ctx).compareTo(info.getActPayLocAmt()) < 0) continue;
                tmpEntryInfo = entryInfo;
            }
        } else {
            String defAcctId = null;
            if (!EmptyUtil.isEmpty((CoreBaseInfo)autoInfo.getNoDefAcct())) {
                defAcctId = autoInfo.getNoDefAcct().getId().toString();
            }
            for (int j = 0; j < entryColl.size(); ++j) {
                AutoMatchAcctSettingEntryInfo entryInfo = entryColl.get(j);
                String matchAcctId = entryInfo.getAccountBank().getId().toString();
                if (defAcctId != null && defAcctId.equals(matchAcctId) && entryInfo.getPayRemainAmt(ctx).compareTo(info.getActPayLocAmt()) >= 0) {
                    tmpEntryInfo = entryInfo;
                    break;
                }
                if (tmpEntryInfo != null || entryInfo.getPayRemainAmt(ctx).compareTo(info.getActPayLocAmt()) < 0) continue;
                tmpEntryInfo = entryInfo;
            }
        }
        if (!EmptyUtil.isEmpty(tmpEntryInfo)) {
            this._addRecord(ctx, info.getId().toString(), tmpEntryInfo.getId().toString(), info.getActPayLocAmt());
            bankInfo = tmpEntryInfo.getAccountBank();
        }
        return bankInfo;
    }

    @Override
    protected void _addRecord(Context ctx, String payId, String setId, BigDecimal amt) throws BOSException, EASBizException {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Timestamp todayTime = new Timestamp(zero);
        String sql = "insert into T_FS_AUTOMATCHAMT(FPAYID,FSETENTRYID,FAMT,FDATE) VALUES (?,?,?,?)";
        com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{payId, setId, amt, todayTime});
    }

    @Override
    protected void _delRecord(Context ctx, String payId, String setId, BigDecimal amt) throws BOSException {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Timestamp todayTime = new Timestamp(zero);
        String sql = "DELETE FROM T_FS_AUTOMATCHAMT WHERE FPAYID =? AND FDATE = ? OR FDATE < ? ";
        com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{payId, todayTime, todayTime});
    }

    @Override
    protected BigDecimal _getEntryUsedAmt(Context ctx, String entryId, Date date) throws BOSException, EASBizException {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Timestamp todayTime = new Timestamp(zero);
        String sql = "SELECT SUM(FAMT) amt FROM T_FS_AUTOMATCHAMT WHERE FSETENTRYID =? AND FDATE = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{entryId, todayTime});
        BigDecimal amt = BigDecimal.ZERO;
        try {
            while (rowSet.next()) {
                if (EmptyUtil.isEmpty((Object)rowSet.getBigDecimal("amt"))) continue;
                amt = amt.add(rowSet.getBigDecimal("amt"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return amt;
    }

    @Override
    protected Set _getLinkPayBillById(Context ctx, String id) throws BOSException, EASBizException {
        HashSet<String> payIdSet = new HashSet<String>();
        AutoMatchAcctSettingInfo info = this.getAutoMatchAcctSettingInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            entryIdSet.add(info.getEntrys().get(i).getId().toString());
        }
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Timestamp todayTime = new Timestamp(zero);
        String ids = FMHelper.setTran2String(entryIdSet);
        String sql = "SELECT FPAYID FROM T_FS_AUTOMATCHAMT WHERE FSETENTRYID IN " + ids + " AND FDATE = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{todayTime});
        try {
            while (rowSet.next()) {
                String payID = rowSet.getString("FPAYID");
                payIdSet.add(payID);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{e.getMessage()});
        }
        return payIdSet;
    }

    @Override
    protected Map _getCompanyStatus(Context ctx, Map idMap) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        String sql = "SELECT DISTINCT FCOMPANYID comId FROM T_FS_AUTOMATCHACCTSETTING WHERE FISON = 1 AND FStartDate <= ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis())});
        try {
            while (rowSet.next()) {
                if (EmptyUtil.isEmpty((String)rowSet.getString("comId"))) continue;
                idSet.add(rowSet.getString("comId"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        for (Object key : idMap.keySet()) {
            if (idMap.get(key) != null) {
                String companyId = idMap.get(key).toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("bizType.type"));
                sic.add(new SelectorItemInfo("fid"));
                PaymentBillInfo info = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(key.toString()), sic);
                if (info.getBizType() != null && (info.getBizType().getType().getValue() == 2 || info.getBizType().getType().getValue() == 100)) {
                    if (!resultMap.keySet().contains(companyId)) {
                        Boolean TM111 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM111", (IObjectPK)new ObjectUuidPK(companyId));
                        if (TM111.booleanValue() && !idSet.contains(companyId)) {
                            idMap.put(key.toString(), false);
                            resultMap.put(companyId, false);
                            continue;
                        }
                        idMap.put(key.toString(), true);
                        resultMap.put(companyId, true);
                        continue;
                    }
                    idMap.put(key.toString(), resultMap.get(companyId));
                    continue;
                }
                idMap.put(key.toString(), true);
                continue;
            }
            idMap.put(key.toString(), true);
        }
        return idMap;
    }
}

