/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.AutoTransFactory;
import com.kingdee.eas.fm.fs.AutoTransInfo;
import com.kingdee.eas.fm.fs.app.AbstractAutoTransControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoTransControllerBean
extends AbstractAutoTransControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.AutoTransControllerBean");
    protected static final String resClassName = "com.kingdee.eas.fm.fs.TransBillResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AutoTransInfo info = (AutoTransInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        IObjectPK pk = super._addnew(ctx, model);
        String logName = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"207_AutoTransControllerBean", (Locale)ctx.getLocale());
        if (!info.isIsTransDown()) {
            logName = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"208_AutoTransControllerBean", (Locale)ctx.getLocale());
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_autoTrans_addNew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AutoTransInfo info = (AutoTransInfo)this.getValue(ctx, pk);
        String logName = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"209_AutoTransControllerBean", (Locale)ctx.getLocale());
        if (!info.isIsTransDown()) {
            logName = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"210_AutoTransControllerBean", (Locale)ctx.getLocale());
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_autoTrans_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._delete(ctx, pk);
        CompanyOrgUnitInfo comp = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)comp.getId().toString());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        AutoTransInfo info = (AutoTransInfo)this.getValue(ctx, pk);
        String logName = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"211_AutoTransControllerBean", (Locale)ctx.getLocale());
        if (!info.isIsTransDown()) {
            logName = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"212_AutoTransControllerBean", (Locale)ctx.getLocale());
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_autoTrans_modify");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _viewTransDetail(Context ctx, Set idSet) throws BOSException, EASBizException {
    }

    @Override
    protected void _openOrClose(Context ctx, Set ids, boolean isOpen) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("company.id"));
        view.getSelector().add(new SelectorItemInfo("state"));
        CoreBaseCollection colls = AutoTransFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            AutoTransInfo info = (AutoTransInfo)colls.get(i);
            info.setState(isOpen);
            String logName = EASCommonResource.getString((String)resClassName, (String)"autoTransDown", (Locale)ctx.getLocale());
            if (!info.isIsTransDown()) {
                logName = EASCommonResource.getString((String)resClassName, (String)"autoTransUp", (Locale)ctx.getLocale());
            }
            logName = logName + EASCommonResource.getString((String)resClassName, (String)"titleSet", (Locale)ctx.getLocale());
            logName = !isOpen ? logName + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"213_AutoTransControllerBean", (Locale)ctx.getLocale()) : logName + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"214_AutoTransControllerBean", (Locale)ctx.getLocale());
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_autoTrans_open");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        AutoTransFactory.getLocalInstance(ctx).update(colls);
    }
}

