/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.PKUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMEntityAccess;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.FSDailySettleException;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerCollection;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import com.kingdee.eas.fm.fs.app.AbstractDailySettleFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DailySettleFacadeControllerBean
extends AbstractDailySettleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.DailySettleFacadeControllerBean");
    private static final int I_ZERO = 0;
    private static final int I_ONE = 1;
    private static final String[] CODES = new String[]{"type", "innerAccount", "bankAcct", "currency", "bizdate"};
    private static final List sumKeys = Collections.unmodifiableList(Arrays.asList(CODES));

    @Override
    protected void _dailySettle(Context ctx, String companyId, java.util.Date date) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyId) || date == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"0_DailySettleFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        this.checkIsCH(ctx, companyId);
        String sql = "UPDATE T_BD_Bank SET FPhone=FPhone WHERE FRelatedCompanyId = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)date);
        this.checkSettleDate(ctx, companyId, settleDate);
        java.util.Date preSettleDate = DateUtil.getBeforeDay((java.util.Date)settleDate);
        SummaryLedgerCollection preSummaryColl = this.getSummaryColl(ctx, companyId, preSettleDate);
        SubsidiaryLedgerCollection subsidiaryColl = this.getSubsidirayColl(ctx, companyId, settleDate);
        SummaryLedgerCollection currSummaryColl = this.initCurrSummaryColl(settleDate, preSummaryColl);
        Map summaryMap = FSHelper.getSumHashSearchMap((IObjectCollection)currSummaryColl);
        int size = subsidiaryColl.size();
        for (int i = 0; i < size; ++i) {
            this.genSummaryLedgerMap(settleDate, summaryMap, subsidiaryColl.get(i));
        }
        this.saveSummaryLedger(ctx, summaryMap);
        this.signSettleDate(ctx, companyId, DateUtil.getAfterDay((java.util.Date)settleDate));
    }

    @Override
    protected void _antiDailySettle(Context ctx, String companyId, java.util.Date date) throws BOSException, EASBizException {
        this.checkIsCH(ctx, companyId);
        java.util.Date antiSettleDate = DateTimeUtils.truncateDate((java.util.Date)date);
        this.checkAntiSettleDate(ctx, companyId, antiSettleDate);
        String sql = "DELETE FROM T_FS_SummaryLedger WHERE FCompanyId = ?  AND FBizDate = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{companyId, new Date(antiSettleDate.getTime())});
        this.signSettleDate(ctx, companyId, antiSettleDate);
    }

    private void checkIsCH(Context ctx, String companyId) throws EASBizException, BOSException {
        BankInfo chInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (chInfo == null) {
            throw new FSException(FSException.COMPANYISNOTCH);
        }
    }

    private void checkAntiSettleDate(Context ctx, String companyId, java.util.Date date) throws EASBizException, BOSException {
        java.util.Date settleDate;
        java.util.Date openDate = FSHelper.getCHOpenDate(ctx, companyId);
        if (openDate.compareTo(settleDate = FSHelper.getDailySettledDate(ctx, companyId)) == 0) {
            throw new FSDailySettleException(FSDailySettleException.ANTISETTLEERROR);
        }
        DateFormat df = BOSLocaleUtil.getDateFormat();
        java.util.Date antiSettleDate = DateUtil.getBeforeDay((java.util.Date)settleDate);
        if (antiSettleDate.compareTo(date) != 0) {
            throw new FSDailySettleException(FSDailySettleException.ANTISETTLEDATEERROR, new Object[]{df.format(date), df.format(settleDate)});
        }
    }

    private void checkSettleDate(Context ctx, String companyId, java.util.Date date) throws EASBizException, BOSException {
        java.util.Date settleDate = FSHelper.getDailySettledDate(ctx, companyId);
        DateFormat df = BOSLocaleUtil.getDateFormat();
        if (settleDate.compareTo(date) != 0) {
            throw new FSDailySettleException(FSDailySettleException.SETTLEDATEERROR, new Object[]{df.format(date), df.format(settleDate)});
        }
    }

    private SummaryLedgerCollection getSummaryColl(Context ctx, String companyId, java.util.Date date) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyId) || date == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"0_DailySettleFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)date));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ISummaryLedger iSummary = SummaryLedgerFactory.getLocalInstance(ctx);
        return iSummary.getSummaryLedgerCollection(evi);
    }

    private SummaryLedgerCollection initCurrSummaryColl(java.util.Date currSettleDate, SummaryLedgerCollection preColl) {
        SummaryLedgerCollection currColl = new SummaryLedgerCollection();
        SummaryLedgerInfo currInfo = null;
        SummaryLedgerInfo preInfo = null;
        int size = preColl.size();
        for (int i = 0; i < size; ++i) {
            currInfo = new SummaryLedgerInfo();
            preInfo = preColl.get(i);
            currInfo.setBizDate(currSettleDate);
            currInfo.setCompany(preInfo.getCompany());
            currInfo.setApplyUnit(preInfo.getApplyUnit());
            currInfo.setCurrency(preInfo.getCurrency());
            currInfo.setInnerAccount(preInfo.getInnerAccount());
            currInfo.setBankAcct(preInfo.getBankAcct());
            currInfo.setDebitTotal(Constants.ZERO);
            currInfo.setLocalDebitTotal(Constants.ZERO);
            currInfo.setCreditTotal(Constants.ZERO);
            currInfo.setLocalCreditTotal(Constants.ZERO);
            currInfo.setDebitCounts(0);
            currInfo.setCreditCounts(0);
            currInfo.setBeginBalance(preInfo.getEndBalance());
            currInfo.setBeginBalanceDC(preInfo.getEndBalanceDC());
            currInfo.setLocalBeginBalance(preInfo.getLocalEndBalance());
            currInfo.setEndBalance(preInfo.getEndBalance());
            currInfo.setEndBalanceDC(preInfo.getEndBalanceDC());
            currInfo.setLocalEndBalance(preInfo.getLocalEndBalance());
            currColl.add(currInfo);
        }
        return currColl;
    }

    private SubsidiaryLedgerCollection getSubsidirayColl(Context ctx, String companyId, java.util.Date date) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyId) || date == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"0_DailySettleFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)date));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("innerAccount.*"));
        ISubsidiaryLedger iSubsidiary = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        return iSubsidiary.getSubsidiaryLedgerCollection(evi);
    }

    private void genSummaryLedgerMap(java.util.Date currDate, Map summaryMap, SubsidiaryLedgerInfo subInfo) {
        String[] CODES = new String[]{"type", "innerAccount", "bankAcct", "currency", "date"};
        List<String> sumKey = Collections.unmodifiableList(Arrays.asList(CODES));
        subInfo.setDate(DateTimeUtils.truncateDate((java.util.Date)subInfo.getDate()));
        String key = FSHelper.getKeyString((IObjectValue)subInfo, FSHelper.getStrings(sumKey));
        if (summaryMap.containsKey(key)) {
            SummaryLedgerInfo sumInfo = (SummaryLedgerInfo)summaryMap.get(key);
            BigDecimal debitTotal = sumInfo.getDebitTotal().add(subInfo.getDebitAmount());
            BigDecimal creditTotal = sumInfo.getCreditTotal().add(subInfo.getCreditAmount());
            sumInfo.setDebitTotal(debitTotal);
            sumInfo.setCreditTotal(creditTotal);
            int debitCounts = sumInfo.getDebitCounts();
            int creditCounts = sumInfo.getCreditCounts();
            if (subInfo.getDebitAmount().signum() != 0) {
                sumInfo.setDebitCounts(++debitCounts);
            } else {
                sumInfo.setCreditCounts(++creditCounts);
            }
            BigDecimal endBalance = sumInfo.getBeginBalance().add(debitTotal).subtract(creditTotal);
            sumInfo.setEndBalance(endBalance);
            sumInfo.setLocalEndBalance(endBalance);
            sumInfo.setEndBalanceDC(FSHelper.getBalanceDirection(endBalance));
        } else {
            SummaryLedgerInfo newSumInfo = this.initSummaryInfo(currDate, subInfo);
            summaryMap.put(key, newSumInfo);
        }
    }

    private SummaryLedgerInfo initSummaryInfo(java.util.Date currDate, SubsidiaryLedgerInfo subInfo) {
        SummaryLedgerInfo sumInfo = new SummaryLedgerInfo();
        sumInfo.setBizDate(currDate);
        sumInfo.setCompany(subInfo.getInnerAccount().getCompany());
        sumInfo.setApplyUnit(subInfo.getApplyUnit());
        sumInfo.setCurrency(subInfo.getCurrency());
        sumInfo.setInnerAccount(subInfo.getInnerAccount());
        if (subInfo.getPayeeBankAccount() != null) {
            sumInfo.setBankAcct(subInfo.getPayeeBankAccount());
        }
        if (subInfo.getPayerBankAccount() != null) {
            sumInfo.setBankAcct(subInfo.getPayerBankAccount());
        }
        BigDecimal debitAmt = FMHelper.checkBigDecimal((BigDecimal)subInfo.getDebitAmount());
        BigDecimal creditAmt = FMHelper.checkBigDecimal((BigDecimal)subInfo.getCreditAmount());
        sumInfo.setDebitTotal(debitAmt);
        sumInfo.setLocalDebitTotal(debitAmt);
        sumInfo.setCreditTotal(creditAmt);
        sumInfo.setLocalCreditTotal(creditAmt);
        sumInfo.setDebitCounts(1);
        sumInfo.setCreditCounts(1);
        sumInfo.setBeginBalance(Constants.ZERO);
        sumInfo.setLocalBeginBalance(Constants.ZERO);
        sumInfo.setBeginBalanceDC(BalanceDirectionEnum.BALANCE);
        BigDecimal endBalance = debitAmt.subtract(creditAmt);
        sumInfo.setEndBalance(endBalance);
        sumInfo.setLocalEndBalance(endBalance);
        sumInfo.setEndBalanceDC(FSHelper.getBalanceDirection(endBalance));
        return sumInfo;
    }

    private void saveSummaryLedger(Context ctx, Map summaryMap) throws EASBizException, BOSException {
        SummaryLedgerInfo info = null;
        SummaryLedgerCollection slc = new SummaryLedgerCollection();
        for (Map.Entry entry : summaryMap.entrySet()) {
            info = (SummaryLedgerInfo)entry.getValue();
            slc.add(info);
        }
        BOSObjectType bosType = new SummaryLedgerInfo().getBOSType();
        EntityObjectInfo entityInfo = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bosType);
        PropertyCollection pc = entityInfo.getProperties();
        String[] properties = new String[pc.size()];
        for (int i = 0; i < pc.size(); ++i) {
            properties[i] = pc.get(i).getName();
        }
        new FMEntityAccess(ctx, bosType, properties).addnew(ctx, (IObjectCollection)slc);
    }

    private void signSettleDate(Context ctx, String companyId, java.util.Date date) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("inGroup", (Object)Boolean.TRUE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("settleDate"));
        view.setFilter(filter);
        view.setSelector(sic);
        CoreBaseCollection colls = BankFactory.getLocalInstance((Context)ctx).getCollection(view);
        for (int index = 0; index < colls.size(); ++index) {
            BankInfo info = (BankInfo)colls.get(index);
            info.setSettleDate((java.util.Date)new Date(date.getTime()));
        }
        BankFactory.getLocalInstance((Context)ctx).updateBatchData(colls);
    }

    protected void requestDailySettleBatchForUpdate(Context ctx, String companyId) throws BOSException, EASBizException {
        boolean isDailySettle = true;
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        UserInfo handler = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String dailySettleSql = null;
        try {
            dailySettleSql = "select * From T_FS_DailySettleBatch WHERE FCompanyId = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)dailySettleSql, (Object[])new Object[]{companyId});
            if (rs.next()) {
                isDailySettle = rs.getBoolean("FisDailySettle");
            } else {
                dailySettleSql = "insert into T_FS_DailySettleBatch (FCompanyId, FisDailySettle, FLastUpdateUserID, FlastUpdateTime) VALUES ( ?, ?, ?, ?)";
                DbUtil.execute((Context)ctx, (String)dailySettleSql, (Object[])new Object[]{companyId, new Integer(1), StringUtils.cnulls((String)ConvertUtils.IDSTR((Object)handler)), currTime});
                isDailySettle = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)e);
            isDailySettle = false;
        }
        if (isDailySettle) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"DailySettleProcessNow", (Locale)ctx.getLocale());
            throw new FSException(FSException.COMMON, new String[]{msg});
        }
        dailySettleSql = "Update T_FS_DailySettleBatch set FisDailySettle = 1, FLastUpdateUserID = ? , FlastUpdateTime = ? WHERE FCompanyId = ?";
        DbUtil.execute((Context)ctx, (String)dailySettleSql, (Object[])new Object[]{StringUtils.cnulls((String)ConvertUtils.IDSTR((Object)handler)), currTime, companyId});
    }

    protected void releaseDailySettleBatchForUpdate(Context ctx, String companyId) throws BOSException, EASBizException {
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        UserInfo handler = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String dailySettleSql = "Update T_FS_DailySettleBatch set FisDailySettle = 0, FLastUpdateUserID = ?, FlastUpdateTime = ? WHERE FCompanyId = ?";
        DbUtil.execute((Context)ctx, (String)dailySettleSql, (Object[])new Object[]{StringUtils.cnulls((String)ConvertUtils.IDSTR((Object)handler)), currTime, companyId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _antiDailySettleBatch(Context ctx, String companyId, java.util.Date settleDate, int settleDayNum) throws BOSException, EASBizException {
        this.requestDailySettleBatchForUpdate(ctx, companyId);
        try {
            this._antiDailySettle(ctx, companyId, settleDate);
            java.util.Date realSettleDate = settleDate;
            for (int i = 1; i < settleDayNum; ++i) {
                realSettleDate = DateUtil.getBeforeDay((java.util.Date)realSettleDate);
                this._antiDailySettle(ctx, companyId, realSettleDate);
            }
        }
        finally {
            this.releaseDailySettleBatchForUpdate(ctx, companyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _dailySettleBatch(Context ctx, String companyId, java.util.Date settleDate, int settleDayNum) throws BOSException, EASBizException {
        this.requestDailySettleBatchForUpdate(ctx, companyId);
        try {
            SubsidiaryLedgerCollection subsidiaryColl;
            java.util.Date key;
            if (FMHelper.isEmpty((String)companyId) || settleDate == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"0_DailySettleFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            this.checkIsCH(ctx, companyId);
            String sql = "UPDATE T_BD_Bank SET FPhone=FPhone WHERE FRelatedCompanyId = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
            settleDate = DateTimeUtils.truncateDate((java.util.Date)settleDate);
            java.util.Date endDate = DateHelper.getNextDay((java.util.Date)settleDate, (int)settleDayNum);
            this.checkSettleDate(ctx, companyId, settleDate);
            java.util.Date preSettleDate = DateHelper.getBeforeDay((java.util.Date)settleDate);
            SummaryLedgerCollection preSummaryColl = this.getSummaryColl(ctx, companyId, preSettleDate);
            SubsidiaryLedgerCollection subsidiaryCollBatch = this.getSubsidirayCollBatch(ctx, companyId, settleDate, endDate);
            TreeMap<java.util.Date, SubsidiaryLedgerCollection> choiceMap = new TreeMap<java.util.Date, SubsidiaryLedgerCollection>();
            Iterator it = subsidiaryCollBatch.iterator();
            while (it.hasNext()) {
                SubsidiaryLedgerInfo subsidiaryLedgerInfo = (SubsidiaryLedgerInfo)it.next();
                key = DateTimeUtils.truncateDate((java.util.Date)subsidiaryLedgerInfo.getDate());
                if (!choiceMap.containsKey(key)) {
                    SubsidiaryLedgerCollection newSubsidiaryColl = new SubsidiaryLedgerCollection();
                    choiceMap.put(key, newSubsidiaryColl);
                }
                subsidiaryColl = (SubsidiaryLedgerCollection)((Object)choiceMap.get(key));
                subsidiaryColl.add(subsidiaryLedgerInfo);
            }
            HashMap resultMap = new HashMap();
            for (int i = 0; i < settleDayNum; ++i) {
                key = DateTimeUtils.truncateDate((java.util.Date)DateHelper.getNextDay((java.util.Date)settleDate, (int)i));
                subsidiaryColl = (SubsidiaryLedgerCollection)((Object)choiceMap.get(key));
                SummaryLedgerCollection currSummaryColl = this.initCurrSummaryColl(key, preSummaryColl);
                Map summaryMap = DailySettleFacadeControllerBean.getSumHashSearchMap((IObjectCollection)currSummaryColl);
                if (subsidiaryColl != null) {
                    int size = subsidiaryColl.size();
                    for (int j = 0; j < size; ++j) {
                        this.genSummaryLedgerMap(key, summaryMap, subsidiaryColl.get(j));
                    }
                }
                preSummaryColl.clear();
                for (SummaryLedgerInfo info : summaryMap.values()) {
                    preSummaryColl.add(info);
                }
                resultMap.putAll(summaryMap);
            }
            this.saveSummaryLedger(ctx, resultMap);
            this.signSettleDate(ctx, companyId, DateTimeUtils.truncateDate((java.util.Date)DateHelper.getNextDay((java.util.Date)settleDate, (int)settleDayNum)));
        }
        finally {
            this.releaseDailySettleBatchForUpdate(ctx, companyId);
        }
    }

    public static Map getSumHashSearchMap(IObjectCollection iObjCol) {
        HashMap<String, SummaryLedgerInfo> map = new HashMap<String, SummaryLedgerInfo>();
        SummaryLedgerInfo sumInfo = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            sumInfo = (SummaryLedgerInfo)iObjCol.getObject(i);
            sumInfo.setBizDate(DateTimeUtils.truncateDate((java.util.Date)sumInfo.getBizDate()));
            map.put(PKUtils.getKeyString((IObjectValue)sumInfo, (String[])FSHelper.getStrings(sumKeys)), sumInfo);
        }
        return map;
    }

    @Override
    protected boolean _checkCanSettle(Context ctx, String companyID, java.util.Date settleDate) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyID) || settleDate == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"0_DailySettleFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        settleDate = DateTimeUtils.truncateDate((java.util.Date)settleDate);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterAll = new FilterInfo();
        view.setFilter(filterAll);
        view.getSelector().add("id");
        filterAll.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        filterAll.getFilterItems().add(new FilterItemInfo("bizDate", (Object)settleDate, CompareType.LESS_EQUALS));
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)Boolean.FALSE));
        HashSet<Integer> setOut = new HashSet<Integer>();
        setOut.add(new Integer(1));
        setOut.add(new Integer(2));
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("type", setOut, CompareType.INCLUDE));
        filter2.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)Boolean.TRUE));
        filter2.getFilterItems().add(new FilterItemInfo("cashier", null));
        HashSet<Integer> setInIF = new HashSet<Integer>();
        setInIF.add(new Integer(51));
        setInIF.add(new Integer(52));
        FilterInfo filter3 = new FilterInfo();
        filter3.getFilterItems().add(new FilterItemInfo("type", setInIF, CompareType.INCLUDE));
        filter3.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)Boolean.TRUE));
        filter3.getFilterItems().add(new FilterItemInfo("cashier", null));
        filter3.getFilterItems().add(new FilterItemInfo("mutilType", (Object)new Integer(3), CompareType.NOTEQUALS));
        filter1.mergeFilter(filter2, "or");
        filter1.mergeFilter(filter3, "or");
        filterAll.mergeFilter(filter1, "and");
        return !SettlementBillFactory.getLocalInstance(ctx).exists(filterAll);
    }

    private SubsidiaryLedgerCollection getSubsidirayCollBatch(Context ctx, String companyId, java.util.Date biginDate, java.util.Date endDate) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyId) || biginDate == null || endDate == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"0_DailySettleFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)biginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)endDate, CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("innerAccount.*"));
        ISubsidiaryLedger iSubsidiary = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        return iSubsidiary.getSubsidiaryLedgerCollection(evi);
    }
}

