/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasSubSidiaryLedgerFacadeFactory;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFormualParam;
import com.kingdee.eas.fm.fs.InAcctFormualParamCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.app.AbstractInAcctControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InAcctControllerBean
extends AbstractInAcctControllerBean {
    private static final String SUMMARY_QUERY = "com.kingdee.eas.fm.fs.SummaryLedgerQuery";
    private static final String SUB_QUERY = "com.kingdee.eas.fm.fs.SubsidiaryLedgerQuery";
    private static final String DEBIT_COUNTS = "debitCounts";
    private static final String CREDIT_COUNTS = "creditCounts";
    private static final String DEBIT_TOTAL = "debitTotal";
    private static final String CREDIT_TOTAL = "creditTotal";
    private static final String END_BALANCE = "endBalance";
    private static final String COMPANY_ID = "company.id";
    private static final String INNERACCT_ID = "innerAccountID";
    private static final String BankAcct_ID = "bankAcctID";
    private static final String INNERACCT_TYPE = "innerAccount.type";
    private static final String CAPITAL_TYPE = "capitalType";
    private static final String CURRENCY_ID = "currencyID";
    private static final String BIZEDATE = "bizDate";
    private static final String SUBSIDIARY_TYPE = "type";
    private static Logger logger = Logger.getLogger(InAcctControllerBean.class);
    public static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    @Override
    protected BigDecimal _inAcct(Context ctx, String companyNumber, String innerAcctNumber, String currencyNumber, java.util.Date beginDay, java.util.Date endDay, InAcctDataTypeEnum inAcctDataType) throws BOSException, EASBizException {
        if (inAcctDataType == null) {
            throw new FSException(FSException.INACCTTYPEISNULL);
        }
        Set companyIds = null;
        Set innerAcctIds = null;
        CurrencyInfo currency = null;
        if (companyNumber != null) {
            companyNumber = companyNumber.trim();
            companyIds = InAcctControllerBean.parseCompanyParam(ctx, companyNumber);
        }
        if (currencyNumber != null) {
            currencyNumber = currencyNumber.trim();
            currency = this.getCurrency(ctx, currencyNumber);
        }
        if (beginDay == null) {
            throw new FSException(FSException.STARTDAYISNULL);
        }
        beginDay = DateTimeUtils.truncateDate((java.util.Date)beginDay);
        if (inAcctDataType.equals((Object)InAcctDataTypeEnum.C) || inAcctDataType.equals((Object)InAcctDataTypeEnum.Y)) {
            endDay = null;
        }
        if (endDay != null) {
            endDay = DateTimeUtils.truncateDate((java.util.Date)endDay);
        }
        if (beginDay != null && endDay != null && endDay.before(beginDay)) {
            throw new FSException(FSException.BEGINLARGEREND);
        }
        if (innerAcctNumber != null) {
            innerAcctNumber = innerAcctNumber.trim();
            innerAcctIds = this.parseInnerAcctParam(ctx, innerAcctNumber);
        }
        BigDecimal result = null;
        if (inAcctDataType.getValue().equals("C")) {
            result = this.getCValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("Y")) {
            result = this.getYValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("MAY")) {
            result = this.getMAYValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("WAY")) {
            result = this.getWAYValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("JF")) {
            result = this.getJFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("DF")) {
            result = this.getDFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("QJF")) {
            result = this.getQJFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("QDF")) {
            result = this.getQDFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("K")) {
            result = this.getKValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        }
        if (result != null && currency != null) {
            result = result.setScale(currency.getPrecision(), 4);
        }
        return result;
    }

    private String getSubsidiarySQL(Context ctx, String selector, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemInfo selectorItemInfo = new SelectorItemInfo(selector);
        view.getSelector().add(selectorItemInfo);
        FilterInfo filter = this.getSubsidiaryFilter(companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        view.setFilter(filter);
        String subSql = null;
        MetaDataPK mainQueryPK = new MetaDataPK(SUB_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        subSql = exec.getSQL();
        return subSql;
    }

    private BigDecimal getKValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        }
        java.util.Date unSettledDate = CHInfo.getSettleDate();
        unSettledDate = DateTimeUtils.truncateDate((java.util.Date)unSettledDate);
        BigDecimal resultSubL = Constants.ZERO;
        if (!beginDay.before(unSettledDate)) {
            String subsidiarySQL = this.getSubsidiarySQL(ctx, "amountOffset", companyIds, innerAcctIds, null, currency, unSettledDate, beginDay);
            String subsidiarySumSQL = "select sum(amountOffset) result from (" + subsidiarySQL + ") as subTable";
            resultSubL = this.getResultBySQL(ctx, subsidiarySumSQL);
            beginDay = this.getBeforeDay(unSettledDate);
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, null);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql).add(resultSubL);
    }

    private BigDecimal getCValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        }
        if (!CHInfo.isUsed()) {
            return Constants.ZERO;
        }
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getSettleDate());
        if (beginDay.after(settleDate)) {
            beginDay = settleDate;
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(beginDay), endDay);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        java.util.Date settleDate;
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        }
        if (beginDay.after(this.getBeforeDay(settleDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getSettleDate())))) {
            beginDay = this.getBeforeDay(settleDate);
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getMAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        }
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getOpenDate());
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getSettleDate());
        if (beginDay.before(openDate)) {
            beginDay = this.getBeforeDay(openDate);
        }
        if (beginDay.after(this.getBeforeDay(settleDate))) {
            return this.getYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(settleDate), null);
        }
        if (endDay.before(openDate)) {
            return Constants.ZERO;
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        BigDecimal sum = this.getResultBySQL(ctx, sql);
        long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return sum.divide(new BigDecimal(subDay), 6, 4);
    }

    private BigDecimal getWAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        }
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getOpenDate());
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getSettleDate());
        if (beginDay.before(openDate)) {
            beginDay = this.getBeforeDay(openDate);
        }
        if (beginDay.after(this.getBeforeDay(settleDate))) {
            return this.getYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(settleDate), null);
        }
        if (endDay.before(openDate)) {
            return Constants.ZERO;
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        if (endDay.before(this.getBeforeDay(settleDate))) {
            String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sql);
            }
            BigDecimal sum = this.getResultBySQL(ctx, sql);
            long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
            return sum.divide(new BigDecimal(subDay), 6, 4);
        }
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        BigDecimal sum = this.getResultBySQL(ctx, sql);
        BigDecimal sumAdd = this.getCValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, settleDate, null);
        long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        long subDay2 = (endDay.getTime() - settleDate.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        sum = sum.add(sumAdd.multiply(new BigDecimal(subDay2)));
        BigDecimal result = sum.divide(new BigDecimal(subDay), 6, 4);
        return result;
    }

    private BigDecimal getJFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, DEBIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(debitTotal) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getDFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, CREDIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(creditTotal) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getQJFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, DEBIT_COUNTS, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(debitCounts) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getQDFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, CREDIT_COUNTS, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(creditCounts) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private String getSubSQL(Context ctx, String entry, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo(entry));
        FilterInfo filter = this.getFilter(companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        view.setFilter(filter);
        String subSql = null;
        MetaDataPK mainQueryPK = new MetaDataPK(SUMMARY_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        subSql = exec.getSQL();
        return subSql;
    }

    private FilterInfo getSubsidiaryFilter(Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (companyIds != null) {
            filterItem = new FilterItemInfo(COMPANY_ID, (Object)companyIds, CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem);
        }
        if (innerAcctIds != null) {
            filter.getFilterItems().add(this.getInnerAccountFilterItem(innerAcctIds));
        }
        if (bankAcctIds != null) {
            filter.getFilterItems().add(this.getBankAcctFilterItem(bankAcctIds));
        }
        if (currency != null) {
            filterItem = new FilterItemInfo("currency", (Object)currency.getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (beginDay != null) {
            beginDay = DateTimeUtils.truncateDate((java.util.Date)beginDay);
            filterItem = new FilterItemInfo("date", (Object)beginDay, CompareType.GREATER_EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return filter;
    }

    private FilterInfo getFilter(Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) {
        FilterInfo filter = new FilterInfo();
        if (companyIds != null) {
            filter.getFilterItems().add(this.getApplyUnitFilterItem(companyIds));
        }
        if (innerAcctIds != null) {
            filter.getFilterItems().add(this.getInnerAccountFilterItem(innerAcctIds));
        }
        if (bankAcctIds != null) {
            filter.getFilterItems().add(this.getBankAcctFilterItem(bankAcctIds));
        }
        if (currency != null) {
            filter.getFilterItems().add(this.getCurrencyFilterItem(currency));
        }
        if (beginDay != null) {
            if (endDay != null) {
                filter.getFilterItems().add(this.getBeginDateFilterItem(beginDay, CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(this.getEndDateFilterItem(endDay));
            } else {
                filter.getFilterItems().add(this.getBeginDateFilterItem(beginDay, CompareType.EQUALS));
            }
        }
        return filter;
    }

    private java.util.Date getBeforeDay(java.util.Date date) {
        if (date == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((java.util.Date)date);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - 1);
        return cal.getTime();
    }

    private static Set parseCompanyParam(Context ctx, String param) throws BOSException {
        if (FMHelper.isEmpty((String)param)) {
            return new HashSet();
        }
        if (param.indexOf(",") > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"33_InAcctControllerBean", (Locale)ctx.getLocale()));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)param));
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(filter);
        CompanyOrgUnitCollection co = iCompany.getCompanyOrgUnitCollection(view);
        int size = co.size();
        if (size == 0) {
            return null;
        }
        HashSet<BOSUuid> companySet = new HashSet<BOSUuid>();
        for (int i = 0; i < size; ++i) {
            CompanyOrgUnitInfo companyInfo = co.get(i);
            companySet.add(companyInfo.getId());
        }
        return companySet;
    }

    private Set parseInnerAcctParam(Context ctx, String param) throws FSException, BOSException {
        FilterInfo filter = this.parseParamFilter(param);
        IInnerAccount iInner = InnerAccountFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        CoreBaseCollection co = iInner.getCollection(view);
        int size = co.size();
        if (size == 0) {
            return null;
        }
        HashSet<BOSUuid> innerSet = new HashSet<BOSUuid>();
        for (int i = 0; i < size; ++i) {
            innerSet.add(co.get(i).getId());
        }
        return innerSet;
    }

    private FilterInfo parseParamFilter(String param) throws FSException {
        HashSet<String> aloneSet = new HashSet<String>();
        HashSet<String> periodSet = new HashSet<String>();
        if (param == null) {
            return null;
        }
        if (param.indexOf(",") == -1 && param.indexOf(":") == -1) {
            aloneSet.add(param);
        } else {
            String[] subParam = param.split(",");
            for (int i = 0; i < subParam.length; ++i) {
                if (subParam[i].indexOf(":") == -1) {
                    aloneSet.add(subParam[i]);
                    continue;
                }
                periodSet.add(subParam[i]);
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo aloneFilter = null;
        if (aloneSet.size() != 0) {
            aloneFilter = new FilterItemInfo("number", aloneSet, CompareType.INCLUDE);
        }
        FilterItemCollection periodFilters = new FilterItemCollection();
        Iterator it = periodSet.iterator();
        while (it.hasNext()) {
            String[] periodString = ((String)it.next()).split(":");
            if (periodString.length != 2) {
                throw new FSException(FSException.EXPRESSWRONG);
            }
            if (periodString[1].compareTo(periodString[0]) < 0) {
                throw new FSException(FSException.NUMBERWRONG);
            }
            periodFilters.add(new FilterItemInfo("number", (Object)periodString[0], CompareType.GREATER_EQUALS));
            periodFilters.add(new FilterItemInfo("number", (Object)periodString[1], CompareType.LESS_EQUALS));
        }
        int maskCount = 0;
        StringBuffer maskString = new StringBuffer("");
        if (aloneFilter != null) {
            filter.getFilterItems().add(aloneFilter);
            maskString.append("#" + maskCount);
            ++maskCount;
        }
        if (periodFilters.size() != 0) {
            filter.getFilterItems().addObjectCollection((IObjectCollection)periodFilters);
            for (int i = 0; i < periodFilters.size(); i += 2) {
                if (!maskString.toString().equals("")) {
                    maskString.append(" or ");
                }
                maskString.append("(#" + maskCount + " and #" + (maskCount + 1) + ")");
                maskCount += 2;
            }
            filter.setMaskString(maskString.toString());
        }
        return filter;
    }

    private FilterItemInfo getApplyUnitFilterItem(Set companyIds) {
        FilterItemInfo filter = new FilterItemInfo(COMPANY_ID, (Object)companyIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getInnerAccountFilterItem(Set innerAcctIds) {
        FilterItemInfo filter = new FilterItemInfo(INNERACCT_ID, (Object)innerAcctIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getBankAcctFilterItem(Set bankAcctIds) {
        FilterItemInfo filter = new FilterItemInfo(BankAcct_ID, (Object)bankAcctIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getBeginDateFilterItem(java.util.Date beginDay, CompareType type) {
        beginDay = DateTimeUtils.truncateDate((java.util.Date)beginDay);
        FilterItemInfo filterItem = new FilterItemInfo(BIZEDATE, (Object)beginDay, type);
        return filterItem;
    }

    private FilterItemInfo getEndDateFilterItem(java.util.Date endDay) {
        FilterItemInfo filterItem = new FilterItemInfo(BIZEDATE, (Object)endDay, CompareType.LESS_EQUALS);
        return filterItem;
    }

    private FilterItemInfo getCurrencyFilterItem(CurrencyInfo currency) {
        FilterItemInfo filterItem = new FilterItemInfo(CURRENCY_ID, (Object)currency.getId().toString());
        return filterItem;
    }

    private CurrencyInfo getCurrency(Context ctx, String currencyNumber) throws BOSException, FSException {
        if (currencyNumber == null) {
            return null;
        }
        CurrencyCollection currencyCollection = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
        view.setFilter(filter);
        currencyCollection = iCurrency.getCurrencyCollection(view);
        if (currencyCollection.size() != 1) {
            throw new FSException(FSException.CURRENCYNUMNOTEXSIST);
        }
        return currencyCollection.get(0);
    }

    private BigDecimal getResultBySQL(Context ctx, String sql) throws SQLDataException, BOSException {
        BigDecimal result = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next() && (result = rs.getBigDecimal("result")) == null) {
                result = Constants.ZERO;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected Map _getInnerAcctDailyBalance(Context ctx, String innerAcctID, String currencyID, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException {
        SQLUtil builder = new SQLUtil();
        builder.appendSql("select  fdate ,sum(fdebitamount-fcreditamount) amount  ");
        builder.appendSql(" from t_fs_subsidiaryledger");
        builder.appendSql(" where   FCurrencyId =");
        builder.appendParam((Object)currencyID);
        builder.appendSql(" and FInnerAccountID=");
        builder.appendParam((Object)innerAcctID);
        builder.appendSql(" and fdate>=");
        builder.appendParam((Object)DateUtil.getSQLBegin((java.util.Date)beginDate));
        builder.appendSql(" and fdate<=");
        builder.appendParam((Object)DateUtil.getSQLBegin((java.util.Date)endDate));
        builder.appendSql(" group by fdate");
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = builder.createState(con);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Date date = rs.getDate("fdate");
                BigDecimal amount = rs.getBigDecimal("amount");
                result.put(date, amount);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sql: " + builder.getTestSql()));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    @Override
    protected InAcctFormualParamCollection _inAcct(Context ctx, InAcctFormualParamCollection inAcctFormualParamColl) throws BOSException, EASBizException {
        if (inAcctFormualParamColl == null || inAcctFormualParamColl.isEmpty()) {
            return new InAcctFormualParamCollection();
        }
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        java.util.Date settleDate = null;
        Map settleAndOpenDateMap = null;
        settleAndOpenDateMap = CasSubSidiaryLedgerFacadeFactory.getLocalInstance((Context)ctx).getCleanHouseDate(inAcctFormualParamColl.get(0).getInnerAcctNumber());
        settleDate = (java.util.Date)settleAndOpenDateMap.get("latest_settledate");
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.fs", "SubsidiaryLedgerQuery");
        InAcctFormualParamCollection coll = new InAcctFormualParamCollection();
        InAcctFormualParam param = null;
        BigDecimal result = Constants.ZERO;
        BigDecimal totalSubsidiaryAmt = Constants.ZERO;
        int size = inAcctFormualParamColl.size();
        for (int i = 0; i < size; ++i) {
            param = inAcctFormualParamColl.get(i);
            if (param.getEndDate().before(settleDate)) {
                result = this._inAcct(ctx, param.getCompanyNumber(), param.getInnerAcctNumber(), param.getCurrencyNumber(), param.getBeginDate(), param.getEndDate(), param.getDataType());
            } else if (param.getBeginDate().after(settleDate)) {
                result = this.getTotalAmt(ctx, (IMetaDataPK)mainQueryPK, param.getInnerAcctNumber(), param.getCurrencyNumber(), param.getBeginDate(), param.getEndDate(), param.getDataType());
            } else {
                if (param.isYearTotal()) {
                    java.util.Date openDate = null;
                    openDate = (java.util.Date)settleAndOpenDateMap.get("earliest_opendate");
                    BigDecimal beginYearData = Constants.ZERO;
                    if (param.getBeginDate().before(openDate)) {
                        beginYearData = param.getDataType().equals((Object)InAcctDataTypeEnum.JF) ? this._inAcct(ctx, param.getCompanyNumber(), param.getInnerAcctNumber(), param.getCurrencyNumber(), param.getBeginDate(), DateUtil.getBeforeDay((java.util.Date)openDate), InAcctDataTypeEnum.DF) : this._inAcct(ctx, param.getCompanyNumber(), param.getInnerAcctNumber(), param.getCurrencyNumber(), param.getBeginDate(), DateUtil.getBeforeDay((java.util.Date)openDate), InAcctDataTypeEnum.JF);
                        BigDecimal YearData = this._inAcct(ctx, param.getCompanyNumber(), param.getInnerAcctNumber(), param.getCurrencyNumber(), openDate, settleDate, param.getDataType());
                        result = YearData.add(beginYearData);
                    } else {
                        result = this._inAcct(ctx, param.getCompanyNumber(), param.getInnerAcctNumber(), param.getCurrencyNumber(), param.getBeginDate(), settleDate, param.getDataType());
                    }
                } else {
                    result = this._inAcct(ctx, param.getCompanyNumber(), param.getInnerAcctNumber(), param.getCurrencyNumber(), param.getBeginDate(), settleDate, param.getDataType());
                }
                totalSubsidiaryAmt = this.getTotalAmt(ctx, (IMetaDataPK)mainQueryPK, param.getInnerAcctNumber(), param.getCurrencyNumber(), settleDate, param.getEndDate(), param.getDataType());
                result = result.add(totalSubsidiaryAmt);
            }
            param.setResult(result);
            coll.add(param);
        }
        return coll;
    }

    private BigDecimal getTotalAmt(Context ctx, IMetaDataPK mainQueryPK, String innerAcctNumber, String currencyNumber, java.util.Date beginDate, java.util.Date endDate, InAcctDataTypeEnum direction) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        HashSet<String> innerAcctSet = new HashSet<String>();
        if (innerAcctNumber.indexOf(",") == -1) {
            innerAcctSet.add(innerAcctNumber);
        } else {
            String[] innerAcctArray = innerAcctNumber.split(",");
            for (int i = 0; i < innerAcctArray.length; ++i) {
                innerAcctSet.add(innerAcctArray[i]);
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("innerAccount.number", innerAcctSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currencyNumber));
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("Date", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Date", (Object)endDate, CompareType.LESS_EQUALS));
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(evi);
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT ");
        if (direction.equals((Object)InAcctDataTypeEnum.JF)) {
            sql.append(" ISNULL(SUM(DEBITAMOUNT),0) AS RESULT");
        } else {
            sql.append(" ISNULL(SUM(CREDITAMOUNT),0) AS RESULT");
        }
        sql.append(" from (");
        sql.append(exec.getSQL());
        sql.append(") a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = sqlExe.executeSQL();
        try {
            if (rs.next()) {
                return rs.getBigDecimal("RESULT");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return Constants.ZERO;
    }

    public BankInfo getClearingHouse(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curent = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(curent.getId().toString());
        if (clearingHouse == null) {
            throw new FSException(FSException.CHNOTUSED);
        }
        return clearingHouse;
    }

    @Override
    protected XTable _createInAcctBalanceDataTable(Context ctx, String[] companyIds, String currencyId, java.util.Date rptDate, java.util.Date settleDate) throws BOSException, EASBizException {
        Map newRow;
        BigDecimal oldBalance;
        Map rowBalance;
        Map rowSec;
        String rowKey;
        int i;
        XTable balanceTable = null;
        if (EmptyUtil.isEmpty((Object)settleDate)) {
            settleDate = this.getClearingHouse(ctx).getSettleDate();
        }
        if (settleDate == null) {
            throw new FSException(FSException.CHNOTUSED);
        }
        if (rptDate.before(settleDate)) {
            balanceTable = this.createBalanceTable(ctx, companyIds, currencyId, rptDate);
        } else {
            balanceTable = this.createBalanceTable(ctx, companyIds, currencyId, DateUtil.getBeforeDay((java.util.Date)settleDate));
            XTable subSectionTable = this.createSubSectionTable(ctx, companyIds, currencyId, settleDate, rptDate);
            for (i = 0; i < subSectionTable.getRowCount(); ++i) {
                rowKey = subSectionTable.getRowKey(i);
                rowSec = subSectionTable.getRow(rowKey);
                rowBalance = balanceTable.getRow(rowKey);
                BigDecimal offset = (BigDecimal)rowSec.get("amountoffset");
                if (offset == null) {
                    offset = Constants.ZERO;
                }
                if (rowBalance != null) {
                    oldBalance = (BigDecimal)rowBalance.get("balance");
                    BigDecimal usebalance = (BigDecimal)rowBalance.get("usebalance");
                    rowBalance.put("balance", oldBalance.add(offset));
                    rowBalance.put("frozenamt", rowBalance.get("frozenamt"));
                    rowBalance.put("usebalance", usebalance.add(offset));
                    continue;
                }
                newRow = balanceTable.addRow(rowKey);
                newRow.put("balance", offset);
                newRow.put("balance", offset);
                newRow.put("usebalance", offset);
            }
        }
        XTable subFrozenable = this.createSubFrozenTable(ctx, companyIds, currencyId, rptDate);
        for (i = 0; i < subFrozenable.getRowCount(); ++i) {
            rowKey = subFrozenable.getRowKey(i);
            rowSec = subFrozenable.getRow(rowKey);
            rowBalance = balanceTable.getRow(rowKey);
            BigDecimal frozenAmt = (BigDecimal)rowSec.get("frozenamt");
            if (frozenAmt == null) {
                frozenAmt = Constants.ZERO;
            }
            if (rowBalance != null) {
                oldBalance = (BigDecimal)rowBalance.get("balance");
                rowBalance.put("frozenamt", frozenAmt);
                rowBalance.put("usebalance", oldBalance.subtract(frozenAmt));
                continue;
            }
            newRow = balanceTable.addRow(rowKey);
            newRow.put("frozenamt", frozenAmt);
            newRow.put("usebalance", frozenAmt.negate());
        }
        return balanceTable;
    }

    private XTable createSubFrozenTable(Context ctx, String[] companyIds, String currencyId, java.util.Date rptDate) throws BOSException {
        String sectionSql = this.getSubFrozenSQL(companyIds, currencyId, rptDate);
        IRowSet sectionRS = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sectionSql).executeSQL();
        XTable xSectionTable = new XTable(sectionRS, new String[]{"company", "currency", "inneracct"});
        return xSectionTable;
    }

    private String getSubFrozenSQL(String[] companyIds, String currencyId, java.util.Date rptDate) {
        String select = "Select FCurCompanyID company,FCurrencyId currency,FInnerAccountId inneracct,isnull(sum(FFrozenAmt),0) frozenamt";
        String from = " From T_FS_InnerFrozenDeposit";
        StringBuffer where = new StringBuffer();
        where.append(" Where ");
        if (companyIds != null && companyIds.length != 0) {
            where.append(" FCurCompanyID in ('").append(companyIds[0]).append("'");
            for (int i = 1; i < companyIds.length; ++i) {
                where.append(",'").append(companyIds[i]).append("'");
            }
            where.append(")");
        }
        if (currencyId != null) {
            where.append(" And FCurrencyId='").append(currencyId).append("'");
        }
        String group = " Group by FCurCompanyID,FCurrencyId,FInnerAccountId";
        return select + from + where + group;
    }

    private XTable createSubSectionTable(Context ctx, String[] companyIds, String currencyId, java.util.Date settleDate, java.util.Date rptDate) throws BOSException {
        String sectionSql = this.getSubSectionSQL(companyIds, currencyId, settleDate, rptDate);
        IRowSet sectionRS = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sectionSql).executeSQL();
        XTable xSectionTable = new XTable(sectionRS, new String[]{"company", "currency", "inneracct"});
        return xSectionTable;
    }

    private String getSubSectionSQL(String[] companyIds, String currencyId, java.util.Date settleDate, java.util.Date rptDate) {
        String select = "Select FapplyUnitId company,FCurrencyId currency,FInnerAccountId inneracct,sum(FDebitAmount-FCreditAmount) amountOffset";
        String from = " From T_Fs_SubsidiaryLedger";
        StringBuffer where = new StringBuffer();
        where.append(" Where FType=1 ");
        if (companyIds != null && companyIds.length != 0) {
            where.append(" And FapplyUnitId in ('").append(companyIds[0]).append("'");
            for (int i = 1; i < companyIds.length; ++i) {
                where.append(",'").append(companyIds[i]).append("'");
            }
            where.append(")");
        }
        if (currencyId != null) {
            where.append(" And FCurrencyId='").append(currencyId).append("'");
        }
        if (settleDate != null) {
            where.append(" and FDate >= {").append(TypeConversionUtils.objToDate((Object)settleDate)).append("}");
        }
        if (rptDate != null) {
            where.append(" and FDate <= {").append(TypeConversionUtils.objToDate((Object)rptDate)).append("}");
        }
        String group = " Group by FapplyUnitId,FCurrencyId,FInnerAccountId";
        return select + from + where + group;
    }

    private XTable createBalanceTable(Context ctx, String[] companyIds, String currencyId, java.util.Date rptDate) throws BOSException {
        String balanceSql = this.getBalanceSQL(ctx, companyIds, currencyId, rptDate);
        IRowSet balanceRS = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)balanceSql).executeSQL();
        XTable xBalanceTable = new XTable(balanceRS, new String[]{"company", "currency", "inneracct"});
        return xBalanceTable;
    }

    private String getBalanceSQL(Context ctx, String[] companyIds, String currencyId, java.util.Date rptDate) {
        String select = "Select FapplyUnitId company,FCurrencyId currency,FInnerAccountId inneracct,sum(FEndBalance) balance,0 frozenAmt,sum(FEndBalance) useBalance";
        String from = " From T_Fs_SummaryLedger";
        StringBuffer where = new StringBuffer();
        where.append(" Where FType=1 ");
        if (companyIds != null && companyIds.length != 0) {
            where.append(" And FapplyUnitId in ('").append(companyIds[0]).append("'");
            for (int i = 1; i < companyIds.length; ++i) {
                where.append(",'").append(companyIds[i]).append("'");
            }
            where.append(")");
        }
        if (currencyId != null) {
            where.append(" And FCurrencyId='").append(currencyId).append("'");
        }
        if (rptDate != null) {
            where.append(" and FBizDate = {").append(TypeConversionUtils.objToDate((Object)rptDate)).append("}");
        }
        String group = " Group by FapplyUnitId,FCurrencyId,FInnerAccountId ";
        return select + from + where.toString() + group;
    }

    @Override
    protected CompanyOrgUnitCollection _getInAcctApplyCompany(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        BankInfo bankinfo = this.getClearingHouse(ctx);
        String innerSql = "SELECT FApplyUnitID FROM T_FS_InnerAccount where FClearingHouseID = '" + bankinfo.getId().toString() + "'";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql, CompareType.INNER));
        evi.setFilter(filterInfo);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo org = coll.get(i);
            String[] tmpLNum = org.getLongNumber().split("!");
            StringBuffer strBuf = new StringBuffer();
            for (int j = 0; j < tmpLNum.length; ++j) {
                if (j == 0) {
                    strBuf.append(tmpLNum[j]);
                } else {
                    strBuf.append("!" + tmpLNum[j]);
                }
                if (set.contains(strBuf.toString())) continue;
                set.add(strBuf.toString());
            }
        }
        evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", set, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        return coll;
    }

    @Override
    protected CompanyOrgUnitCollection _getInAcctApplyCompany(Context ctx, boolean isContainSealUp) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        BankInfo bankinfo = this.getClearingHouse(ctx);
        String innerSql = "SELECT FApplyUnitID FROM T_FS_InnerAccount where FClearingHouseID = '" + bankinfo.getId().toString() + "'";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql, CompareType.INNER));
        evi.setFilter(filterInfo);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo org = coll.get(i);
            String[] tmpLNum = org.getLongNumber().split("!");
            StringBuffer strBuf = new StringBuffer();
            for (int j = 0; j < tmpLNum.length; ++j) {
                if (j == 0) {
                    strBuf.append(tmpLNum[j]);
                } else {
                    strBuf.append("!" + tmpLNum[j]);
                }
                if (set.contains(strBuf.toString())) continue;
                set.add(strBuf.toString());
            }
        }
        evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", set, CompareType.INCLUDE));
        if (!isContainSealUp) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        evi.setFilter(filterInfo);
        coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        return coll;
    }

    @Override
    protected Set _getUpAndcurCompanyID(Context ctx, Set set) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo org = coll.get(i);
            String[] tmpLNum = org.getLongNumber().split("!");
            StringBuffer strBuf = new StringBuffer();
            for (int j = 0; j < tmpLNum.length; ++j) {
                if (j == 0) {
                    strBuf.append(tmpLNum[j]);
                } else {
                    strBuf.append("!" + tmpLNum[j]);
                }
                if (companySet.contains(strBuf.toString())) continue;
                companySet.add(strBuf.toString());
            }
        }
        evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", companySet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        HashSet<String> resultSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            resultSet.add(coll.get(i).getId().toString());
        }
        return resultSet;
    }
}

