/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.app.AbstractInAcctExtControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InAcctExtControllerBean
extends AbstractInAcctExtControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.InAcctExtControllerBean");
    private Map companyIdMap = null;
    private Map currencyIdMap = null;
    private Map innerAcctIdMap = null;
    private Map bankMap = null;

    @Override
    protected BigDecimal _inAcct(Context ctx, String companyNumber, String innerAcctNumber, String currencyNumber, Date beginDay, Date endDay, InAcctDataTypeEnum inAcctDataType) throws BOSException, EASBizException {
        this.verify(companyNumber, innerAcctNumber, currencyNumber, inAcctDataType);
        BigDecimal rst = Constants.ZERO;
        try {
            rst = this.calc(ctx, companyNumber, innerAcctNumber, currencyNumber, beginDay, endDay, inAcctDataType);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rst;
    }

    private void cacheParam(Context ctx) throws BOSException, SQLException {
        if (this.companyIdMap == null) {
            this.companyIdMap = this.getCompanyIdMap(ctx);
        }
        if (this.currencyIdMap == null) {
            this.currencyIdMap = this.getCurrencyIdMap(ctx);
        }
        if (this.innerAcctIdMap == null) {
            this.innerAcctIdMap = this.getInnerAcctIdMap(ctx);
        }
        if (this.bankMap == null) {
            this.bankMap = this.getBankMap(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal calc(Context ctx, String companyNumber, String innerAcctNumber, String currencyNumber, Date beginDay, Date endDay, InAcctDataTypeEnum inAcctDataType) throws BOSException, SQLException, EASBizException {
        BigDecimal rst;
        try {
            this.cacheParam(ctx);
            String companyId = null;
            companyId = this.companyIdMap.get(companyNumber) != null ? (String)this.companyIdMap.get(companyNumber) : this.getCompanyId(ctx, companyNumber);
            String currencyId = null;
            currencyId = this.currencyIdMap.get(currencyNumber) != null ? (String)this.currencyIdMap.get(currencyNumber) : this.getCurrencyId(ctx, currencyNumber);
            Set<String> innerSet = new HashSet();
            String innerAcctId = null;
            if (this.innerAcctIdMap.get(innerAcctNumber) != null) {
                innerAcctId = (String)this.innerAcctIdMap.get(innerAcctNumber);
                innerSet.add(innerAcctId);
            } else {
                innerSet = this.getInnerAcctIds(ctx, innerAcctNumber);
            }
            BankInfo bank = null;
            bank = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(companyId);
            if (bank == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"34_InAcctExtControllerBean", (Locale)ctx.getLocale()) + companyNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"35_InAcctExtControllerBean", (Locale)ctx.getLocale()));
            }
            if (InAcctDataTypeEnum.C.equals((Object)inAcctDataType)) {
                endDay = beginDay;
            } else if (InAcctDataTypeEnum.Y.equals((Object)inAcctDataType)) {
                endDay = beginDay;
            }
            Date setteDate = bank.getSettleDate();
            if (setteDate == null) {
                BigDecimal bigDecimal = Constants.ZERO;
                return bigDecimal;
            }
            Date openDate = bank.getOpenDate();
            if (beginDay.compareTo(openDate) < 0) {
                beginDay = openDate;
            }
            if (endDay.compareTo(openDate) < 0) {
                BigDecimal bigDecimal = Constants.ZERO;
                return bigDecimal;
            }
            rst = null;
            if (InAcctDataTypeEnum.Y.equals((Object)inAcctDataType)) {
                if (beginDay.compareTo(openDate) < 0) {
                    rst = Constants.ZERO;
                }
                if (beginDay.compareTo(openDate) >= 0 && beginDay.compareTo(setteDate) < 0) {
                    rst = this.getSummaryBalance(ctx, "fendbalance", companyId, currencyId, innerSet, beginDay, beginDay);
                }
                if (beginDay.compareTo(setteDate) >= 0) {
                    BigDecimal a = this.getSummaryBalance(ctx, "fendbalance", companyId, currencyId, innerSet, DateUtil.getBeforeDay((Date)setteDate), DateUtil.getBeforeDay((Date)setteDate));
                    BigDecimal b = this.getSubisidarySum(ctx, "FDEBITAMOUNT -FCREDITAMOUNT", companyId, currencyId, innerSet, setteDate, beginDay);
                    rst = a.add(b);
                }
            } else if (InAcctDataTypeEnum.C.equals((Object)inAcctDataType)) {
                if (beginDay.compareTo(openDate) < 0) {
                    rst = Constants.ZERO;
                }
                if (beginDay.compareTo(openDate) >= 0 && beginDay.compareTo(setteDate) < 0) {
                    rst = this.getSummaryBalance(ctx, "fbeginbalance", companyId, currencyId, innerSet, beginDay, beginDay);
                }
                if (beginDay.compareTo(setteDate) >= 0) {
                    BigDecimal a = this.getSummaryBalance(ctx, "fendbalance", companyId, currencyId, innerSet, DateUtil.getBeforeDay((Date)setteDate), DateUtil.getBeforeDay((Date)setteDate));
                    BigDecimal b = this.getSubisidarySum(ctx, "FDEBITAMOUNT -FCREDITAMOUNT", companyId, currencyId, innerSet, setteDate, DateUtil.getBeforeDay((Date)beginDay));
                    rst = a.add(b);
                }
            } else if (InAcctDataTypeEnum.JF.equals((Object)inAcctDataType)) {
                if (endDay.compareTo(openDate) < 0) {
                    rst = Constants.ZERO;
                }
                if (beginDay.compareTo(openDate) >= 0 && endDay.compareTo(setteDate) < 0) {
                    rst = this.getSummaryBalance(ctx, "FDEBITTOTAL", companyId, currencyId, innerSet, beginDay, endDay);
                }
                if (beginDay.compareTo(setteDate) < 0 && endDay.compareTo(setteDate) >= 0) {
                    BigDecimal a = this.getSummaryBalance(ctx, "FDEBITTOTAL", companyId, currencyId, innerSet, beginDay, endDay);
                    BigDecimal b = this.getSubisidarySum(ctx, "FDEBITAMOUNT", companyId, currencyId, innerSet, setteDate, endDay);
                    rst = a.add(b);
                }
                if (beginDay.compareTo(setteDate) >= 0) {
                    BigDecimal b;
                    rst = b = this.getSubisidarySum(ctx, "FDEBITAMOUNT", companyId, currencyId, innerSet, beginDay, endDay);
                }
            } else if (InAcctDataTypeEnum.DF.equals((Object)inAcctDataType)) {
                if (endDay.compareTo(openDate) < 0) {
                    rst = Constants.ZERO;
                }
                if (beginDay.compareTo(openDate) >= 0 && endDay.compareTo(setteDate) < 0) {
                    rst = this.getSummaryBalance(ctx, "FCREDITTOTAL", companyId, currencyId, innerSet, beginDay, endDay);
                }
                if (beginDay.compareTo(setteDate) < 0 && endDay.compareTo(setteDate) >= 0) {
                    BigDecimal a = this.getSummaryBalance(ctx, "FCREDITTOTAL", companyId, currencyId, innerSet, beginDay, endDay);
                    BigDecimal b = this.getSubisidarySum(ctx, "FCREDITAMOUNT", companyId, currencyId, innerSet, setteDate, endDay);
                    rst = a.add(b);
                }
                if (beginDay.compareTo(setteDate) >= 0) {
                    BigDecimal b;
                    rst = b = this.getSubisidarySum(ctx, "FCREDITAMOUNT", companyId, currencyId, innerSet, beginDay, endDay);
                }
            }
        }
        finally {
            this.companyIdMap = null;
            this.currencyIdMap = null;
            this.innerAcctIdMap = null;
            this.bankMap = null;
        }
        return rst;
    }

    private BigDecimal getSubisidarySum(Context ctx, String field, String companyId, String currencyId, Set innerAccountSet, Date beginDay, Date endDay) throws SQLException, BOSException {
        SQLUtil filter = this.getSubisidarySumSQLUtil(field, companyId, currencyId, innerAccountSet, beginDay, endDay, null);
        ResultSet rs = filter.exeQuery(ctx);
        BigDecimal rst = Constants.ZERO;
        if (rs.next()) {
            rst = rs.getBigDecimal("subisidary");
        }
        if (rst == null) {
            rst = Constants.ZERO;
        }
        return rst;
    }

    private SQLUtil getSubisidarySumSQLUtil(String field, String companyId, String currencyId, Set innerAccountSet, Date beginDay, Date endDay, String fpFormulaId) {
        SQLUtil filter = new SQLUtil("select ");
        if (!EmptyUtil.isEmpty((String)fpFormulaId)) {
            filter.appendSql("'" + fpFormulaId + "'");
            filter.appendSql(" as fpFormulaId, ");
        }
        filter.appendSql(" sum(");
        filter.appendSql(field);
        filter.appendSql(") as subisidary from T_FS_SUBSIDIARYLEDGER where  1=1  ");
        filter.appendSql(" and ftype=1");
        filter.appendSql(" and fcompanyid=?");
        filter.addParam((Object)companyId);
        filter.appendSql(" and fDate>=" + FMHelper.formateSqlDate((Date)beginDay));
        filter.appendSql(" and fDate<=" + FMHelper.formateSqlDate((Date)endDay));
        filter.appendSql(" and fcurrencyid=?");
        filter.addParam((Object)currencyId);
        if (innerAccountSet.size() > 0) {
            filter.appendSql(" and finneraccountid in (");
            filter.appendParam(innerAccountSet.toArray());
            filter.appendSql(")");
        }
        return filter;
    }

    private SQLUtil getSummaryBalanceSQLUtil(String field, String companyId, String currencyId, Set innerAccountSet, Date beginDay, Date endDay, String fpFormulaId) {
        SQLUtil filter = new SQLUtil("select ");
        if (!EmptyUtil.isEmpty((String)fpFormulaId)) {
            filter.appendSql("'" + fpFormulaId + "'");
            filter.appendSql(" as fpFormulaId, ");
        }
        filter.appendSql(" sum(");
        filter.appendSql(field);
        filter.appendSql(")  as balance from t_fs_summaryledger where  1=1  ");
        filter.appendSql(" and ftype=1");
        filter.appendSql(" and fcompanyid=?");
        filter.addParam((Object)companyId);
        filter.appendSql(" and fbizDate>=" + FMHelper.formateSqlDate((Date)beginDay));
        filter.appendSql(" and fbizDate<=" + FMHelper.formateSqlDate((Date)endDay));
        filter.appendSql(" and fcurrencyid=?");
        filter.addParam((Object)currencyId);
        if (innerAccountSet.size() > 0) {
            filter.appendSql(" and finneraccountid in (");
            filter.appendParam(innerAccountSet.toArray());
            filter.appendSql(")");
        }
        return filter;
    }

    private BigDecimal getSummaryBalance(Context ctx, String field, String companyId, String currencyId, Set innerAccountSet, Date beginDay, Date endDay) throws BOSException, SQLException {
        SQLUtil filter = this.getSummaryBalanceSQLUtil(field, companyId, currencyId, innerAccountSet, beginDay, endDay, null);
        ResultSet rs = filter.exeQuery(ctx);
        BigDecimal rst = Constants.ZERO;
        if (rs.next()) {
            rst = rs.getBigDecimal("balance");
        }
        if (rst == null) {
            rst = Constants.ZERO;
        }
        return rst;
    }

    private Set getInnerAcctIds(Context ctx, String innerAcctNumber) throws BOSException, SQLException {
        HashSet<String> innerSet = new HashSet<String>();
        Object[] ainerNumber = innerAcctNumber.split(",");
        if (FMHelper.isEmpty((Object[])ainerNumber)) {
            return innerSet;
        }
        String flag = "fnumber";
        SQLUtil sb = new SQLUtil("select fid from t_fs_inneraccount where   ");
        String ne = ((String)ainerNumber[0]).trim();
        int n = ne.indexOf(":");
        if (ne.indexOf(":") > 0) {
            String from = ne.substring(n);
            String to = ne.substring(n);
            sb.appendSql("   (" + flag + ">=? and " + flag + "<=?)");
            sb.addParam((Object)from);
            sb.addParam((Object)to);
        } else {
            sb.appendSql("  (" + flag + "=?) ");
            sb.addParam((Object)ne);
        }
        for (int i = 1; i < ainerNumber.length; ++i) {
            String ne2 = ((String)ainerNumber[i]).trim();
            int n2 = ne2.indexOf(":");
            if (ne2.indexOf(":") > 0) {
                String from = ne2.substring(n2);
                String to = ne2.substring(n2);
                sb.appendSql(" or  (" + flag + ">=? and " + flag + "<=?)");
                sb.addParam((Object)from);
                sb.addParam((Object)to);
                continue;
            }
            sb.appendSql(" or (" + flag + "=?) ");
            sb.addParam((Object)ne2);
        }
        ResultSet innerRs = sb.exeQuery(ctx);
        while (innerRs.next()) {
            innerSet.add(innerRs.getString(1));
        }
        return innerSet;
    }

    private String getCurrencyId(Context ctx, String currencyNumber) throws BOSException, SQLException {
        String currencySql = "select fid from t_bd_currency where fnumber=?";
        IRowSet currencyRs = DbUtil.executeQuery((Context)ctx, (String)currencySql, (Object[])new Object[]{currencyNumber});
        if (!currencyRs.next()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"36_InAcctExtControllerBean", (Locale)ctx.getLocale()) + currencyNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"37_InAcctExtControllerBean", (Locale)ctx.getLocale()));
        }
        String currencyId = currencyRs.getString(1);
        return currencyId;
    }

    private String getCompanyId(Context ctx, String companyNumber) throws BOSException, SQLException {
        String compaySql = "select fid from t_org_company where fnumber=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)compaySql, (Object[])new Object[]{companyNumber});
        if (!rs.next()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"38_InAcctExtControllerBean", (Locale)ctx.getLocale()) + companyNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"37_InAcctExtControllerBean", (Locale)ctx.getLocale()));
        }
        String companyId = rs.getString(1);
        return companyId;
    }

    private Map getCompanyIdMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> companyIdMap = new HashMap<String, String>();
        String compaySql = "select fid,fnumber from t_org_company ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)compaySql);
        while (rs.next()) {
            companyIdMap.put(rs.getString(2), rs.getString(1));
        }
        return companyIdMap;
    }

    private Map getCurrencyIdMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> currencyIdMap = new HashMap<String, String>();
        String compaySql = "select fid,fnumber from t_bd_currency ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)compaySql);
        while (rs.next()) {
            currencyIdMap.put(rs.getString(2), rs.getString(1));
        }
        return currencyIdMap;
    }

    private Map getInnerAcctIdMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> innerAcctIdMap = new HashMap<String, String>();
        String compaySql = "select fid,fnumber from t_fs_inneraccount ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)compaySql);
        while (rs.next()) {
            innerAcctIdMap.put(rs.getString(2), rs.getString(1));
        }
        return innerAcctIdMap;
    }

    private Map getBankMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, BankInfo> currencyIdMap = new HashMap<String, BankInfo>();
        String compaySql = "select fid,FRelatedCompanyId,FopenDate, FsettleDate from t_bd_bank where FIsInGroup=1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)compaySql);
        while (rs.next()) {
            BankInfo bank = new BankInfo();
            bank.setId(BOSUuid.read((String)rs.getString(1)));
            bank.setOpenDate((Date)rs.getDate(3));
            bank.setSettleDate((Date)rs.getDate(4));
            currencyIdMap.put(rs.getString(2), bank);
        }
        return currencyIdMap;
    }

    @Override
    protected Map _inAcctBatch(Context ctx, IObjectCollection fpFormulaCol) throws BOSException, EASBizException {
        Map map = new HashMap();
        ArrayList sqlBalanceList = new ArrayList();
        ArrayList sqlSubisidaryList = new ArrayList();
        try {
            this.cacheParam(ctx);
            for (int i = 0; i < fpFormulaCol.size(); ++i) {
                FPFormulaInfo info = (FPFormulaInfo)fpFormulaCol.getObject(i);
                Object[] params = info.getParams();
                String companyNumber = (String)params[0];
                String innerAcctNumber = (String)params[1];
                String currencyNumber = (String)params[2];
                Date beginDay = (Date)params[3];
                Date endDay = (Date)params[4];
                InAcctDataTypeEnum inAcctDataType = (InAcctDataTypeEnum)((Object)params[5]);
                this.verify(companyNumber, innerAcctNumber, currencyNumber, inAcctDataType);
                this.getInAcctSqlList(ctx, companyNumber, innerAcctNumber, currencyNumber, beginDay, endDay, inAcctDataType, info.getId().toString(), sqlBalanceList, sqlSubisidaryList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.companyIdMap = null;
            this.currencyIdMap = null;
            this.innerAcctIdMap = null;
            this.bankMap = null;
        }
        String sqlBalance = this.getInAcctUnionSql(sqlBalanceList);
        String sqlSubisidary = this.getInAcctUnionSql(sqlSubisidaryList);
        try {
            map = this.getFinalResultMap(this.getResultMap(ctx, sqlBalance), this.getResultMap(ctx, sqlSubisidary));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private BigDecimal nullToZero(Object val) {
        return val == null ? Constants.ZERO : (BigDecimal)val;
    }

    private Map getFinalResultMap(Map balanceMap, Map subisidaryMap) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (balanceMap.size() > subisidaryMap.size()) {
            for (Map.Entry entry : balanceMap.entrySet()) {
                String key = (String)entry.getKey();
                BigDecimal addRst = FMHelper.add((BigDecimal)this.nullToZero(entry.getValue()), (BigDecimal)this.nullToZero(subisidaryMap.get(key)));
                map.put(key, addRst);
            }
        } else {
            for (Map.Entry entry : subisidaryMap.entrySet()) {
                String key = (String)entry.getKey();
                BigDecimal addRst = FMHelper.add((BigDecimal)this.nullToZero(entry.getValue()), (BigDecimal)this.nullToZero(balanceMap.get(key)));
                map.put(key, addRst);
            }
        }
        return map;
    }

    private Map getResultMap(Context ctx, String sql) throws BOSException, SQLException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (!EmptyUtil.isEmpty((String)sql)) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                map.put(rs.getString(1), rs.getBigDecimal(2));
            }
        }
        return map;
    }

    private String getInAcctUnionSql(List list) {
        StringBuffer buf = new StringBuffer();
        if (list.size() > 0) {
            buf.append((String)list.get(0));
        }
        String union = " union all ";
        for (int i = 1; i < list.size(); ++i) {
            buf.append(union);
            buf.append((String)list.get(i));
        }
        return buf.toString();
    }

    private void getInAcctSqlList(Context ctx, String companyNumber, String innerAcctNumber, String currencyNumber, Date beginDay, Date endDay, InAcctDataTypeEnum inAcctDataType, String fpFormulaId, List sqlBalance, List sqlSubisidary) throws BOSException, SQLException, EASBizException {
        String companyId = null;
        companyId = this.companyIdMap.get(companyNumber) != null ? (String)this.companyIdMap.get(companyNumber) : this.getCompanyId(ctx, companyNumber);
        String currencyId = null;
        currencyId = this.currencyIdMap.get(currencyNumber) != null ? (String)this.currencyIdMap.get(currencyNumber) : this.getCurrencyId(ctx, currencyNumber);
        Set<String> innerSet = new HashSet();
        String innerAcctId = null;
        if (this.innerAcctIdMap.get(innerAcctNumber) != null) {
            innerAcctId = (String)this.innerAcctIdMap.get(innerAcctNumber);
            innerSet.add(innerAcctId);
        } else {
            innerSet = this.getInnerAcctIds(ctx, innerAcctNumber);
        }
        BankInfo bank = null;
        bank = this.bankMap.get(companyId) != null ? (BankInfo)this.bankMap.get(companyId) : BankFactory.getLocalInstance((Context)ctx).getClearingHouse(companyId);
        if (bank == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"34_InAcctExtControllerBean", (Locale)ctx.getLocale()) + companyNumber + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"35_InAcctExtControllerBean", (Locale)ctx.getLocale()));
        }
        if (InAcctDataTypeEnum.C.equals((Object)inAcctDataType)) {
            endDay = beginDay;
        } else if (InAcctDataTypeEnum.Y.equals((Object)inAcctDataType)) {
            endDay = beginDay;
        }
        Date setteDate = bank.getSettleDate();
        if (setteDate == null) {
            return;
        }
        Date openDate = bank.getOpenDate();
        if (beginDay.compareTo(openDate) < 0) {
            beginDay = openDate;
        }
        if (endDay.compareTo(openDate) < 0) {
            return;
        }
        if (InAcctDataTypeEnum.Y.equals((Object)inAcctDataType)) {
            SQLUtil filterBalance;
            if (beginDay.compareTo(openDate) < 0) {
                return;
            }
            if (beginDay.compareTo(openDate) >= 0 && beginDay.compareTo(setteDate) < 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("fendbalance", companyId, currencyId, innerSet, beginDay, beginDay, fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
            }
            if (beginDay.compareTo(setteDate) >= 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("fendbalance", companyId, currencyId, innerSet, DateUtil.getBeforeDay((Date)setteDate), DateUtil.getBeforeDay((Date)setteDate), fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
                SQLUtil filterSub = this.getSubisidarySumSQLUtil("FDEBITAMOUNT -FCREDITAMOUNT", companyId, currencyId, innerSet, setteDate, beginDay, fpFormulaId);
                sqlSubisidary.add(filterSub.getTestSql());
            }
        } else if (InAcctDataTypeEnum.C.equals((Object)inAcctDataType)) {
            SQLUtil filterBalance;
            if (beginDay.compareTo(openDate) < 0) {
                return;
            }
            if (beginDay.compareTo(openDate) >= 0 && beginDay.compareTo(setteDate) < 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("fbeginbalance", companyId, currencyId, innerSet, beginDay, beginDay, fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
            }
            if (beginDay.compareTo(setteDate) >= 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("fendbalance", companyId, currencyId, innerSet, DateUtil.getBeforeDay((Date)setteDate), DateUtil.getBeforeDay((Date)setteDate), fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
                SQLUtil filterSub = this.getSubisidarySumSQLUtil("FDEBITAMOUNT -FCREDITAMOUNT", companyId, currencyId, innerSet, setteDate, DateUtil.getBeforeDay((Date)beginDay), fpFormulaId);
                sqlSubisidary.add(filterSub.getTestSql());
            }
        } else if (InAcctDataTypeEnum.JF.equals((Object)inAcctDataType)) {
            SQLUtil filterBalance;
            if (endDay.compareTo(openDate) < 0) {
                return;
            }
            if (beginDay.compareTo(openDate) >= 0 && endDay.compareTo(setteDate) < 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("FDEBITTOTAL", companyId, currencyId, innerSet, beginDay, endDay, fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
            }
            if (beginDay.compareTo(setteDate) < 0 && endDay.compareTo(setteDate) >= 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("FDEBITTOTAL", companyId, currencyId, innerSet, beginDay, endDay, fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
                SQLUtil filterSub = this.getSubisidarySumSQLUtil("FDEBITAMOUNT", companyId, currencyId, innerSet, setteDate, endDay, fpFormulaId);
                sqlSubisidary.add(filterSub.getTestSql());
            }
            if (beginDay.compareTo(setteDate) >= 0) {
                SQLUtil filterSub = this.getSubisidarySumSQLUtil("FDEBITAMOUNT", companyId, currencyId, innerSet, beginDay, endDay, fpFormulaId);
                sqlSubisidary.add(filterSub.getTestSql());
            }
        } else if (InAcctDataTypeEnum.DF.equals((Object)inAcctDataType)) {
            SQLUtil filterBalance;
            if (endDay.compareTo(openDate) < 0) {
                return;
            }
            if (beginDay.compareTo(openDate) >= 0 && endDay.compareTo(setteDate) < 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("FCREDITTOTAL", companyId, currencyId, innerSet, beginDay, endDay, fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
            }
            if (beginDay.compareTo(setteDate) < 0 && endDay.compareTo(setteDate) >= 0) {
                filterBalance = this.getSummaryBalanceSQLUtil("FCREDITTOTAL", companyId, currencyId, innerSet, beginDay, endDay, fpFormulaId);
                sqlBalance.add(filterBalance.getTestSql());
                SQLUtil filterSub = this.getSubisidarySumSQLUtil("FCREDITAMOUNT", companyId, currencyId, innerSet, setteDate, endDay, fpFormulaId);
                sqlSubisidary.add(filterSub.getTestSql());
            }
            if (beginDay.compareTo(setteDate) >= 0) {
                SQLUtil filterSub = this.getSubisidarySumSQLUtil("FCREDITAMOUNT", companyId, currencyId, innerSet, beginDay, endDay, fpFormulaId);
                sqlSubisidary.add(filterSub.getTestSql());
            }
        }
    }

    private void verify(String companyNumber, String innerAcctNumber, String currencyNumber, InAcctDataTypeEnum inAcctDataType) throws EASBizException {
        FMVerifyHelper.checkBlank((String)companyNumber, (Object[])new Object[]{"companyNumber"});
        FMVerifyHelper.checkBlank((String)innerAcctNumber, (Object[])new Object[]{"innerAcctNumber"});
        FMVerifyHelper.checkBlank((String)currencyNumber, (Object[])new Object[]{"currencyNumber"});
        FMVerifyHelper.checkBlank((Object)((Object)inAcctDataType), (Object[])new Object[]{"inAcctDataType"});
    }
}

