/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.CollectionUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.HashSearchEngine;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerAcctInitException;
import com.kingdee.eas.fm.fs.SummaryLedgerCollection;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import com.kingdee.eas.fm.fs.app.AbstractInnerAccountInitControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InnerAccountInitControllerBean
extends AbstractInnerAccountInitControllerBean {
    private static final String INNER_DEPOSIT_key = "InnerDeposit";
    private static Logger logger = Logger.getLogger((String)InnerAccountInitControllerBean.class.getName());
    private String loc;

    @Override
    protected void _init(Context ctx, String companyId) throws BOSException, EASBizException {
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, companyId);
        java.util.Date openDate = clearingHouse.getOpenDate();
        java.util.Date preOpenDate = DateTimeUtils.truncateDate((java.util.Date)DateUtil.getBeforeDay((java.util.Date)openDate));
        Date sqlDate = new Date(preOpenDate.getTime());
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "update T_FS_SummaryLedger set FBizDate = ? where FBizDate is null and FCompanyID=?";
            ps = conn.prepareStatement(sql);
            ps.setDate(1, sqlDate);
            ps.setString(2, companyId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        clearingHouse.setUsed(true);
        clearingHouse.setSettleDate(openDate);
        BankFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)clearingHouse);
        this.setUsedSymbolByCompany(ctx, companyId, true);
    }

    private void setUsedSymbolByCompany(Context ctx, String companyId, boolean isUsed) throws EASBizException, BOSException {
        String sql = "UPDATE T_FS_INNERACCOUNT SET FisUsed = ?, FsetUsedDate = ? where fcompanyid =?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            if (isUsed) {
                stmt.setInt(1, 1);
                BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, companyId);
                stmt.setDate(2, TypeConversionUtils.objToDate((Object)clearingHouse.getOpenDate()));
                stmt.setString(3, companyId);
            } else {
                stmt.setInt(1, 0);
                stmt.setNull(2, 91);
                stmt.setString(3, companyId);
            }
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private SummaryLedgerCollection sumCollectionByDims(SummaryLedgerCollection coll, String[] sumDims) {
        String[] sumAttrs = new String[]{"debitTotal", "creditTotal", "endBalance"};
        String[] sumDimsPlusAttrs = this.mergeArray(sumDims, sumAttrs);
        SummaryLedgerCollection sumColl = new SummaryLedgerCollection();
        HashSearchEngine searchEngine = new HashSearchEngine((IObjectCollection)sumColl, sumDims);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            SummaryLedgerInfo sumInfo;
            SummaryLedgerInfo info = (SummaryLedgerInfo)iter.next();
            if (searchEngine.evaluate((IObjectValue)info)) {
                sumInfo = (SummaryLedgerInfo)searchEngine.getResult();
                this.sumAttribute(sumInfo, info, sumAttrs);
                continue;
            }
            sumInfo = (SummaryLedgerInfo)info.clone();
            sumColl.add(sumInfo);
            searchEngine.add((IObjectValue)sumInfo);
        }
        return sumColl;
    }

    private SummaryLedgerCollection sumCollectionByType(SummaryLedgerCollection coll, String[] sumDims) {
        String[] sumAttrs = new String[]{"debitTotal", "creditTotal", "endBalance"};
        String[] sumDimsPlusAttrs = this.mergeArray(sumDims, sumAttrs);
        SummaryLedgerCollection sumColl = new SummaryLedgerCollection();
        HashSearchEngine searchEngine = new HashSearchEngine((IObjectCollection)sumColl, sumDims);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            SummaryLedgerInfo sumInfo;
            SummaryLedgerInfo info = (SummaryLedgerInfo)iter.next();
            if (searchEngine.evaluate((IObjectValue)info)) {
                sumInfo = (SummaryLedgerInfo)searchEngine.getResult();
                this.sumAttribute(sumInfo, info, sumAttrs);
                continue;
            }
            sumInfo = (SummaryLedgerInfo)info.clone();
            sumColl.add(sumInfo);
            searchEngine.add((IObjectValue)sumInfo);
        }
        return sumColl;
    }

    private String[] mergeArray(String[] array1, String[] array2) {
        String[] newArray = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    private SummaryLedgerCollection getSummaryLedgerCollByType(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("applyUnit.id"));
        view.getSelector().add(new SelectorItemInfo("applyUnit.name"));
        view.getSelector().add(new SelectorItemInfo("company.id"));
        view.getSelector().add(new SelectorItemInfo("company.name"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        SummaryLedgerCollection coll = SummaryLedgerFactory.getLocalInstance(ctx).getSummaryLedgerCollection(view);
        return coll;
    }

    private SummaryLedgerCollection getSummaryLedgerCollByTypeSet(Context ctx, Set typeSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)typeSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("applyUnit.id"));
        view.getSelector().add(new SelectorItemInfo("applyUnit.name"));
        view.getSelector().add(new SelectorItemInfo("company.id"));
        view.getSelector().add(new SelectorItemInfo("company.name"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        SummaryLedgerCollection coll = SummaryLedgerFactory.getLocalInstance(ctx).getSummaryLedgerCollection(view);
        return coll;
    }

    public void sumAttribute(SummaryLedgerInfo sumInfo, SummaryLedgerInfo info, String[] sumAttrs) {
        for (int i = 0; i < sumAttrs.length; ++i) {
            String attr = sumAttrs[i];
            BigDecimal sumValue = sumInfo.getBigDecimal(attr) == null ? Constants.ZERO : sumInfo.getBigDecimal(attr);
            BigDecimal value = info.getBigDecimal(attr) == null ? Constants.ZERO : info.getBigDecimal(attr);
            sumInfo.setBigDecimal(attr, sumValue.add(value));
        }
    }

    public void transferAttribute(SummaryLedgerInfo sumInfo, SummaryLedgerInfo info, String[] dims) {
        for (int i = 0; i < dims.length; ++i) {
            sumInfo.put(dims[i], info.get(dims[i]));
        }
    }

    public boolean equalAttribute(SummaryLedgerInfo sumInfo, SummaryLedgerInfo info, String[][] compareAttrs) {
        for (int i = 0; i < compareAttrs.length; ++i) {
            BigDecimal balance2;
            BigDecimal balance1;
            BigDecimal tempBig;
            if (!(compareAttrs[i][0].equals("endBalance") ? (tempBig = (balance1 = sumInfo.get(compareAttrs[i][0]) == null ? Constants.ZERO : (BigDecimal)sumInfo.get(compareAttrs[i][0])).add(balance2 = info.get(compareAttrs[i][1]) == null ? Constants.ZERO : (BigDecimal)info.get(compareAttrs[i][1]))).compareTo(Constants.ZERO) != 0 : !EqualsUtil.equals((Object)sumInfo.get(compareAttrs[i][0]), (Object)info.get(compareAttrs[i][1])))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void _setBizDate(Context ctx) throws BOSException {
    }

    @Override
    protected void _antiInit(Context ctx, String companyId) throws BOSException, EASBizException {
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, companyId);
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)clearingHouse.getOpenDate());
        Timestamp sqlDate = new Timestamp(openDate.getTime());
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "delete T_FS_SummaryLedger where FBizDate >= ? AND FCompanyId = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, sqlDate);
            pstmt.setString(2, companyId);
            pstmt.execute();
            String sql2 = "update T_FS_SummaryLedger set FBizDate = null where FBizDate < ? AND FCompanyId = ?";
            pstmt2 = conn.prepareStatement(sql2);
            pstmt2.setTimestamp(1, sqlDate);
            pstmt2.setString(2, companyId);
            pstmt2.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmt2, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmt2, (Connection)conn);
        this.setUsedSymbolByCompany(ctx, companyId, false);
        clearingHouse.setUsed(false);
        clearingHouse.setSettleDate(null);
        BankFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)clearingHouse);
    }

    @Override
    protected IObjectCollection _getColl(Context ctx, EntityViewInfo view) throws BOSException {
        ISummaryLedger manager = SummaryLedgerFactory.getLocalInstance(ctx);
        return manager.getSummaryLedgerCollection(view);
    }

    @Override
    protected void _submit(Context ctx, SummaryLedgerCollection billInfoColl, String currencyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.deleteOldInitData(ctx, company.getId().toString(), currencyId, true);
        ISummaryLedger slFactory = SummaryLedgerFactory.getLocalInstance(ctx);
        if (billInfoColl != null && billInfoColl.size() > 0) {
            for (int i = 0; i < billInfoColl.size(); ++i) {
                SummaryLedgerInfo billInfo = billInfoColl.get(i);
                slFactory.addnew(billInfo);
            }
        }
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? Constants.ZERO : big;
    }

    private void deleteOldInitData(Context ctx, String companyId, String currencyId, boolean isInnerDeposit) throws BOSException {
        String sql = "DELETE T_FS_SummaryLedger WHERE FCompanyID = ? AND   FCurrencyId = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, companyId);
            pstmt.setString(2, currencyId);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected List _getBalanceDiff(Context ctx) throws BOSException, EASBizException {
        ArrayList<SummaryLedgerInfo> diffList = new ArrayList<SummaryLedgerInfo>();
        SummaryLedgerCollection depColl = this.getSummaryLedgerCollByType(ctx);
        HashSet typeSet = new HashSet();
        SummaryLedgerCollection innerColl = this.getSummaryLedgerCollByTypeSet(ctx, typeSet);
        String[] sumDims = new String[]{"applyUnit", "currency"};
        if (depColl != null && innerColl != null && depColl.size() < 1 && innerColl.size() > 0 || depColl == null && innerColl != null && innerColl.size() > 0) {
            SummaryLedgerCollection sumInnerColl = this.sumCollectionByDims(innerColl, sumDims);
            this.setSumInnerColl(innerColl, sumInnerColl);
            for (int i = 0; i < sumInnerColl.size(); ++i) {
                SummaryLedgerInfo info;
                SummaryLedgerInfo sumInfo = sumInnerColl.get(i);
                if (sumInfo.getCreditTotal().compareTo(Constants.ZERO) != 0) {
                    info = (SummaryLedgerInfo)sumInfo.clone();
                    info.put("tryBalanceType", "debitTotal");
                    info.put(INNER_DEPOSIT_key, Constants.ZERO);
                    info.put("tryBalanceDiff", info.getCreditTotal());
                    diffList.add(info);
                }
                if (sumInfo.getDebitTotal().compareTo(Constants.ZERO) != 0) {
                    info = (SummaryLedgerInfo)sumInfo.clone();
                    info.put("tryBalanceType", "creditTotal");
                    info.put(INNER_DEPOSIT_key, Constants.ZERO);
                    info.put("tryBalanceDiff", info.getDebitTotal());
                    diffList.add(info);
                }
                if (sumInfo.getEndBalance().compareTo(Constants.ZERO) == 0) continue;
                info = (SummaryLedgerInfo)sumInfo.clone();
                info.put("tryBalanceType", "endBalance");
                info.put(INNER_DEPOSIT_key, Constants.ZERO);
                info.put("tryBalanceDiff", info.getEndBalance());
                diffList.add(info);
            }
        }
        if (depColl != null && depColl.size() > 0) {
            SummaryLedgerCollection sumDepColl = this.sumCollectionByDims(depColl, sumDims);
            SummaryLedgerCollection sumInnerColl = this.sumCollectionByDims(innerColl, sumDims);
            this.setSumInnerColl(innerColl, sumInnerColl);
            String[][] sumAttrs2 = new String[][]{{"debitTotal", "creditTotal"}, {"creditTotal", "debitTotal"}, {"endBalance", "endBalance"}};
            HashSearchEngine setSearchEngine = new HashSearchEngine((IObjectCollection)sumInnerColl, sumDims);
            SummaryLedgerInfo info = null;
            Iterator iter = sumDepColl.iterator();
            while (iter.hasNext()) {
                SummaryLedgerInfo depInfo = (SummaryLedgerInfo)iter.next();
                if (!setSearchEngine.evaluate((IObjectValue)depInfo)) {
                    info = new SummaryLedgerInfo();
                    info.setCompany(depInfo.getCompany());
                    info.setApplyUnit(depInfo.getApplyUnit());
                    info.setCurrency(depInfo.getCurrency());
                    info.put("tryBalanceType", "debitTotal");
                    info.put(INNER_DEPOSIT_key, depInfo.getDebitTotal());
                    info.put("tryBalanceDiff", depInfo.getDebitTotal());
                    diffList.add(info);
                    info = new SummaryLedgerInfo();
                    info.setCompany(depInfo.getCompany());
                    info.setApplyUnit(depInfo.getApplyUnit());
                    info.setCurrency(depInfo.getCurrency());
                    info.put("tryBalanceType", "creditTotal");
                    info.put(INNER_DEPOSIT_key, depInfo.getCreditTotal());
                    info.put("tryBalanceDiff", depInfo.getCreditTotal());
                    diffList.add(info);
                    info = new SummaryLedgerInfo();
                    info.setCompany(depInfo.getCompany());
                    info.setApplyUnit(depInfo.getApplyUnit());
                    info.setCurrency(depInfo.getCurrency());
                    info.put("tryBalanceType", "endBalance");
                    info.put(INNER_DEPOSIT_key, depInfo.getEndBalance());
                    info.put("tryBalanceDiff", depInfo.getEndBalance());
                    diffList.add(info);
                    continue;
                }
                SummaryLedgerInfo setInfo = (SummaryLedgerInfo)setSearchEngine.getResult();
                for (int i = 0; i < sumAttrs2.length; ++i) {
                    if (sumAttrs2[i][0].equals("endBalance")) {
                        BigDecimal balance2;
                        BigDecimal balance1 = (BigDecimal)depInfo.get(sumAttrs2[i][0]);
                        BigDecimal tempBig = balance1.add(balance2 = (BigDecimal)setInfo.get(sumAttrs2[i][1]));
                        if (tempBig.compareTo(Constants.ZERO) == 0) continue;
                        info = (SummaryLedgerInfo)setInfo.clone();
                        info.setCompany(depInfo.getCompany());
                        info.setApplyUnit(depInfo.getApplyUnit());
                        info.setCurrency(depInfo.getCurrency());
                        info.put("tryBalanceType", "endBalance");
                        info.put(INNER_DEPOSIT_key, balance1);
                        info.put("tryBalanceDiff", tempBig);
                        diffList.add(info);
                        continue;
                    }
                    if (EqualsUtil.equals((Object)depInfo.get(sumAttrs2[i][0]), (Object)setInfo.get(sumAttrs2[i][1]))) continue;
                    info = (SummaryLedgerInfo)setInfo.clone();
                    info.setCompany(depInfo.getCompany());
                    info.setApplyUnit(depInfo.getApplyUnit());
                    info.setCurrency(depInfo.getCurrency());
                    info.put("tryBalanceType", sumAttrs2[i][0]);
                    BigDecimal deposit = (BigDecimal)depInfo.get(sumAttrs2[i][0]);
                    info.put(INNER_DEPOSIT_key, deposit);
                    BigDecimal settle = (BigDecimal)setInfo.get(sumAttrs2[i][1]);
                    info.put("tryBalanceDiff", deposit.subtract(settle));
                    diffList.add(info);
                }
                setSearchEngine.remove((IObjectValue)setInfo);
            }
            SummaryLedgerCollection restSumColl = new SummaryLedgerCollection();
            setSearchEngine.cat((IObjectCollection)restSumColl);
            for (int i = 0; i < restSumColl.size(); ++i) {
                SummaryLedgerInfo restInfo;
                SummaryLedgerInfo sumInfo = restSumColl.get(i);
                if (sumInfo.getCreditTotal().compareTo(Constants.ZERO) != 0) {
                    restInfo = (SummaryLedgerInfo)sumInfo.clone();
                    restInfo.put("tryBalanceType", "debitTotal");
                    restInfo.put(INNER_DEPOSIT_key, Constants.ZERO);
                    restInfo.put("tryBalanceDiff", sumInfo.getCreditTotal());
                    diffList.add(restInfo);
                }
                if (sumInfo.getDebitTotal().compareTo(Constants.ZERO) != 0) {
                    restInfo = (SummaryLedgerInfo)sumInfo.clone();
                    restInfo.put("tryBalanceType", "creditTotal");
                    restInfo.put(INNER_DEPOSIT_key, Constants.ZERO);
                    restInfo.put("tryBalanceDiff", sumInfo.getDebitTotal());
                    diffList.add(restInfo);
                }
                if (sumInfo.getEndBalance().compareTo(Constants.ZERO) == 0) continue;
                restInfo = (SummaryLedgerInfo)sumInfo.clone();
                restInfo.put("tryBalanceType", "endBalance");
                restInfo.put(INNER_DEPOSIT_key, Constants.ZERO);
                restInfo.put("tryBalanceDiff", sumInfo.getEndBalance());
                diffList.add(restInfo);
            }
        }
        return diffList;
    }

    private void setSumInnerColl(SummaryLedgerCollection innerColl, SummaryLedgerCollection sumInnerColl) {
        String[] sumTypeDims = new String[]{"company", "currency", "type"};
        SummaryLedgerCollection sumInnerTypeColl = this.sumCollectionByType(innerColl, sumTypeDims);
        if (sumInnerColl != null && sumInnerTypeColl != null) {
            Map sumInnerTypeHash = CollectionUtil.getHashSearchMap((IObjectCollection)sumInnerTypeColl, (String[])sumTypeDims);
            Object strKey = null;
            int size = sumInnerColl.size();
            for (int i = 0; i < size; ++i) {
                SummaryLedgerInfo innerTypeInfo;
                SummaryLedgerInfo sumInnerInfo = sumInnerColl.get(i);
                String companyId = sumInnerInfo.getCompany().getId().toString();
                String currencyId = sumInnerInfo.getCurrency().getId().toString();
                if (sumInnerTypeHash.containsKey(strKey)) {
                    innerTypeInfo = (SummaryLedgerInfo)sumInnerTypeHash.get(strKey);
                    sumInnerInfo.put("settDebit", innerTypeInfo.getDebitTotal());
                    sumInnerInfo.put("settCredit", innerTypeInfo.getCreditTotal());
                    sumInnerInfo.put("settBalance", innerTypeInfo.getEndBalance());
                } else {
                    sumInnerInfo.put("settDebit", Constants.ZERO);
                    sumInnerInfo.put("settCredit", Constants.ZERO);
                    sumInnerInfo.put("settBalance", Constants.ZERO);
                }
                strKey = null;
                if (sumInnerTypeHash.containsKey(strKey)) {
                    innerTypeInfo = (SummaryLedgerInfo)sumInnerTypeHash.get(strKey);
                    sumInnerInfo.put("accrualDebit", innerTypeInfo.getDebitTotal());
                    sumInnerInfo.put("accrualCredit", innerTypeInfo.getCreditTotal());
                    sumInnerInfo.put("accrualBalance", innerTypeInfo.getEndBalance());
                } else {
                    sumInnerInfo.put("accrualDebit", Constants.ZERO);
                    sumInnerInfo.put("accrualCredit", Constants.ZERO);
                    sumInnerInfo.put("accrualBalance", Constants.ZERO);
                }
                strKey = null;
                if (sumInnerTypeHash.containsKey(strKey)) {
                    innerTypeInfo = (SummaryLedgerInfo)sumInnerTypeHash.get(strKey);
                    sumInnerInfo.put("feeDebit", innerTypeInfo.getDebitTotal());
                    sumInnerInfo.put("feeCredit", innerTypeInfo.getCreditTotal());
                    sumInnerInfo.put("feeBalance", innerTypeInfo.getEndBalance());
                    continue;
                }
                sumInnerInfo.put("feeDebit", Constants.ZERO);
                sumInnerInfo.put("feeCredit", Constants.ZERO);
                sumInnerInfo.put("feeBalance", Constants.ZERO);
            }
        }
    }

    @Override
    protected boolean _checkDate(Context ctx, String companyId) throws BOSException, EASBizException {
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, companyId);
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)clearingHouse.getOpenDate());
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)clearingHouse.getSettleDate());
        java.util.Date now = DateTimeUtils.truncateDate((java.util.Date)settleDate);
        return openDate.compareTo(settleDate) == 0;
    }

    @Override
    protected IObjectCollection _importGL(Context ctx, String companyId, String currencyId) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyId) || FMHelper.isEmpty((String)currencyId)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"41_InnerAccountInitControllerBean", (Locale)ctx.getLocale()));
        }
        InnerAccountCollection innerAcctColl = this.getInnerAcctColl(ctx, companyId);
        this.checkBeforImport(ctx, companyId, innerAcctColl);
        BankInfo chInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        java.util.Date openDate = chInfo.getOpenDate();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        boolean isFirstDayOfYear = DateUtil.isFirstDayOfYear((java.util.Date)openDate);
        PeriodInfo settlePeriod = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)openDate, (IObjectPK)companyPK);
        SystemEnum glSystem = SystemEnum.GENERALLEDGER;
        PeriodInfo glStartPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)glSystem, (IObjectPK)companyPK);
        boolean isGLStartPeriod = settlePeriod.getId().toString().equals(glStartPeriod.getId().toString());
        Map glBalanceMap = this.getGLBalanceMap(ctx, companyId, currencyId, settlePeriod, isFirstDayOfYear, isGLStartPeriod);
        SummaryLedgerCollection summaryColl = new SummaryLedgerCollection();
        SummaryLedgerInfo summaryInfo = null;
        InnerAccountInfo innerAcctInfo = null;
        StringBuffer key = null;
        int size = innerAcctColl.size();
        for (int i = 0; i < size; ++i) {
            innerAcctInfo = innerAcctColl.get(i);
            key = new StringBuffer();
            key.append(innerAcctInfo.getAcctView().getId().toString()).append("_").append(innerAcctInfo.getId().toString());
            if (glBalanceMap.containsKey(key.toString())) {
                summaryInfo = (SummaryLedgerInfo)glBalanceMap.get(key.toString());
            } else {
                summaryInfo = new SummaryLedgerInfo();
                summaryInfo.setEndBalance(Constants.ZERO);
                summaryInfo.setDebitTotal(Constants.ZERO);
                summaryInfo.setCreditTotal(Constants.ZERO);
            }
            summaryInfo.setApplyUnit(innerAcctInfo.getApplyUnit());
            summaryInfo.setInnerAccount(innerAcctInfo);
            summaryColl.add(summaryInfo);
        }
        return summaryColl;
    }

    private Map getGLBalanceMap(Context ctx, String companyId, String currencyId, PeriodInfo period, boolean isFirstDayOfYear, boolean isGLStartPeriod) throws BOSException, EASBizException {
        StringBuffer baseSql = this.getGLBalanceSql(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.beginBalance, T2.yearDebit, T2.yearCredit, \n").append("\tT2.acctViewId, T2.acctView, T2.innerAcctId, T2.innerAcct \n").append(" FROM (").append(baseSql).append(" ) T1 \n LEFT JOIN (").append(baseSql).append(" ) T2 ON T1.acctViewId = T2.acctViewId AND T1.innerAcctId = T2.innerAcctId \n");
        logger.info((Object)("\n getGLBalanceMap sql = " + baseSql.toString()));
        logger.info((Object)("\n getGLBalanceMap sql = " + sql.toString()));
        HashMap<String, SummaryLedgerInfo> map = new HashMap<String, SummaryLedgerInfo>();
        try {
            IRowSet rs = null;
            if (isGLStartPeriod || isFirstDayOfYear) {
                rs = DbUtil.executeQuery((Context)ctx, (String)baseSql.toString(), (Object[])new Object[]{companyId, currencyId, period.getNumber()});
            } else {
                PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(period.getId()));
                Object[] params = new Object[]{companyId, currencyId, period.getNumber(), companyId, currencyId, prePeriod.getNumber()};
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            }
            SummaryLedgerInfo summaryInfo = null;
            while (rs.next()) {
                summaryInfo = new SummaryLedgerInfo();
                summaryInfo.setEndBalance(rs.getBigDecimal("beginBalance").negate());
                if (isGLStartPeriod || isFirstDayOfYear) {
                    summaryInfo.setDebitTotal(Constants.ZERO);
                    summaryInfo.setCreditTotal(Constants.ZERO);
                } else {
                    summaryInfo.setDebitTotal(rs.getBigDecimal("yearDebit"));
                    summaryInfo.setCreditTotal(rs.getBigDecimal("yearCredit"));
                }
                String key = rs.getString("acctViewId") + "_" + rs.getString("innerAcctId");
                map.put(key, summaryInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private StringBuffer getGLBalanceSql(Context ctx) {
        StringBuffer sql = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("SELECT SUM(a.FBeginBalanceFor) beginBalance, \n").append("\tSUM(a.FYearDebitFor) yearDebit, SUM(a.FYearCreditFor) yearCredit, \n").append("\tSUM(a.FEndBalanceFor) endBalance, \n").append(" \td.FID acctViewId, d.fname_").append(this.loc).append("  acctView, \n").append("\tc.FID innerAcctId, c.fname_").append(this.loc).append("  innerAcct \n").append(" FROM T_GL_AssistBalance_5F a ").append(" JOIN T_BD_AssistantHG b ON a.FAssistGrpID = b.FID \n").append(" JOIN T_FS_InnerAccount c ON b.FInnerAccountId = c.FID \n").append(" JOIN T_BD_AccountView d ON a.FAccountId = d.FID \n").append(" WHERE a.FOrgUnitId = ? AND a.FCurrencyId = ? \n").append(" \tAND a.FPeriod = ?   \n").append(" GROUP BY d.FID, d.FName_").append(this.loc).append(" , c.FID, c.FName_").append(this.loc).append("  \n").append(" ORDER BY d.FID, c.FID ");
        return sql;
    }

    private void checkBeforImport(Context ctx, String companyId, InnerAccountCollection innerAcctColl) throws BOSException, EASBizException {
        int size = innerAcctColl.size();
        for (int i = 0; i < size; ++i) {
            AccountViewInfo acctView = innerAcctColl.get(i).getAcctView();
            if (FMHelper.hasAsstInnerAcct((Context)ctx, (String)acctView.getId().toString())) continue;
            throw new InnerAcctInitException(InnerAcctInitException.ACCTVIEWHASNOTINNERACCT, new Object[]{acctView.getNumber() + " " + acctView.getName()});
        }
        this.checkPeriodValid(ctx, companyId);
    }

    private void checkPeriodValid(Context ctx, String companyId) throws BOSException, EASBizException {
        BankInfo chInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        java.util.Date openDate = chInfo.getOpenDate();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        PeriodInfo settlePeriod = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)openDate, (IObjectPK)companyPK);
        DateFormat df = BOSLocaleUtil.getDateFormat();
        if (settlePeriod == null) {
            throw new InnerAcctInitException(InnerAcctInitException.OPENDATEHASNOTPERIOD, new Object[]{df.format(openDate)});
        }
        SystemEnum glSystem = SystemEnum.GENERALLEDGER;
        ISystemStatusCtrol iSystemCtrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean glIsStart = iSystemCtrl.isStart(glSystem.getValue(), companyId);
        if (!glIsStart) {
            throw new InnerAcctInitException(InnerAcctInitException.GLHASNOTSTARTED);
        }
        boolean isAsstAcctInited = true;
        if (!isAsstAcctInited) {
            throw new InnerAcctInitException(InnerAcctInitException.ASSTACCTBALANCENOTINITED);
        }
        PeriodInfo glStartPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)glSystem, (IObjectPK)companyPK);
        PeriodInfo glCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)glSystem, (IObjectPK)companyPK);
        if (settlePeriod.getEndDate().compareTo(glStartPeriod.getBeginDate()) < 0 || settlePeriod.getBeginDate().compareTo(glCurrentPeriod.getEndDate()) > 0) {
            throw new InnerAcctInitException(InnerAcctInitException.OPENPERIODERROR, new Object[]{String.valueOf(glStartPeriod.getPeriodYear()), String.valueOf(glStartPeriod.getPeriodNumber()), String.valueOf(glCurrentPeriod.getPeriodYear()), String.valueOf(glCurrentPeriod.getPeriodNumber())});
        }
    }

    private InnerAccountCollection getInnerAcctColl(Context ctx, String companyId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("company.*"));
        evi.getSelector().add(new SelectorItemInfo("applyUnit.*"));
        evi.getSelector().add(new SelectorItemInfo("acctView.*"));
        IInnerAccount iInnerAcct = InnerAccountFactory.getLocalInstance(ctx);
        return iInnerAcct.getInnerAccountCollection(evi);
    }

    @Override
    protected IRowSet _checkBalance(Context ctx, String companyId) throws BOSException, EASBizException {
        ISystemStatusCtrol iSystemCtrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean glIsStart = iSystemCtrl.isStart(SystemEnum.GENERALLEDGER.getValue(), companyId);
        if (!glIsStart) {
            throw new InnerAcctInitException(InnerAcctInitException.GLHASNOTSTARTED);
        }
        BankInfo chInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        java.util.Date openDate = chInfo.getOpenDate();
        openDate = DateTimeUtils.truncateDate((java.util.Date)openDate);
        String tblDesc = "checkBalance";
        String tblName = this.createTempTable(ctx, tblDesc);
        this.insertBalanceData(ctx, tblName, companyId, openDate);
        this.signBalancedSymbol(ctx, tblName);
        return this.getUnBalancedData(ctx, tblName);
    }

    private IRowSet getUnBalancedData(Context ctx, String tblName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FAcctViewNumber, a.FAcctViewName, \n").append("\ta.FCurrencyId, a.FCurrencyNumber, a.FCurrencyName, \n").append("\tb.FInnerAcctNumber glInnerAcctNumber, b.FInneracctName glInnerAcctName, \n").append("\t(b.fbalance*-1) glBalance, \n").append("   a.FInnerAcctNumber fsInnerAcctNumber, a.FInnerAcctName fsInnerAcctName, \n").append("\ta.FBalance fsBalance, ((ISNULL(b.fbalance,0) + ISNULL(a.fbalance,0))*-1) diff \n").append(" FROM ").append("\t(SELECT * FROM ").append(tblName).append("\t\t\n WHERE FType = 1 AND FIsBalanced = 0 and fbalance <>0) a \n").append("\tLEFT JOIN \n").append("\t(SELECT * FROM ").append(tblName).append("\t\t\n WHERE (FType = 2 OR FType = 3) AND FIsBalanced = 0) b \n").append("\tON a.FAcctViewID = b.FAcctViewID AND a.FCurrencyID = b.FCurrencyID \n").append("\t\tAND a.FInnerAcctID = b.FInnerAcctID \n").append(" UNION \n").append(" SELECT a.FAcctViewNumber, a.FAcctViewName, \n").append("\ta.FCurrencyId, a.FCurrencyNumber, a.FCurrencyName, \n").append("\ta.FInnerAcctNumber glInnerAcctNumber, a.FInneracctName glInnerAcctName, \n").append("\t(a.fbalance*-1) glBalance, \n").append("   b.FInnerAcctNumber fsInnerAcctNumber, b.FInnerAcctName fsInnerAcctName, \n").append("\tb.FBalance fsBalance, ((ISNULL(a.fbalance,0) + ISNULL(b.fbalance,0))*-1) diff \n").append(" FROM ").append("\t(SELECT * FROM ").append(tblName).append("\t\t\n WHERE (FType = 2 OR FType = 3) AND FIsBalanced = 0 and fbalance <>0) a \n").append("\tLEFT JOIN \n").append("\t(SELECT * FROM ").append(tblName).append("\t\t\n WHERE FType = 1 AND FIsBalanced = 0) b \n").append("\tON a.FAcctViewID = b.FAcctViewID AND a.FCurrencyID = b.FCurrencyID \n").append("\t\tAND a.FInnerAcctID = b.FInnerAcctID \n");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private void signBalancedSymbol(Context ctx, String tblName) throws BOSException {
        this.signAssistBlanaced(ctx, tblName);
        this.signAccountBalanced(ctx, tblName);
    }

    private void signAssistBlanaced(Context ctx, String tblName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tblName).append(" SET FIsBalanced = 1 \n").append(" WHERE ((FAcctViewID || FCurrencyID) || FInnerAcctID) IN \n").append("\t(SELECT ((a.FAcctViewID || a.FCurrencyID) || a.FInnerAcctID) \n").append("\t\tFROM \n").append("\t \t (SELECT * FROM ").append(tblName).append(" \t\t\t\t\n WHERE FType = 1) a \n").append("\t\t\tJOIN ").append("\t\t (SELECT SUM(FBalance) FBalance, FAcctViewID, FCurrencyID, FInnerAcctID FROM ").append(tblName).append("\t\t\t\t\n WHERE FType = 2 GROUP BY FAcctViewID, FCurrencyID, FInnerAcctID) b \n").append("\t\t\tON a.FAcctViewID = b.FAcctViewID \n").append("\t\t\t\tAND a.FCurrencyID = b.FCurrencyID AND a.FInnerAcctID = b.FInnerAcctID \n").append("\t\t\tWHERE a.FBalance + b.FBalance = 0) \n");
        logger.info((Object)("signAssistBlanaced sql = \n" + sql.toString()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void signAccountBalanced(Context ctx, String tblName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tblName).append(" SET FIsBalanced = 1 \n").append(" WHERE (FAcctViewID || FCurrencyID) IN \n").append("\t(SELECT (a.FAcctViewID || a.FCurrencyID) \n").append("\t\tFROM \n").append("\t \t (SELECT SUM(FBalance) FBalance, FAcctViewID, FCurrencyID FROM ").append(tblName).append(" \t\t\t\t\n WHERE FType = 1 GROUP BY FAcctViewID, FCurrencyID) a \n").append("\t\t\tJOIN ").append("\t\t (SELECT * FROM ").append(tblName).append("\t\t\t\t\n WHERE FType = 3) b \n").append("\t\t\tON a.FAcctViewID = b.FAcctViewID AND a.FCurrencyID = b.FCurrencyID \n").append("\t\t\tWHERE a.FBalance + b.FBalance = 0) \n");
        logger.info((Object)("signAccountBalanced sql = \n" + sql.toString()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertBalanceData(Context ctx, String tblName, String companyId, java.util.Date openDate) throws BOSException, EASBizException {
        this.insertSummaryLedger(ctx, tblName, companyId, openDate);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        PeriodInfo settlePeriod = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)openDate, (IObjectPK)companyPK);
        DateFormat df = BOSLocaleUtil.getDateFormat();
        if (settlePeriod == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{df.format(openDate) + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"42_InnerAccountInitControllerBean", (Locale)ctx.getLocale())});
        }
        this.insertAssistBalance(ctx, tblName, companyId, settlePeriod);
        this.insertAccountBalance(ctx, tblName, companyId, settlePeriod);
    }

    private void insertSummaryLedger(Context ctx, String tblName, String companyId, java.util.Date openDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("INSERT INTO ").append(tblName).append(" SELECT 1, c.FID, c.FNumber, c.FName_").append(this.loc).append(" , \n").append(" \td.FID, d.FNumber, d.FName_").append(this.loc).append(" , \n").append("\tb.FID, b.FNumber, b.FName_").append(this.loc).append(" , \n").append(" \ta.FEndBalance, 0 \n").append(" FROM T_FS_SummaryLedger a \n").append(" JOIN T_FS_InnerAccount b ON a.FInnerAccountID = b.FID \n").append(" JOIN T_BD_AccountView  c ON b.FAcctViewID = c.FID \n").append(" JOIN T_BD_Currency\t d ON a.FCurrencyID = d.FID \n").append(" WHERE   a.FCompanyID = ? \n").append(" \tAND (a.FBizDate = ? or a.FBizDate IS NULL) \n").append("\tAND a.FEndBalance <> 0 \n");
        java.util.Date preDate = DateUtil.getBeforeDay((java.util.Date)openDate);
        Date sqlDate = new Date(preDate.getTime());
        Object[] params = new Object[]{companyId, sqlDate};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void insertAssistBalance(Context ctx, String tblName, String companyId, PeriodInfo period) throws BOSException {
        StringBuffer sql = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("INSERT INTO ").append(tblName).append(" SELECT 2, d.FID, d.FNumber, d.FName_").append(this.loc).append(" , \n").append(" \th.FID, h.FNumber, h.FName_").append(this.loc).append(" , \n").append("\tc.FID, c.FNumber, c.FName_").append(this.loc).append(" , \n").append("\tSUM(a.FBeginBalanceFor), 0 \n").append(" FROM T_GL_AssistBalance_5F a \n").append(" JOIN T_BD_AssistantHG  b ON a.FAssistGrpID = b.FID \n").append(" JOIN T_FS_InnerAccount c ON b.FInnerAccountID = c.FID \n").append(" JOIN T_BD_AccountView  d ON a.FAccountId = d.FID \n").append(" JOIN T_BD_AsstAccount  e ON d.FCAA = e.FID \n").append(" JOIN T_BD_AsstActGroupDetail f ON f.FAsstAccountID = e.FID \n").append(" JOIN T_BD_AsstActType  g ON f.FAsstActTypeID = g.FID \n").append(" JOIN T_BD_Currency \t h ON a.FCurrencyid = h.FID \n").append(" WHERE a.forgUnitid = ? AND c.FCompanyID = ? \n").append(" \tAND a.FPeriod = ? \n").append(" \tAND g.FRealtionDataObject = 'T_FS_InnerAccount' \n").append(" GROUP BY d.FID, d.FNumber, d.FName_").append(this.loc).append(" , \n").append("\tc.FID, c.FNumber, c.FName_").append(this.loc).append(" , h.FID, h.FNumber, h.FName_").append(this.loc).append("  \n");
        Object[] params = new Object[]{companyId, companyId, period.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void insertAccountBalance(Context ctx, String tblName, String companyId, PeriodInfo period) throws BOSException {
        StringBuffer sql = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("INSERT INTO ").append(tblName).append(" SELECT 3,  b.FID, b.FNumber, b.FName_").append(this.loc).append(" , \n").append(" \tc.FID, c.FNumber, c.FName_").append(this.loc).append(" , \n").append(" \tnull, null, null, sum(FBeginBalanceFor), 0 \n").append(" FROM  T_GL_AccountBalance_5F a \n").append(" JOIN T_BD_AccountView b ON a.FAccountId = b.FID \n").append(" JOIN T_BD_Currency \tc ON a.FCurrencyID = c.FID \n").append(" JOIN (SELECT DISTINCT a.FID FROM T_BD_AccountView a \n").append("\t\tJOIN T_FS_InnerAccount b ON a.FID = b.FAcctViewId \n").append("\t\tWHERE b.FCompanyID= ? AND a.FID NOT IN (SELECT a.FID FROM T_BD_AccountView a \n").append("\t\t\tJOIN T_BD_AsstAccount b on a.FCAA = b.FID \n").append("\t\t\tJOIN T_BD_AsstActGroupDetail c on c.FAsstAccountID = b.FID \n").append("\t\t\tJOIN T_BD_AsstActType d on c.FAsstActTypeID = d.FID \n").append("\t\t\tWHERE d.FRealtionDataObject = 'T_FS_InnerAccount')) d on b.fid=d.fid \n").append(" WHERE a.FOrgUnitID = ? \n").append(" \tAND a.FPeriod = ? \n").append(" GROUP BY b.FID, b.fNumber, b.FName_").append(this.loc).append(" , c.FID, c.FNumber, c.FName_").append(this.loc).append("  \n");
        Object[] params = new Object[]{companyId, companyId, period.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private String createTempTable(Context ctx, String desc) throws BOSException {
        ITableManagerFacade tblMgr = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tblName = tblMgr.getTableName(desc);
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(tblName).append(" ( ").append(" FType \t\t\tINT,").append(" FAcctViewId \t\tVARCHAR(44), ").append(" FAcctViewNumber \tNVARCHAR(80), ").append(" FAcctViewName\t\tNVARCHAR(80), ").append(" FCurrencyId \t\tVARCHAR(44), ").append(" FCurrencyNumber \tNVARCHAR(80), ").append(" FCurrencyName\t\tNVARCHAR(80), ").append(" FInnerAcctId \t\tVARCHAR(44), ").append(" FInnerAcctNumber\tNVARCHAR(80), ").append(" FInnerAcctName\tNVARCHAR(80), ").append(" FBalance  \t\tNUMERIC(19,4), ").append(" FIsBalanced \t\tINT ").append(" )");
        tblMgr.createTempTable(sql.toString());
        return tblName;
    }
}

