/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryCollection;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupInfo;
import com.kingdee.eas.fm.fs.app.AbstractInnerAcctGroupControllerBean;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class InnerAcctGroupControllerBean
extends AbstractInnerAcctGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.InnerAcctGroupControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InnerAcctGroupInfo info = (InnerAcctGroupInfo)model;
        this.checkAcctBankGroupValid(ctx, info);
        return super._submit(ctx, model);
    }

    private void checkAcctBankGroupValid(Context ctx, InnerAcctGroupInfo info) throws BOSException, EASBizException, AccountBankException {
        this.checkEntriesAcctBankDup(info);
        InnerAcctGroupEntryCollection coll = this.checkAcctBankBelongOtherGrouped(ctx, info);
        if (coll.size() > 0) {
            StringBuffer acctNums = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                InnerAcctGroupEntryInfo entry = coll.get(i);
                acctNums.append(entry.getInnerAcct().getNumber() + " ");
            }
            throw new FSException(FSException.INNERACCTHASGROUPED, new Object[]{acctNums});
        }
    }

    private InnerAcctGroupEntryCollection checkAcctBankBelongOtherGrouped(Context ctx, InnerAcctGroupInfo info) throws EASBizException, BOSException {
        InnerAcctGroupEntryCollection entries = info.getEntrys();
        HashSet<String> acctBankIdSet = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            InnerAcctGroupEntryInfo entry1 = entries.get(i);
            InnerAccountInfo acctBank1 = entry1.getInnerAcct();
            acctBankIdSet.add(acctBank1.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("innerAcct.id");
        view.getSelector().add("innerAcct.number");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("Parent.id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("innerAcct.id", acctBankIdSet, CompareType.INCLUDE));
        InnerAcctGroupEntryCollection coll = InnerAcctGroupEntryFactory.getLocalInstance(ctx).getInnerAcctGroupEntryCollection(view);
        return coll;
    }

    private void checkEntriesAcctBankDup(InnerAcctGroupInfo info) throws BOSException, EASBizException {
        int i;
        InnerAcctGroupEntryCollection entries = info.getEntrys();
        for (i = entries.size() - 1; i >= 0; --i) {
            InnerAcctGroupEntryInfo entryInfo = entries.get(i);
            if (entryInfo == null || entryInfo.getInnerAcct() != null) continue;
            entries.removeObject((IObjectValue)entryInfo);
        }
        for (i = 0; i < entries.size(); ++i) {
            InnerAcctGroupEntryInfo entry1 = entries.get(i);
            InnerAccountInfo acctBank1 = entry1.getInnerAcct();
            for (int j = i + 1; j < entries.size(); ++j) {
                InnerAcctGroupEntryInfo entry2 = entries.get(j);
                InnerAccountInfo acctBank2 = entry2.getInnerAcct();
                if (!acctBank1.getId().equals((Object)acctBank2.getId())) continue;
                throw new FSException(FSException.INNERACCTCANTSAME);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InnerAcctGroupInfo info = (InnerAcctGroupInfo)model;
        this.checkAcctBankGroupValid(ctx, info);
        super._update(ctx, pk, model);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }
}

