/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.InnerFrozenDepositInfo;
import com.kingdee.eas.fm.fs.app.AbstractInnerFrozenDepositControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class InnerFrozenDepositControllerBean
extends AbstractInnerFrozenDepositControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.InnerFrozenDepositControllerBean");

    @Override
    protected BigDecimal _getTotalFrozenAmt(Context ctx, String id, String currencyID) throws BOSException, EASBizException {
        String ids = null;
        if (id != null) {
            id = id.trim();
            ids = this.parseInnerAcctParam(ctx, id);
        }
        BigDecimal result = null;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select sum(FFrozenAmt) result from t_fs_innerfrozendeposit where FInnerAccountID in (");
        sqlBuffer.append(ids);
        sqlBuffer.append(") and FCurrencyID = '");
        sqlBuffer.append(currencyID);
        sqlBuffer.append("'");
        result = this.getResultBySQL(ctx, sqlBuffer.toString());
        return result;
    }

    private String parseInnerAcctParam(Context ctx, String param) throws FSException, BOSException {
        StringBuffer allIds = new StringBuffer();
        String allIdsString = null;
        if (param.indexOf(",") == -1) {
            allIds.append("'").append(param).append("'").append(",");
        } else {
            String[] subParam = param.split(",");
            for (int i = 0; i < subParam.length; ++i) {
                allIds.append("'").append(subParam[i]).append("'").append(",");
            }
        }
        allIdsString = allIds.toString().substring(0, allIds.length() - 1);
        return allIdsString;
    }

    private BigDecimal getResultBySQL(Context ctx, String sql) throws SQLDataException, BOSException {
        BigDecimal result = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next() && (result = rs.getBigDecimal("result")) == null) {
                result = Constants.ZERO;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private int getResultBySQLFroInt(Context ctx, String sql) throws SQLDataException, BOSException {
        int result = 1;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt("result");
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        if (result == 0) {
            result = 1;
        }
        return result;
    }

    @Override
    protected int _getAutoNumber(Context ctx, String innerAccountId, String currencyID) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select max(FFrozenNumber)+1 result from t_fs_innerfrozendeposit where FInnerAccountID = '");
        sqlBuffer.append(innerAccountId);
        sqlBuffer.append("'");
        sqlBuffer.append(" and FCurrencyID = '");
        sqlBuffer.append(currencyID);
        sqlBuffer.append("'");
        int result = this.getResultBySQLFroInt(ctx, sqlBuffer.toString());
        return result;
    }

    @Override
    protected String _checkCanRemove(Context ctx, String frozenId) throws BOSException, EASBizException {
        InnerFrozenDepositInfo info = this.getInnerFrozenDepositInfo(ctx, (IObjectPK)new ObjectUuidPK(frozenId));
        String result = "0";
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select max(FFrozenNumber) result from t_fs_innerfrozendeposit where FInnerAccountID = '");
        sqlBuffer.append(info.getInnerAccount().getId().toString());
        sqlBuffer.append("'");
        sqlBuffer.append(" and FCurrencyID = '");
        sqlBuffer.append(info.getCurrency().getId().toString());
        sqlBuffer.append("'");
        int maxNumber = this.getResultBySQLFroInt(ctx, sqlBuffer.toString());
        if (info.getFrozenNumber() < maxNumber) {
            result = "1";
        }
        return result;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InnerFrozenDepositInfo info = (InnerFrozenDepositInfo)model;
        info.setCurBalance(Constants.ZERO);
        info.setUseBalance(Constants.ZERO);
        info.setTotalFrozenAmt(Constants.ZERO);
        return super._submit(ctx, (IObjectValue)info);
    }
}

