/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryCollection;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.util.Date;

public class OverDraftCheckHelper {
    public static final int FLAG_SAVE = 0;
    public static final int FLAG_SUBMIT = 1;
    public static final int FLAG_ACCEPT = 2;

    public static void checkOverDraft(Context ctx, IObjectValue model, int flag, boolean isGather, BigDecimal gatherAmount, boolean isPay) throws EASBizException, BOSException, UuidException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        if (info.getPayeeInnerAcct() != null && info.getPayerInnerAcct() != null && info.getPayeeInnerAcct().getId().equals((Object)info.getPayerInnerAcct().getId())) {
            return;
        }
        InnerAccountInfo inAcct = null;
        CurrencyInfo currency = null;
        String inAcctId = null;
        String currencyId = null;
        BigDecimal billAmount = null;
        boolean isRedBill = false;
        if (info.getAmount().compareTo(Constants.ZERO) > 0) {
            if (info.getPayerInnerAcct() == null) {
                return;
            }
            if (!info.isIsDlByPay()) {
                return;
            }
            inAcctId = info.getPayerInnerAcct().getId().toString();
            currencyId = info.getCurrency().getId().toString();
            billAmount = info.getAmount();
            isRedBill = false;
        } else if (info.getAmount().compareTo(Constants.ZERO) < 0) {
            if (info.getPayeeInnerAcct() == null) {
                return;
            }
            if (!info.isIsDlByRec()) {
                return;
            }
            inAcctId = info.getPayeeInnerAcct().getId().toString();
            currencyId = info.getCurrency().getId().toString();
            billAmount = info.getAmount().abs();
            isRedBill = true;
        } else {
            return;
        }
        if (isGather) {
            billAmount = gatherAmount.abs();
        }
        inAcct = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inAcctId)));
        currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)currencyId)));
        AccountMgrStrategyInfo ctrlParam = inAcct.getCtrlParam();
        boolean isSingleOk = false;
        if (ctrlParam != null) {
            AccountMgrStrategyInfo ctrlStrategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParam.getId()));
            OverdraftCtrlEnum overdraftCtrl = ctrlStrategy.getOverdraftCtrl();
            isSingleOk = OverDraftCheckHelper.isNeedCtrl(flag, isRedBill, ctrlStrategy);
            if (!isSingleOk) {
                OverDraftCheckHelper.innerAcctCtrl(ctx, info, inAcct, currency, billAmount, ctrlStrategy, overdraftCtrl);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("innerAcct.id", (Object)inAcctId));
        InnerAcctGroupEntryCollection coll = InnerAcctGroupEntryFactory.getLocalInstance(ctx).getInnerAcctGroupEntryCollection(view);
        if (coll != null && coll.size() > 0) {
            InnerAcctGroupEntryInfo innerAcctGroupEntryInfo = coll.get(0);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("ctrlParam.*");
            selector.add("entrys.*");
            selector.add("entrys.innerAcct.*");
            InnerAcctGroupInfo innerAcctGroupInfo = InnerAcctGroupFactory.getLocalInstance(ctx).getInnerAcctGroupInfo((IObjectPK)new ObjectUuidPK(innerAcctGroupEntryInfo.getParent().getId()), selector);
            AccountMgrStrategyInfo ctrlParamGroup = innerAcctGroupInfo.getCtrlParam();
            boolean isGroupOk = false;
            if (ctrlParamGroup != null) {
                AccountMgrStrategyInfo ctrlStrategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId()));
                OverdraftCtrlEnum overdraftCtrl = ctrlStrategy.getOverdraftCtrl();
                isGroupOk = OverDraftCheckHelper.isNeedCtrl(flag, isRedBill, ctrlStrategy);
                if (!isGroupOk) {
                    OverDraftCheckHelper.innerAcctGroupCtrl(ctx, info, inAcct, currency, billAmount, innerAcctGroupInfo, ctrlStrategy, overdraftCtrl);
                }
            }
        }
        if ((info.getType() == SettBizTypeEnum.PAYOUTSIDE || info.getType() == SettBizTypeEnum.LINKPAY) && info.getPayerBankAcct() != null) {
            AccountMgrStrategyInfo ctrlStrategy;
            AccountMgrStrategyInfo ctrlStrategy2;
            boolean isSingleAcctOk = false;
            AccountBankInfo acctBank = info.getPayerBankAcct();
            AccountMgrStrategyInfo strategy = null;
            if (acctBank != null) {
                strategy = acctBank.getCtrlStrategy();
            }
            if (strategy != null && !(isSingleAcctOk = OverDraftCheckHelper.isNeedCtrl(flag, isRedBill, ctrlStrategy2 = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(strategy.getId()))))) {
                RecPayAcctBankStratageCtrl.acctBankBalanceSettleBillCtrlSingle((Context)ctx, (IObjectValue)info, (AccountMgrStrategyInfo)ctrlStrategy2, (boolean)isPay);
            }
            boolean isGroupAcctOk = false;
            AccountBankGroupInfo acctBankGroup = null;
            if (acctBank != null) {
                acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(acctBank.getId().toString());
            }
            AccountMgrStrategyInfo ctrlParamGroup = null;
            if (acctBankGroup != null) {
                ctrlParamGroup = acctBankGroup.getStrategy();
            }
            if (ctrlParamGroup != null && !(isGroupAcctOk = OverDraftCheckHelper.isNeedCtrl(flag, isRedBill, ctrlStrategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId()))))) {
                RecPayAcctBankStratageCtrl.acctBankBalanceSettleBillCtrlGroup((Context)ctx, (IObjectValue)info, (AccountMgrStrategyInfo)ctrlStrategy, (boolean)isPay);
            }
        }
    }

    public static boolean isNeedCtrl(int flag, boolean isRedBill, AccountMgrStrategyInfo ctrlStrategy) {
        OverdraftCtrlEnum overdraftCtrl = ctrlStrategy.getOverdraftCtrl();
        boolean notNeed = false;
        if (flag == 0 && !ctrlStrategy.isCtrlSettleSave()) {
            notNeed = true;
        }
        if (flag == 1 && !ctrlStrategy.isCtrlSettleSubm()) {
            notNeed = true;
        }
        if (flag == 2 && !ctrlStrategy.isCtrlSettlePast()) {
            notNeed = true;
        }
        if (isRedBill && !ctrlStrategy.isCtrlRedBill()) {
            notNeed = true;
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            notNeed = true;
        }
        return notNeed;
    }

    private static void innerAcctGroupCtrl(Context ctx, SettlementBillInfo info, InnerAccountInfo inAcct, CurrencyInfo currency, BigDecimal billAmount, InnerAcctGroupInfo innerAcctGroupInfo, AccountMgrStrategyInfo ctrlStrategy, OverdraftCtrlEnum overdraftCtrl) throws BOSException, EASBizException, FSException {
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        String companyNumber = chCompany.getNumber();
        Date unSettleDate = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString()).getSettleDate();
        StringBuffer allInnerAcctNumber = new StringBuffer();
        String allInnerAcctNumberString = null;
        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
            allInnerAcctNumber.append(entryInfo.getInnerAcct().getNumber());
            allInnerAcctNumber.append(",");
        }
        allInnerAcctNumberString = allInnerAcctNumber.substring(0, allInnerAcctNumber.length() - 1);
        BigDecimal curBalance = InAcctFactory.getLocalInstance(ctx).inAcct(companyNumber, allInnerAcctNumberString, currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        StringBuffer allInnerAcctId = new StringBuffer();
        String allInnerAcctIdString = null;
        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
            allInnerAcctId.append(entryInfo.getInnerAcct().getId());
            allInnerAcctId.append(",");
        }
        allInnerAcctIdString = allInnerAcctId.substring(0, allInnerAcctId.length() - 1);
        BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getLocalInstance(ctx).getTotalFrozenAmt(allInnerAcctIdString, currency.getId().toString());
        BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
        BigDecimal preAmount = kValue.subtract(billAmount);
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) < 0) {
            throw new FSException(FSException.OVERDRAFTGROUP, new Object[]{inAcct.getName(), innerAcctGroupInfo.getName(), kValue, ctrlStrategy.getOverDraftAmount(), preAmount.abs().subtract(ctrlStrategy.getOverDraftAmount())});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW) && preAmount.signum() < 0) {
            throw new FSException(FSException.NOALLOWOVERDRAFTGROUP, new Object[]{inAcct.getName(), innerAcctGroupInfo.getName(), kValue, preAmount.abs()});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && preAmount.compareTo(ctrlStrategy.getLowestBalance()) < 0) {
            throw new FSException(FSException.OVERLOWAMOUNTGROUP, new Object[]{inAcct.getName(), innerAcctGroupInfo.getName(), kValue, ctrlStrategy.getLowestBalance().subtract(preAmount)});
        }
    }

    private static void innerAcctCtrl(Context ctx, SettlementBillInfo info, InnerAccountInfo inAcct, CurrencyInfo currency, BigDecimal billAmount, AccountMgrStrategyInfo ctrlStrategy, OverdraftCtrlEnum overdraftCtrl) throws BOSException, EASBizException, FSException {
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        String companyNumber = chCompany.getNumber();
        Date unSettleDate = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString()).getSettleDate();
        BigDecimal curBalance = InAcctFactory.getLocalInstance(ctx).inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getLocalInstance(ctx).getTotalFrozenAmt(inAcct.getId().toString(), currency.getId().toString());
        BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
        BigDecimal preAmount = kValue.subtract(billAmount);
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) < 0) {
            throw new FSException(FSException.OVERDRAFT, new Object[]{inAcct.getName(), kValue, ctrlStrategy.getOverDraftAmount(), preAmount.abs().subtract(ctrlStrategy.getOverDraftAmount())});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW) && preAmount.signum() < 0) {
            throw new FSException(FSException.NOALLOWOVERDRAFT, new Object[]{inAcct.getName(), kValue, preAmount.abs()});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && preAmount.compareTo(ctrlStrategy.getLowestBalance()) < 0) {
            throw new FSException(FSException.OVERLOWAMOUNT, new Object[]{inAcct.getName(), kValue, ctrlStrategy.getLowestBalance().subtract(preAmount)});
        }
    }

    public static void checkOverDraft4Repayment(Context ctx, IObjectValue model) throws EASBizException, BOSException, UuidException {
        RepaymentInfo info = (RepaymentInfo)model;
        if (info.getInnerAccount() != null) {
            if (info.getInnerAccount() != null && info.getPayeeAccount() != null && info.getInnerAccount().equals((Object)info.getPayeeAccount())) {
                return;
            }
            String inAcctId = info.getInnerAccount().getId().toString();
            String currencyId = info.getCurrency().getId().toString();
            BigDecimal billAmount = null;
            billAmount = info.getInterest() != null ? FMHelper.add((BigDecimal)info.getSourceAmount(), (BigDecimal)info.getInterest()) : info.getSourceAmount();
            InnerAccountInfo inAcct = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inAcctId)));
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)currencyId)));
            AccountMgrStrategyInfo ctrlParam = inAcct.getCtrlParam();
            AccountMgrStrategyInfo ctrlStrategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParam.getId()));
            OverdraftCtrlEnum overdraftCtrl = ctrlStrategy.getOverdraftCtrl();
            OverDraftCheckHelper.innerAcctCtrl4Repayment(ctx, info, inAcct, currency, billAmount, ctrlStrategy, overdraftCtrl);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("innerAcct.id", (Object)inAcctId));
            InnerAcctGroupEntryCollection coll = InnerAcctGroupEntryFactory.getLocalInstance(ctx).getInnerAcctGroupEntryCollection(view);
            if (coll != null && coll.size() > 0) {
                InnerAcctGroupEntryInfo innerAcctGroupEntryInfo = coll.get(0);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("ctrlParam.*");
                selector.add("entrys.*");
                selector.add("entrys.innerAcct.*");
                InnerAcctGroupInfo innerAcctGroupInfo = InnerAcctGroupFactory.getLocalInstance(ctx).getInnerAcctGroupInfo((IObjectPK)new ObjectUuidPK(innerAcctGroupEntryInfo.getParent().getId()), selector);
                AccountMgrStrategyInfo ctrlParamGroup = innerAcctGroupInfo.getCtrlParam();
                if (ctrlParamGroup != null) {
                    ctrlStrategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId()));
                    overdraftCtrl = ctrlStrategy.getOverdraftCtrl();
                    OverDraftCheckHelper.innerAcctGroupCtrl4Repayment(ctx, info, inAcct, currency, billAmount, innerAcctGroupInfo, ctrlStrategy, overdraftCtrl);
                }
            }
        }
    }

    private static void innerAcctCtrl4Repayment(Context ctx, RepaymentInfo info, InnerAccountInfo inAcct, CurrencyInfo currency, BigDecimal billAmount, AccountMgrStrategyInfo ctrlStrategy, OverdraftCtrlEnum overdraftCtrl) throws BOSException, EASBizException, FSException {
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        String companyNumber = chCompany.getNumber();
        Date unSettleDate = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString()).getSettleDate();
        BigDecimal curBalance = InAcctFactory.getLocalInstance(ctx).inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getLocalInstance(ctx).getTotalFrozenAmt(inAcct.getId().toString(), currency.getId().toString());
        BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
        BigDecimal preAmount = kValue.subtract(billAmount);
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) < 0) {
            throw new FSException(FSException.OVERDRAFT4REPAYMENT, new Object[]{inAcct.getName(), kValue, ctrlStrategy.getOverDraftAmount(), preAmount.abs().subtract(ctrlStrategy.getOverDraftAmount())});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW) && preAmount.signum() < 0) {
            throw new FSException(FSException.NOALLOWOVERDRAFT4REPAYMENT, new Object[]{inAcct.getName(), kValue, preAmount.abs()});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && preAmount.compareTo(ctrlStrategy.getLowestBalance()) < 0) {
            throw new FSException(FSException.OVERLOWAMOUNT4REPAYMENT, new Object[]{inAcct.getName(), kValue, ctrlStrategy.getLowestBalance().subtract(preAmount)});
        }
    }

    public static void innerAcctGroupCtrl4Repayment(Context ctx, RepaymentInfo info, InnerAccountInfo inAcct, CurrencyInfo currency, BigDecimal billAmount, InnerAcctGroupInfo innerAcctGroupInfo, AccountMgrStrategyInfo ctrlStrategy, OverdraftCtrlEnum overdraftCtrl) throws BOSException, EASBizException, FSException {
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        String companyNumber = chCompany.getNumber();
        Date unSettleDate = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString()).getSettleDate();
        StringBuffer allInnerAcctNumber = new StringBuffer();
        String allInnerAcctNumberString = null;
        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
            allInnerAcctNumber.append(entryInfo.getInnerAcct().getNumber());
            allInnerAcctNumber.append(",");
        }
        allInnerAcctNumberString = allInnerAcctNumber.substring(0, allInnerAcctNumber.length() - 1);
        BigDecimal curBalance = InAcctFactory.getLocalInstance(ctx).inAcct(companyNumber, allInnerAcctNumberString, currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        StringBuffer allInnerAcctId = new StringBuffer();
        String allInnerAcctIdString = null;
        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
            allInnerAcctId.append(entryInfo.getInnerAcct().getId());
            allInnerAcctId.append(",");
        }
        allInnerAcctIdString = allInnerAcctId.substring(0, allInnerAcctId.length() - 1);
        BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getLocalInstance(ctx).getTotalFrozenAmt(allInnerAcctIdString, currency.getId().toString());
        BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
        BigDecimal preAmount = kValue.subtract(billAmount);
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) < 0) {
            throw new FSException(FSException.OVERDRAFTGROUP4REPAYMENT, new Object[]{inAcct.getName(), innerAcctGroupInfo.getName(), kValue, ctrlStrategy.getOverDraftAmount(), preAmount.abs().subtract(ctrlStrategy.getOverDraftAmount())});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW) && preAmount.signum() < 0) {
            throw new FSException(FSException.NOALLOWOVERDRAFTGROUP4REPAYMENT, new Object[]{inAcct.getName(), innerAcctGroupInfo.getName(), kValue, preAmount.abs()});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && preAmount.compareTo(ctrlStrategy.getLowestBalance()) < 0) {
            throw new FSException(FSException.OVERLOWAMOUNTGROUP4REPAYMENT, new Object[]{inAcct.getName(), innerAcctGroupInfo.getName(), kValue, ctrlStrategy.getLowestBalance().subtract(preAmount)});
        }
    }
}

