/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;

public class SettleBillDataVerify {
    public static void verifyCollection(Context ctx, SettlementBillCollection coll) throws FSException, EASBizException {
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            SettleBillDataVerify.verifyInfo(ctx, info);
        }
    }

    public static void verifyInfo(Context ctx, SettlementBillInfo info) throws FSException, EASBizException {
        SettleBillDataVerify.verifyNormalData(ctx, info);
        switch (info.getType().getValue()) {
            case 2: 
            case 100: {
                SettleBillDataVerify.verifyPayer(ctx, info);
                break;
            }
            case 1: {
                SettleBillDataVerify.verifyPayee(ctx, info);
                break;
            }
            case 4: {
                if (info.getInnerPayerAcct() != null || info.getInnerPayeeAcct() != null) break;
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"43_SettleBillDataVerify", (Locale)ctx.getLocale())));
            }
            case 3: {
                if (info.getInnerPayerAcct() != null || info.getInnerPayeeAcct() != null) break;
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"43_SettleBillDataVerify", (Locale)ctx.getLocale())));
            }
        }
    }

    public static void verifyNormalData(Context ctx, SettlementBillInfo info) throws EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"amount");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"exchange");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"applyUnit");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"type");
    }

    private static void verifyPayee(Context ctx, SettlementBillInfo info) throws EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"innerPayeeAcct");
    }

    private static void verifyPayer(Context ctx, SettlementBillInfo info) throws EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"innerPayerAcct");
    }
}

