/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.app.CommitToBeService;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.app.service.settlementbill.SettleService;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SettleCommitToBeService
extends CommitToBeService {
    private static Logger logger = Logger.getLogger((String)SettleCommitToBeService.class.getName());
    private ISettleFacade iSettleFacade;

    private ISettleFacade getSettleFacade(Context ctx) throws BOSException {
        if (this.iSettleFacade == null) {
            this.iSettleFacade = SettleFacadeFactory.getLocalInstance(ctx);
        }
        return this.iSettleFacade;
    }

    protected IObjectPK executeBankPayingBill(Context ctx, BillBaseInfo bizBillInfo, boolean isNeedCommitToBank) throws BOSException, EASBizException {
        return this.getSettleFacade(ctx).commitToBENew((SettlementBillInfo)bizBillInfo);
    }

    protected List<BankPayResult> submitToBe(Context ctx, Set<String> bankPayBillIdSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> bankPayResults = new ArrayList<BankPayResult>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("sourceBillId");
        selector.add("number");
        BankPayingBillCollection bankPayingBills = this.getBankPayingBillCollection(ctx, bankPayBillIdSet, selector);
        HashSet<String> bankPayBillIds = new HashSet<String>();
        ISettleFacade iSettleFacade = this.getSettleFacade(ctx);
        int size = bankPayingBills.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBills.get(i);
            String sourceBillId = info.getSourceBillId();
            if (sourceBillId == null) continue;
            try {
                iSettleFacade.commitToBeAll4WF((IObjectPK)new ObjectUuidPK(sourceBillId));
                bankPayBillIds.add(info.getId().toString());
                continue;
            }
            catch (Exception e) {
                String returnMsg = new BEException(BEException.COMMITFAILURE, (Throwable)e).getMessage();
                BankPayResult bankResultInfo = new BankPayResult(info.getId().toString(), info.getSerialNumber(), BankPayingBillStateEnum.OF, returnMsg);
                bankResultInfo.setSrcId(info.getSourceBillId());
                bankResultInfo.setErrorDetail(ExceptionMessageUtility.getMessage((Throwable)e));
                bankPayResults.add(bankResultInfo);
            }
        }
        bankPayResults.addAll(BankFacadeFactory.getLocalInstance((Context)ctx).batchSubmit(bankPayBillIds));
        return bankPayResults;
    }

    protected void reserveForBeException(Context ctx, String bankPayingbillId, String number) throws EASBizException, BOSException {
        this.getSettleFacade(ctx).reserveForBeException(bankPayingbillId);
    }

    protected void reserveForOtherException(Context ctx, BankPayingBillInfo bankPayingbillinfo, String returnMsg) throws EASBizException, BOSException {
        this.getSettleFacade(ctx).reserveForOtherException(bankPayingbillinfo, returnMsg);
    }

    protected void updateBillStateAndReturnMsg(Context ctx, String bankPayingBillId, int state, String returnMsg) throws EASBizException, BOSException {
        this.getSettleFacade(ctx).updateBillStateAndReturnMsg(bankPayingBillId, state, returnMsg);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.baseCurrency.id");
        selector.add("company.baseExchangeTable.id");
        selector.add("payerBankAcct.isSetBankInterface");
        selector.add("payerBankAcct.account.id");
        selector.add("settleType.payThroughBE");
        return selector;
    }

    protected IObjectCollection getBizBillCollection(Context ctx, Set<String> bizBillIdSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bizBillIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        return SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(view);
    }

    protected Set<String> createNeedToBeBankPayingBillIdSet(Context ctx, IObjectCollection bizColl, Set<String> bizBillIdSet) throws BOSException, EASBizException {
        int i;
        ArrayList<String> ids = new ArrayList<String>();
        for (int i2 = 0; i2 < bizColl.size(); ++i2) {
            ids.add(bizColl.getObject(i2).get("id").toString());
        }
        long dTime = System.currentTimeMillis();
        SettleService settleService = new SettleService(ctx, ids, "commitToBENew");
        List batchResult = settleService.doService();
        System.out.println("settleService spent: " + (System.currentTimeMillis() - dTime) + "ms.");
        HashSet<String> bankPayBillIdSet = new HashSet<String>();
        String hintTitle = this.getBEResource("submit") + this.getBEResource("bankPayBill");
        HashSet<String> billIdSet = new HashSet<String>();
        for (int i3 = 0; i3 < bizColl.size(); ++i3) {
            billIdSet.add(bizColl.getObject(i3).get("id").toString());
        }
        SettlementBillCollection bizBillColls = new SettlementBillCollection();
        int size = ids.size();
        for (i = 0; i < size; ++i) {
            bizBillColls.addObject((IObjectValue)settleService.getInfo((String)ids.get(i)));
        }
        size = bizBillColls.size();
        for (i = 0; i < size; ++i) {
            BillBaseInfo bizBillInfo = (BillBaseInfo)bizBillColls.getObject(i);
            String bizBillId = bizBillInfo.getId().toString();
            BankPayResult resultInfo = new BankPayResult(bizBillId, bizBillInfo.getNumber(), null, null);
            boolean isNeedCommitToBank = this.isNeedCommitToBank(ctx, bizBillInfo);
            this.updateBankPayResult(resultInfo, BankPayingBillStateEnum.OP, hintTitle + this.getBEResource("success"), null, null);
            Map bankPayingbillIdMap = (Map)ctx.get((Object)"SettleServiceResult");
            Exception e = (Exception)batchResult.get(settleService.getIndex(bizBillId));
            if (e == null) {
                if (isNeedCommitToBank) {
                    bankPayBillIdSet.add((String)bankPayingbillIdMap.get(bizBillId));
                }
                this.bankPayResultMap.put(bankPayingbillIdMap.get(bizBillId), resultInfo);
                continue;
            }
            this.updateBankPayResult(resultInfo, BankPayingBillStateEnum.OF, hintTitle + this.getBEResource("failure"), null, e.getMessage());
            this.bankPayResultMap.put(bizBillId, resultInfo);
            if (!this.isFromWF) continue;
            throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{e.getMessage()});
        }
        return bankPayBillIdSet;
    }
}

