/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SettlementBillSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.SettlementBillSmartFilter");

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        String queryOql = "";
        try {
            FilterInfo filterInfo = new FilterInfo(filterSql);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String compareOp;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String filterValue = null;
                    Object cmpVal = filterItemInfo.getCompareValue();
                    if (cmpVal != null) {
                        filterValue = cmpVal.toString();
                    }
                    if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endValue = "";
                    try {
                        Date date = df.parse(filterValue);
                        date.setTime(date.getTime() + 1000L);
                        endValue = df.format(date);
                        if (EmptyUtil.isEmpty((String)endValue)) continue;
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id where " + filterSql + " and company.id = '" + companyID + "'  ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("SettlementBillSmartFilter============" + iexec.getSQL() + " and fissmart in (1,3) "));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL() + " and fissmart in (1,3) ");
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        String businessNumber;
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"516_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"517_SettlementBillSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(filterSql);
            }
        } else {
            result.append(filterSql);
        }
        if ("6E41E17C6".equals(businessNumber = busiInfo.getBusinessNumber())) {
            result.append(" and (type = 2 or type=100) and payeeBankAcctNum is not null ");
        } else if ("6E41E17C2".equals(businessNumber)) {
            result.append(" and type = 1 and payeeBankAcctNum is not null ");
        } else if ("6E41E17C3".equals(businessNumber)) {
            result.append(" and (type = 3 or type = 51 ) ");
        } else if ("6E41E17C4".equals(businessNumber)) {
            result.append(" and (type = 4 or type = 52 ) ");
        } else if ("6E41E17C5".equals(businessNumber)) {
            result.append(" and (type = 10 ) ");
        }
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.out_rec_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.in_rec_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.in_rec_submit_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.in_pay_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_sumbit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.in_pay_submit_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_submit_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_submit_accept_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_submit_accept_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_submit_accept_audit_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_submit_accept_audit_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.out_rec_submit_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_commit_accept_audit_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept_audit_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.out_rec_submit_accept_rec.getName().equals(operatorNumber)) {
            result.append(" and  billStatus in (1,2)  ");
        }
        if (InterfaceTypeEnum.out_rec_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.out_rec_accept_rec.getName().equals(operatorNumber) || InterfaceTypeEnum.in_rec_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.in_pay_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_accept_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_accept_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_accept_audit_commintBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_accept_audit_commitBank.getName().equals(operatorNumber)) {
            result.append(" and  billStatus = 2 ");
        }
        if (InterfaceTypeEnum.out_rec_rec.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.out_pay_commitBank.getName().equals(operatorNumber)) {
            result.append(" and  billStatus in (3,4) ");
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        String companyID = "";
        String auditor = "";
        String acceptor = "";
        String casherid = "";
        if (paramMap.get("companyID") != null) {
            companyID = "" + paramMap.get("companyID");
        }
        if (schemaInfo != null && schemaInfo.getAuditor() != null) {
            auditor = schemaInfo.getAuditor().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getAcceptor() != null) {
            acceptor = schemaInfo.getAcceptor().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getPayer() != null) {
            casherid = schemaInfo.getPayer().getId().toString();
        }
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            String msg;
            StringBuffer failMsg;
            SettlementBillInfo info;
            Object[] params;
            Map map;
            StringBuffer sb;
            String msg2;
            String msg3;
            BankPayResult bankResult;
            StringBuffer failMsg2;
            Set chongFuSet;
            ArrayList resultChongFuList;
            String msg4;
            PeriodInfo currPeriodInfo;
            SettlementBillInfo info2;
            ArrayList list;
            Set bankSet;
            SettlementBillInfo info3;
            String msg5;
            SettlementBillInfo info4;
            Object[] params2;
            String errmsg;
            Map map2;
            ArrayList list2;
            SettlementBillInfo info5;
            HashSet auditSet;
            Object[] params3;
            String errmsg2;
            Map map3;
            Object[] params4;
            String msg6;
            String msg7;
            ArrayList list3;
            HashSet acceptorSet;
            Object[] params5;
            String errmsg3;
            Map map4;
            int i;
            ArrayList<Object[]> paramList;
            String operatorNumber = busiInfo.getOperatorNumber();
            ISettlementBill biz = SettlementBillFactory.getLocalInstance(ctx);
            boolean mustAuditParam = false;
            if (!EmptyUtil.isEmpty((String)companyID)) {
                mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(companyID));
            }
            String sqlFailMsg = "UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ?";
            if (InterfaceTypeEnum.out_rec_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_sumbit.getName().equals(operatorNumber)) {
                paramList = new ArrayList<Object[]>();
                for (i = 0; i < billList.size(); ++i) {
                    try {
                        ArrayList list4 = new ArrayList();
                        list4.add(billList.get(i));
                        map4 = biz.saveBatch(list4);
                        errmsg3 = "";
                        if (map4.get("error") != null) {
                            errmsg3 = map4.get("error").toString();
                        }
                        if (errmsg3 != null && errmsg3.toString() != null && errmsg3.toString().length() > 0) {
                            if (errmsg3.length() > 2000) {
                                errmsg3 = errmsg3.substring(0, 2000);
                            }
                            params5 = new Object[]{errmsg3, billList.get(i).toString()};
                            paramList.add(params5);
                        }
                        ++success;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                    if (EmptyUtil.isEmpty(paramList)) continue;
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.out_rec_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList2 = new ArrayList<Object[]>();
                for (int i2 = 0; i2 < billList.size(); ++i2) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i2));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i2));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i2).toString()};
                        paramList2.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList2)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList2);
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb2 = new StringBuffer();
                    sb2.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb2.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb2.toString(), (Object[])new Object[]{acceptor});
                }
            }
            if (InterfaceTypeEnum.out_rec_rec.getName().equals(operatorNumber)) {
                paramList = new ArrayList();
                for (i = 0; i < billList.size(); ++i) {
                    try {
                        ArrayList list5 = new ArrayList();
                        list5.add(billList.get(i));
                        SettleFacadeFactory.getLocalInstance(ctx).settle(list5, true);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg6 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg6) && msg6.length() > 2000) {
                            msg6 = msg6.substring(0, 2000);
                        }
                        params4 = new Object[]{msg6, billList.get(i).toString()};
                        paramList.add(params4);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.out_rec_submit_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList3 = new ArrayList<Object[]>();
                for (int i3 = 0; i3 < billList.size(); ++i3) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i3));
                        map3 = biz.saveBatch(list3);
                        errmsg2 = "";
                        if (map3.get("error") != null) {
                            errmsg2 = map3.get("error").toString();
                        }
                        if (errmsg2 != null && errmsg2.toString() != null && errmsg2.toString().length() > 0) {
                            if (errmsg2.length() > 2000) {
                                errmsg2 = errmsg2.substring(0, 2000);
                            }
                            params3 = new Object[]{errmsg2, billList.get(i3).toString()};
                            paramList3.add(params3);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i3));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i3).toString()};
                        paramList3.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb3 = new StringBuffer();
                    sb3.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb3.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb3.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList3)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList3);
                }
            }
            if (InterfaceTypeEnum.out_rec_submit_accept_rec.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList4 = new ArrayList<Object[]>();
                for (int i4 = 0; i4 < billList.size(); ++i4) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i4));
                        map3 = biz.saveBatch(list3);
                        errmsg2 = "";
                        if (map3.get("error") != null) {
                            errmsg2 = map3.get("error").toString();
                        }
                        if (errmsg2 != null && errmsg2.toString() != null && errmsg2.toString().length() > 0) {
                            if (errmsg2.length() > 2000) {
                                errmsg2 = errmsg2.substring(0, 2000);
                            }
                            params3 = new Object[]{errmsg2, billList.get(i4).toString()};
                            paramList4.add(params3);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i4));
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).settle(list3, true);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i4).toString()};
                        paramList4.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb4 = new StringBuffer();
                    sb4.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb4.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb4.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList4)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList4);
                }
            }
            if (InterfaceTypeEnum.out_rec_accept_rec.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList5 = new ArrayList<Object[]>();
                for (int i5 = 0; i5 < billList.size(); ++i5) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i5));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i5));
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).settle(list3, true);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i5).toString()};
                        paramList5.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb5 = new StringBuffer();
                    sb5.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb5.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb5.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList5)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList5);
                }
            }
            if (InterfaceTypeEnum.in_rec_submit.getName().equals(operatorNumber)) {
                paramList = new ArrayList();
                for (int i6 = 0; i6 < billList.size(); ++i6) {
                    try {
                        ArrayList list6 = new ArrayList();
                        list6.add(billList.get(i6));
                        map4 = biz.saveBatch(list6);
                        errmsg3 = "";
                        if (map4.get("error") != null) {
                            errmsg3 = map4.get("error").toString();
                        }
                        if (errmsg3 != null && errmsg3.toString() != null && errmsg3.toString().length() > 0) {
                            if (errmsg3.length() > 2000) {
                                errmsg3 = errmsg3.substring(0, 2000);
                            }
                            params5 = new Object[]{errmsg3, billList.get(i6).toString()};
                            paramList.add(params5);
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg6 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg6) && msg6.length() > 2000) {
                            msg6 = msg6.substring(0, 2000);
                        }
                        params4 = new Object[]{msg6, billList.get(i6).toString()};
                        paramList.add(params4);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.in_rec_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList6 = new ArrayList<Object[]>();
                for (int i7 = 0; i7 < billList.size(); ++i7) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i7));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i7));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i7).toString()};
                        paramList6.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb6 = new StringBuffer();
                    sb6.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb6.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb6.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList6)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList6);
                }
            }
            if (InterfaceTypeEnum.in_rec_submit_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList7 = new ArrayList<Object[]>();
                for (int i8 = 0; i8 < billList.size(); ++i8) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i8));
                        map3 = biz.saveBatch(list3);
                        errmsg2 = "";
                        if (map3.get("error") != null) {
                            errmsg2 = map3.get("error").toString();
                        }
                        if (errmsg2 != null && errmsg2.toString() != null && errmsg2.toString().length() > 0) {
                            if (errmsg2.length() > 2000) {
                                errmsg2 = errmsg2.substring(0, 2000);
                            }
                            params3 = new Object[]{errmsg2, billList.get(i8).toString()};
                            paramList7.add(params3);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i8));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i8).toString()};
                        paramList7.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb7 = new StringBuffer();
                    sb7.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb7.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb7.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList7)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList7);
                }
            }
            if (InterfaceTypeEnum.in_pay_submit.getName().equals(operatorNumber)) {
                paramList = new ArrayList();
                for (int i9 = 0; i9 < billList.size(); ++i9) {
                    try {
                        ArrayList list7 = new ArrayList();
                        list7.add(billList.get(i9));
                        map4 = biz.saveBatch(list7);
                        errmsg3 = "";
                        if (map4.get("error") != null) {
                            errmsg3 = map4.get("error").toString();
                        }
                        if (errmsg3 != null && errmsg3.toString() != null && errmsg3.toString().length() > 0) {
                            if (errmsg3.length() > 2000) {
                                errmsg3 = errmsg3.substring(0, 2000);
                            }
                            params5 = new Object[]{errmsg3, billList.get(i9).toString()};
                            paramList.add(params5);
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.in_pay_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList8 = new ArrayList<Object[]>();
                for (int i10 = 0; i10 < billList.size(); ++i10) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i10));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i10));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i10).toString()};
                        paramList8.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb8 = new StringBuffer();
                    sb8.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb8.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb8.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList8)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList8);
                }
            }
            if (InterfaceTypeEnum.in_pay_submit_accept.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList9 = new ArrayList<Object[]>();
                for (int i11 = 0; i11 < billList.size(); ++i11) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i11));
                        map3 = biz.saveBatch(list3);
                        errmsg2 = "";
                        if (map3.get("error") != null) {
                            errmsg2 = map3.get("error").toString();
                        }
                        if (errmsg2 != null && errmsg2.toString() != null && errmsg2.toString().length() > 0) {
                            if (errmsg2.length() > 2000) {
                                errmsg2 = errmsg2.substring(0, 2000);
                            }
                            params3 = new Object[]{errmsg2, billList.get(i11).toString()};
                            paramList9.add(params3);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i11));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i11).toString()};
                        paramList9.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb9 = new StringBuffer();
                    sb9.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb9.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb9.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList9)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList9);
                }
            }
            if (InterfaceTypeEnum.out_pay_submit.getName().equals(operatorNumber)) {
                paramList = new ArrayList();
                for (int i12 = 0; i12 < billList.size(); ++i12) {
                    try {
                        ArrayList list8 = new ArrayList();
                        list8.add(billList.get(i12));
                        map4 = biz.saveBatch(list8);
                        errmsg3 = "";
                        if (map4.get("error") != null) {
                            errmsg3 = map4.get("error").toString();
                        }
                        if (errmsg3 != null && errmsg3.toString() != null && errmsg3.toString().length() > 0) {
                            if (errmsg3.length() > 2000) {
                                errmsg3 = errmsg3.substring(0, 2000);
                            }
                            params5 = new Object[]{errmsg3, billList.get(i12).toString()};
                            paramList.add(params5);
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg6 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg6) && msg6.length() > 2000) {
                            msg6 = msg6.substring(0, 2000);
                        }
                        params4 = new Object[]{msg6, billList.get(i12).toString()};
                        paramList.add(params4);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.out_pay_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_audit_pay.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                ArrayList<Object[]> paramList10 = new ArrayList<Object[]>();
                for (int i13 = 0; i13 < billList.size(); ++i13) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i13));
                        info5 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i13).toString()));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info5.getCompany().getId().toString()));
                        }
                        if (mustAuditParam && info5.getBillStatus().getValue() != 4) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list3));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i13));
                            }
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).settle(list3, true);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i13).toString()};
                        paramList10.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb10 = new StringBuffer();
                    sb10.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb10.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb10.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList10)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList10);
                }
            }
            if (InterfaceTypeEnum.out_pay_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_audit.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                ArrayList<Object[]> paramList11 = new ArrayList<Object[]>();
                for (int i14 = 0; i14 < billList.size(); ++i14) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i14));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info5 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i14).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info5.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list3));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i14));
                            }
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i14).toString()};
                        paramList11.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb11 = new StringBuffer();
                    sb11.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb11.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb11.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList11)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList11);
                }
            }
            if (InterfaceTypeEnum.out_pay_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList12 = new ArrayList<Object[]>();
                for (int i15 = 0; i15 < billList.size(); ++i15) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i15));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i15));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i15).toString()};
                        paramList12.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb12 = new StringBuffer();
                    sb12.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb12.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb12.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList12)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList12);
                }
            }
            if (InterfaceTypeEnum.out_pay_submit_accept.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                ArrayList<Object[]> paramList13 = new ArrayList<Object[]>();
                for (int i16 = 0; i16 < billList.size(); ++i16) {
                    try {
                        list3 = new ArrayList();
                        list3.add(billList.get(i16));
                        map3 = biz.saveBatch(list3);
                        errmsg2 = "";
                        if (map3.get("error") != null) {
                            errmsg2 = map3.get("error").toString();
                        }
                        if (errmsg2 != null && errmsg2.toString() != null && errmsg2.toString().length() > 0) {
                            if (errmsg2.length() > 2000) {
                                errmsg2 = errmsg2.substring(0, 2000);
                            }
                            params3 = new Object[]{errmsg2, billList.get(i16).toString()};
                            paramList13.add(params3);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list3);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i16));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg7 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                            msg7 = msg7.substring(0, 2000);
                        }
                        params5 = new Object[]{msg7, billList.get(i16).toString()};
                        paramList13.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb13 = new StringBuffer();
                    sb13.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb13.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb13.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(paramList13)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList13);
                }
            }
            if (InterfaceTypeEnum.out_pay_submit_accept_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept_audit.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                HashSet auditSet2 = new HashSet();
                ArrayList<Object[]> paramList14 = new ArrayList<Object[]>();
                for (int i17 = 0; i17 < billList.size(); ++i17) {
                    try {
                        list2 = new ArrayList();
                        list2.add(billList.get(i17));
                        map2 = biz.saveBatch(list2);
                        errmsg = "";
                        if (map2.get("error") != null) {
                            errmsg = map2.get("error").toString();
                        }
                        if (errmsg != null && errmsg.toString() != null && errmsg.toString().length() > 0) {
                            if (errmsg.length() > 2000) {
                                errmsg = errmsg.substring(0, 2000);
                            }
                            params2 = new Object[]{errmsg, billList.get(i17).toString()};
                            paramList14.add(params2);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list2);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i17));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info4 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i17).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info4.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list2));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet2.add(billList.get(i17));
                            }
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg5 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg5) && msg5.length() > 2000) {
                            msg5 = msg5.substring(0, 2000);
                        }
                        params3 = new Object[]{msg5, billList.get(i17).toString()};
                        paramList14.add(params3);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb14 = new StringBuffer();
                    sb14.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb14.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb14.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet2)) {
                    StringBuffer sb15 = new StringBuffer();
                    sb15.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb15.append(StringUtil.buildIn((String)"fid", (Object[])auditSet2.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb15.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList14)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList14);
                }
            }
            if (InterfaceTypeEnum.out_pay_submit_accept_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept_audit_pay.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                HashSet auditSet3 = new HashSet();
                ArrayList<Object[]> paramList15 = new ArrayList<Object[]>();
                for (int i18 = 0; i18 < billList.size(); ++i18) {
                    try {
                        list2 = new ArrayList();
                        list2.add(billList.get(i18));
                        map2 = biz.saveBatch(list2);
                        errmsg = "";
                        if (map2.get("error") != null) {
                            errmsg = map2.get("error").toString();
                        }
                        if (errmsg != null && errmsg.toString() != null && errmsg.toString().length() > 0) {
                            if (errmsg.length() > 2000) {
                                errmsg = errmsg.substring(0, 2000);
                            }
                            params2 = new Object[]{errmsg, billList.get(i18).toString()};
                            paramList15.add(params2);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list2);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i18));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info4 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i18).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info4.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list2));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet3.add(billList.get(i18));
                            }
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).settle(list2, true);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg5 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg5) && msg5.length() > 2000) {
                            msg5 = msg5.substring(0, 2000);
                        }
                        params3 = new Object[]{msg5, billList.get(i18).toString()};
                        paramList15.add(params3);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb16 = new StringBuffer();
                    sb16.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb16.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb16.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet3)) {
                    StringBuffer sb17 = new StringBuffer();
                    sb17.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb17.append(StringUtil.buildIn((String)"fid", (Object[])auditSet3.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb17.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList15)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList15);
                }
            }
            if (InterfaceTypeEnum.out_pay_accept_audit_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit_pay.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                HashSet auditSet4 = new HashSet();
                ArrayList<Object[]> paramList16 = new ArrayList<Object[]>();
                for (int i19 = 0; i19 < billList.size(); ++i19) {
                    try {
                        list2 = new ArrayList();
                        list2.add(billList.get(i19));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list2);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i19));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info3 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i19).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info3.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list2));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet4.add(billList.get(i19));
                            }
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).settle(list2, true);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg5 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg5) && msg5.length() > 2000) {
                            msg5 = msg5.substring(0, 2000);
                        }
                        params3 = new Object[]{msg5, billList.get(i19).toString()};
                        paramList16.add(params3);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb18 = new StringBuffer();
                    sb18.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb18.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb18.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet4)) {
                    StringBuffer sb19 = new StringBuffer();
                    sb19.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb19.append(StringUtil.buildIn((String)"fid", (Object[])auditSet4.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb19.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList16)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList16);
                }
            }
            if (InterfaceTypeEnum.out_pay_accept_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit.getName().equals(operatorNumber)) {
                acceptorSet = new HashSet();
                HashSet auditSet5 = new HashSet();
                ArrayList<Object[]> paramList17 = new ArrayList<Object[]>();
                for (int i20 = 0; i20 < billList.size(); ++i20) {
                    try {
                        list2 = new ArrayList();
                        list2.add(billList.get(i20));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list2);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet.add(billList.get(i20));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info3 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i20).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info3.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list2));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet5.add(billList.get(i20));
                            }
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg5 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg5) && msg5.length() > 2000) {
                            msg5 = msg5.substring(0, 2000);
                        }
                        params3 = new Object[]{msg5, billList.get(i20).toString()};
                        paramList17.add(params3);
                    }
                }
                if (!EmptyUtil.isEmpty(acceptorSet)) {
                    StringBuffer sb20 = new StringBuffer();
                    sb20.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb20.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb20.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet5)) {
                    StringBuffer sb21 = new StringBuffer();
                    sb21.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb21.append(StringUtil.buildIn((String)"fid", (Object[])auditSet5.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb21.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList17)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList17);
                }
            }
            if (InterfaceTypeEnum.out_pay_accept_audit_commintBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit_commitBank_link.getName().equals(operatorNumber)) {
                bankSet = new HashSet();
                HashSet acceptorSet2 = new HashSet();
                HashSet auditSet6 = new HashSet();
                ArrayList<Object[]> paramList18 = new ArrayList<Object[]>();
                for (int i21 = 0; i21 < billList.size(); ++i21) {
                    try {
                        list = new ArrayList();
                        list.add(billList.get(i21));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet2.add(billList.get(i21));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info2 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i21).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info2.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet6.add(billList.get(i21));
                            }
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info2 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i21).toString()));
                            PeriodInfo currPeriodInfo2 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info2.getCompany());
                            if (currPeriodInfo2 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info2.getCompany().getId().toString()));
                        } else {
                            currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyID));
                            if (currPeriodInfo == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                        }
                        bankSet.add(billList.get(i21));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg4 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg4) && msg4.length() > 2000) {
                            msg4 = msg4.substring(0, 2000);
                        }
                        params2 = new Object[]{msg4, billList.get(i21).toString()};
                        paramList18.add(params2);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList18)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList18);
                }
                if (!EmptyUtil.isEmpty(acceptorSet2)) {
                    StringBuffer sb22 = new StringBuffer();
                    sb22.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb22.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet2.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb22.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet6)) {
                    StringBuffer sb23 = new StringBuffer();
                    sb23.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb23.append(StringUtil.buildIn((String)"fid", (Object[])auditSet6.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb23.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    StringBuffer sb24 = new StringBuffer();
                    sb24.append("UPDATE T_FS_SettlementBill SET fissmart = ? WHERE");
                    sb24.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb24.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet, 2);
                    if (verifyChongMap != null) {
                        bankSet = (Set)verifyChongMap.get("idSetCorrectNew");
                        resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"518_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + resultChongFuList));
                        chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"519_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i22 = 0; i22 < chongFuSet.size(); ++i22) {
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                bankResult = (BankPayResult)resultChongFuList.get(i22);
                                msg3 = bankResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                                    msg3 = msg3.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg3, bankResult.getId()});
                            }
                        }
                    }
                    try {
                        if (!EmptyUtil.isEmpty(bankSet)) {
                            list = SettleFacadeFactory.getLocalInstance(ctx).commitToBENewBatch(bankSet);
                            success = bankSet.size();
                            for (int i23 = 0; i23 < list.size(); ++i23) {
                                BankPayResult bankPayResult = (BankPayResult)list.get(i23);
                                if (bankPayResult.getErrorDetail() == null) continue;
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                msg2 = bankPayResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                                    msg2 = msg2.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg2, bankPayResult.getId()});
                                bankSet.remove(bankPayResult.getId());
                            }
                            sb = new StringBuffer();
                            if (bankSet != null && bankSet.size() > 0) {
                                sb.append("UPDATE T_FS_SettlementBill SET FCashierID = ? WHERE");
                                sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{casherid});
                            }
                        }
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.out_pay_accept_audit_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_accept_audit_commitBank.getName().equals(operatorNumber)) {
                bankSet = new HashSet();
                HashSet acceptorSet3 = new HashSet();
                HashSet auditSet7 = new HashSet();
                ArrayList<Object[]> paramList19 = new ArrayList<Object[]>();
                for (int i24 = 0; i24 < billList.size(); ++i24) {
                    try {
                        list = new ArrayList();
                        list.add(billList.get(i24));
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet3.add(billList.get(i24));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info2 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i24).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info2.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set(list));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet7.add(billList.get(i24));
                            }
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info2 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i24).toString()));
                            PeriodInfo currPeriodInfo3 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info2.getCompany());
                            if (currPeriodInfo3 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info2.getCompany().getId().toString()));
                        } else {
                            currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyID));
                            if (currPeriodInfo == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                        }
                        bankSet.add(billList.get(i24));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg4 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg4) && msg4.length() > 2000) {
                            msg4 = msg4.substring(0, 2000);
                        }
                        Object[] params6 = new Object[]{msg4, billList.get(i24).toString()};
                        paramList19.add(params6);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList19)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList19);
                }
                if (!EmptyUtil.isEmpty(acceptorSet3)) {
                    StringBuffer sb25 = new StringBuffer();
                    sb25.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb25.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet3.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb25.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet7)) {
                    StringBuffer sb26 = new StringBuffer();
                    sb26.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb26.append(StringUtil.buildIn((String)"fid", (Object[])auditSet7.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb26.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    StringBuffer sb27 = new StringBuffer();
                    sb27.append("UPDATE T_FS_SettlementBill SET fissmart = ? WHERE");
                    sb27.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb27.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet, 2);
                    if (verifyChongMap != null) {
                        bankSet = (Set)verifyChongMap.get("idSetCorrectNew");
                        resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"518_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + resultChongFuList));
                        chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"519_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i25 = 0; i25 < chongFuSet.size(); ++i25) {
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                bankResult = (BankPayResult)resultChongFuList.get(i25);
                                msg3 = bankResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                                    msg3 = msg3.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg3, bankResult.getId()});
                            }
                        }
                    }
                    try {
                        if (!EmptyUtil.isEmpty(bankSet)) {
                            list = SettleFacadeFactory.getLocalInstance(ctx).commitToBENewBatch(bankSet);
                            success = bankSet.size();
                            for (int i26 = 0; i26 < list.size(); ++i26) {
                                BankPayResult bankPayResult = (BankPayResult)list.get(i26);
                                if (bankPayResult.getErrorDetail() == null) continue;
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                msg2 = bankPayResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                                    msg2 = msg2.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg2, bankPayResult.getId()});
                                bankSet.remove(bankPayResult.getId());
                            }
                            sb = new StringBuffer();
                            if (bankSet != null && bankSet.size() > 0) {
                                sb.append("UPDATE T_FS_SettlementBill SET FCashierID = ? WHERE");
                                sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{casherid});
                            }
                        }
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.out_pay_submit_accept_audit_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_commit_accept_audit_commitBank_link.getName().equals(operatorNumber)) {
                bankSet = new HashSet();
                HashSet acceptorSet4 = new HashSet();
                HashSet auditSet8 = new HashSet();
                ArrayList<Object[]> paramList20 = new ArrayList<Object[]>();
                for (int i27 = 0; i27 < billList.size(); ++i27) {
                    try {
                        list = new ArrayList();
                        list.add(billList.get(i27));
                        map = biz.saveBatch(list);
                        String errmsg4 = "";
                        if (map.get("error") != null) {
                            errmsg4 = map.get("error").toString();
                        }
                        if (errmsg4 != null && errmsg4.toString() != null && errmsg4.toString().length() > 0) {
                            if (errmsg4.length() > 2000) {
                                errmsg4 = errmsg4.substring(0, 2000);
                            }
                            params = new Object[]{errmsg4, billList.get(i27).toString()};
                            paramList20.add(params);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet4.add(billList.get(i27));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i27).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set((List)list));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet8.add(billList.get(i27));
                            }
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i27).toString()));
                            PeriodInfo currPeriodInfo4 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
                            if (currPeriodInfo4 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
                        } else {
                            PeriodInfo currPeriodInfo5 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyID));
                            if (currPeriodInfo5 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                        }
                        bankSet.add(billList.get(i27));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg4 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg4) && msg4.length() > 2000) {
                            msg4 = msg4.substring(0, 2000);
                        }
                        Object[] params7 = new Object[]{msg4, billList.get(i27).toString()};
                        paramList20.add(params7);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList20)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList20);
                }
                if (!EmptyUtil.isEmpty(acceptorSet4)) {
                    StringBuffer sb28 = new StringBuffer();
                    sb28.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb28.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet4.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb28.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet8)) {
                    StringBuffer sb29 = new StringBuffer();
                    sb29.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb29.append(StringUtil.buildIn((String)"fid", (Object[])auditSet8.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb29.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    StringBuffer sb30 = new StringBuffer();
                    sb30.append("UPDATE T_FS_SettlementBill SET fissmart = ? WHERE");
                    sb30.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb30.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet, 2);
                    if (verifyChongMap != null) {
                        bankSet = (Set)verifyChongMap.get("idSetCorrectNew");
                        resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"518_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + resultChongFuList));
                        chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"519_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i28 = 0; i28 < chongFuSet.size(); ++i28) {
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                bankResult = (BankPayResult)resultChongFuList.get(i28);
                                msg3 = bankResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                                    msg3 = msg3.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg3, bankResult.getId()});
                            }
                        }
                    }
                    try {
                        if (!EmptyUtil.isEmpty(bankSet)) {
                            list = SettleFacadeFactory.getLocalInstance(ctx).commitToBENewBatch(bankSet);
                            success = bankSet.size();
                            for (int i29 = 0; i29 < list.size(); ++i29) {
                                BankPayResult bankPayResult = (BankPayResult)list.get(i29);
                                if (bankPayResult.getErrorDetail() == null) continue;
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                msg2 = bankPayResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                                    msg2 = msg2.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg2, bankPayResult.getId()});
                                bankSet.remove(bankPayResult.getId());
                            }
                            sb = new StringBuffer();
                            if (bankSet != null && bankSet.size() > 0) {
                                sb.append("UPDATE T_FS_SettlementBill SET FCashierID = ? WHERE");
                                sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{casherid});
                            }
                        }
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.out_pay_submit_accept_audit_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_submit_accept_audit_commitBank.getName().equals(operatorNumber)) {
                bankSet = new HashSet();
                HashSet acceptorSet5 = new HashSet();
                HashSet auditSet9 = new HashSet();
                ArrayList<Object[]> paramList21 = new ArrayList<Object[]>();
                for (int i30 = 0; i30 < billList.size(); ++i30) {
                    try {
                        list = new ArrayList();
                        list.add(billList.get(i30));
                        map = biz.saveBatch(list);
                        String errmsg5 = "";
                        if (map.get("error") != null) {
                            errmsg5 = map.get("error").toString();
                        }
                        if (errmsg5 != null && errmsg5.toString() != null && errmsg5.toString().length() > 0) {
                            if (errmsg5.length() > 2000) {
                                errmsg5 = errmsg5.substring(0, 2000);
                            }
                            params = new Object[]{errmsg5, billList.get(i30).toString()};
                            paramList21.add(params);
                            continue;
                        }
                        SettleFacadeFactory.getLocalInstance(ctx).accept(list);
                        if (!EmptyUtil.isEmpty((String)acceptor)) {
                            acceptorSet5.add(billList.get(i30));
                        }
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i30).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            SettleFacadeFactory.getLocalInstance(ctx).approve(FMHelper.list2Set((List)list));
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet9.add(billList.get(i30));
                            }
                        }
                        bankSet.add(billList.get(i30));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        msg4 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg4) && msg4.length() > 2000) {
                            msg4 = msg4.substring(0, 2000);
                        }
                        Object[] params8 = new Object[]{msg4, billList.get(i30).toString()};
                        paramList21.add(params8);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList21)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList21);
                }
                if (!EmptyUtil.isEmpty(acceptorSet5)) {
                    StringBuffer sb31 = new StringBuffer();
                    sb31.append("UPDATE T_FS_SettlementBill SET FAcceptorID = ? WHERE");
                    sb31.append(StringUtil.buildIn((String)"fid", (Object[])acceptorSet5.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb31.toString(), (Object[])new Object[]{acceptor});
                }
                if (!EmptyUtil.isEmpty(auditSet9)) {
                    StringBuffer sb32 = new StringBuffer();
                    sb32.append("UPDATE T_FS_SettlementBill SET FAUDITORID = ? WHERE");
                    sb32.append(StringUtil.buildIn((String)"fid", (Object[])auditSet9.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb32.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    StringBuffer sb33 = new StringBuffer();
                    sb33.append("UPDATE T_FS_SettlementBill SET fissmart = ? WHERE");
                    sb33.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb33.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet, 2);
                    if (verifyChongMap != null) {
                        bankSet = (Set)verifyChongMap.get("idSetCorrectNew");
                        resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"518_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + resultChongFuList));
                        chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"519_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i31 = 0; i31 < chongFuSet.size(); ++i31) {
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                bankResult = (BankPayResult)resultChongFuList.get(i31);
                                msg3 = bankResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                                    msg3 = msg3.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg3, bankResult.getId()});
                            }
                        }
                    }
                    try {
                        if (!EmptyUtil.isEmpty(bankSet)) {
                            list = SettleFacadeFactory.getLocalInstance(ctx).commitToBENewBatch(bankSet);
                            success = bankSet.size();
                            for (int i32 = 0; i32 < list.size(); ++i32) {
                                BankPayResult bankPayResult = (BankPayResult)list.get(i32);
                                if (bankPayResult.getErrorDetail() == null) continue;
                                failMsg2 = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                msg2 = bankPayResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                                    msg2 = msg2.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg2, bankPayResult.getId()});
                                bankSet.remove(bankPayResult.getId());
                            }
                            sb = new StringBuffer();
                            if (bankSet != null && bankSet.size() > 0) {
                                sb.append("UPDATE T_FS_SettlementBill SET FCashierID = ? WHERE");
                                sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{casherid});
                            }
                        }
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.out_pay_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_commitBank_link.getName().equals(operatorNumber)) {
                bankSet = new HashSet();
                ArrayList<Object[]> paramList22 = new ArrayList<Object[]>();
                for (int i33 = 0; i33 < billList.size(); ++i33) {
                    try {
                        ArrayList list9 = new ArrayList();
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            SettlementBillInfo info6 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i33).toString()));
                            PeriodInfo currPeriodInfo6 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info6.getCompany());
                            if (currPeriodInfo6 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info6.getCompany().getId().toString()));
                        } else {
                            PeriodInfo currPeriodInfo7 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyID));
                            if (currPeriodInfo7 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                        }
                        list9.add(billList.get(i33));
                        bankSet.add(billList.get(i33));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        String msg8 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg8) && msg8.length() > 2000) {
                            msg8 = msg8.substring(0, 2000);
                        }
                        params5 = new Object[]{msg8, billList.get(i33).toString()};
                        paramList22.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList22)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList22);
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    StringBuffer sb34 = new StringBuffer();
                    sb34.append("UPDATE T_FS_SettlementBill SET fissmart = ? WHERE");
                    sb34.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb34.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet, 2);
                    if (verifyChongMap != null) {
                        bankSet = (Set)verifyChongMap.get("idSetCorrectNew");
                        ArrayList resultChongFuList2 = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"518_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + resultChongFuList2));
                        Set chongFuSet2 = new LinkedHashSet();
                        chongFuSet2 = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"519_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + chongFuSet2));
                        if (chongFuSet2 != null && chongFuSet2.size() > 0 && resultChongFuList2 != null && resultChongFuList2.size() > 0) {
                            for (int i34 = 0; i34 < chongFuSet2.size(); ++i34) {
                                failMsg = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                BankPayResult bankResult2 = (BankPayResult)resultChongFuList2.get(i34);
                                msg = bankResult2.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                                    msg = msg.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg.toString(), (Object[])new Object[]{msg, bankResult2.getId()});
                            }
                        }
                    }
                    try {
                        if (!EmptyUtil.isEmpty(bankSet)) {
                            ArrayList resultListNormal = SettleFacadeFactory.getLocalInstance(ctx).commitToBENewBatch(bankSet);
                            success = bankSet.size();
                            HashSet<String> failIdSet = new HashSet<String>();
                            for (int j = 0; j < resultListNormal.size(); ++j) {
                                BankPayResult resultInfo = (BankPayResult)resultListNormal.get(j);
                                if (resultInfo.getErrorDetail() == null) continue;
                                failIdSet.add(resultInfo.getId().toString());
                                failure = failure++;
                                errorMsg = errorMsg + resultInfo.getErrorDetail();
                            }
                            bankSet.removeAll(failIdSet);
                            if (!EmptyUtil.isEmpty(bankSet)) {
                                StringBuffer sb35 = new StringBuffer();
                                sb35.append("UPDATE T_FS_SettlementBill SET FCashierID = ? WHERE");
                                sb35.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                                DbUtil.execute((Context)ctx, (String)sb35.toString(), (Object[])new Object[]{casherid});
                            }
                        }
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.out_pay_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.link_pay_commitBank.getName().equals(operatorNumber)) {
                bankSet = new HashSet();
                ArrayList<Object[]> paramList23 = new ArrayList<Object[]>();
                for (int i35 = 0; i35 < billList.size(); ++i35) {
                    try {
                        ArrayList list10 = new ArrayList();
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            SettlementBillInfo info7 = biz.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i35).toString()));
                            PeriodInfo currPeriodInfo8 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info7.getCompany());
                            if (currPeriodInfo8 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(info7.getCompany().getId().toString()));
                        } else {
                            PeriodInfo currPeriodInfo9 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyID));
                            if (currPeriodInfo9 == null) {
                                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
                            }
                        }
                        list10.add(billList.get(i35));
                        bankSet.add(billList.get(i35));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        String msg9 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg9) && msg9.length() > 2000) {
                            msg9 = msg9.substring(0, 2000);
                        }
                        Object[] params9 = new Object[]{msg9, billList.get(i35).toString()};
                        paramList23.add(params9);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList23)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList23);
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    StringBuffer sb36 = new StringBuffer();
                    sb36.append("UPDATE T_FS_SettlementBill SET fissmart = ? WHERE");
                    sb36.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb36.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet, 2);
                    if (verifyChongMap != null) {
                        bankSet = (Set)verifyChongMap.get("idSetCorrectNew");
                        ArrayList resultChongFuList3 = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"518_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + resultChongFuList3));
                        Set chongFuSet3 = new LinkedHashSet();
                        chongFuSet3 = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"519_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + chongFuSet3));
                        if (chongFuSet3 != null && chongFuSet3.size() > 0 && resultChongFuList3 != null && resultChongFuList3.size() > 0) {
                            for (int i36 = 0; i36 < chongFuSet3.size(); ++i36) {
                                failMsg = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                BankPayResult bankResult3 = (BankPayResult)resultChongFuList3.get(i36);
                                msg = bankResult3.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                                    msg = msg.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg.toString(), (Object[])new Object[]{msg, bankResult3.getId()});
                            }
                        }
                    }
                    try {
                        if (!EmptyUtil.isEmpty(bankSet)) {
                            ArrayList list11 = SettleFacadeFactory.getLocalInstance(ctx).commitToBENewBatch(bankSet);
                            success = bankSet.size();
                            for (int i37 = 0; i37 < list11.size(); ++i37) {
                                BankPayResult bankPayResult = (BankPayResult)list11.get(i37);
                                if (bankPayResult.getErrorDetail() == null) continue;
                                failMsg = new StringBuffer(" UPDATE T_FS_SettlementBill SET fsettleFailMsg = ? where fid = ? ");
                                String msg10 = bankPayResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg10) && msg10.length() > 2000) {
                                    msg10 = msg10.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg.toString(), (Object[])new Object[]{msg10, bankPayResult.getId()});
                                bankSet.remove(bankPayResult.getId());
                            }
                            StringBuffer sb37 = new StringBuffer();
                            if (bankSet != null && bankSet.size() > 0) {
                                sb37.append("UPDATE T_FS_SettlementBill SET FCashierID = ? WHERE");
                                sb37.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                                DbUtil.execute((Context)ctx, (String)sb37.toString(), (Object[])new Object[]{casherid});
                            }
                        }
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        logger.error((Object)("===" + errorMsg));
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }

    public Map verifyChongFuNew(Context ctx, Set idSetCorrectNew, int actionType) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedHashSet<String> chongFuSet = new LinkedHashSet<String>();
        LinkedHashMap allCompanyIdMap = new LinkedHashMap();
        LinkedHashMap<String, SettlementBillInfo> allCompanyInfoMap = new LinkedHashMap<String, SettlementBillInfo>();
        ArrayList<BankPayResult> resultChongFuList = new ArrayList<BankPayResult>();
        ArrayList idSetCorrectNewList = new ArrayList(idSetCorrectNew);
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        Map resultMap = iSettlementBill.verifyChongFuNew(idSetCorrectNewList, actionType);
        if (resultMap != null && resultMap.size() > 0) {
            for (Object companyId : resultMap.keySet()) {
                HashMap map = (HashMap)resultMap.get(companyId);
                if (map.containsKey("days") && !EmptyUtil.isEmpty(map.get("days"))) {
                    map.remove("days");
                }
                if (map.containsKey("isCS128") && !EmptyUtil.isEmpty(map.get("isCS128"))) {
                    map.remove("isCS128");
                }
                allCompanyIdMap.putAll(map);
                HashSet allIdSet = new HashSet();
                for (Object id : map.keySet()) {
                    allIdSet.add(id);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", allIdSet, CompareType.INCLUDE));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("company.number"));
                sic.add(new SelectorItemInfo("amount"));
                sic.add(new SelectorItemInfo("currency.precision"));
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                view.getSorter().add(item);
                view.setSelector(sic);
                view.setFilter(filter);
                SettlementBillCollection coll = iSettlementBill.getSettlementBillCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    allCompanyInfoMap.put(coll.get(i).getId().toString(), coll.get(i));
                }
                for (Object id : map.keySet()) {
                    SettlementBillInfo info = (SettlementBillInfo)allCompanyInfoMap.get(id);
                    List likedIdAndNumList = (List)map.get(id);
                    StringBuffer messageOne = new StringBuffer();
                    chongFuSet.add(id.toString());
                    String repeatNumber = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"136_CasPaymentPayRepeat", (Object[])new Object[]{info.getNumber(), info.getPayerAmount()});
                    messageOne.append(info.getCompany().getName() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"137_Down") + repeatNumber + "\n");
                    for (int i = 0; i < likedIdAndNumList.size(); ++i) {
                        String likedIdAndNum = (String)likedIdAndNumList.get(i);
                        String[] likedIdAndNumArr = likedIdAndNum.split(";");
                        messageOne.append(likedIdAndNumArr[1] + "     ");
                    }
                    messageOne.append("\n");
                }
            }
        }
        if (chongFuSet.size() > 0) {
            for (String id : chongFuSet) {
                SettlementBillInfo info = (SettlementBillInfo)allCompanyInfoMap.get(id);
                BankPayResult resultInfo = new BankPayResult();
                resultInfo.setId(id);
                resultInfo.setNumber(info.getNumber());
                StringBuffer errorDetail = new StringBuffer();
                List likedIdAndNumList = (List)allCompanyIdMap.get(id);
                StringBuffer newDetail = new StringBuffer();
                BigDecimal actPayAmt = Constants.ZERO;
                for (int i = 0; i < likedIdAndNumList.size(); ++i) {
                    String likedIdAndNum = (String)likedIdAndNumList.get(i);
                    String[] likedIdAndNumArr = likedIdAndNum.split(";");
                    newDetail.append(likedIdAndNumArr[1] + "     ");
                }
                int precision = info.getCurrency().getPrecision();
                BigDecimal actPayAmtShow = info.getAmount().multiply(new BigDecimal(1)).setScale(precision, 4);
                NumberFormat nf = NumberFormat.getCurrencyInstance();
                nf.setMinimumFractionDigits(precision);
                String replace = nf.format(actPayAmtShow).replace("\uffe5", "");
                errorDetail.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"460_SettlementBillListUI", (Locale)ctx.getLocale()) + info.getCompany().getName() + "\uff0c");
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"139_MayBeChongFu", (Object[])new Object[]{replace}));
                errorDetail.append("\n");
                errorDetail.append(newDetail.toString());
                errorDetail.append("\n");
                resultInfo.setErrorDetail(errorDetail.toString());
                resultChongFuList.add(resultInfo);
            }
            idSetCorrectNew.removeAll(chongFuSet);
        }
        result.put("idSetCorrectNew", idSetCorrectNew);
        result.put("chongFuSet", chongFuSet);
        result.put("resultChongFuList", resultChongFuList);
        result.put("allCompanyIdMap", allCompanyIdMap);
        return result;
    }
}

