/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.ORMEngine;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.utils.BankVCUtil;
import com.kingdee.eas.fi.cas.vo.BankVCFilterVO;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.be.app.util.EReceiptJDBC;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryFactory;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.app.AbstractSubsidiaryLedgerControllerBean;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubsidiaryLedgerControllerBean
extends AbstractSubsidiaryLedgerControllerBean {
    private static Logger logger = Logger.getLogger((String)SubsidiaryLedgerControllerBean.class.getName());

    @Override
    protected BigDecimal _getBalance(Context ctx, String innerId, Date date, String currencyId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select top 1 FEndBalance as balance, FEndBalanceDC as direction from T_FS_SummaryLedger where ");
        sql.append("FInnerAccountID='" + innerId + "'");
        sql.append(" and FBizDate<'" + TypeConversionUtils.objToDate((Object)date) + "'");
        sql.append(" order by  FBizDate desc");
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = exec.executeSQL();
        try {
            if (rs.next()) {
                int direciton = rs.getInt("direction");
                BigDecimal balance = rs.getBigDecimal("balance");
                if (com.kingdee.eas.basedata.master.account.BalanceDirectionEnum.CREDIT.getValue() == direciton) {
                    balance = balance.negate();
                }
                return balance;
            }
            return new BigDecimal("0");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected BigDecimal _getBizTotal(Context ctx, String innerId, Date dateFrom, Date dateTo, com.kingdee.eas.basedata.master.account.BalanceDirectionEnum direction, String currencyId) throws BOSException, EASBizException {
        StringBuffer sql = null;
        sql = direction.equals((Object)com.kingdee.eas.basedata.master.account.BalanceDirectionEnum.DEBIT) ? new StringBuffer("select sum(FDebitTotal) as Sum from T_FS_SummaryLedger where") : new StringBuffer("select sum(FCreditTotal) as Sum from T_FS_SummaryLedger where");
        sql.append(" 1=1 ");
        if (innerId != null) {
            sql.append("and FInnerAccountID='" + innerId + "'");
        }
        if (dateFrom != null) {
            sql.append("and FBizDate >='" + TypeConversionUtils.objToDate((Object)dateFrom) + "'");
        }
        if (dateTo != null) {
            sql.append(" and FBizDate<'" + TypeConversionUtils.objToDate((Object)dateTo) + "'");
        }
        if (currencyId != null) {
            sql.append(" and FCurrencyID='" + currencyId + "'");
        }
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = exec.executeSQL();
        try {
            if (rs.next()) {
                BigDecimal sum = rs.getBigDecimal("sum");
                if (sum == null) {
                    sum = new BigDecimal("0");
                }
                return sum;
            }
            return new BigDecimal("0");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected int _getBizCount(Context ctx, String innerId, Date dateFrom, Date dateTo, com.kingdee.eas.basedata.master.account.BalanceDirectionEnum direction, String currencyId) throws BOSException, EASBizException {
        StringBuffer sql = null;
        sql = direction.equals((Object)com.kingdee.eas.basedata.master.account.BalanceDirectionEnum.DEBIT) ? new StringBuffer("select sum(FDebitCounts) as count from T_FS_SummaryLedger where") : new StringBuffer("select sum(FCreditCounts) as count from T_FS_SummaryLedger where");
        sql.append(" 1=1 ");
        if (innerId != null) {
            sql.append("and FInnerAccountID='" + innerId + "'");
        }
        if (dateFrom != null) {
            sql.append("and FBizDate >='" + TypeConversionUtils.objToDate((Object)dateFrom) + "'");
        }
        if (dateTo != null) {
            sql.append("and FBizDate<'" + TypeConversionUtils.objToDate((Object)dateTo) + "'");
        }
        if (currencyId != null) {
            sql.append("and FCurrencyID='" + currencyId + "'");
        }
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = exec.executeSQL();
        try {
            if (rs.next()) {
                return rs.getInt("count");
            }
            return 0;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _book(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        this.checkisDailySettle(ctx);
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String key = company.getId().toString() + "_SubsidiaryLedgerBook";
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean result = iMutex.requestObjIDForUpdate(key);
        try {
            for (int i = 0; i < coll.size(); ++i) {
                SubsidiaryLedgerInfo sub = (SubsidiaryLedgerInfo)coll.getObject(i);
                if (sub.getBillId() != null) {
                    this._cancelBook(ctx, sub.getBillId().toString());
                }
                sub.setDate(DateTimeUtils.truncateDate((Date)sub.getDate()));
                sub.setCreateTime(new Timestamp(System.currentTimeMillis()));
                sub.setSeq(i);
                sub.setIsCreateInnerEReceipt(false);
                this.verifyBookSubsidiaryLedger(ctx, sub);
            }
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)coll);
        }
        finally {
            if (result) {
                iMutex.releaseObjIDForUpdate(key);
            }
        }
    }

    private void checkisDailySettle(Context ctx) throws BOSException, FSException {
        boolean isDailySettle = false;
        try {
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String sql = "select * From T_FS_DailySettleBatch WHERE FCompanyId = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString()});
            if (rs.next()) {
                isDailySettle = rs.getBoolean("FisDailySettle");
            } else {
                Timestamp currTime = new Timestamp(System.currentTimeMillis());
                UserInfo handler = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                sql = "insert into T_FS_DailySettleBatch (FCompanyId, FisDailySettle, FLastUpdateUserID, FlastUpdateTime) VALUES ( ?, ?, ?, ?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), new Integer(0), StringUtils.cnulls((String)ConvertUtils.IDSTR((Object)handler)), currTime});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)e);
        }
        if (isDailySettle) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"DailySettleNow", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"notAllowBook", (Locale)ctx.getLocale());
            throw new FSException(FSException.COMMON, new String[]{msg});
        }
    }

    private void checkisDailySettleWithCom(Context ctx, CompanyOrgUnitInfo company) throws BOSException, FSException {
        boolean isDailySettle = false;
        try {
            String sql = "select * From T_FS_DailySettleBatch WHERE FCompanyId = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString()});
            if (rs.next()) {
                isDailySettle = rs.getBoolean("FisDailySettle");
            } else {
                Timestamp currTime = new Timestamp(System.currentTimeMillis());
                UserInfo handler = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                sql = "insert into T_FS_DailySettleBatch (FCompanyId, FisDailySettle, FLastUpdateUserID, FlastUpdateTime) VALUES ( ?, ?, ?, ?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), new Integer(0), StringUtils.cnulls((String)ConvertUtils.IDSTR((Object)handler)), currTime});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)e);
        }
        if (isDailySettle) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"DailySettleNow", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"notAllowBook", (Locale)ctx.getLocale());
            throw new FSException(FSException.COMMON, new String[]{msg});
        }
    }

    private void verifyAntiBookSubsidiaryLedger(Context ctx, SubsidiaryLedgerInfo sub) throws EASBizException, BOSException {
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, null);
        if (clearingHouse == null) {
            clearingHouse = FSHelper.getClearingHouseInfo(ctx, sub.getCompany().getId().toString());
        }
        if (!clearingHouse.isUsed()) {
            throw new FSException(FSException.CLEARINGHOUSENOTUSED);
        }
        if (clearingHouse.getSettleDate().compareTo(sub.getDate()) > 0) {
            throw new FSException(FSException.DATENOTSUITCHSETTLEDDATE, new Object[]{clearingHouse.getSettleDate(), sub.getDate()});
        }
        if (sub.isIsDownLoad()) {
            throw new FSException(FSException.SUBHASDOWNLOAD);
        }
    }

    private void verifyAntiBookSubsidiaryLedger(Context ctx, SubsidiaryLedgerInfo sub, String companyId) throws EASBizException, BOSException {
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (!clearingHouse.isUsed()) {
            throw new FSException(FSException.CLEARINGHOUSENOTUSED);
        }
        if (clearingHouse.getSettleDate().compareTo(sub.getDate()) > 0) {
            throw new FSException(FSException.DATENOTSUITCHSETTLEDDATE, new Object[]{clearingHouse.getSettleDate(), sub.getDate()});
        }
        if (sub.isIsDownLoad()) {
            throw new FSException(FSException.SUBHASDOWNLOAD);
        }
    }

    private void verifyBookSubsidiaryLedger(Context ctx, SubsidiaryLedgerInfo sub) throws EASBizException, BOSException {
        BigDecimal creditAmount;
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, sub.getCompany().getId().toString());
        if (!clearingHouse.isUsed()) {
            throw new FSException(FSException.CLEARINGHOUSENOTUSED);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)sub, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)sub, (String)"applyUnit");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)sub, (String)"innerAccount");
        if (!sub.getDate().after(clearingHouse.getSettleDate())) {
            sub.setDate(DateTimeUtils.truncateDate((Date)clearingHouse.getSettleDate()));
        }
        BigDecimal debitAmount = sub.getDebitAmount();
        if (debitAmount == null) {
            sub.setDebitAmount(SysConstant.BIGZERO);
        }
        if ((creditAmount = sub.getCreditAmount()) == null) {
            sub.setCreditAmount(SysConstant.BIGZERO);
        }
        sub.setLocalAmount(SysConstant.BIGZERO);
        if (sub.getDebitAmount().equals(SysConstant.BIGZERO) && sub.getCreditAmount().equals(SysConstant.BIGZERO)) {
            throw new FSException(FSException.AMOUNTALLZERO);
        }
    }

    private CompanyOrgUnitInfo getBillCompany(Context ctx, String billId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        String bosType = BOSUuid.read((String)billId).getType().toString();
        if (new TransUpBillInfo().getBOSType().toString().equals(bosType)) {
            TransUpBillInfo transUpInfo = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(billId));
            company = transUpInfo.getCompany();
        } else if (new TransUpBillEntryInfo().getBOSType().toString().equals(bosType)) {
            TransUpBillEntryInfo transUpEntryInfo = TransUpBillEntryFactory.getLocalInstance(ctx).getTransUpBillEntryInfo((IObjectPK)new ObjectUuidPK(billId));
            String tranUpId = transUpEntryInfo.getParent().getId().toString();
            TransUpBillInfo transUpInfo = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(tranUpId));
            company = transUpInfo.getCompany();
        } else if (new TransDownBillInfo().getBOSType().toString().equals(bosType)) {
            TransDownBillInfo transDownInfo = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(billId));
            company = transDownInfo.getCompany();
        } else if (new TransDownBillEntryInfo().getBOSType().toString().equals(bosType)) {
            TransDownBillEntryInfo transDownEntryInfo = TransDownBillEntryFactory.getLocalInstance(ctx).getTransDownBillEntryInfo((IObjectPK)new ObjectUuidPK(billId));
            String tranDownId = transDownEntryInfo.getParent().getId().toString();
            TransDownBillInfo transDownInfo = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(tranDownId));
            company = transDownInfo.getCompany();
        } else if (new SettlementBillInfo().getBOSType().toString().equals(bosType)) {
            SettlementBillInfo settlementBillInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId));
            company = settlementBillInfo.getCompany();
        } else {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        return company;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _cancelBook(Context ctx, String billId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.getBillCompany(ctx, billId);
        this.checkisDailySettleWithCom(ctx, company);
        String key = company.getId().toString() + "_SubsidiaryLedgerBook";
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean result = iMutex.requestObjIDForUpdate(key);
        try {
            iMutex.requestObjIDForUpdate(key);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
            view.setFilter(filter);
            SubsidiaryLedgerCollection coll = this.getSubsidiaryLedgerCollection(ctx, view);
            for (int i = 0; i < coll.size(); ++i) {
                SubsidiaryLedgerInfo sub = coll.get(i);
                ProcessInstInfo[] procInsts = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(billId);
                if (procInsts != null && procInsts.length != 0) {
                    BillBaseInfo billBaseInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(billId);
                    if (billBaseInfo != null) {
                        this.verifyAntiBookSubsidiaryLedger(ctx, sub, billBaseInfo.getCompany().getId().toString());
                    }
                } else {
                    this.verifyAntiBookSubsidiaryLedger(ctx, sub);
                }
                if (sub.getInnerEReceiptId() == null) continue;
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"520_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()));
                this.deleteInnerEReceipt(ctx, sub.getInnerEReceiptId());
            }
            ISubsidiaryLedger iSub = SubsidiaryLedgerFactory.getLocalInstance(ctx);
            iSub.delete(filter);
        }
        finally {
            if (result) {
                iMutex.releaseObjIDForUpdate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _book(Context ctx, String billId, String providerName) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.getBillCompany(ctx, billId);
        this.checkisDailySettleWithCom(ctx, company);
        String key = company.getId().toString() + "_SubsidiaryLedgerBook";
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean result = iMutex.requestObjIDForUpdate(key);
        try {
            logger.info((Object)"SubsidiaryLedgerControllerBean._book()");
            ISubsidiaryBookProvider provider = null;
            try {
                provider = (ISubsidiaryBookProvider)Class.forName(providerName).newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort();
            }
            SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
            if (provider != null) {
                coll = provider.getCollection(ctx, billId);
            }
            SubsidiaryLedgerInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = (SubsidiaryLedgerInfo)coll.getObject(i);
                info.setDate(DateTimeUtils.truncateDate((Date)info.getDate()));
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                InnerAccountInfo tmpInfo = (InnerAccountInfo)InnerAccountFactory.getLocalInstance(ctx).getDataBaseInfo((IObjectPK)new ObjectUuidPK(info.getInnerAccount().getId()));
                if (tmpInfo != null) {
                    info.setApplyUnit(tmpInfo.getApplyUnit());
                } else {
                    String sql = "select fApplyUnitid from T_FS_InnerAccount where fid = ?";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getInnerAccount().getId()});
                    try {
                        String fApplyUnitid;
                        if (rs.next() && !EmptyUtil.isEmpty((String)(fApplyUnitid = rs.getString("fApplyUnitid")))) {
                            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                            CompanyOrgUnitInfo applyCompany = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fApplyUnitid));
                            info.setApplyUnit(applyCompany);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                info.setApplyUnit(tmpInfo.getApplyUnit());
                info.setSeq(i);
                info.setIsCreateInnerEReceipt(false);
                this.verifyBookSubsidiaryLedger(ctx, info);
            }
            String srcBillId = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                srcBillId = coll.get(i).getBillId().toString();
                this._cancelBook(ctx, srcBillId);
            }
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)coll);
        }
        finally {
            if (result) {
                iMutex.releaseObjIDForUpdate(key);
            }
        }
    }

    private String createSubsidiaryLedgerHistoryTempTable(Context ctx) throws BOSException {
        String tableName = "";
        try {
            ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tableName = mang.getTableName("SubsidiaryLedgerList");
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        StringBuffer sbCreate = new StringBuffer("create table ");
        sbCreate.append(tableName);
        sbCreate.append(" ( ");
        sbCreate.append("FID varchar (44), ");
        sbCreate.append("FCompanyID varchar (44), ");
        sbCreate.append("FInnerAccountID varchar (44), ");
        sbCreate.append("FDate DateTime, ");
        sbCreate.append("FCreateTime DateTime, ");
        sbCreate.append("FSeq INT DEFAULT 0, ");
        sbCreate.append("FBillNumber NVARCHAR(80), ");
        sbCreate.append("FDebitAmount NUMERIC(17,4), ");
        sbCreate.append("FCurrencyID varchar (44), ");
        sbCreate.append("FYear NVARCHAR(4), ");
        sbCreate.append("Fmonth NVARCHAR(2), ");
        sbCreate.append("FDescription NVARCHAR(255), ");
        sbCreate.append("FCreditAmount NUMERIC(17,4), ");
        sbCreate.append("FBalance NUMERIC(17,4), ");
        sbCreate.append("FGroup int NOT NULL");
        sbCreate.append(")");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbCreate.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        return tableName;
    }

    private String getSelectBankStatementSQL(BankVCFilterVO filterVO) {
        StringBuffer oqlA = new StringBuffer();
        oqlA.append("SELECT FID FROM T_CAS_BankStatement WHERE FcurrencyID = '");
        oqlA.append(filterVO.getCurrency().getId().toString());
        oqlA.append("' AND FAccountBankID = '");
        oqlA.append(filterVO.getAcctBank().getId().toString());
        oqlA.append("'");
        oqlA.append(" AND FCreateDate >= {");
        oqlA.append(BankVCUtil.dateFormat.format(filterVO.getStartDate())).append("}");
        oqlA.append(" AND FCreateDate <= {");
        oqlA.append(BankVCUtil.dateFormat.format(filterVO.getEndDate()));
        oqlA.append("}");
        return oqlA.toString();
    }

    private BigDecimal getBalance(Context ctx, IMetaDataPK mainQueryPK, SubsidiaryLedgerFilterParam param, Date dateFrom, String companyNumber, BOSUuid currencyId, String innerNumber, BankInfo clearingHouseParam) throws EASBizException, BOSException, SQLException {
        IInAcct iInAcct = InAcctFactory.getLocalInstance(ctx);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currencyInfo = null;
        currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        String currencyNumber = currencyInfo.getNumber();
        BigDecimal adjustBalance = this.getAdjustBalance(ctx, mainQueryPK, innerNumber, currencyId.toString(), dateFrom, clearingHouseParam);
        dateFrom = this.adjustDate(dateFrom, clearingHouseParam);
        BigDecimal balance = iInAcct.inAcct(companyNumber, innerNumber, currencyNumber, dateFrom, null, InAcctDataTypeEnum.C);
        balance = balance.add(adjustBalance);
        return balance;
    }

    private BigDecimal getAdjustBalance(Context ctx, IMetaDataPK mainQueryPK, String innerAcctNumber, String currencyId, Date from, BankInfo clearingHouseParam) throws SQLException, BOSException, EASBizException {
        Date settDate;
        HashSet<String> innerAcctSet = new HashSet<String>();
        if (innerAcctNumber.indexOf(",") == -1) {
            innerAcctSet.add(innerAcctNumber);
        } else {
            String[] innerAcctArray = innerAcctNumber.split(",");
            for (int i = 0; i < innerAcctArray.length; ++i) {
                innerAcctSet.add(innerAcctArray[i]);
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("innerAccount.number", innerAcctSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        ev.setFilter(fi);
        if (clearingHouseParam == null) {
            clearingHouseParam = FSClientHelper.getClearingHouse();
        }
        if ((settDate = clearingHouseParam.getSettleDate()) == null) {
            return Constants.ZERO;
        }
        if (!from.after(settDate)) {
            return Constants.ZERO;
        }
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)settDate, CompareType.GREATER_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)DateTimeUtils.truncateDate((Date)from), CompareType.LESS));
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" SUM(DEBITAMOUNT)-SUM(CREDITAMOUNT) AS BALANCE");
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        BigDecimal result = null;
        if (rs.next()) {
            result = rs.getBigDecimal("BALANCE");
        }
        if (result == null) {
            result = Constants.ZERO;
        }
        return result;
    }

    private Date adjustDate(Date date, BankInfo clearingHouseParam) {
        if (clearingHouseParam == null) {
            try {
                clearingHouseParam = FSClientHelper.getClearingHouse();
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        Date openDate = clearingHouseParam.getOpenDate();
        Date settDate = clearingHouseParam.getSettleDate();
        if (settDate == null) {
            return null;
        }
        if (date.before(openDate)) {
            return openDate;
        }
        if (date.after(settDate)) {
            return settDate;
        }
        return DateTimeUtils.truncateDate((Date)date);
    }

    @Override
    protected Map _generateTempTableData(Context ctx, HashMap subsidiaryLedgerFilterParams) throws BOSException, EASBizException {
        HashMap<String, Object> gridData = new HashMap<String, Object>();
        try {
            String dayTotalDataSql;
            IRowSet rsDayTotalDataRowSet;
            BigDecimal balance = Constants.ZERO;
            IMetaDataPK mainQueryPK = (IMetaDataPK)subsidiaryLedgerFilterParams.get("mainQueryPK");
            SubsidiaryLedgerFilterParam subsidiaryLedgerFilterParam = (SubsidiaryLedgerFilterParam)subsidiaryLedgerFilterParams.get("param");
            Date balanceUseDate = (Date)subsidiaryLedgerFilterParams.get("date");
            String companyNumber = (String)subsidiaryLedgerFilterParams.get("companyNumber");
            BOSUuid currencyIdBosUuid = (BOSUuid)subsidiaryLedgerFilterParams.get("currencyIdBosUuid");
            String acctNumber = (String)subsidiaryLedgerFilterParams.get("acctNumber");
            BankInfo clearingHouseParam = (BankInfo)subsidiaryLedgerFilterParams.get("clearingHouseParam");
            try {
                balance = this.getBalance(ctx, mainQueryPK, subsidiaryLedgerFilterParam, balanceUseDate, companyNumber, currencyIdBosUuid, acctNumber, clearingHouseParam);
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            gridData.put("balance", balance);
            Date fromDate = (Date)subsidiaryLedgerFilterParams.get("fromDate");
            Date toDate = (Date)subsidiaryLedgerFilterParams.get("toDate");
            String companyId = (String)subsidiaryLedgerFilterParams.get("companyId");
            String currencyId = (String)subsidiaryLedgerFilterParams.get("currencyId");
            Set acctIdSet = (Set)subsidiaryLedgerFilterParams.get("acctIdSet");
            String acctIds = new String();
            Iterator iter = acctIdSet.iterator();
            int i = 0;
            while (iter.hasNext()) {
                String accountId = "'" + iter.next().toString() + "'";
                acctIds = i == 0 ? acctIds + accountId : acctIds + "," + accountId;
                ++i;
            }
            boolean isDispBalance = (Boolean)subsidiaryLedgerFilterParams.get("isDispBalance");
            ArrayList<Object[]> balanceParamList = new ArrayList<Object[]>();
            String tableName = null;
            tableName = this.createSubsidiaryLedgerHistoryTempTable(ctx);
            StringBuffer subsidiaryLedgerSql = new StringBuffer();
            subsidiaryLedgerSql.append("SELECT FID,FCompanyID,FCurrencyID,FInnerAccountID,FDate,FCreateTime,FSeq,FBillNumber,FDebitAmount,FDescription,FCreditAmount,1 FROM T_FS_SubsidiaryLedger WHERE FDate  >= {");
            subsidiaryLedgerSql.append(BankVCUtil.timeFormat.format(fromDate)).append("}");
            subsidiaryLedgerSql.append(" AND FDate <= {");
            subsidiaryLedgerSql.append(BankVCUtil.timeFormat.format(toDate)).append("}");
            subsidiaryLedgerSql.append(" AND FCompanyID = '");
            subsidiaryLedgerSql.append(companyId);
            subsidiaryLedgerSql.append("' AND FCurrencyID = '");
            subsidiaryLedgerSql.append(currencyId);
            subsidiaryLedgerSql.append("' AND FInnerAccountID IN ( ");
            subsidiaryLedgerSql.append(acctIds);
            subsidiaryLedgerSql.append(") ");
            subsidiaryLedgerSql.append("order by FCompanyID,FInnerAccountID,FDate,FCreateTime,FSeq,FBillNumber,FDebitAmount");
            String insertTempDataSql = "INSERT INTO " + tableName + "(FID,FCompanyID,FCurrencyID,FInnerAccountID,FDate,FCreateTime,FSeq,FBillNumber,FDebitAmount,FDescription,FCreditAmount,FGroup) (" + subsidiaryLedgerSql.toString() + ")";
            Connection connection = null;
            PreparedStatement ps = null;
            try {
                connection = this.getConnection(ctx);
                ps = connection.prepareStatement(insertTempDataSql);
                ps.execute();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)connection);
            gridData.put("tableName", tableName);
            String keyCountSql = "SELECT COUNT(*) NUM FROM " + tableName;
            IRowSet keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
            keyCountRowSet.next();
            int num = keyCountRowSet.getInt("NUM");
            gridData.put("totalCount", num);
            if (isDispBalance) {
                if (num == 0) {
                    Timestamp fromDateTimestamp = new Timestamp(fromDate.getTime());
                    Object[] param = new Object[]{BOSUuid.create((String)"A42C5900").toString(), companyId, currencyId, "", fromDateTimestamp, balance, 0};
                    balanceParamList.add(param);
                    String insertBalanceResultSql = "INSERT INTO " + tableName + "(FId,FCompanyID,FCurrencyID,FInnerAccountID,FDate,FBalance,FGroup) VALUES (?,?,?,?,?,?,?)";
                    if (balanceParamList.size() > 0) {
                        DbUtil.executeBatch((Context)ctx, (String)insertBalanceResultSql, balanceParamList);
                        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"521_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()) + balanceParamList.size()));
                    }
                } else {
                    StringBuffer firstbalanceParamSql = new StringBuffer();
                    firstbalanceParamSql.append("SELECT  top 1 FCompanyID,FCurrencyID,FInnerAccountID FROM ");
                    firstbalanceParamSql.append(tableName);
                    firstbalanceParamSql.append(" WHERE FDate  >= {");
                    firstbalanceParamSql.append(BankVCUtil.timeFormat.format(fromDate)).append("}");
                    firstbalanceParamSql.append(" AND FDate <= {");
                    firstbalanceParamSql.append(BankVCUtil.timeFormat.format(toDate)).append("}");
                    firstbalanceParamSql.append(" AND FCompanyID = '");
                    firstbalanceParamSql.append(companyId);
                    firstbalanceParamSql.append("' AND FCurrencyID = '");
                    firstbalanceParamSql.append(currencyId);
                    firstbalanceParamSql.append("' AND FInnerAccountID IN ( ");
                    firstbalanceParamSql.append(acctIds);
                    firstbalanceParamSql.append(") ");
                    firstbalanceParamSql.append("order by FCompanyID,FInnerAccountID,FDate,FCreateTime,FSeq,FBillNumber,FDebitAmount");
                    IRowSet rsFirstBalanceParamSet = DbUtil.executeQuery((Context)ctx, (String)firstbalanceParamSql.toString());
                    rsFirstBalanceParamSet.beforeFirst();
                    rsFirstBalanceParamSet.next();
                    if (rsFirstBalanceParamSet != null || rsFirstBalanceParamSet.size() != 0) {
                        Timestamp fromDateTimestamp = new Timestamp(fromDate.getTime());
                        Object[] param = new Object[]{BOSUuid.create((String)"A42C5900").toString(), rsFirstBalanceParamSet.getString("FCompanyID"), rsFirstBalanceParamSet.getString("FCurrencyID"), rsFirstBalanceParamSet.getString("FInnerAccountID"), fromDateTimestamp, balance, 0};
                        balanceParamList.add(param);
                    }
                }
            }
            if (num == 0) {
                keyCountSql = "SELECT COUNT(*) NUM FROM " + tableName;
                keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
                keyCountRowSet.next();
                num = keyCountRowSet.getInt("NUM");
                gridData.put("totalCount", num);
                return gridData;
            }
            boolean isDisDayTotal = (Boolean)subsidiaryLedgerFilterParams.get("isDisDayTotal");
            if (isDisDayTotal) {
                String dayTotalSql = "SELECT newbosid('A42C5900'),FDate,SUM(FCreditAmount),SUM(FDebitAmount),2 FROM " + tableName + " GROUP BY FDate";
                insertTempDataSql = "INSERT INTO " + tableName + "(FID,FDate,FCreditAmount,FDebitAmount,FGroup) (" + dayTotalSql + ")";
                connection = null;
                ps = null;
                try {
                    connection = this.getConnection(ctx);
                    ps = connection.prepareStatement(insertTempDataSql);
                    ps.execute();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((Statement)ps, (Connection)connection);
                }
            }
            boolean isDispMouthTotal = (Boolean)subsidiaryLedgerFilterParams.get("isDispMouthTotal");
            boolean isDispYearTotal = (Boolean)subsidiaryLedgerFilterParams.get("isDispYearTotal");
            GregorianCalendar cal = new GregorianCalendar();
            if (isDispMouthTotal && ((rsDayTotalDataRowSet = DbUtil.executeQuery((Context)ctx, (String)(dayTotalDataSql = "SELECT FCompanyID,FCurrencyID,FInnerAccountID,FDate,FCreditAmount,FDebitAmount FROM " + tableName + " where FGroup='2' ORDER BY  FDate,FCompanyID,FInnerAccountID"))) != null || rsDayTotalDataRowSet.size() != 0)) {
                Object[] param;
                rsDayTotalDataRowSet.beforeFirst();
                rsDayTotalDataRowSet.next();
                java.sql.Date tempDate = rsDayTotalDataRowSet.getDate("FDate");
                Timestamp tempTimestamp = rsDayTotalDataRowSet.getTimestamp("FDate");
                cal.setTime(tempDate);
                int tmpYear = cal.get(1);
                int tmpMonth = cal.get(2);
                int tmpDay = cal.get(5);
                BigDecimal debitAmount = Constants.ZERO;
                BigDecimal creditAmount = Constants.ZERO;
                BigDecimal tmpMonthDebitTotal = Constants.ZERO;
                BigDecimal tmpMonthCreditTotal = Constants.ZERO;
                BigDecimal tmpYearDebitTotal = Constants.ZERO;
                BigDecimal tmpYearCreditTotal = Constants.ZERO;
                tmpMonthDebitTotal = tmpMonthDebitTotal.add(rsDayTotalDataRowSet.getBigDecimal("FDebitAmount"));
                tmpMonthCreditTotal = tmpMonthCreditTotal.add(rsDayTotalDataRowSet.getBigDecimal("FCreditAmount"));
                tmpYearDebitTotal = tmpYearDebitTotal.add(rsDayTotalDataRowSet.getBigDecimal("FDebitAmount"));
                tmpYearCreditTotal = tmpYearCreditTotal.add(rsDayTotalDataRowSet.getBigDecimal("FCreditAmount"));
                String tmpFInnerAccountID = rsDayTotalDataRowSet.getString("FInnerAccountID");
                String tmpFCompanyID = rsDayTotalDataRowSet.getString("FCompanyID");
                String tmpFCurrencyID = rsDayTotalDataRowSet.getString("FCurrencyID");
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                while (rsDayTotalDataRowSet.next()) {
                    Object[] balanceParam;
                    Timestamp fromDateTimestamp;
                    BigDecimal sumTempBalanceCreditAmt;
                    BigDecimal sumTempBalanceDebitAmt;
                    IRowSet tempBalanceDataRowSet;
                    String tempBalanceDataSql;
                    BigDecimal tempBalance;
                    Date openDate;
                    BankInfo clearingHouse;
                    CompanyOrgUnitInfo curent;
                    Date balanceDate;
                    GregorianCalendar endCal;
                    java.sql.Date date = rsDayTotalDataRowSet.getDate("FDate");
                    Timestamp timestamp = rsDayTotalDataRowSet.getTimestamp("FDate");
                    cal.setTime(date);
                    int day = cal.get(5);
                    int month = cal.get(2);
                    int year = cal.get(1);
                    debitAmount = rsDayTotalDataRowSet.getBigDecimal("FDebitAmount");
                    creditAmount = rsDayTotalDataRowSet.getBigDecimal("FCreditAmount");
                    if (year == tmpYear) {
                        tmpYearDebitTotal = tmpYearDebitTotal.add(debitAmount);
                        tmpYearCreditTotal = tmpYearCreditTotal.add(creditAmount);
                        if (month == tmpMonth) {
                            tmpMonthDebitTotal = tmpMonthDebitTotal.add(debitAmount);
                            tmpMonthCreditTotal = tmpMonthCreditTotal.add(creditAmount);
                        } else {
                            param = new Object[]{BOSUuid.create((String)"A42C5900").toString(), tmpFCompanyID, tmpFCurrencyID, tmpFInnerAccountID, tempTimestamp, tmpMonthCreditTotal, tmpMonthDebitTotal, 3};
                            paramList.add(param);
                            tmpMonthDebitTotal = debitAmount;
                            tmpMonthCreditTotal = creditAmount;
                            if (isDispBalance) {
                                endCal = new GregorianCalendar(year, month, 1);
                                balanceDate = endCal.getTime();
                                curent = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                                clearingHouse = new BankInfo();
                                try {
                                    clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(curent.getId().toString());
                                }
                                catch (EASBizException e) {
                                    e.printStackTrace();
                                }
                                openDate = clearingHouse.getOpenDate();
                                if (endCal.getTime().before(openDate)) {
                                    balanceDate = openDate;
                                }
                                tempBalance = Constants.ZERO;
                                tempBalanceDataSql = "SELECT FDate,FCreditAmount,FDebitAmount,FGroup FROM " + tableName + " where FGroup='1' FDate  >= { " + BankVCUtil.dateFormat.format(fromDate) + "} AND FDate <= {" + BankVCUtil.dateFormat.format(timestamp) + "} AND ORDER BY  FDate,FGroup";
                                tempBalanceDataRowSet = DbUtil.executeQuery((Context)ctx, (String)tempBalanceDataSql);
                                sumTempBalanceDebitAmt = CasConstants.ZERO;
                                sumTempBalanceCreditAmt = CasConstants.ZERO;
                                while (tempBalanceDataRowSet.next()) {
                                    sumTempBalanceDebitAmt = sumTempBalanceDebitAmt.add(tempBalanceDataRowSet.getBigDecimal("DEBITAMOUNT"));
                                    sumTempBalanceCreditAmt = sumTempBalanceCreditAmt.add(tempBalanceDataRowSet.getBigDecimal("CREDITAMOUNT"));
                                }
                                tempBalance = balance.add(sumTempBalanceDebitAmt).subtract(sumTempBalanceCreditAmt);
                                fromDateTimestamp = new Timestamp(balanceDate.getTime());
                                balanceParam = new Object[]{BOSUuid.create((String)"A42C5900").toString(), tmpFCompanyID, tmpFCurrencyID, tmpFInnerAccountID, tempTimestamp, tempBalance, 0};
                                balanceParamList.add(balanceParam);
                            }
                        }
                    } else {
                        param = new Object[]{BOSUuid.create((String)"A42C5900").toString(), tmpFCompanyID, tmpFCurrencyID, tmpFInnerAccountID, tempTimestamp, tmpMonthCreditTotal, tmpMonthDebitTotal, 3};
                        paramList.add(param);
                        tmpMonthDebitTotal = debitAmount;
                        tmpMonthCreditTotal = creditAmount;
                        if (isDispBalance) {
                            endCal = new GregorianCalendar(year, month, 1);
                            balanceDate = endCal.getTime();
                            curent = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                            clearingHouse = new BankInfo();
                            try {
                                clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(curent.getId().toString());
                            }
                            catch (EASBizException e) {
                                e.printStackTrace();
                            }
                            openDate = clearingHouse.getOpenDate();
                            if (endCal.getTime().before(openDate)) {
                                balanceDate = openDate;
                            }
                            tempBalance = Constants.ZERO;
                            tempBalanceDataSql = "SELECT FDate,FCreditAmount,FDebitAmount,FGroup FROM " + tableName + " where FGroup='1' FDate  >= { " + BankVCUtil.dateFormat.format(fromDate) + "} AND FDate <= {" + BankVCUtil.dateFormat.format(timestamp) + "} AND ORDER BY  FDate,FGroup";
                            tempBalanceDataRowSet = DbUtil.executeQuery((Context)ctx, (String)tempBalanceDataSql);
                            sumTempBalanceDebitAmt = CasConstants.ZERO;
                            sumTempBalanceCreditAmt = CasConstants.ZERO;
                            while (tempBalanceDataRowSet.next()) {
                                sumTempBalanceDebitAmt = sumTempBalanceDebitAmt.add(tempBalanceDataRowSet.getBigDecimal("DEBITAMOUNT"));
                                sumTempBalanceCreditAmt = sumTempBalanceCreditAmt.add(tempBalanceDataRowSet.getBigDecimal("CREDITAMOUNT"));
                            }
                            tempBalance = balance.add(sumTempBalanceDebitAmt).subtract(sumTempBalanceCreditAmt);
                            fromDateTimestamp = new Timestamp(balanceDate.getTime());
                            balanceParam = new Object[]{BOSUuid.create((String)"A42C5900").toString(), tmpFCompanyID, tmpFCurrencyID, tmpFInnerAccountID, tempTimestamp, tempBalance, 0};
                            balanceParamList.add(balanceParam);
                        }
                        param = new Object[]{BOSUuid.create((String)"A42C5900").toString(), tmpFCompanyID, tmpFCurrencyID, tmpFInnerAccountID, tempTimestamp, tmpYearCreditTotal, tmpYearDebitTotal, 4};
                        paramList.add(param);
                        tmpYearDebitTotal = debitAmount;
                        tmpYearCreditTotal = creditAmount;
                    }
                    tempDate = date;
                    tempTimestamp = timestamp;
                    tmpDay = day;
                    tmpMonth = month;
                    tmpYear = year;
                    tmpFInnerAccountID = rsDayTotalDataRowSet.getString("FInnerAccountID");
                    tmpFCompanyID = rsDayTotalDataRowSet.getString("FCompanyID");
                }
                param = new Object[]{BOSUuid.create((String)"A42C5900").toString(), tmpFCompanyID, tmpFCurrencyID, tmpFInnerAccountID, tempTimestamp, tmpMonthCreditTotal, tmpMonthDebitTotal, 3};
                paramList.add(param);
                param = new Object[]{BOSUuid.create((String)"A42C5900").toString(), tmpFCompanyID, tmpFCurrencyID, tmpFInnerAccountID, tempTimestamp, tmpYearCreditTotal, tmpYearDebitTotal, 4};
                paramList.add(param);
                String insertSumMonthYearResultSql = "INSERT INTO " + tableName + "(FId,FCompanyID,FCurrencyID,FInnerAccountID,FDate,FCreditAmount,FDebitAmount,FGroup) VALUES (?,?,?,?,?,?,?,?)";
                if (paramList.size() > 0) {
                    DbUtil.executeBatch((Context)ctx, (String)insertSumMonthYearResultSql, paramList);
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"522_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()) + paramList.size()));
                }
                String insertBalanceResultSql = "INSERT INTO " + tableName + "(FId,FCompanyID,FCurrencyID,FInnerAccountID,FDate,FBalance,FGroup) VALUES (?,?,?,?,?,?,?)";
                if (balanceParamList.size() > 0) {
                    DbUtil.executeBatch((Context)ctx, (String)insertBalanceResultSql, balanceParamList);
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"521_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()) + balanceParamList.size()));
                }
            }
            keyCountSql = "SELECT COUNT(*) NUM FROM " + tableName;
            keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
            keyCountRowSet.next();
            num = keyCountRowSet.getInt("NUM");
            gridData.put("totalCount", num);
            gridData.put("tableName", tableName);
            return gridData;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getTempListData(Context ctx, BigDecimal balance, String tableName, int start, int length) throws BOSException, EASBizException {
        HashMap gridData = new HashMap();
        try {
            if (tableName != null && !tableName.equals("")) {
                String selectKeySql = "SELECT FID FROM " + tableName + " ORDER BY FDate,FGROUP,FCompanyID,FInnerAccountID,FCreateTime,FSeq,FBillNumber,FDebitAmount";
                IRowSet keyRowSet = DbUtil.executeQuery((Context)ctx, (String)selectKeySql, (int)start, (int)length);
                keyRowSet.next();
                StringBuffer subsidiaryLedgerResultSql = new StringBuffer("SELECT TEMPSUBSIDIARYLEDGER.FID AS ID, TEMPSUBSIDIARYLEDGER.Fgroup AS Fgroup, TEMPSUBSIDIARYLEDGER.FDate AS FDATE,TEMPSUBSIDIARYLEDGER.FCompanyID AS FCompanyID,TEMPSUBSIDIARYLEDGER.FINNERACCOUNTID AS FINNERACCOUNTID,SUBSIDIARYLEDGER.FBizType AS BIZTYPE, SUBSIDIARYLEDGER.FBillNumber AS BILLNUMBER,SUBSIDIARYLEDGER.FPayeeBankAcct AS PAYEEBANKACCT, SUBSIDIARYLEDGER.FPayerBankAcct AS PAYERBANKACCT,SUBSIDIARYLEDGER.FDescription AS DESCRIPTION, TEMPSUBSIDIARYLEDGER.FDebitAmount AS DEBITAMOUNT,TEMPSUBSIDIARYLEDGER.FCreditAmount AS CREDITAMOUNT,INNERACCOUNT.FNumber AS INNERACCOUNTNUMBER,BOOKKEEPER.FName_l2 AS BOOKERNAME,BOOKKEEPER.FName_l2 AS BOOKKEEPERNAME,CPINNERACCOUNT.FName_l2 AS CPINNERACCOUNTNAME,INNERACCOUNT.FTypeId AS INNERACCOUNTTYPE,SUBSIDIARYLEDGER.FIsDownLoad AS ISDOWNLOAD,(SUBSIDIARYLEDGER.FDebitAmount - SUBSIDIARYLEDGER.FCreditAmount) AS AMOUNTOFFSET,INNERACCOUNT.FID AS INNERACCOUNTID,CURRENCY.FID AS CURRENCY,SETTLETYPE.FName_l2 AS SETTLETYPENAME,SUBSIDIARYLEDGER.FSettleNumber AS SETTLENUMBER,COMPANY.FID AS COMPANYID,APPLYUNIT.FID AS APPLYUNITID,SUBSIDIARYLEDGER.FFPItemID AS FPITEMID,FPITEM.FName_l2 AS FPITEMNAME,FPITEM.FNumber AS FPITEMNUMBER,SUBSIDIARYLEDGER.FCreateTime AS CREATETIME,SUBSIDIARYLEDGER.FSeq AS SEQ,INNERACCOUNT.FNumber AS INNERACCOUNTNUMBER,INNERACCOUNT.FName_l2 AS INNERACCOUNTNAME,APPLYUNIT1.FName_l2 AS ACCOUNTOPENCOMPANY,(SUBSIDIARYLEDGER.FDebitAmount - SUBSIDIARYLEDGER.FCreditAmount) AS ENDBALANCE FROM " + tableName + " AS TEMPSUBSIDIARYLEDGER LEFT OUTER JOIN T_FS_SubsidiaryLedger AS SUBSIDIARYLEDGER ON SUBSIDIARYLEDGER.FID=TEMPSUBSIDIARYLEDGER.FID LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON SUBSIDIARYLEDGER.FCurrencyID = CURRENCY.FID LEFT OUTER JOIN T_FS_InnerAccount AS INNERACCOUNT ON SUBSIDIARYLEDGER.FInnerAccountID = INNERACCOUNT.FID LEFT OUTER JOIN T_FS_InnerAccount AS CPINNERACCOUNT\tON SUBSIDIARYLEDGER.FCpInnerAccountID = CPINNERACCOUNT.FID LEFT OUTER JOIN T_PM_User AS BOOKKEEPER ON SUBSIDIARYLEDGER.FBookkeeperID = BOOKKEEPER.FID LEFT OUTER JOIN T_BD_SettlementType AS SETTLETYPE ON SUBSIDIARYLEDGER.FSettleTypeID = SETTLETYPE.FID LEFT OUTER JOIN T_ORG_Company AS APPLYUNIT ON SUBSIDIARYLEDGER.FCompanyID = APPLYUNIT.FID LEFT OUTER JOIN T_ORG_Company AS COMPANY ON SUBSIDIARYLEDGER.FCompanyID = COMPANY.FID LEFT OUTER JOIN T_FPL_FpItem AS FPITEM ON SUBSIDIARYLEDGER.FFPItemID = FPITEM.FID LEFT OUTER JOIN T_ORG_Company AS APPLYUNIT1 ON INNERACCOUNT.FApplyUnitID = APPLYUNIT1.FID  WHERE TEMPSUBSIDIARYLEDGER.FID IN (''");
                keyRowSet.beforeFirst();
                while (keyRowSet.next()) {
                    subsidiaryLedgerResultSql.append(",'" + keyRowSet.getString("FID") + "'");
                }
                subsidiaryLedgerResultSql.append(") ORDER BY FDate,FGROUP,FCompanyID, FINNERACCOUNTID");
                IRowSet subsidiaryLedgerResultRowSet = DbUtil.executeQuery((Context)ctx, (String)subsidiaryLedgerResultSql.toString());
                ArrayList subsidiaryLedgerLists = new ArrayList();
                BigDecimal debitAmt = null;
                BigDecimal creditAmt = null;
                BigDecimal tempBalance = Constants.ZERO;
                String startBeforeDataSql = "SELECT FDate,FCreditAmount,FDebitAmount,FGroup FROM " + tableName + " where FGroup='1' ORDER BY  FCompanyID,FInnerAccountID,FDate,FGROUP,FCreateTime,FSeq,FBillNumber,FDebitAmount";
                IRowSet startBeforeDataRowSet = DbUtil.executeQuery((Context)ctx, (String)startBeforeDataSql, (int)0, (int)start);
                BigDecimal sumStartBeforeDebitAmt = CasConstants.ZERO;
                BigDecimal sumStartBeforeCreditAmt = CasConstants.ZERO;
                while (startBeforeDataRowSet.next()) {
                    sumStartBeforeDebitAmt = sumStartBeforeDebitAmt.add(startBeforeDataRowSet.getBigDecimal("FDebitAmount"));
                    sumStartBeforeCreditAmt = sumStartBeforeCreditAmt.add(startBeforeDataRowSet.getBigDecimal("FCreditAmount"));
                }
                tempBalance = balance.add(sumStartBeforeDebitAmt).subtract(sumStartBeforeCreditAmt);
                while (subsidiaryLedgerResultRowSet.next()) {
                    HashMap<String, Object> subsidiaryLedgerMap = new HashMap<String, Object>();
                    subsidiaryLedgerMap.put("date", Constants.FORMAT_DAY.format(subsidiaryLedgerResultRowSet.getDate("FDATE")));
                    subsidiaryLedgerMap.put("id", subsidiaryLedgerResultRowSet.getString("ID"));
                    subsidiaryLedgerMap.put("accountNumber", subsidiaryLedgerResultRowSet.getString("INNERACCOUNTNUMBER"));
                    subsidiaryLedgerMap.put("accountName", subsidiaryLedgerResultRowSet.getString("INNERACCOUNTNAME"));
                    subsidiaryLedgerMap.put("accountOpenCompany", subsidiaryLedgerResultRowSet.getString("ACCOUNTOPENCOMPANY"));
                    subsidiaryLedgerMap.put("bizType", (Object)SubsidiaryBillTypeEnum.getEnum(subsidiaryLedgerResultRowSet.getInt("BIZTYPE")));
                    subsidiaryLedgerMap.put("billNumber", subsidiaryLedgerResultRowSet.getString("BILLNUMBER"));
                    subsidiaryLedgerMap.put("payeeBankAcct", subsidiaryLedgerResultRowSet.getString("PAYEEBANKACCT"));
                    subsidiaryLedgerMap.put("payerBankAcct", subsidiaryLedgerResultRowSet.getString("PAYERBANKACCT"));
                    subsidiaryLedgerMap.put("cpInnerAccountName", subsidiaryLedgerResultRowSet.getString("CPINNERACCOUNTNAME"));
                    subsidiaryLedgerMap.put("settleType", subsidiaryLedgerResultRowSet.getString("SETTLETYPENAME"));
                    subsidiaryLedgerMap.put("settleNumber", subsidiaryLedgerResultRowSet.getString("SETTLENUMBER"));
                    subsidiaryLedgerMap.put("description", subsidiaryLedgerResultRowSet.getString("DESCRIPTION"));
                    debitAmt = subsidiaryLedgerResultRowSet.getBigDecimal("DEBITAMOUNT");
                    creditAmt = subsidiaryLedgerResultRowSet.getBigDecimal("CREDITAMOUNT");
                    if (debitAmt == null) {
                        debitAmt = CasConstants.ZERO;
                    }
                    if (creditAmt == null) {
                        creditAmt = CasConstants.ZERO;
                    }
                    if (creditAmt.compareTo(Constants.ZERO) != 0) {
                        subsidiaryLedgerMap.put("creditAmount", creditAmt);
                    }
                    if (debitAmt.compareTo(Constants.ZERO) != 0) {
                        subsidiaryLedgerMap.put("debitAmount", debitAmt);
                    }
                    subsidiaryLedgerMap.put("booker", subsidiaryLedgerResultRowSet.getString("BOOKKEEPERNAME"));
                    BigDecimal rsBalance = Constants.ZERO;
                    String FGroup = subsidiaryLedgerResultRowSet.getString("FGroup");
                    if (FGroup.equals("1")) {
                        rsBalance = tempBalance.add(debitAmt).subtract(creditAmt);
                        tempBalance = tempBalance.add(debitAmt).subtract(creditAmt);
                    } else {
                        rsBalance = tempBalance;
                    }
                    subsidiaryLedgerMap.put("balance", rsBalance.abs());
                    subsidiaryLedgerMap.put("group", FGroup);
                    BalanceDirectionEnum direction = null;
                    direction = rsBalance.compareTo(Constants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (rsBalance.compareTo(Constants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
                    subsidiaryLedgerMap.put("direction", (Object)direction);
                    subsidiaryLedgerLists.add(subsidiaryLedgerMap);
                }
                gridData.put("subsidiaryLedgerHistoryData", subsidiaryLedgerLists);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return gridData;
    }

    @Override
    protected void _deleteInnerEReceipt(Context ctx, String innerERecId) throws BOSException, EASBizException {
        try {
            StorageSettingInstance storageSetting = StorageSettingInstance.getInstance((Context)ctx);
            EReceiptStorageSettingInfo eReceiptStorageSettingInfo = storageSetting.getStorageSettingInfo();
            EReceiptInfo eReceiptInfo = EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptInfo((IObjectPK)new ObjectUuidPK(innerERecId));
            if (eReceiptStorageSettingInfo == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"523_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()));
            }
            if (!eReceiptInfo.getFileSource().equals("3")) {
                String fileSource = eReceiptInfo.getFileSource();
                if (fileSource.equals("0")) {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"524_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()));
                } else if (fileSource.equals("1")) {
                    EReceiptJDBC eReceiptJDBCTool = new EReceiptJDBC();
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"525_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()));
                    eReceiptJDBCTool.deleteEReceipt(eReceiptInfo.getId().toString(), CompareType.EQUALS, eReceiptStorageSettingInfo);
                } else if (fileSource.equals("2")) {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"526_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()));
                }
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"527_SubsidiaryLedgerControllerBean", (Locale)ctx.getLocale()));
            }
            EReceiptFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(innerERecId));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }
}

