/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fs.CapitalStockTypeEnum;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.IInAcctExt;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctExtFactory;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.SummaryLedgerEnum;
import com.kingdee.eas.fm.fs.app.AbstractSummaryLedgerControllerBean;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SummaryLedgerControllerBean
extends AbstractSummaryLedgerControllerBean {
    private static final int I_ZERO = 0;
    private static final int I_ONE = 1;
    private static Logger logger = Logger.getLogger(SummaryLedgerControllerBean.class);

    @Override
    protected BigDecimal _getTransferAmount(Context ctx, SummaryLedgerEnum type, String companyId, String currencyId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            BigDecimal bigDecimal;
            String sql = this.getSql(type, companyId, currencyId, beginDate, endDate).toString();
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                BigDecimal sum = rs.getBigDecimal("result");
                if (sum == null) {
                    sum = Constants.ZERO;
                }
                bigDecimal = sum;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bigDecimal;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return Constants.ZERO;
    }

    private StringBuffer getSql(SummaryLedgerEnum type, String companyId, String currencyId, Date beginDate, Date endDate) {
        StringBuffer sql = null;
        switch (type.getValue()) {
            case 1: {
                sql = new StringBuffer("select sum(FBeginBalance) as result from T_FS_SummaryLedger ");
                break;
            }
            case 3: {
                sql = new StringBuffer("select sum(FCreditTotal) as result from T_FS_SummaryLedger ");
                break;
            }
            case 2: {
                sql = new StringBuffer("select sum(FDebitTotal) as result from T_FS_SummaryLedger ");
                break;
            }
            default: {
                sql = new StringBuffer("select sum(FEndBalance) as result from T_FS_SummaryLedger ");
            }
        }
        sql.append(" where FBizDate >='" + TypeConversionUtils.objToDate((Object)beginDate) + "'");
        sql.append(" and FBizDate <'" + TypeConversionUtils.objToDate((Object)endDate) + "'");
        sql.append(" and FCompanyID='" + companyId + "'");
        sql.append(" and FCurrencyID='" + currencyId + "'");
        return sql;
    }

    private IObjectCollection execInacct(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        IInAcct inacct = InAcctFactory.getLocalInstance(ctx);
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            Object[] params = info.getParams();
            BigDecimal tmp = inacct.inAcct((String)params[0], (String)params[1], (String)params[2], (Date)params[3], (Date)params[4], (InAcctDataTypeEnum)((Object)params[5]));
            info.setResult(tmp);
        }
        return coll;
    }

    private IObjectCollection execInacctExt(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        IInAcctExt inacct = InAcctExtFactory.getLocalInstance(ctx);
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            BOSUuid id = BOSUuid.create((BOSObjectType)new FPFormulaInfo().getBOSType());
            if (null != info.getId()) continue;
            info.setId(id);
        }
        Map rstMap = inacct.inAcctBatch((FPFormulaCollection)coll);
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            Object rst = rstMap.get(info.getId().toString());
            if (EmptyUtil.isEmpty(rst)) {
                info.setResult(Constants.ZERO);
                continue;
            }
            info.setResult((BigDecimal)rst);
        }
        return coll;
    }

    private IObjectCollection execOutacct(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        IInAcct inacct = InAcctFactory.getLocalInstance(ctx);
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            Object[] objectArray = info.getParams();
        }
        return coll;
    }

    private IObjectCollection execReportCal(Context ctx, IObjectCollection coll) throws EASBizException, BOSException {
        FPFormulaInfo info;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        boolean includeVoucher = false;
        boolean checkDataRight = false;
        BigDecimal beginBalance = Constants.ZERO;
        BigDecimal debitTotal = Constants.ZERO;
        BigDecimal creditTotal = Constants.ZERO;
        BigDecimal endBalance = Constants.ZERO;
        BigDecimal tmpBeginBalance = Constants.ZERO;
        BigDecimal tmpDebitTotal = Constants.ZERO;
        BigDecimal tmpCreditTotal = Constants.ZERO;
        BigDecimal tmpEndBalance = Constants.ZERO;
        String tmpAccountNum = "";
        for (int i = 0; i < coll.size(); ++i) {
            info = (FPFormulaInfo)coll.getObject(i);
            Object[] params = info.getParams();
            String accountNumber = (String)params[1];
            if (tmpAccountNum.equals(accountNumber)) continue;
            String companyNumber = (String)params[0];
            int beginYear = (Integer)params[3];
            int beginMonth = (Integer)params[4];
            int endYear = (Integer)params[5];
            int endMonth = (Integer)params[6];
            String currencyNumber = (String)params[7];
            tmpBeginBalance = reportCacl.acct(companyNumber, accountNumber, BalanceTypeEnum.C, beginYear, beginMonth, endYear, endMonth, currencyNumber, false, includeVoucher, checkDataRight);
            beginBalance = beginBalance.add(tmpBeginBalance);
            tmpDebitTotal = reportCacl.acct(companyNumber, accountNumber, BalanceTypeEnum.JF, beginYear, beginMonth, endYear, endMonth, currencyNumber, false, includeVoucher, checkDataRight);
            debitTotal = debitTotal.add(tmpDebitTotal);
            tmpCreditTotal = reportCacl.acct(companyNumber, accountNumber, BalanceTypeEnum.DF, beginYear, beginMonth, endYear, endMonth, currencyNumber, false, includeVoucher, checkDataRight);
            creditTotal = creditTotal.add(tmpCreditTotal);
            tmpAccountNum = accountNumber;
        }
        endBalance = beginBalance.add(debitTotal).subtract(creditTotal);
        FPFormulaCollection resultColl = new FPFormulaCollection();
        info = new FPFormulaInfo();
        info.setResult(beginBalance);
        resultColl.add(info);
        info = new FPFormulaInfo();
        info.setResult(debitTotal);
        resultColl.add(info);
        info = new FPFormulaInfo();
        info.setResult(creditTotal);
        resultColl.add(info);
        info = new FPFormulaInfo();
        info.setResult(endBalance);
        resultColl.add(info);
        return resultColl;
    }

    private IObjectCollection execReportCalByDate(Context ctx, IObjectCollection coll) throws EASBizException, BOSException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        boolean includeVoucher = false;
        boolean checkDataRight = false;
        BigDecimal amount = Constants.ZERO;
        for (int i = 0; i < coll.size(); ++i) {
            BigDecimal amountTotal = Constants.ZERO;
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            Object[] params = info.getParams();
            String companyNumber = (String)params[1];
            String[] accountNumbers = (String[])params[2];
            VoucherGetTypeEnum type = (VoucherGetTypeEnum)params[3];
            String beginDate = DateTimeUtils.formatDate((Date)((Date)params[4]));
            String endDate = DateTimeUtils.formatDate((Date)((Date)params[5]));
            String currencyNumber = (String)params[6];
            includeVoucher = (Boolean)params[7];
            amount = Constants.ZERO;
            for (String accountNumber : accountNumbers) {
                PeriodInfo startPeriod = FMHelper.getStartPeriod((Context)ctx, (String)companyNumber);
                if (startPeriod != null) {
                    amount = reportCacl.acctExt(companyNumber, accountNumber, "", "", type, currencyNumber, beginDate, endDate, includeVoucher, checkDataRight);
                }
                amountTotal = amountTotal.add(amount);
            }
            info.setResult(amountTotal);
        }
        return coll;
    }

    private IObjectCollection execMReportCal(Context ctx, IObjectCollection coll) throws EASBizException, BOSException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        boolean includeVoucher = false;
        boolean checkDataRight = false;
        if (coll == null || coll.isEmpty()) {
            return coll;
        }
        FPFormulaInfo info = (FPFormulaInfo)coll.getObject(0);
        Object[] params = info.getParams();
        boolean isByPeriod = (Boolean)params[0];
        if (!isByPeriod) {
            return this.execReportCalByDate(ctx, coll);
        }
        return this.execReportCalByPeriod(ctx, coll);
    }

    private IObjectCollection execReportCalByPeriod(Context ctx, IObjectCollection coll) throws EASBizException, BOSException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        Calendar cal = Calendar.getInstance();
        boolean includeVoucher = false;
        boolean checkDataRight = false;
        BigDecimal amount = Constants.ZERO;
        for (int i = 0; i < coll.size(); ++i) {
            BigDecimal amountTotal = Constants.ZERO;
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            Object[] params = info.getParams();
            String companyNumber = (String)params[1];
            Object[] accountNumbers = (String[])params[2];
            if (FMHelper.isEmpty((Object[])accountNumbers)) continue;
            BalanceTypeEnum balanceType = (BalanceTypeEnum)params[3];
            VoucherGetTypeEnum voucherType = BalanceTypeEnum.AC.equals((Object)balanceType) ? VoucherGetTypeEnum.C : (BalanceTypeEnum.DF.equals((Object)balanceType) ? VoucherGetTypeEnum.DF : VoucherGetTypeEnum.JF);
            int beginYear = (Integer)params[4];
            int beginMonth = (Integer)params[5];
            int endYear = (Integer)params[6];
            int endMonth = (Integer)params[7];
            cal.set(beginYear, beginMonth - 1, 1, 0, 0, 0);
            String beginDate = DateTimeUtils.formatDate((Date)cal.getTime());
            cal.set(endYear, endMonth - 1, cal.getActualMaximum(5), 0, 0, 0);
            String endDate = DateTimeUtils.formatDate((Date)cal.getTime());
            String currencyNumber = (String)params[8];
            includeVoucher = (Boolean)params[9];
            amount = Constants.ZERO;
            for (Object accountNumber : accountNumbers) {
                PeriodInfo startPeriod = FMHelper.getStartPeriod((Context)ctx, (String)companyNumber);
                if (startPeriod != null) {
                    amount = reportCacl.acctExt(companyNumber, (String)accountNumber, "", "", voucherType, currencyNumber, beginDate, endDate, includeVoucher, checkDataRight);
                }
                amountTotal = amountTotal.add(amount);
            }
            info.setResult(amountTotal);
        }
        return coll;
    }

    private IObjectCollection execCashMgt(Context ctx, IObjectCollection coll) throws EASBizException, BOSException {
        ICashManagement inacct = CashManagementFactory.getLocalInstance((Context)ctx);
        Object[] params = null;
        String companyNumber = null;
        CashDataSourceEnum dataSource = null;
        String accountNum = null;
        String acctTableNum = null;
        String bankAcctNum = null;
        String currencyNum = null;
        Date beginDate = null;
        Date endDate = null;
        CashDataTypeEnum dataType = null;
        boolean isIncludeUnsettled = false;
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            params = info.getParams();
            companyNumber = (String)params[0];
            dataSource = (CashDataSourceEnum)params[1];
            acctTableNum = (String)params[2];
            accountNum = (String)params[3];
            bankAcctNum = (String)params[4];
            currencyNum = (String)params[5];
            beginDate = (Date)params[6];
            endDate = (Date)params[7];
            dataType = (CashDataTypeEnum)params[8];
            isIncludeUnsettled = (Boolean)params[9];
            info.setResult(inacct.cash(companyNumber, dataSource, acctTableNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, dataType, isIncludeUnsettled));
        }
        return coll;
    }

    protected Map getBalanceBatch(Context ctx, String companyNum, CashDataSourceEnum dataSource, String acctTableNum, String accountNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>();
        Date firstDayOfMonth = DateUtil.getFirstDayOfMonth((Date)endDate);
        StringBuffer sqlBalance = new StringBuffer();
        sqlBalance.append("         select h.FCompanyId,h.FAccountBankID,h.FCurrencyId,h.FType,sum(h.FMonthStartAmt) SubResult\n");
        sqlBalance.append("          from T_CAS_Journalbalance h\n");
        sqlBalance.append("          join (select b.fcompanyid,c.fid fperiodid,c.fperiodyear,c.fperiodnumber,c.fbegindate,c.fenddate\n");
        sqlBalance.append("                 from t_bd_period c\n");
        sqlBalance.append("                 join (select distinct balance.fcompanyid,\n");
        sqlBalance.append("case when {").append(TypeConversionUtils.objToDate((Object)endDate)).append("} <= m.fbegindate then\n");
        sqlBalance.append("   m.fbegindate when {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}>=x.fbegindate then\n");
        sqlBalance.append("\t\t\t\t\tx.fbegindate\n");
        sqlBalance.append("   else\n");
        sqlBalance.append(" {").append(TypeConversionUtils.objToDate((Object)firstDayOfMonth)).append("} \n");
        sqlBalance.append("  end fbegindate\n");
        sqlBalance.append("from T_CAS_JournalBalance balance\n");
        sqlBalance.append("join (select b.fcompanyid, period.fbegindate\n");
        sqlBalance.append("     from t_bd_period period\n");
        sqlBalance.append("     join (select sysStaCtr.FCompanyID,\n");
        sqlBalance.append("                sysStaCtr.Fstartperiodid Fstartperiodid\n");
        sqlBalance.append("           from T_BD_SystemStatusCtrol sysStaCtr,\n");
        sqlBalance.append("           T_BD_SystemStatus      sysSta\n");
        sqlBalance.append("  where sysStaCtr.FSystemStatusID = sysSta.FID\n");
        sqlBalance.append("    and sysSta.FName = 7\n");
        sqlBalance.append("      and FCurrentPeriodID is not null) b on b.Fstartperiodid =\n");
        sqlBalance.append("                                      period.fid) m on balance.fcompanyid =\n");
        sqlBalance.append("    m.fcompanyid\n");
        sqlBalance.append(" \t\tjoin ( select  b.fcompanyid,period.fbegindate\n");
        sqlBalance.append(" \t\t\t  from t_bd_period period\n");
        sqlBalance.append(" join (select sysStaCtr.FCompanyID,\n");
        sqlBalance.append("         sysStaCtr.Fcurrentperiodid Fcurrentperiodid\n");
        sqlBalance.append("    from T_BD_SystemStatusCtrol sysStaCtr,\n");
        sqlBalance.append("          T_BD_SystemStatus      sysSta\n");
        sqlBalance.append("    where sysStaCtr.FSystemStatusID = sysSta.FID\n");
        sqlBalance.append("       and sysSta.FName = 7\n");
        sqlBalance.append("     and FCurrentPeriodID is not null) b on b.Fcurrentperiodid =\n");
        sqlBalance.append("                             period.fid) x on x.fcompanyid = balance.fcompanyid\n");
        sqlBalance.append(" \t\t) b on c.fbegindate =\n");
        sqlBalance.append("                                                   b.fbegindate) i on h.fcompanyid =\n");
        sqlBalance.append("                                                                      i.fcompanyid\n");
        sqlBalance.append("                                                                  and h.fperiodid =\n");
        sqlBalance.append("                                                                      i.fperiodid\n");
        sqlBalance.append("         where h.FIsInit = 0\n");
        sqlBalance.append("         group by h.FCompanyId,h.FCurrencyId,h.FAccountBankID,h.FType\n");
        StringBuffer sqlAmt = new StringBuffer();
        sqlAmt.append("        select h.FCompanyId,h.FAccountBankID,h.FCurrencyId,h.FType,sum(h.FDebitAmount - h.FCreditAmount) SubResult\n");
        sqlAmt.append("          from t_cas_JournalSummary h\n");
        sqlAmt.append("          join (select b.fcompanyid,c.fid fperiodid,c.fperiodyear,c.fperiodnumber,case when c.fbegindate<={").append(TypeConversionUtils.objToDate((Object)endDate)).append(" }then c.fbegindate \n");
        sqlAmt.append("        else {").append(TypeConversionUtils.objToDate((Object)firstDayOfMonth)).append("}  end  fbegindate,c.fenddate\n");
        sqlAmt.append("                  from t_bd_period c\n");
        sqlAmt.append(" join ( ");
        sqlAmt.append(" select sysStaCtr.FCompanyID,FCurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr ,T_BD_SystemStatus sysSta  ");
        sqlAmt.append(" where sysStaCtr.FSystemStatusID=sysSta.FID and sysSta.FName=7 and FCurrentPeriodID is not null ");
        sqlAmt.append(" ) b on c.fid = b.FCurrentPeriodID ");
        sqlAmt.append("                  join t_org_company d on d.FAccountPeriodID = c.FTypeID\n");
        sqlAmt.append("                                      and d.fid = b.fcompanyid) i on h.fcompanyid =\n");
        sqlAmt.append("                                                                     i.fcompanyid\n");
        sqlAmt.append("                                                                 and h.FCreateDate >=\n");
        sqlAmt.append("                                                                     i.fbegindate\n");
        sqlAmt.append("                                                                 and h.FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}\n");
        sqlAmt.append("         group by h.FCompanyId,h.FAccountBankID,h.FCurrencyId,h.FType\n");
        StringBuffer sqlAll = new StringBuffer();
        sqlAll.append("select z.FCompanyId,z.FAccountBankID,z.FCurrencyId,z.FType,sum(SubResult) Result\n ");
        sqlAll.append("   from (\n");
        sqlAll.append(sqlBalance);
        sqlAll.append("         union all \n ");
        sqlAll.append(sqlAmt);
        sqlAll.append("        ) z\n");
        sqlAll.append("where z.subResult != 0\n");
        sqlAll.append("  group by z.FCompanyId,z.FAccountBankID,z.FCurrencyId,z.FType ");
        String datatype = String.valueOf(dataType.getValue());
        String sql = sqlAll.toString();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String FCompanyId = rs.getString("FCompanyId");
                String FAccountBankID = rs.getString("FAccountBankID");
                String FCurrencyId = rs.getString("FCurrencyId");
                String FType = rs.getString("FType");
                BigDecimal value = rs.getBigDecimal("Result");
                String key = this.genKey(FCompanyId, FAccountBankID, FCurrencyId, FType, datatype);
                balanceMap.put(key, value);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sql: " + sql));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return balanceMap;
    }

    protected Map getAmtBatch(Context ctx, String companyNum, CashDataSourceEnum dataSource, String acctTableNum, String accountNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        Date firstDayOfMonth = DateUtil.getFirstDayOfMonth((Date)endDate);
        StringBuffer sqlAmt = new StringBuffer();
        sqlAmt.append("        select  h.FCompanyId,h.FAccountBankID,h.FCurrencyId,h.FType,sum(h.FDebitAmount) debitResult,sum(h.FCreditAmount)creditResult \n");
        sqlAmt.append("          from t_cas_JournalSummary h\n");
        sqlAmt.append("           where h.FCreateDate >= {").append(TypeConversionUtils.objToDate((Object)beginDate)).append("}\n");
        sqlAmt.append("           and h.FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}\n");
        sqlAmt.append("         group by h.FCompanyId,h.FAccountBankID,h.FCurrencyId,h.FType\n");
        String datatypeJf = String.valueOf(3);
        String datatypeDf = String.valueOf(4);
        String sql = sqlAmt.toString();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String FCompanyId = rs.getString("FCompanyId");
                String FAccountBankID = rs.getString("FAccountBankID");
                String FCurrencyId = rs.getString("FCurrencyId");
                String FType = rs.getString("FType");
                BigDecimal debitValue = rs.getBigDecimal("debitResult");
                BigDecimal creditValue = rs.getBigDecimal("creditResult");
                String keyJf = this.genKey(FCompanyId, FAccountBankID, FCurrencyId, FType, datatypeJf);
                amtMap.put(keyJf, debitValue);
                String keyDf = this.genKey(FCompanyId, FAccountBankID, FCurrencyId, FType, datatypeDf);
                amtMap.put(keyDf, creditValue);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sql: " + sql));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return amtMap;
    }

    private String genKey(String FCompanyId, String FAccountBankID, String FCurrencyId, String FType, String dataType) {
        StringBuffer sb = new StringBuffer();
        sb.append("FCompanyId--");
        if (FCompanyId == null) {
            sb.append("null");
        } else {
            sb.append(FCompanyId);
        }
        sb.append("FAccountBankID--");
        if (FAccountBankID == null) {
            sb.append("null");
        } else {
            sb.append(FAccountBankID);
        }
        sb.append("FCurrencyId--");
        if (FCurrencyId == null) {
            sb.append("null");
        } else {
            sb.append(FCurrencyId);
        }
        sb.append("FType--");
        if (FType == null) {
            sb.append("null");
        } else {
            sb.append(FType);
        }
        sb.append("dataType--");
        if (dataType == null) {
            sb.append("null");
        } else {
            sb.append(dataType);
        }
        return sb.toString();
    }

    @Override
    protected IObjectCollection _exec(Context ctx, InacctTypeEnum inacctType, IObjectCollection coll) throws BOSException, EASBizException {
        switch (inacctType.getValue()) {
            case 1: {
                return this.execInacct(ctx, coll);
            }
            case 6: {
                return this.execInacctExt(ctx, coll);
            }
            case 3: {
                return this.execReportCal(ctx, coll);
            }
            case 2: {
                return this.execCashMgt(ctx, coll);
            }
            case 5: {
                return this.execMReportCal(ctx, coll);
            }
        }
        return this.execOutacct(ctx, coll);
    }

    @Override
    protected IObjectCollection _execBatch(Context ctx, InacctTypeEnum inacctType, IObjectCollection coll, CapitalStockTypeEnum type) throws BOSException, EASBizException {
        Object[] params = null;
        String companyNumber = null;
        CashDataSourceEnum dataSource = null;
        String accountNum = null;
        String acctTableNum = null;
        String bankAcctNum = null;
        String currencyNum = null;
        String companyNum = null;
        Date beginDate = null;
        Date endDate = null;
        CashDataTypeEnum dataType = null;
        boolean isIncludeUnsettled = false;
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            params = info.getParams();
            dataType = (CashDataTypeEnum)params[8];
            if (CapitalStockTypeEnum.CAPITALCHANGE == type) {
                if (dataType != CashDataTypeEnum.JF) continue;
                companyNumber = (String)params[0];
                dataSource = (CashDataSourceEnum)params[1];
                acctTableNum = (String)params[2];
                accountNum = (String)params[3];
                bankAcctNum = (String)params[4];
                currencyNum = (String)params[5];
                beginDate = (Date)params[6];
                endDate = (Date)params[7];
                isIncludeUnsettled = (Boolean)params[9];
                break;
            }
            companyNumber = (String)params[0];
            dataSource = (CashDataSourceEnum)params[1];
            acctTableNum = (String)params[2];
            accountNum = (String)params[3];
            bankAcctNum = (String)params[4];
            currencyNum = (String)params[5];
            beginDate = (Date)params[6];
            endDate = (Date)params[7];
            isIncludeUnsettled = (Boolean)params[9];
            break;
        }
        Map balanceMap = null;
        if (CapitalStockTypeEnum.FINALCAPITAL == type) {
            balanceMap = this.getBalanceBatch(ctx, companyNum, dataSource, acctTableNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, CashDataTypeEnum.Y, isIncludeUnsettled);
        } else {
            balanceMap = this.getBalanceBatch(ctx, companyNum, dataSource, acctTableNum, accountNum, bankAcctNum, currencyNum, beginDate, DateHelper.getBeforeDay(beginDate), CashDataTypeEnum.C, isIncludeUnsettled);
            Map amtMap = this.getAmtBatch(ctx, companyNum, dataSource, acctTableNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, dataType, isIncludeUnsettled);
            balanceMap.putAll(amtMap);
            Map balanceMapY = this.getBalanceBatch(ctx, companyNum, dataSource, acctTableNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, CashDataTypeEnum.Y, isIncludeUnsettled);
            balanceMap.putAll(balanceMapY);
        }
        for (int i = 0; i < coll.size(); ++i) {
            String datatype;
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            params = info.getParams();
            companyNumber = (String)params[0];
            dataSource = (CashDataSourceEnum)params[1];
            acctTableNum = (String)params[2];
            accountNum = (String)params[3];
            bankAcctNum = (String)params[4];
            currencyNum = (String)params[5];
            beginDate = (Date)params[6];
            endDate = (Date)params[7];
            dataType = (CashDataTypeEnum)params[8];
            isIncludeUnsettled = (Boolean)params[9];
            String journalType = String.valueOf(dataSource.getValue() + 1);
            String key = this.genKey(companyNumber, bankAcctNum, currencyNum, journalType, datatype = String.valueOf(dataType.getValue()));
            BigDecimal value = (BigDecimal)balanceMap.get(key);
            if (value == null) {
                value = Constants.ZERO;
            }
            info.setResult(value);
        }
        return coll;
    }
}

