/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransDownBillCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillOverdraftChecker;
import com.kingdee.eas.fm.fs.TransDownBillStateEnum;
import com.kingdee.eas.fm.fs.app.AbstractTransDownBillWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDownBillWebFacadeControllerBean
extends AbstractTransDownBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.TransDownBillWebFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.fm.fs.TransUpAndDownWebResource";
    private static final String EDIT = "TRANS_DOWN_EDIT";
    private static final String SUBMIT = "TRANS_DOWN_SUBMIT";
    private static final String AUDIT = "TRANS_DOWN_AUDIT";
    private static final String UN_AUDIT = "TRANS_DOWN_UN_AUDIT";
    private static final String CONFIRM = "TRANS_DOWN_CONFIRM";
    private static final String UN_CONFIRM = "TRANS_DOWN_UN_CONFIRM";
    private static final String COMMITTOBE = "TRANS_DOWN_DELETE_COMMITTOBE";
    private static final String SEND_RECEIPT = "TRANS_DOWN_SEND_RECEIPT";
    private static final String WITHDRAW_RECEIPT = "TRANS_DOWN_WITHDRAW_RECEIPT";
    private static final String SUCESSMSG = "sucessMsg";

    @Override
    protected Map _save(Context ctx, TransDownBillInfo info) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.checkPermission(ctx, info.getCompany(), EDIT, "Permission_NO_Save");
        this.verifyBeforeSaveAndSubmit(ctx, info);
        this.checkbillStatusChanged(info);
        IObjectPK pk = TransDownBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Save_Success"));
        map.put("id", pk.toString());
        return map;
    }

    @Override
    protected Map _submit(Context ctx, TransDownBillInfo info) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.checkPermission(ctx, info.getCompany(), SUBMIT, "Permission_NO_Submit");
        this.verifyBeforeSaveAndSubmit(ctx, info);
        this.checkbillStatusChanged(info);
        info.setState(TransDownBillStateEnum.SUBMITED);
        TransDownBillOverdraftChecker checker = new TransDownBillOverdraftChecker();
        checker.batchCheckOverdraft(ctx, info);
        IObjectPK pk = TransDownBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Submit_Success"));
        map.put("id", pk.toString());
        return map;
    }

    private void verifyBeforeSaveAndSubmit(Context ctx, TransDownBillInfo info) throws BOSException, EASBizException {
        TransDownBillEntryCollection entrys = info.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Entry_Not_Null")});
        }
        boolean tm110 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "TM110"));
        for (int i = entrys.size() - 1; i >= 0; --i) {
            TransDownBillEntryInfo entry = entrys.get(i);
            if (entry.getUnitAcctBank() == null) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UnitAcctBank_Not_Null")});
            }
            if (!(info.getState() != TransDownBillStateEnum.SAVED && tm110 || !EmptyUtil.isEmpty((String)entry.getRecProvince()) && !EmptyUtil.isEmpty((String)entry.getRecCity()))) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Province_City_Not_Null")});
            }
            if (entry.getAmount().compareTo(BigDecimal.ZERO) != 0) continue;
            entrys.remove(entry);
        }
        if (entrys.size() == 0) {
            throw new TransBillException(TransBillException.ENTRYAMTISALLZERO);
        }
    }

    private void checkbillStatusChanged(TransDownBillInfo info) throws EASBizException, BOSException {
        EntityViewInfo query = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        query.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("state");
        query.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK(info.getId())));
        TransDownBillCollection coll = TransDownBillFactory.getRemoteInstance().getTransDownBillCollection(query);
        if (null != coll && coll.size() > 0) {
            TransDownBillInfo transdowninfo = coll.get(0);
            if (info.getState() != transdowninfo.getState()) {
                throw new TransBillException(TransBillException.STATECHANGE);
            }
        }
    }

    @Override
    protected Map _audit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransDownBillInfo info = this.getTransDownBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), AUDIT, "Permission_NO_Audit");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransDownBillFacadeFactory.getLocalInstance(ctx).audit(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Audit_Success"));
        return map;
    }

    @Override
    protected Map _unAudit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransDownBillInfo info = this.getTransDownBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), UN_AUDIT, "Permission_NO_UnAudit");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransDownBillFacadeFactory.getLocalInstance(ctx).antiAudit(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UnAudit_Success"));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _confirm(Context ctx, TransDownBillInfo info) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitInfo company = info.getCompany();
        this.checkPermission(ctx, company, CONFIRM, "Permission_NO_Confirm");
        Boolean isMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestBizObjIDForUpdate(info.getId().toString());
        if (!isMutex.booleanValue()) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
        }
        try {
            BigDecimal confirmedAmt = info.getConfirmedAmt();
            BigDecimal confirmedLocalAmt = confirmedAmt.multiply(info.getExchangeRate());
            if (company.getBaseCurrency() == null || company.getBaseCurrency().getPrecision() == 0) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("baseCurrency.id"));
                selector.add(new SelectorItemInfo("baseCurrency.precision"));
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), selector);
            }
            confirmedLocalAmt.setScale(company.getBaseCurrency().getPrecision(), 4);
            info.setConfirmedLocalAmt(confirmedLocalAmt);
            BigDecimal outAmt = FMConstants.ZERO;
            TransDownBillEntryCollection entrys = info.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                TransDownBillEntryInfo entryInfo = entrys.get(i);
                if (!entryInfo.isIsSuccessed()) {
                    entryInfo.setOutBgItemAmount(FMConstants.ZERO);
                    continue;
                }
                outAmt = outAmt.add(entryInfo.getAmount());
            }
            info.setOutBgItemAmount(outAmt);
            TransDownBillFacadeFactory.getLocalInstance(ctx).confirm(info);
            map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Confirm_Success"));
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(info.getId().toString());
        }
        return map;
    }

    @Override
    protected Map _unConfirm(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransDownBillInfo info = this.getTransDownBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), UN_CONFIRM, "Permission_NO_UnConfirm");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransDownBillFacadeFactory.getLocalInstance(ctx).unConfirm(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UnConfirm_Success"));
        return map;
    }

    @Override
    protected Map _submitToBe(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransDownBillInfo info = this.getTransDownBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), COMMITTOBE, "Permission_NO_SubmitToBe");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransDownBillFacadeFactory.getLocalInstance(ctx).commitToBE(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SubmitToBe_Success"));
        return map;
    }

    @Override
    protected Map _rejected(Context ctx, String id, String remark) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransDownBillInfo info = this.getTransDownBillInfo(ctx, id);
        if (!TransDownBillStateEnum.SAVED.equals((Object)info.getState()) && !TransDownBillStateEnum.SUBMITED.equals((Object)info.getState())) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_Rejected_StateError")});
        }
        if (!SourceTypeEnum.APPTRANSDOWN.equals((Object)info.getSourceType())) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_Rejected_NotFromApplyBill")});
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransDownBillFacadeFactory.getLocalInstance(ctx).rejectedApplyTransDown((IObjectPK)new ObjectUuidPK(id), remark);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Rejected_Success"));
        return map;
    }

    @Override
    protected Map _sendReceipt(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransDownBillInfo info = this.getTransDownBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), SEND_RECEIPT, "Permission_NO_SendReceipt");
        Boolean isMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestBizObjIDForUpdate(id);
        if (!isMutex.booleanValue()) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransDownBillFacadeFactory.getLocalInstance(ctx).sendReceipt(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SendReceipt_Success"));
        return map;
    }

    @Override
    protected Map _withdrawReceipt(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransDownBillInfo info = this.getTransDownBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), WITHDRAW_RECEIPT, "Permission_NO_WithdrawReceipt");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransDownBillFacadeFactory.getLocalInstance(ctx).withdrawReceipt(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"WithdrawReceipt_Success"));
        return map;
    }

    @Override
    protected Map _beforeUnConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean hasSendReceipt = TransDownBillFacadeFactory.getLocalInstance(ctx).hasSendReceipt(idSet);
        map.put("hasSendReceipt", String.valueOf(hasSendReceipt));
        return map;
    }

    private TransDownBillInfo getTransDownBillInfo(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("company.number"));
        return TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(id), selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillDetailColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        TransDownBillOverdraftChecker checker = new TransDownBillOverdraftChecker();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            boolean isLock = false;
            try {
                this.checkPermission(ctx, info.getCompany(), SUBMIT, "Permission_NO_Submit", permissionSet);
                isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                TransDownBillStateEnum state = info.getState();
                if (!state.equals((Object)TransDownBillStateEnum.SAVED) && !state.equals((Object)TransDownBillStateEnum.SUBMITED)) {
                    throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"237_TransDownBillControllerBean", (Locale)ctx.getLocale())});
                }
                checker.batchCheckOverdraft(ctx, info);
                info.setState(TransDownBillStateEnum.SUBMITED);
                TransDownBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_SUBMIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_SUBMIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            boolean isLock = false;
            try {
                this.checkPermission(ctx, info.getCompany(), AUDIT, "Permission_NO_Audit", permissionSet);
                isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransDownBillFacadeFactory.getLocalInstance(ctx).audit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_AUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_AUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchUnAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            boolean isLock = false;
            try {
                this.checkPermission(ctx, info.getCompany(), UN_AUDIT, "Permission_NO_UnAudit", permissionSet);
                isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransDownBillFacadeFactory.getLocalInstance(ctx).antiAudit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_UNAUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_UNAUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchConfirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillDetailColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            boolean isMutex = false;
            try {
                this.checkPermission(ctx, info.getCompany(), CONFIRM, "Permission_NO_Confirm", permissionSet);
                isMutex = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isMutex) {
                    throw new BEException(BEException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                BigDecimal confirmedAmt = new BigDecimal(0);
                BigDecimal confirmedLocalAmt = new BigDecimal(0);
                TransDownBillEntryCollection entrys = info.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    TransDownBillEntryInfo entry = entrys.get(j);
                    entry.setIsSuccessed(true);
                    confirmedAmt = confirmedAmt.add(entry.getAmount());
                    confirmedLocalAmt = confirmedLocalAmt.add(entry.getLocalAmt());
                }
                info.setConfirmedCounts(entrys.size());
                info.setConfirmedAmt(confirmedAmt);
                info.setConfirmedLocalAmt(confirmedLocalAmt);
                TransDownBillFacadeFactory.getLocalInstance(ctx).confirm(info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_CONFIRM_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_CONFIRM_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isMutex) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_CONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"CONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchUnConfirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), UN_CONFIRM, "Permission_NO_UnConfirm", permissionSet);
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransDownBillFacadeFactory.getLocalInstance(ctx).unConfirm(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_UNCONFIRM_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_UNCONFIRM_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_UNCONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UNCONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            boolean isMutex = false;
            try {
                this.checkPermission(ctx, info.getCompany(), COMMITTOBE, "Permission_NO_SubmitToBe", permissionSet);
                isMutex = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isMutex) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransDownBillFacadeFactory.getLocalInstance(ctx).commitToBE(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_COMMITTOBE_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_COMMITTOBE_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isMutex) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_COMMITTOBE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"COMMITTOBE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchSendReceipt(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), SEND_RECEIPT, "Permission_NO_SendReceipt", permissionSet);
                String billId = info.getId().toString();
                Boolean isMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestBizObjIDForUpdate(billId);
                if (!isMutex.booleanValue()) {
                    throw new BEException(BEException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransDownBillFacadeFactory.getLocalInstance(ctx).sendReceipt(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_SENDRECEIPT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_SENDRECEIPT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_SENDRECEIPT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SENDRECEIPT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchWithdrawReceipt(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransDownBillCollection coll = this.getTransDownBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TransDownBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), WITHDRAW_RECEIPT, "Permission_NO_WithdrawReceipt", permissionSet);
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransDownBillFacadeFactory.getLocalInstance(ctx).withdrawReceipt(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_WITHDRAWRECEIPT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DOWN_WITHDRAWRECEIPT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_WITHDRAWRECEIPT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"WITHDRAWRECEIPT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    protected TransDownBillCollection getTransDownBillColl(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return TransDownBillFactory.getLocalInstance(ctx).getTransDownBillCollection(view);
    }

    protected TransDownBillCollection getTransDownBillDetailColl(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("fundFlowItem.id"));
        sic.add(new SelectorItemInfo("fundFlowItem.number"));
        sic.add(new SelectorItemInfo("fundFlowItem.name"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.*"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.name"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("entrys.subAcct.*"));
        sic.add(new SelectorItemInfo("entrys.subAcct.innerAccount.*"));
        sic.add(new SelectorItemInfo("entrys.subAcct.innerAccount.company.*"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.id"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.number"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.name"));
        sic.add(new SelectorItemInfo("entrys.project.number"));
        sic.add(new SelectorItemInfo("entrys.project.name"));
        sic.add(new SelectorItemInfo("entrys.feeType.number"));
        sic.add(new SelectorItemInfo("entrys.feeType.name"));
        sic.add(new SelectorItemInfo("entrys.outBgItemNumber"));
        sic.add(new SelectorItemInfo("entrys.fpItem.number"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.id"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.name"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.number"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return TransDownBillFactory.getLocalInstance(ctx).getTransDownBillCollection(view);
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource, Set<String> permissionSet) throws EASBizException, BOSException {
        if (!permissionSet.contains(company.getId().toString())) {
            this.checkPermission(ctx, company, checkPermissionName, exceptionResource);
            permissionSet.add(company.getId().toString());
        }
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)checkPermissionName);
        if (!isPermission) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)exceptionResource, (String[])new String[]{company.getName()})});
        }
    }
}

