/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.common.CtrlNodeEnum;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.fs.ApplyTransUpCollection;
import com.kingdee.eas.fm.fs.ApplyTransUpFactory;
import com.kingdee.eas.fm.fs.ApplyTransUpInfo;
import com.kingdee.eas.fm.fs.ApplyTransUpStateEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransUpBillCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillStateEnum;
import com.kingdee.eas.fm.fs.app.AbstractTransUpBillControllerBean;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransUpBillControllerBean
extends AbstractTransUpBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.TransUpBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransUpBillEntryInfo entryInfo;
        TransUpBillInfo info = (TransUpBillInfo)model;
        Iterator iterator = info.getEntrys().iterator();
        while (iterator.hasNext() && (entryInfo = (TransUpBillEntryInfo)iterator.next()).getId() != null) {
            String sql = "select fid from t_fs_TransUpBillEntry where FTransDetailId=?";
            String billId = entryInfo.getTransDetailId();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
            try {
                if (!rs.next()) continue;
                throw new TransBillException(TransBillException.HASTRANSUP);
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
        }
        IObjectPK pk = super._addnew(ctx, model);
        if (info.isIsCreatedFromTransDetail() && BOTPUtil.getSrcBillIdSet((Context)ctx, (String)info.getId().toString()).size() <= 0) {
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                HashMap<String, String> idMap = new HashMap<String, String>();
                String sourceBillId = info.getEntrys().get(i).getTransDetailId();
                idMap.put(sourceBillId, info.getId().toString());
                BOTPUtil.saveBOTRelation((Context)ctx, idMap);
                this.dispose(ctx, sourceBillId, false, info.getNumber());
            }
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransUpBillInfo oldInfo;
        int state;
        this.checkNumberDup(ctx, model);
        this.checkCreatedFromApplyTransUpBySaveOrSubmit(ctx, (TransUpBillInfo)model);
        TransUpBillInfo info = (TransUpBillInfo)model;
        this.preProcess(ctx, info);
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (state = (oldInfo = this.getTransUpBillInfo(ctx, "select * where id='" + info.getId().toString() + "'")).getState().getValue()) != 1) {
            throw new TransBillException(TransBillException.STATEERRORSAVE, new Object[]{info.getNumber()});
        }
        this.disposeCreatedFromApplyTransUpBySaveOrSubmit(ctx, (TransUpBillInfo)model, false);
        this.processSourceTypeBySaveOrSubmit(ctx, (TransUpBillInfo)model);
        IObjectPK pk = super._save(ctx, model);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transupbill_save", (String)info.getCompany().getId().toString(), (String)"\u6682\u5b58\u4e0a\u5212\u5355");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit");
        this.checkNumberDup(ctx, model);
        this.checkCreatedFromTransDetail(ctx, (TransUpBillInfo)model);
        String pfLogId1 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit.checkCreatedFromApplyTransUpBySaveOrSubmit");
        this.checkCreatedFromApplyTransUpBySaveOrSubmit(ctx, (TransUpBillInfo)model);
        PerfLogRecorder.endRecord((String)pfLogId1);
        TransUpBillInfo info = (TransUpBillInfo)model;
        String pfLogId2 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit.checkBizUnitInfo");
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model, (CtrlNodeEnum)CtrlNodeEnum.submit);
        PerfLogRecorder.endRecord((String)pfLogId2);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((TransUpBillInfo)model));
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            int state;
            TransUpBillInfo oldInfo = this.getTransUpBillInfo(ctx, "select * where id='" + info.getId().toString() + "'");
            if (oldInfo != null) {
                String pfLogId7 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit.signBgItemRelease");
                FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
                PerfLogRecorder.endRecord((String)pfLogId7);
            }
            if ((state = oldInfo.getState().getValue()) != 1 && state != 2) {
                throw new TransBillException(TransBillException.STATEERROREDIT, new Object[]{info.getNumber()});
            }
        }
        String pfLogId8 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit.preProcess");
        this.preProcess(ctx, info);
        PerfLogRecorder.endRecord((String)pfLogId8);
        String pfLogId5 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit.disposeCreatedFromApplyTransUpBySaveOrSubmit");
        this.disposeCreatedFromApplyTransUpBySaveOrSubmit(ctx, (TransUpBillInfo)model, true);
        PerfLogRecorder.endRecord((String)pfLogId5);
        this.processSourceTypeBySaveOrSubmit(ctx, (TransUpBillInfo)model);
        UserInfo acceptor = (UserInfo)model.get("auditor");
        UserInfo cashier = (UserInfo)model.get("cashier");
        this.cleanUserInfo(acceptor, cashier, (TransUpBillInfo)model);
        String pfLogId4 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit._submit");
        IObjectPK pk = super._submit(ctx, model);
        PerfLogRecorder.endRecord((String)pfLogId4);
        String pfLogId3 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit.requestBudget");
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk, (CtrlNodeEnum)CtrlNodeEnum.submit);
        PerfLogRecorder.endRecord((String)pfLogId3);
        String pfLogId7 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._submit.processCreatedFromTransDetail");
        this.processCreatedFromTransDetail(ctx, pk, info, acceptor, cashier);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u63d0\u4ea4\u4e0a\u5212\u5355", (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transupbill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        PerfLogRecorder.endRecord((String)pfLogId7);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((TransUpBillInfo)model));
        PerfLogRecorder.endRecord((String)pfLogId);
        return pk;
    }

    private void cleanUserInfo(UserInfo acceptor, UserInfo cashier, TransUpBillInfo model) {
        if (model.isIsCreatedFromTransDetail()) {
            model.setAuditor(null);
            model.setCashier(null);
        }
    }

    private void processCreatedFromTransDetail(Context ctx, IObjectPK pk, TransUpBillInfo info, UserInfo acceptor, UserInfo cashier) throws BOSException, EASBizException {
        if (!info.isIsCreatedFromTransDetail()) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)"update T_FS_TransUpBill set FState = 3, FAuditorId = ?, FCashierId = ? where fid = ? ", (Object[])new String[]{EmptyUtil.isEmpty((CoreBaseInfo)acceptor) ? info.getCreator().getId().toString() : acceptor.getId().toString(), EmptyUtil.isEmpty((CoreBaseInfo)cashier) ? info.getCreator().getId().toString() : cashier.getId().toString(), pk.toString()});
        DbUtil.execute((Context)ctx, (String)"update T_FS_TransUpBillEntry set FIsSuccessed = 1 where fparentid = ? ", (Object[])new String[]{pk.toString()});
        info = this.getTransUpBillInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), this.getSelectors());
        TransUpBillEntryCollection entryColl = info.getEntrys();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryColl.get(i).setIsSuccessed(true);
        }
        this.preProcess(ctx, info);
        TransUpBillFacadeFactory.getLocalInstance(ctx).confirmRequires(info);
    }

    private void checkCreatedFromTransDetail(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        if (!info.isIsCreatedFromTransDetail()) {
            return;
        }
        if (null == info.getCompany()) {
            throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"63_TransDownBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (null == info.getMotherAcctBank()) {
            throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"64_TransDownBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (null == info.getCurrency()) {
            throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"65_TransDownBillControllerBean", (Locale)ctx.getLocale())});
        }
        boolean TM116 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "TM116"));
        int n = info.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            TransUpBillEntryInfo entryInfo = info.getEntrys().get(i);
            if (null == entryInfo.getUnitAcctBank()) {
                throw new FSException(FSException.COMMON, new String[]{entryInfo.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"66_TransDownBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getUnitAcctBank().getSubAccount())) {
                throw new FSException(FSException.COMMON, new String[]{entryInfo.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"67_TransDownBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (null == entryInfo.getUnit()) {
                throw new FSException(FSException.COMMON, new String[]{entryInfo.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"68_TransDownBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (!TM116 || entryInfo.getUnitAcctBank().getSubAccount().equalsPK((IObjectValue)info.getMotherAcctBank())) continue;
            throw new FSException(FSException.COMMON, new String[]{entryInfo.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"69_TransDownBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void preProcess(Context ctx, TransUpBillInfo info) throws EASBizException, BOSException {
        Date bizDate = info.getBizDate();
        info.setBizDate(DateTimeUtils.truncateDate((Date)bizDate));
        BigDecimal exRate = this.calculatorExchangeRate(ctx, info);
        info.setExchangeRate(exRate);
        int scale = this.getBaseCurrencyPrec(ctx, info);
        int roundingMode = 4;
        TransUpBillEntryCollection entryColl = info.getEntrys();
        TransUpBillEntryInfo entryInfo = null;
        BigDecimal totalAmt = Constants.ZERO;
        BigDecimal confirmAmt = Constants.ZERO;
        BigDecimal localAmt = Constants.ZERO;
        int totalCounts = 0;
        int confirmCounts = 0;
        for (int i = entryColl.size() - 1; i >= 0; --i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getUnitAcctBank() == null || entryInfo.getAmount() == null || entryInfo.getAmount().compareTo(Constants.ZERO) == 0) {
                entryColl.removeObject(i);
                continue;
            }
            totalAmt = totalAmt.add(entryInfo.getAmount());
            ++totalCounts;
            if (entryInfo.isIsSuccessed()) {
                confirmAmt = confirmAmt.add(entryInfo.getAmount());
                ++confirmCounts;
            }
            localAmt = entryInfo.getAmount().multiply(exRate);
            entryInfo.setLocalAmt(localAmt.setScale(scale, roundingMode));
        }
        info.setTotalAmt(totalAmt);
        info.setTotalCounts(totalCounts);
        info.setConfirmedAmt(confirmAmt);
        info.setConfirmedCounts(confirmCounts);
        localAmt = info.getTotalAmt().multiply(exRate);
        info.setTotalLocalAmt(localAmt.setScale(scale, roundingMode));
        localAmt = info.getConfirmedAmt().multiply(exRate);
        info.setConfirmedLocalAmt(localAmt.setScale(scale, roundingMode));
    }

    private BigDecimal calculatorExchangeRate(Context ctx, TransUpBillInfo info) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((Object)info.getExchangeRate()) || FMBillBigDecimalUtil.isEqZero((Object)info.getExchangeRate())) {
            ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)info.getCurrency(), (CurrencyInfo)info.getCompany().getBaseCurrency(), (CompanyOrgUnitInfo)info.getCompany(), (Date)info.getBizDate());
            BigDecimal rate = Constants.ONE;
            if (rateInfo != null) {
                rate = rateInfo.getConvertRate();
            }
            return rate;
        }
        return info.getExchangeRate();
    }

    private int getBaseCurrencyPrec(Context ctx, TransUpBillInfo info) throws EASBizException, BOSException {
        String currencyId = null;
        if (info.getCompany().getBaseCurrency() == null) {
            ObjectUuidPK companyPk = new ObjectUuidPK(info.getCompany().getId());
            currencyId = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPk).getBaseCurrency().getId().toString();
        } else {
            currencyId = info.getCompany().getBaseCurrency().getId().toString();
        }
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        return iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)).getPrecision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, pk);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
            if (!isLock) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
            }
            this.checkCreatedFromApplyTransUpBydelete(ctx, info);
            if (!info.getState().equals((Object)TransUpBillStateEnum.SAVED) && !info.getState().equals((Object)TransUpBillStateEnum.SUBMITED)) {
                throw new TransBillException(TransBillException.STATEERRORREMOVE, new Object[]{info.getNumber()});
            }
            FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
            boolean isCreateFromDetail = info.isIsCreatedFromTransDetail();
            if (isCreateFromDetail) {
                for (int i = 0; i < info.getEntrys().size(); ++i) {
                    String sourceBillId = info.getEntrys().get(i).getTransDetailId();
                    this.dispose(ctx, sourceBillId, true, null);
                }
            }
            this.disposeCreatedFromApplyTransUpByDelete(ctx, info);
            ctx.remove((Object)"rejectedApplyTransUp");
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
            super._delete(ctx, pk);
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(info.getId().toString());
            }
        }
    }

    private void dispose(Context ctx, String id, boolean isDelete, String number) throws BOSException {
        if (isDelete) {
            String sql = "update T_BE_TransDetail set FIsCreatedTransUp=0, FIsReced = 0, FrecedBillType = '', FRecedBillNumber = '' where fid= '" + id + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "Update T_BE_EReceipt set  FSrcBillbizType = null ,FBillNumber = null where FTransDetailId = '" + id + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            String sql = "update T_BE_TransDetail set FIsCreatedTransUp=1, FIsReced = 1, FrecedBillType = '" + this.getBOSType() + "', FRecedBillNumber = '" + number + "' where fid= '" + id + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        Set idSet = this.getIdSet((CoreBillBaseCollection)sourceBillCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("State");
        sic.add("Number");
        sic.add("Id");
        evi.setSelector(sic);
        TransUpBillCollection coll = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(evi);
        TransUpBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getState().equals((Object)TransUpBillStateEnum.CONFIRMED)) continue;
            throw new TransBillException(TransBillException.STATEERRORVOUCHER, new Object[]{info.getNumber()});
        }
        DAPTransformResult result = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        return result;
    }

    private Set getIdSet(CoreBillBaseCollection coll) {
        HashSet<String> idSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(coll.get(i).getId().toString());
        }
        return idSet;
    }

    private void setAccountant(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.size() < 1) {
            return;
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String userId = userInfo.getId().toString();
        String ids = FMHelper.setTran2String((Set)idSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_FS_TransUpBill SET FAccountantID = ? ").append(" WHERE FID IN ").append(ids);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId});
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation;
        BOSObjectType bosType;
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID()) && BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            TransUpBillInfo info = (TransUpBillInfo)srcBillVO;
            TransUpBillEntryCollection col = this.getTransUpBillInfo(ctx, "select entrys.* where id = '" + info.getId().toString() + "'").getEntrys();
            info.getEntrys().addCollection(col);
        }
        if ((bosType = BOSUuid.read((String)(relation = (BOTRelationInfo)bOTRelationInfo).getDestObjectID()).getType()).equals((Object)new VoucherInfo().getBOSType())) {
            TransUpBillInfo info = (TransUpBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW) || bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.EDIT)) {
                info.setAccountant(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private boolean isApplyTransUp(TransUpBillInfo model) {
        return SourceTypeEnum.APPTRANSUP.equals((Object)model.getSourceType());
    }

    private void checkApplyTransUpExists(Context ctx, TransUpBillInfo model) throws BOSException, EASBizException, FSException {
        Set idSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)model.getId().toString());
        if (FMHelper.isEmpty((Collection)idSet)) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("state");
        evi.getSelector().add("number");
        evi.getSelector().add("company.name");
        ApplyTransUpCollection applyTransUpCollection = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpCollection(evi);
        if (applyTransUpCollection.size() != idSet.size()) {
            throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"250_TransUpBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void checkApplyTransUpExistsAndState(Context ctx, TransUpBillInfo model) throws BOSException, EASBizException, FSException {
        Set idSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)model.getId().toString());
        if (FMHelper.isEmpty((Collection)idSet)) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("state");
        evi.getSelector().add("number");
        evi.getSelector().add("company.name");
        ApplyTransUpCollection applyTransUpCollection = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpCollection(evi);
        if (applyTransUpCollection.size() != idSet.size()) {
            throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"250_TransUpBillControllerBean", (Locale)ctx.getLocale())});
        }
        Iterator it = applyTransUpCollection.iterator();
        while (it.hasNext()) {
            ApplyTransUpInfo applyTransUpInfo = (ApplyTransUpInfo)it.next();
            if (ApplyTransUpStateEnum.AUDIT.equals((Object)applyTransUpInfo.getState())) continue;
            String msg = applyTransUpInfo.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"251_TransUpBillControllerBean", (Locale)ctx.getLocale()) + applyTransUpInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"231_TransDownBillControllerBean", (Locale)ctx.getLocale());
            throw new FSException(FSException.COMMON, new String[]{msg});
        }
    }

    private void checkCreatedFromApplyTransUpBySaveOrSubmit(Context ctx, TransUpBillInfo model) throws EASBizException, BOSException {
        if (!this.isApplyTransUp(model)) {
            return;
        }
        this.checkApplyTransUpExistsAndState(ctx, model);
    }

    private void disposeCreatedFromApplyTransUpBySaveOrSubmit(Context ctx, TransUpBillInfo model, boolean isSubmit) throws FSException, EASBizException, BOSException {
        if (!this.isApplyTransUp(model)) {
            return;
        }
        this.checkApplyTransUpExists(ctx, model);
        HashSet<String> idSet = new HashSet<String>();
        TransUpBillEntryCollection entrys = model.getEntrys();
        Iterator it = entrys.iterator();
        while (it.hasNext()) {
            TransUpBillEntryInfo transUpBillEntryInfo = (TransUpBillEntryInfo)it.next();
            this.mergeSet(idSet, transUpBillEntryInfo.getIdSet());
        }
        if (FMHelper.isEmpty(idSet) && !FMHelper.isEmpty((AbstractObjectCollection)entrys) && entrys.size() == 1) {
            TransUpBillEntryInfo transUpBillEntryInfo = entrys.get(0);
            String applyTransUpPk = transUpBillEntryInfo.getTransDetailId().toString();
            ApplyTransUpInfo applyTransUpInfo = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpInfo((IObjectPK)new ObjectUuidPK(applyTransUpPk));
            idSet.add(applyTransUpPk);
            transUpBillEntryInfo.setIdSet(applyTransUpPk);
            if (EmptyUtil.isEmpty((String)transUpBillEntryInfo.getDescription())) {
                transUpBillEntryInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"252_TransUpBillControllerBean", (Locale)ctx.getLocale()) + applyTransUpInfo.getNumber());
            }
        }
        if (isSubmit) {
            for (String id : idSet) {
                FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectUuidPK(id));
                FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(id));
            }
        }
        String ids = FMHelper.setTran2String(idSet);
        StringBuffer sb = new StringBuffer();
        sb.append("update T_FS_ApplyTransUp set FTransNumber = ? where fid IN ");
        sb.append(ids);
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{model.getNumber()});
    }

    private void mergeSet(Set set, String idString) {
        if (FMHelper.isEmpty((String)idString)) {
            return;
        }
        String[] idSet = idString.split(",");
        for (int i = 0; i < idSet.length; ++i) {
            set.add(idSet[i]);
        }
    }

    private void checkCreatedFromApplyTransUpBydelete(Context ctx, TransUpBillInfo model) throws FSException, EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (ctx.get((Object)"rejectedApplyTransUp") != null) {
            return;
        }
        if (BondUtil.getBooleanParam((Context)ctx, (String)"TM107", (CompanyOrgUnitInfo)company) && this.isApplyTransUp(model)) {
            throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"253_TransUpBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void disposeCreatedFromApplyTransUpByDelete(Context ctx, TransUpBillInfo model) throws FSException, EASBizException, BOSException {
        if (!this.isApplyTransUp(model)) {
            return;
        }
        this.checkApplyTransUpExists(ctx, model);
        if (ctx.get((Object)"rejectedApplyTransUp") == null) {
            String oql = "select * where transNumber ='" + model.getNumber() + "'";
            ApplyTransUpCollection applyTransUpCollection = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpCollection(oql);
            Iterator it = applyTransUpCollection.iterator();
            while (it.hasNext()) {
                ApplyTransUpInfo applyTransUpInfo = (ApplyTransUpInfo)it.next();
                FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)applyTransUpInfo);
                FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)new ObjectUuidPK(applyTransUpInfo.getId()), (IFMBgUsed)applyTransUpInfo);
                NTHelper.OnWaybgCtrl((Context)ctx, (String)new ObjectUuidPK(applyTransUpInfo.getId()).toString());
            }
        }
        DbUtil.execute((Context)ctx, (String)"update T_FS_ApplyTransUp set FTransNumber = null where FTransNumber = ?", (Object[])new String[]{model.getNumber()});
    }

    private void processSourceTypeBySaveOrSubmit(Context ctx, TransUpBillInfo model) {
        if (!this.isApplyTransUp(model)) {
            if (model.isIsCreatedFromTransDetail()) {
                model.setSourceType(SourceTypeEnum.TRANSDETAIL);
            } else {
                model.setSourceType(SourceTypeEnum.CUSTOMIZE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._batchSubmit");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        String pfLogId1 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._batchSubmit.getTransUpBillCollection");
        TransUpBillCollection coll = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(evi);
        PerfLogRecorder.endRecord((String)pfLogId1);
        String errorDetail = "";
        TransUpBillInfo info = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int validCount = 0;
        String pfLogId2 = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            boolean isLock = false;
            try {
                this.checkBeforeSaveOrSubmit(ctx, info);
                isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                ++validCount;
                info.setState(TransUpBillStateEnum.SUBMITED);
                pfLogId2 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillControllerBean._batchSubmit.submit");
                TransUpBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                PerfLogRecorder.endRecord((String)pfLogId2);
                continue;
            }
            catch (Exception ex) {
                PerfLogRecorder.endRecord(pfLogId2);
                errorDetail = errorDetail + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"254_TransUpBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + "\uff1a" + ex.getMessage() + "\n";
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        PerfLogRecorder.endRecord((String)pfLogId);
        return map;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add("company.number");
        sic.add("entrys.unit.number");
        sic.add("entrys.feetype.number");
        sic.add("entrys.project.number");
        sic.add("currency.number");
        sic.add("settletype.number");
        sic.add("fundflowItem.number");
        sic.add("entrys.fundflowItem.number");
        sic.add("motherAcctBank.bank.number");
        sic.add(new SelectorItemInfo("entrys.subAcct.innerAccount.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        sic.add(new SelectorItemInfo("entrys.project.number"));
        sic.add(new SelectorItemInfo("entrys.project.name"));
        sic.add(new SelectorItemInfo("entrys.feeType.number"));
        sic.add(new SelectorItemInfo("entrys.feeType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.name"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.id"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.name"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.number"));
        return sic;
    }

    private void checkBeforeSaveOrSubmit(Context ctx, TransUpBillInfo info) throws EASBizException, BOSException {
        TransUpBillStateEnum state = info.getState();
        if (!state.equals((Object)TransUpBillStateEnum.SAVED) && !state.equals((Object)TransUpBillStateEnum.SUBMITED)) {
            throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"237_TransDownBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected IObjectPK _submitForAuto(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, model);
        this.checkCreatedFromTransDetail(ctx, (TransUpBillInfo)model);
        this.checkCreatedFromApplyTransUpBySaveOrSubmit(ctx, (TransUpBillInfo)model);
        TransUpBillInfo info = (TransUpBillInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model, (CtrlNodeEnum)CtrlNodeEnum.submit);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((TransUpBillInfo)model));
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            int state;
            TransUpBillInfo oldInfo = this.getTransUpBillInfo(ctx, "select * where id='" + info.getId().toString() + "'");
            if (oldInfo != null) {
                FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
            }
            if ((state = oldInfo.getState().getValue()) != 1 && state != 2) {
                throw new TransBillException(TransBillException.STATEERROREDIT, new Object[]{info.getNumber()});
            }
        }
        this.preProcess(ctx, info);
        info.setState(TransUpBillStateEnum.SUBMITED);
        this.disposeCreatedFromApplyTransUpBySaveOrSubmit(ctx, (TransUpBillInfo)model, true);
        this.processSourceTypeBySaveOrSubmit(ctx, (TransUpBillInfo)model);
        IObjectPK pk = super._submit(ctx, model);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk, (CtrlNodeEnum)CtrlNodeEnum.submit);
        TransUpBillEntryCollection entryColl = info.getEntrys();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryColl.get(i).setIsSuccessed(true);
        }
        this.preProcess(ctx, info);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((TransUpBillInfo)model));
        return pk;
    }

    @Override
    protected Map _openSmart(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<String> validIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("isSmart"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        TransUpBillCollection transUpColl = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(view);
        BatchExecuteResult result = new BatchExecuteResult();
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)transUpColl)) {
            for (int i = 0; i < transUpColl.size(); ++i) {
                TransUpBillInfo info = transUpColl.get(i);
                if (info.getIsSmart().getValue() == 2 || info.getIsSmart().getValue() == 4) {
                    validIds.add(info.getId().toString());
                    if (EmptyUtil.isEmpty((String)numbers)) {
                        numbers = info.getNumber();
                        continue;
                    }
                    numbers = numbers + "," + info.getNumber();
                    continue;
                }
                result.getDetailMsgList().add(info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"503_SettlementBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if (!EmptyUtil.isEmpty(validIds)) {
            String idString = FMHelper.setTran2String(new HashSet(validIds));
            String sql = "update T_FS_TransUpBill set FIsSmart=1  where fid in " + idString;
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (transUpColl.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_OpenSmart", (String)companyID, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"541_TransUpBillControllerBean", (Locale)ctx.getLocale()));
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        if (!EmptyUtil.isEmpty(validIds) && validIds.size() == idSet.size()) {
            result.setError(0);
            result.setSummaryMsg(idSet.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"504_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setError(1);
            int success = validIds == null ? 0 : validIds.size();
            result.setSummaryMsg(success + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"505_SettlementBillControllerBean", (Locale)ctx.getLocale()) + (idSet.size() - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"506_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    @Override
    protected Map _closeSmart(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<String> validIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("isSmart"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        TransUpBillCollection transUpColl = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(view);
        BatchExecuteResult result = new BatchExecuteResult();
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)transUpColl)) {
            for (int i = 0; i < transUpColl.size(); ++i) {
                TransUpBillInfo info = transUpColl.get(i);
                if (info.getIsSmart().getValue() == 1 || info.getIsSmart().getValue() == 3) {
                    validIds.add(info.getId().toString());
                    if (EmptyUtil.isEmpty((String)numbers)) {
                        numbers = info.getNumber();
                        continue;
                    }
                    numbers = numbers + "," + info.getNumber();
                    continue;
                }
                result.getDetailMsgList().add(info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"508_SettlementBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if (!EmptyUtil.isEmpty(validIds)) {
            String idString = FMHelper.setTran2String(new HashSet(validIds));
            String sql = "update T_FS_TransUpBill set FIsSmart=2  where fid in " + idString;
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (transUpColl.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_CloseSmart", (String)companyID, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"542_TransUpBillControllerBean", (Locale)ctx.getLocale()));
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        if (!EmptyUtil.isEmpty(validIds) && validIds.size() == idSet.size()) {
            result.setError(0);
            result.setSummaryMsg(idSet.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"509_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setError(1);
            int success = validIds == null ? 0 : validIds.size();
            result.setSummaryMsg(success + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"510_SettlementBillControllerBean", (Locale)ctx.getLocale()) + (idSet.size() - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"511_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destObjCol) throws BOSException, EASBizException {
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
                for (int i = 0; i < bOTRelationInfos.size(); ++i) {
                    int j;
                    VoucherEntryCollection col;
                    HashSet<String> idSet;
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    VoucherInfo voucherInfo = new VoucherInfo();
                    if (destObjCol != null && destObjCol.size() > 0) {
                        try {
                            for (int j2 = 0; j2 < destObjCol.size(); ++j2) {
                                voucherInfo = (VoucherInfo)destObjCol.getObject(j2);
                                if (bOTRelationInfos.get(i).getDestObjectID().equals(voucherInfo.getId().toString())) break;
                            }
                        }
                        catch (Exception e) {
                            voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                        }
                    } else {
                        voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                    }
                    String oppAccountId = "";
                    VoucherEntryCollection coll = voucherInfo.getEntries();
                    for (int j3 = 0; j3 < coll.size(); ++j3) {
                        VoucherEntryInfo entryInfo = coll.get(j3);
                        if (EntryDC.DEBIT != entryInfo.getEntryDC() || entryInfo.getAccount() == null) continue;
                        oppAccountId = entryInfo.getAccount().getId().toString();
                        break;
                    }
                    HashSet<String> entryIdSet = new HashSet<String>();
                    TransUpBillInfo info = this.getTransUpBillInfo(ctx, (IObjectPK)new ObjectUuidPK(srcBillId));
                    TransUpBillEntryCollection entryColl = info.getEntrys();
                    for (int j4 = 0; j4 < entryColl.size(); ++j4) {
                        entryIdSet.add(entryColl.get(j4).getId().toString());
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("billId", entryIdSet, CompareType.INCLUDE));
                    boolean isexist = JournalFactory.getLocalInstance((Context)ctx).exists(filter);
                    String billSql = "";
                    String journalSql = "";
                    String vcResultSql = "";
                    if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                        billSql = "Update T_FS_TransUpBill set FVoucherID = null, FFivouchered = 0, FVoucherTypeID = null ,FACCOUNTANTID =null where FID = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = null , FVoucherTypeID = null, FVoucherId = null where FBillId in  (" + this.newBuildIn(entryIdSet.toArray());
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = null, FVOUCHERTYPEID = null where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillId in  (" + this.newBuildIn(entryIdSet.toArray()) + ")";
                        } else {
                            idSet = new HashSet<String>();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = null , FBillNumber = null ,FVoucherTypeID = null, FVoucherId = null where FBillId = '" + voucherInfo.getId().toString() + "'  or FBillId in  (" + this.newBuildIn(idSet.toArray());
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = null ,FbillNumber = null , FVOUCHERTYPEID = null where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "'  or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                        }
                    } else if (BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                        billSql = "Update T_FS_TransUpBill set FVoucherID =  '" + voucherInfo.getId().toString() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' where Fid = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' , FOPPACCOUNTVIEWID = '" + oppAccountId + "' where FBillId in  (" + this.newBuildIn(entryIdSet.toArray());
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillId in  (" + this.newBuildIn(entryIdSet.toArray()) + ")";
                        } else {
                            idSet = new HashSet();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            if (idSet.size() > 0) {
                                journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' where FBillId = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray());
                                vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FbillNumber  = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                            }
                        }
                    } else {
                        billSql = "Update T_FS_TransUpBill set FVoucherID =  '" + voucherInfo.getId().toString() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FFivouchered = 1 ,FACCOUNTANTID = '" + userId + "'  where Fid = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' , FOPPACCOUNTVIEWID = '" + oppAccountId + "' where FBillId in  (" + this.newBuildIn(entryIdSet.toArray());
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillId in  (" + this.newBuildIn(entryIdSet.toArray()) + ")";
                        } else {
                            idSet = new HashSet();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            if (idSet.size() > 0) {
                                journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' where FBillId = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray());
                                vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                            }
                        }
                    }
                    if (!EmptyUtil.isEmpty((String)billSql)) {
                        stmt.addBatch(billSql);
                    }
                    if (!EmptyUtil.isEmpty((String)journalSql)) {
                        stmt.addBatch(journalSql);
                    }
                    if (EmptyUtil.isEmpty((String)vcResultSql)) continue;
                    stmt.addBatch(vcResultSql);
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String newBuildIn(Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        for (int i = 0; i < set.length; ++i) {
            if (i == set.length - 1) {
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                continue;
            }
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

