/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ITransUpBill;
import com.kingdee.eas.fm.fs.ITransUpBillFacade;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransUpBillSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.TransUpBillSmartFilter");

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String queryOql = "";
        try {
            FilterInfo filterInfo = new FilterInfo(filterSql);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String compareOp;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String filterValue = null;
                    Object cmpVal = filterItemInfo.getCompareValue();
                    if (cmpVal != null) {
                        filterValue = cmpVal.toString();
                    }
                    if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endValue = "";
                    try {
                        Date date = df.parse(filterValue);
                        date.setTime(date.getTime() + 1000L);
                        endValue = df.format(date);
                        if (EmptyUtil.isEmpty((String)endValue)) continue;
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id,number where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        String exeSQL = iexec.getSQL();
        logger.error((Object)("TransUpBillSmartFilter============" + exeSQL + " and fissmart in (1,3) "));
        result = this.getSourceBillRowSet(ctx, exeSQL + " and fissmart in (1,3) ");
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"516_SettlementBillSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"517_SettlementBillSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(filterSql);
            }
        } else {
            result.append(filterSql);
        }
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.transUp_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.transUp_submit_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.transUp_submit_audit_commitToBe.getName().equals(operatorNumber) || InterfaceTypeEnum.transUp_submit_audit_comfirm.getName().equals(operatorNumber)) {
            result.append(" and state in (1,2) ");
        }
        if (InterfaceTypeEnum.transUp_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.transUp_audit_commitToBe.getName().equals(operatorNumber) || InterfaceTypeEnum.transUp_audit_comfirm.getName().equals(operatorNumber)) {
            result.append(" and state = 2 ");
        }
        if (InterfaceTypeEnum.transUp_commitToBe.getName().equals(operatorNumber)) {
            result.append(" and state = 3 and isCommittoBe = 0 ");
        }
        if (InterfaceTypeEnum.transUp_confirm.getName().equals(operatorNumber)) {
            result.append(" and state = 3 ");
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap map = new HashMap();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String payer = "";
        String approve = "";
        String creator = "";
        if (schemaInfo != null && schemaInfo.getPayeer() != null) {
            payer = schemaInfo.getPayeer().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getApprove() != null) {
            approve = schemaInfo.getApprove().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getOriginator() != null) {
            creator = schemaInfo.getOriginator().getId().toString();
        }
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            Map msg;
            HashSet set;
            int i;
            String operatorNumber = busiInfo.getOperatorNumber();
            ITransUpBill biz = TransUpBillFactory.getLocalInstance(ctx);
            ITransUpBillFacade facade = TransUpBillFacadeFactory.getLocalInstance(ctx);
            if (InterfaceTypeEnum.transUp_submit.getName().equals(operatorNumber)) {
                HashSet<String> idSet = null;
                for (i = 0; i < billList.size(); ++i) {
                    try {
                        idSet = new HashSet<String>();
                        idSet.add(billList.get(i).toString());
                        Map msg2 = biz.batchSubmit(idSet);
                        if (EmptyUtil.isEmpty(msg2.get("errorDetail"))) {
                            ++success;
                            continue;
                        }
                        ++failure;
                        errorMsg = errorMsg + msg2.get(billList.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.transUp_audit.getName().equals(operatorNumber)) {
                HashSet auditSet = new HashSet();
                for (i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet();
                        set.add(billList.get(i));
                        facade.audit(set);
                        auditSet.add(billList.get(i));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet) && !EmptyUtil.isEmpty((String)approve)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
            }
            if (InterfaceTypeEnum.transUp_commitToBe.getName().equals(operatorNumber)) {
                for (int i2 = 0; i2 < billList.size(); ++i2) {
                    try {
                        HashSet set2 = new HashSet();
                        set2.add(billList.get(i2));
                        facade.commitToBE(set2);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.transUp_confirm.getName().equals(operatorNumber)) {
                HashSet comfirmSet = new HashSet();
                for (int i3 = 0; i3 < billList.size(); ++i3) {
                    try {
                        set = new HashSet();
                        set.add(billList.get(i3));
                        msg = facade.batchConfirm(set);
                        if (msg.size() == 0) {
                            ++success;
                            comfirmSet.add(billList.get(i3));
                            continue;
                        }
                        ++failure;
                        errorMsg = errorMsg + msg.get(billList.get(i3));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(comfirmSet) && !EmptyUtil.isEmpty((String)payer)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])comfirmSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
            if (InterfaceTypeEnum.transUp_submit_audit.getName().equals(operatorNumber)) {
                HashSet<String> idSet = null;
                HashSet<String> auditSet = new HashSet<String>();
                for (int i4 = 0; i4 < billList.size(); ++i4) {
                    try {
                        idSet = new HashSet<String>();
                        idSet.add(billList.get(i4).toString());
                        msg = biz.batchSubmit(idSet);
                        if (!EmptyUtil.isEmpty(msg.get("errorDetail"))) {
                            ++failure;
                            errorMsg = errorMsg + msg.get(billList.get(i4));
                            continue;
                        }
                        facade.audit(idSet);
                        auditSet.add(billList.get(i4).toString());
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet) && !EmptyUtil.isEmpty((String)approve)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
            }
            if (InterfaceTypeEnum.transUp_submit_audit_commitToBe.getName().equals(operatorNumber)) {
                HashSet<String> idSet = null;
                HashSet<String> auditSet = new HashSet<String>();
                for (int i5 = 0; i5 < billList.size(); ++i5) {
                    try {
                        idSet = new HashSet<String>();
                        idSet.add(billList.get(i5).toString());
                        msg = biz.batchSubmit(idSet);
                        if (!EmptyUtil.isEmpty(msg.get("errorDetail"))) {
                            ++failure;
                            errorMsg = errorMsg + msg.get(billList.get(i5));
                            continue;
                        }
                        facade.audit(idSet);
                        auditSet.add(billList.get(i5).toString());
                        facade.commitToBE(idSet);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet) && !EmptyUtil.isEmpty((String)approve)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
            }
            if (InterfaceTypeEnum.transUp_audit_commitToBe.getName().equals(operatorNumber)) {
                HashSet<String> idSet = null;
                HashSet<String> auditSet = new HashSet<String>();
                for (int i6 = 0; i6 < billList.size(); ++i6) {
                    try {
                        idSet = new HashSet<String>();
                        idSet.add(billList.get(i6).toString());
                        facade.audit(idSet);
                        auditSet.add(billList.get(i6).toString());
                        facade.commitToBE(idSet);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet) && !EmptyUtil.isEmpty((String)approve)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
            }
            if (InterfaceTypeEnum.transUp_audit_comfirm.getName().equals(operatorNumber)) {
                HashSet<String> idSet = null;
                HashSet<String> auditSet = new HashSet<String>();
                HashSet<String> comfirmSet = new HashSet<String>();
                for (int i7 = 0; i7 < billList.size(); ++i7) {
                    try {
                        idSet = new HashSet<String>();
                        idSet.add(billList.get(i7).toString());
                        facade.audit(idSet);
                        auditSet.add(billList.get(i7).toString());
                        Map confirmMsg = facade.batchConfirm(idSet);
                        if (confirmMsg.size() == 0) {
                            ++success;
                            comfirmSet.add(billList.get(i7).toString());
                            continue;
                        }
                        ++failure;
                        errorMsg = errorMsg + confirmMsg.get(billList.get(i7));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet) && !EmptyUtil.isEmpty((String)approve)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(comfirmSet) && !EmptyUtil.isEmpty((String)payer)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])comfirmSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
            if (InterfaceTypeEnum.transUp_submit_audit_comfirm.getName().equals(operatorNumber)) {
                HashSet<String> idSet = null;
                HashSet<String> auditSet = new HashSet<String>();
                HashSet<String> comfirmSet = new HashSet<String>();
                for (int i8 = 0; i8 < billList.size(); ++i8) {
                    try {
                        idSet = new HashSet<String>();
                        idSet.add(billList.get(i8).toString());
                        Map msg3 = biz.batchSubmit(idSet);
                        if (!EmptyUtil.isEmpty(msg3.get("errorDetail"))) {
                            ++failure;
                            errorMsg = errorMsg + msg3.get(billList.get(i8));
                            continue;
                        }
                        facade.audit(idSet);
                        auditSet.add(billList.get(i8).toString());
                        Map confirmMsg = facade.batchConfirm(idSet);
                        if (confirmMsg.size() == 0) {
                            ++success;
                            comfirmSet.add(billList.get(i8).toString());
                            continue;
                        }
                        ++failure;
                        errorMsg = errorMsg + confirmMsg.get(billList.get(i8));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet) && !EmptyUtil.isEmpty((String)approve)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(comfirmSet) && !EmptyUtil.isEmpty((String)payer)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_TransUpBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])comfirmSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
        }
        if (errorMsg.length() > 600) {
            errorMsg = errorMsg.substring(0, 600);
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }
}

