/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransUpBillCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillStateEnum;
import com.kingdee.eas.fm.fs.app.AbstractTransUpBillWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransUpBillWebFacadeControllerBean
extends AbstractTransUpBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.TransUpBillWebFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.fm.fs.TransUpAndDownWebResource";
    private static final String EIDT = "TRANS_UP_EIDT";
    private static final String SUBMIT = "TRANS_UP_SUBMIT";
    private static final String AUDIT = "TRANS_UP_AUDIT";
    private static final String UN_AUDIT = "TRANS_UP_UN_AUDIT";
    private static final String CONFIRM = "TRANS_UP_CONFIRM";
    private static final String UN_CONFIRM = "TRANS_UP_UN_CONFIRM";
    private static final String COMMITTOBE = "TRANS_UP_DELETE_COMMITTOBE";
    private static final String SEND_RECEIPT = "TRANS_UP_SEND_RECEIPT";
    private static final String WITHDRAW_RECEIPT = "TRANS_UP_WITHDRAW_RECEIPT";
    private static final String SUCESSMSG = "sucessMsg";

    @Override
    protected Map _save(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.checkPermission(ctx, info.getCompany(), EIDT, "Permission_NO_Save");
        this.verifyBeforeSaveAndSubmit(ctx, info);
        this.checkbillStatusChanged(info);
        IObjectPK pk = TransUpBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Save_Success"));
        map.put("id", pk.toString());
        return map;
    }

    @Override
    protected Map _submit(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.checkPermission(ctx, info.getCompany(), SUBMIT, "Permission_NO_Submit");
        this.verifyBeforeSaveAndSubmit(ctx, info);
        this.checkbillStatusChanged(info);
        info.setState(TransUpBillStateEnum.SUBMITED);
        IObjectPK pk = TransUpBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Submit_Success"));
        map.put("id", pk.toString());
        return map;
    }

    private void verifyBeforeSaveAndSubmit(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        TransUpBillEntryCollection entrys = info.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Entry_Not_Null")});
        }
        for (int i = entrys.size() - 1; i >= 0; --i) {
            TransUpBillEntryInfo entry = entrys.get(i);
            if (entry.getUnitAcctBank() == null) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UnitAcctBank_Not_Null")});
            }
            if (entry.getAmount().compareTo(BigDecimal.ZERO) != 0) continue;
            entrys.remove(entry);
        }
        if (entrys.size() == 0) {
            throw new TransBillException(TransBillException.ENTRYAMTISALLZERO);
        }
    }

    private void checkbillStatusChanged(TransUpBillInfo info) throws EASBizException, BOSException {
        EntityViewInfo query = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        query.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("state");
        query.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK(info.getId())));
        TransUpBillCollection coll = TransUpBillFactory.getRemoteInstance().getTransUpBillCollection(query);
        if (null != coll && coll.size() > 0) {
            TransUpBillInfo transupinfo = coll.get(0);
            if (info.getState() != transupinfo.getState()) {
                throw new TransBillException(TransBillException.STATECHANGE);
            }
        }
    }

    @Override
    protected Map _audit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), AUDIT, "Permission_NO_Audit");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransUpBillFacadeFactory.getLocalInstance(ctx).audit(idSet);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transupbill_audit", (String)info.getCompany().getId().toString(), (String)"\u4e0a\u5212\u5355\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Audit_Success"));
        return map;
    }

    @Override
    protected Map _unAudit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), UN_AUDIT, "Permission_NO_UnAudit");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransUpBillFacadeFactory.getLocalInstance(ctx).antiAudit(idSet);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transupbill_Unaudit", (String)info.getCompany().getId().toString(), (String)"\u4e0a\u5212\u5355\u53cd\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UnAudit_Success"));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _confirm(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitInfo company = info.getCompany();
        this.checkPermission(ctx, company, CONFIRM, "Permission_NO_Confirm");
        Boolean isMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestBizObjIDForUpdate(info.getId().toString());
        if (!isMutex.booleanValue()) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
        }
        try {
            BigDecimal confirmedAmt = info.getConfirmedAmt();
            BigDecimal confirmedLocalAmt = confirmedAmt.multiply(info.getExchangeRate());
            if (company.getBaseCurrency() == null || company.getBaseCurrency().getPrecision() == 0) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("baseCurrency.id"));
                selector.add(new SelectorItemInfo("baseCurrency.precision"));
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), selector);
            }
            confirmedLocalAmt.setScale(company.getBaseCurrency().getPrecision(), 4);
            info.setConfirmedLocalAmt(confirmedLocalAmt);
            TransUpBillFacadeFactory.getLocalInstance(ctx).confirm(info);
            map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Confirm_Success"));
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(info.getId().toString());
        }
        return map;
    }

    @Override
    protected Map _unConfirm(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), UN_CONFIRM, "Permission_NO_UnConfirm");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransUpBillFacadeFactory.getLocalInstance(ctx).unConfirm(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UnConfirm_Success"));
        return map;
    }

    @Override
    protected Map _submitToBe(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), COMMITTOBE, "Permission_NO_SubmitToBe");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransUpBillFacadeFactory.getLocalInstance(ctx).commitToBE(idSet);
        String enableAutoSign = PermissionParameterFactory.getLocalInstance((Context)ctx).getPermissionParameter("EnableAutoSign");
        if ("true".equalsIgnoreCase(enableAutoSign)) {
            // empty if block
        }
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SubmitToBe_Success"));
        return map;
    }

    @Override
    protected Map _rejected(Context ctx, String id, String remark) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, id);
        if (!TransUpBillStateEnum.SAVED.equals((Object)info.getState()) && !TransUpBillStateEnum.SUBMITED.equals((Object)info.getState())) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_Rejected_StateError")});
        }
        if (!SourceTypeEnum.APPTRANSUP.equals((Object)info.getSourceType())) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_Rejected_NotFromApplyBill")});
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransUpBillFacadeFactory.getLocalInstance(ctx).rejectedApplyTransUp((IObjectPK)new ObjectUuidPK(id), remark);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Rejected_Success"));
        return map;
    }

    @Override
    protected Map _sendReceipt(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), SEND_RECEIPT, "Permission_NO_SendReceipt");
        Boolean isMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestBizObjIDForUpdate(id);
        if (!isMutex.booleanValue()) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransUpBillFacadeFactory.getLocalInstance(ctx).sendReceipt(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SendReceipt_Success"));
        return map;
    }

    @Override
    protected Map _withdrawReceipt(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        TransUpBillInfo info = this.getTransUpBillInfo(ctx, id);
        this.checkPermission(ctx, info.getCompany(), WITHDRAW_RECEIPT, "Permission_NO_WithdrawReceipt");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        TransUpBillFacadeFactory.getLocalInstance(ctx).withdrawReceipt(idSet);
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"WithdrawReceipt_Success"));
        return map;
    }

    private TransUpBillInfo getTransUpBillInfo(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("company.number"));
        return TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(id), selector);
    }

    @Override
    protected Map _beforeUnConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean hasSendReceipt = TransUpBillFacadeFactory.getLocalInstance(ctx).hasSendReceipt(idSet);
        map.put("hasSendReceipt", String.valueOf(hasSendReceipt));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillDetailColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            boolean isLock = false;
            try {
                this.checkPermission(ctx, info.getCompany(), SUBMIT, "Permission_NO_Submit", permissionSet);
                isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                TransUpBillStateEnum state = info.getState();
                if (!state.equals((Object)TransUpBillStateEnum.SAVED) && !state.equals((Object)TransUpBillStateEnum.SUBMITED)) {
                    throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"237_TransDownBillControllerBean", (Locale)ctx.getLocale())});
                }
                info.setState(TransUpBillStateEnum.SUBMITED);
                TransUpBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_SUBMIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_SUBMIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            try {
                numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
                this.checkPermission(ctx, info.getCompany(), AUDIT, "Permission_NO_Audit", permissionSet);
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransUpBillFacadeFactory.getLocalInstance(ctx).audit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_AUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_AUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_audit", (String)companyID, (String)"\u4e0a\u5212\u5355\u5ba1\u6279");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            try {
                numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
                this.checkPermission(ctx, info.getCompany(), UN_AUDIT, "Permission_NO_UnAudit", permissionSet);
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransUpBillFacadeFactory.getLocalInstance(ctx).antiAudit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_UNAUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_UNAUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_Unaudit", (String)companyID, (String)"\u4e0a\u5212\u5355\u53cd\u5ba1\u6279");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchConfirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillDetailColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            boolean isMutex = false;
            try {
                this.checkPermission(ctx, info.getCompany(), CONFIRM, "Permission_NO_Confirm", permissionSet);
                isMutex = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isMutex) {
                    throw new BEException(BEException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                BigDecimal confirmedAmt = new BigDecimal(0);
                BigDecimal confirmedLocalAmt = new BigDecimal(0);
                TransUpBillEntryCollection entrys = info.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    TransUpBillEntryInfo entry = entrys.get(j);
                    entry.setIsSuccessed(true);
                    confirmedAmt = confirmedAmt.add(entry.getAmount());
                    confirmedLocalAmt = confirmedLocalAmt.add(entry.getLocalAmt());
                }
                info.setConfirmedCounts(entrys.size());
                info.setConfirmedAmt(confirmedAmt);
                info.setConfirmedLocalAmt(confirmedLocalAmt);
                TransUpBillFacadeFactory.getLocalInstance(ctx).confirm(info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_CONFIRM_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_CONFIRM_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isMutex) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_CONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"CONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchUnConfirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), UN_CONFIRM, "Permission_NO_UnConfirm", permissionSet);
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransUpBillFacadeFactory.getLocalInstance(ctx).unConfirm(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_UNCONFIRM_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_UNCONFIRM_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_UNCONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UNCONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            boolean isMutex = false;
            try {
                this.checkPermission(ctx, info.getCompany(), COMMITTOBE, "Permission_NO_SubmitToBe", permissionSet);
                isMutex = iMutex.requestBizObjIDForUpdate(info.getId().toString());
                if (!isMutex) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransUpBillFacadeFactory.getLocalInstance(ctx).commitToBE(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_COMMITTOBE_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_COMMITTOBE_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (isMutex) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_COMMITTOBE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"COMMITTOBE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchSendReceipt(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), SEND_RECEIPT, "Permission_NO_SendReceipt", permissionSet);
                String billId = info.getId().toString();
                Boolean isMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestBizObjIDForUpdate(billId);
                if (!isMutex.booleanValue()) {
                    throw new BEException(BEException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransUpBillFacadeFactory.getLocalInstance(ctx).sendReceipt(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_SENDRECEIPT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_SENDRECEIPT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_SENDRECEIPT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SENDRECEIPT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchWithdrawReceipt(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TransUpBillCollection coll = this.getTransUpBillColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TransUpBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), WITHDRAW_RECEIPT, "Permission_NO_WithdrawReceipt", permissionSet);
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                TransUpBillFacadeFactory.getLocalInstance(ctx).withdrawReceipt(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_WITHDRAWRECEIPT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UP_WITHDRAWRECEIPT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_WITHDRAWRECEIPT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"WITHDRAWRECEIPT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    protected TransUpBillCollection getTransUpBillColl(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(view);
    }

    protected TransUpBillCollection getTransUpBillDetailColl(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("fundflowItem.number"));
        sic.add(new SelectorItemInfo("entrys.subAcct.innerAccount.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        sic.add(new SelectorItemInfo("entrys.project.number"));
        sic.add(new SelectorItemInfo("entrys.project.name"));
        sic.add(new SelectorItemInfo("entrys.feeType.number"));
        sic.add(new SelectorItemInfo("entrys.feeType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.name"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.id"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.name"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.subAccount.number"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(view);
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource, Set<String> permissionSet) throws EASBizException, BOSException {
        if (!permissionSet.contains(company.getId().toString())) {
            this.checkPermission(ctx, company, checkPermissionName, exceptionResource);
            permissionSet.add(company.getId().toString());
        }
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)checkPermissionName);
        if (!isPermission) {
            throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)exceptionResource, (String[])new String[]{company.getName()})});
        }
    }
}

