/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanException;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.LoanApplyBillFacadeFactory;
import com.kingdee.eas.fm.ft.FundTransferBillCollection;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillStatusEnum;
import com.kingdee.eas.fm.ft.app.AbstractFundTransferBillControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundTransferBillControllerBean
extends AbstractFundTransferBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ft.app.FundTransferBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FundTransferBillInfo oldInfo;
        FundTransferBillInfo info = (FundTransferBillInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((FundTransferBillInfo)model));
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = this.getFundTransferBillInfo(ctx, "select * where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        if (EmptyUtil.isEmpty((Object)((Object)((FundTransferBillInfo)model).getStatus())) || !((FundTransferBillInfo)model).getStatus().equals((Object)FundTransferBillStatusEnum.AUDITED)) {
            ((FundTransferBillInfo)model).setStatus(FundTransferBillStatusEnum.SUBMITED);
        }
        IObjectPK pkReturn = super._submit(ctx, model);
        FundTransferBillInfo sumbittedInfo = this.getFundTransferBillInfo(ctx, "select * where id='" + pkReturn.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pkReturn, (IFMBgUsed)sumbittedInfo);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pkReturn);
        return pkReturn;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ((FundTransferBillInfo)model).setStatus(FundTransferBillStatusEnum.SAVE);
        IObjectPK pkReturn = super._save(ctx, model);
        return pkReturn;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((FundTransferBillInfo)model).getCompany() == null) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        this.updateLoanApplyBill(ctx, (FundTransferBillInfo)model);
        return pkReturn;
    }

    private void updateLoanApplyBill(Context ctx, FundTransferBillInfo info) throws EASBizException, BOSException {
        if (info.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance((Context)ctx).afterGenLoanOrgBill((IObjectPK)new ObjectUuidPK(info.getLoanApplyBill().getId()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundTransferBillInfo info = this.getFundTransferBillInfo(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)info.getId().toString()));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        if (coll != null && coll.size() > 0) {
            FMHelper.throwFMCommonException((String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"4_FundTransferBillControllerBean", (Locale)ctx.getLocale()));
        }
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        if (info.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance((Context)ctx).afterLoanOrgBillDeleted((IObjectPK)new ObjectUuidPK(info.getLoanApplyBill().getId()));
        }
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FundTransferBillInfo info = (FundTransferBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _batchOverDue(Context ctx, Set fundTransIDSet) throws BOSException, EASBizException {
        this.overDueCheck(ctx, fundTransIDSet);
        this.doOverDue(ctx, fundTransIDSet);
    }

    private void overDueCheck(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FundTransferBillCollection col = this.getFundTransCol(ctx, loanIDSet);
        int size = col.size();
        FundTransferBillInfo tmp = null;
        for (int i = 0; i < size; ++i) {
            tmp = col.get(i);
            if (tmp.getLoanBalanceAmt().compareTo(Constants.ZERO) <= 0) {
                throw new ConsignmentLoanException(ConsignmentLoanException.OVERDUE_ERROR, new Object[]{tmp.getNumber()});
            }
            if (tmp.getStatus() != FundTransferBillStatusEnum.AUDITED) {
                throw new ConsignmentLoanException(ConsignmentLoanException.OVERDUE_ERROR1, new Object[]{tmp.getNumber()});
            }
            if (!tmp.isIsOverdue()) continue;
            throw new ConsignmentLoanException(ConsignmentLoanException.ALREADY_OVERDUE, new Object[]{tmp.getNumber()});
        }
    }

    private void doOverDue(Context ctx, Set loanIDSet) throws BOSException {
        String sql = "update T_FT_FundTransferBill set FIsOverdue = 1 where ";
        sql = sql + " fid in " + this.getValues(loanIDSet.toArray(new String[loanIDSet.size()]));
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    @Override
    protected void _batchCancelOveDue(Context ctx, Set fundTransIDSet) throws BOSException, EASBizException {
        this.checkCancelOverDue(ctx, fundTransIDSet);
        this.doCancelOverDue(ctx, fundTransIDSet);
    }

    private void doCancelOverDue(Context ctx, Set fundTransIDSet) throws BOSException {
        String sql = "update T_FT_FundTransferBill set FIsOverdue = 0 where ";
        sql = sql + " fid in " + this.getValues(fundTransIDSet.toArray(new String[fundTransIDSet.size()]));
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void checkCancelOverDue(Context ctx, Set fundTransIDSet) throws BOSException, EASBizException {
        FundTransferBillCollection col = this.getFundTransCol(ctx, fundTransIDSet);
        int size = col.size();
        FundTransferBillInfo tmp = null;
        for (int i = 0; i < size; ++i) {
            tmp = col.get(i);
            if (tmp.isIsOverdue()) continue;
            throw new ConsignmentLoanException(ConsignmentLoanException.CANCEL_OVERDUE_ERROR);
        }
    }

    private void antiAuditCheck(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FundTransferBillCollection col = this.getFundTransCol(ctx, loanIDSet);
        int size = col.size();
        FundTransferBillInfo tmp = null;
        for (int i = 0; i < size; ++i) {
            tmp = col.get(i);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billId", (Object)tmp.getId().toString()));
            view.setFilter(filter);
            JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
            if (coll != null && coll.size() > 0) {
                FMHelper.throwFMCommonException((String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"5_FundTransferBillControllerBean", (Locale)ctx.getLocale()));
            }
            if (tmp.getStatus() != FundTransferBillStatusEnum.AUDITED) {
                throw new ConsignmentLoanException(ConsignmentLoanException.ANTI_AUDIT_ERROR, new Object[]{tmp.getNumber()});
            }
            if (tmp.getExtTimes() > 0) {
                throw new ConsignmentLoanException(ConsignmentLoanException.HAS_EXT_ERROR);
            }
            if (!tmp.isIsGenLoan()) continue;
            throw new ConsignmentLoanException(ConsignmentLoanException.HAS_LOAD_ERROR);
        }
    }

    private FundTransferBillCollection getFundTransCol(Context ctx, Set loanIDSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanIDSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        FundTransferBillCollection col = this.getFundTransferBillCollection(ctx, evi);
        return col;
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            super.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected boolean _sendAntiAudit(Context ctx, IObjectPK fundTransferBillPK) throws BOSException {
        String sql = "update T_FT_FundTransferBill set FStatus = 1, FAuditorID = null  where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fundTransferBillPK.toString()});
        return true;
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        this.antiAuditCheck(ctx, idSet);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FundTransferBillCollection fundCol = this.getFundTransferBillCollection(ctx, evi);
        FundTransferBillInfo infoTmp = null;
        for (int i = 0; i < fundCol.size(); ++i) {
            infoTmp = fundCol.get(i);
            this.sendAntiAudit(ctx, (IObjectPK)new ObjectUuidPK(infoTmp.getId()));
        }
    }

    @Override
    protected boolean _isSupportWorkFlow(Context ctx) throws BOSException {
        return true;
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK fundTransferBillPK) throws BOSException, EASBizException {
        String sql = "update T_FT_FundTransferBill set FStatus = ?, FAuditorID = ? where fid = ?";
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), currentUser.getId().toString(), fundTransferBillPK.toString()});
    }

    @Override
    protected List _batchSubmit(Context ctx, Set ids) throws BOSException, EASBizException {
        FundTransferBillCollection fundTransferBillCollection = this.getFundTransCol(ctx, ids);
        ArrayList<String> returnList = new ArrayList<String>();
        FundTransferBillInfo tmpInfo = null;
        for (int i = 0; i < fundTransferBillCollection.size(); ++i) {
            tmpInfo = fundTransferBillCollection.get(i);
            try {
                if (tmpInfo.getStatus() != FundTransferBillStatusEnum.SAVE) continue;
                super.submit(ctx, (CoreBaseInfo)tmpInfo);
                returnList.add(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"22_FundTransferBillListUI"));
                continue;
            }
            catch (Exception e) {
                returnList.add(tmpInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"6_FundTransferBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        return returnList;
    }

    @Override
    protected void _updatePaymentBillID(Context ctx, IObjectPK fundTransInID, IObjectPK paymentBillID) throws BOSException, EASBizException {
        if (paymentBillID != null) {
            String sql = "update T_FT_FundTransferBill set FPaymentBillID = ? where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{paymentBillID.toString(), fundTransInID.toString()});
        } else {
            String sql = "update T_FT_FundTransferBill set FPaymentBillID = null where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fundTransInID.toString()});
        }
    }
}

