/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ft.FundTransferBillBookNotifyBuilder;
import com.kingdee.eas.fm.ft.FundTransferBillCollection;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.app.AbstractFundTransferBillFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FundTransferBillFacadeControllerBean
extends AbstractFundTransferBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ft.app.FundTransferBillFacadeControllerBean");

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        FundTransferBillBookNotifyBuilder builder = new FundTransferBillBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_FT_FundTransferBill SET FCashierID = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String billId = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            if (this.isBooked(ctx, billId)) continue;
            journalColl.addCollection(builder.getJournalColl(ctx, billId));
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
    }

    @Override
    protected void _antiBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_FT_FundTransferBill SET FCashierID = NULL WHERE FID = ? ";
        String billId = null;
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        }
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        FundTransferBillCollection coll = FundTransferBillFactory.getLocalInstance(ctx).getFundTransferBillCollection(evi);
        FundTransferBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getDistributeAcctBank() == null) {
                FMHelper.throwFMCommonException((String)(ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"7_FundTransferBillFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"8_FundTransferBillFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            if (info.isIsHistoryBill()) {
                FMHelper.throwFMCommonException((String)(ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"7_FundTransferBillFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"9_FundTransferBillFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            if (info.getPaymentBill() == null) continue;
            FMHelper.throwFMCommonException((String)(ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"7_FundTransferBillFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"10_FundTransferBillFacadeControllerBean", (Locale)ctx.getLocale())));
        }
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }
}

