/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferExtBillInfo;
import com.kingdee.eas.fm.ft.app.AbstractFundTransferExtBillControllerBean;
import com.kingdee.eas.framework.AbstractCoreBillBaseInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FundTransferExtBillControllerBean
extends AbstractFundTransferExtBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ft.app.FundTransferExtBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, info);
        if (((AbstractCoreBillBaseInfo)info).getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)((AbstractCoreBillBaseInfo)info).getSourceBillId(), (String)"1");
        }
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((FundTransferExtBillInfo)model).getCompany() == null) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        this.afterAddNew(ctx, model, pk);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
        this.afterUpdate(ctx, (FundTransferExtBillInfo)model);
    }

    private void afterUpdate(Context ctx, FundTransferExtBillInfo info) throws BOSException, EASBizException {
        String sql = "update T_FT_FundTransferBill set FMaturityDate = ?,FHorizon=?  where fid = ?";
        String loanid = info.getLoan().getId().toString();
        java.util.Date endDate = info.getAfterExtDate();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime()), this.getHorizon(ctx, info, endDate), loanid});
    }

    private void afterAddNew(Context ctx, IObjectValue info, IObjectPK pk) throws BOSException, EASBizException {
        this.updateLoanInfo(ctx, (FundTransferExtBillInfo)info, 1);
        this.saveBOTPRelationShip(ctx, (FundTransferExtBillInfo)info, pk);
    }

    private void saveBOTPRelationShip(Context ctx, FundTransferExtBillInfo info, IObjectPK pk) throws BOSException {
        if (FMHelper.isInstanceof((String)info.getSourceBillId(), FundTransferBillInfo.class)) {
            HashMap<String, String> botpRelationShip = new HashMap<String, String>();
            botpRelationShip.put(info.getLoan().getId().toString(), pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FundTransferExtBillInfo info = (FundTransferExtBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void updateLoanInfo(Context ctx, FundTransferExtBillInfo info, int type) throws BOSException, EASBizException {
        String sql = "update T_FT_FundTransferBill set FMaturityDate = ?,FHorizon=?,FExtTimes = FExtTimes+?  where fid = ?";
        String loanid = info.getLoan().getId().toString();
        if (type == 1) {
            java.util.Date endDate = info.getAfterExtDate();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime()), this.getHorizon(ctx, info, endDate), new Integer(1), loanid});
        } else {
            java.util.Date endDate = info.getBeforeExtDate();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime()), this.getHorizon(ctx, info, endDate), new Integer(-1), loanid});
        }
    }

    private BigDecimal getHorizon(Context ctx, FundTransferExtBillInfo info, java.util.Date endDate) throws EASBizException, BOSException {
        java.util.Date startDate = DateTimeUtils.truncateDate((java.util.Date)info.getLoan().getEffectiveDate());
        return FinHorizon.getHorizon((java.util.Date)startDate, (java.util.Date)endDate);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundTransferExtBillInfo info = this.getFundTransferExtBillInfo(ctx, pk, this.getLoanSelectors());
        this.updateLoanInfo(ctx, info, 2);
        if (info.getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)info.getSourceBillId(), (String)"0");
        }
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    private SelectorItemCollection getLoanSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loan.id"));
        sic.add(new SelectorItemInfo("loan.effectiveDate"));
        return sic;
    }
}

