/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.RepayBaseBillInfo;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.cl.modelutils.AppUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferExtBillCollection;
import com.kingdee.eas.fm.ft.FundTransferExtBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ft.LoanAndRepayEntryCollection;
import com.kingdee.eas.fm.ft.LoanAndRepayEntryEnum;
import com.kingdee.eas.fm.ft.LoanAndRepayEntryInfo;
import com.kingdee.eas.fm.ft.app.AbstractFundTransferRepayBillControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundTransferRepayBillControllerBean
extends AbstractFundTransferRepayBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ft.app.FundTransferRepayBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((FundTransferRepayBillInfo)model));
        FundTransferRepayBillInfo repayInfo = (FundTransferRepayBillInfo)model;
        repayInfo.setState(StateEnum.SUBMISSION);
        repayInfo.setLoanBaseBill(repayInfo.getLoan());
        repayInfo.setLastRepayDate(repayInfo.getLoan().getLastRepayDate());
        IObjectPK pk = super._submit(ctx, (IObjectValue)repayInfo);
        FundTransferRepayBillInfo sumbittedInfo = this.getFundTransferRepayBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
        this.reverseLoanRepay(ctx, sumbittedInfo.getSourceBillId(), "1");
        if (!repayInfo.getIsModifyOper()) {
            this.reverseFundTRansferBill(ctx, sumbittedInfo);
        }
        return pk;
    }

    private void reverseFundTRansferBill(Context ctx, FundTransferRepayBillInfo sumbittedInfo) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)sumbittedInfo)) {
            BigDecimal balanceAmt;
            FundTransferBillInfo fInfo = new FundTransferBillInfo();
            if (sumbittedInfo.getLoan() != null && sumbittedInfo.getLoan().getId() != null) {
                fInfo = FundTransferBillFactory.getLocalInstance(ctx).getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(sumbittedInfo.getLoan().getId()));
            }
            BigDecimal loanAmt = fInfo.getLoanAmt();
            BigDecimal loanBalanceAmt = fInfo.getLoanBalanceAmt();
            BigDecimal amt = balanceAmt = loanAmt.subtract(loanBalanceAmt);
            BigDecimal sumAmt = loanAmt;
            if (fInfo.getId() != null) {
                LoanAndRepayEntryEnum loanAndRepayEntryEnum;
                BigDecimal useAmt;
                LoanAndRepayEntryInfo info;
                int i;
                LoanAndRepayEntryCollection loanAndRepaycol = fInfo.getLoanAndRepay();
                boolean falg = false;
                for (i = 0; i < loanAndRepaycol.size(); ++i) {
                    info = loanAndRepaycol.get(i);
                    useAmt = info.getUseAmt();
                    loanAndRepayEntryEnum = info.getState();
                    if (!loanAndRepayEntryEnum.equals((Object)LoanAndRepayEntryEnum.PERMUTATION)) continue;
                    sumAmt = loanAmt.subtract(useAmt);
                    amt = balanceAmt.subtract(useAmt);
                }
                for (i = 0; i < loanAndRepaycol.size(); ++i) {
                    info = loanAndRepaycol.get(i);
                    useAmt = info.getUseAmt();
                    loanAndRepayEntryEnum = info.getState();
                    if (!loanAndRepayEntryEnum.equals((Object)LoanAndRepayEntryEnum.NORMAL)) continue;
                    BigDecimal ratio = useAmt.divide(sumAmt, 2, RoundingMode.HALF_UP);
                    BigDecimal returnAmt = amt.multiply(ratio);
                    info.setReturnAmt(returnAmt);
                    info.setOccAmt(useAmt.subtract(returnAmt));
                    falg = true;
                }
                if (falg) {
                    FundTransferBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(fInfo.getId()), (CoreBaseInfo)fInfo);
                }
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundTransferRepayBillInfo repayInfo = this.getFundTransferRepayBillInfo(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)repayInfo.getId().toString()));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        if (coll != null && coll.size() > 0) {
            FMHelper.throwFMCommonException((String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"4_FundTransferBillControllerBean", (Locale)ctx.getLocale()));
        }
        repayInfo.setLoanBaseBill(repayInfo.getLoan());
        this.deleteRelatedIntBill(ctx, pk);
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        this.reverseLoanRepay(ctx, repayInfo.getSourceBillId(), "0");
        AppUtils.afterRepaymentBillDeleted((Context)ctx, (RepayBaseBillInfo)repayInfo);
        this.reverseFundTransferExtBill(ctx, repayInfo);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        this.reverseFundTRansferBill(ctx, repayInfo);
    }

    private void deleteRelatedIntBill(Context ctx, IObjectPK repayBillPk) throws EASBizException, BOSException {
        FundTransferInterestBillFactory.getLocalInstance(ctx).deleteRaleted(repayBillPk);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((FundTransferRepayBillInfo)model).getCompany() == null) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        try {
            FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
            FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        }
        catch (Exception ex) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        return pkReturn;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FundTransferRepayBillInfo info = (FundTransferRepayBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            ObjectUuidPK srcBillPK = new ObjectUuidPK(AccessHelper.getId((Object)sourceBillCollection.getObject(i)));
            FundTransferInterestBillInfo intRe = this.findFundTransferInterestBillInfo(ctx, (IObjectPK)srcBillPK);
            if (intRe == null || intRe.isFivouchered()) continue;
            try {
                FundTransferInterestBillFactory.getLocalInstance(ctx).generateVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
                continue;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw new FMException(FMException.EASBIZADDBOT, new Object[]{e.getMessage()});
            }
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        FundTransferInterestBillInfo intRe = this.findFundTransferInterestBillInfo(ctx, sourceBillPk);
        if (intRe != null && intRe.isFivouchered()) {
            FundTransferInterestBillFactory.getLocalInstance(ctx).deleteVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    private FundTransferInterestBillInfo findFundTransferInterestBillInfo(Context ctx, IObjectPK srcBillPK) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("transRepay.id", (Object)srcBillPK.toString()));
        evi.setFilter(f);
        FundTransferInterestBillCollection intCol = FundTransferInterestBillFactory.getLocalInstance(ctx).getFundTransferInterestBillCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            return intCol.get(0);
        }
        return null;
    }

    @Override
    protected void _updateRecmentBillID(Context ctx, IObjectPK fundTransRecID, IObjectPK recBillID) throws BOSException, EASBizException {
        if (recBillID != null) {
            String sql = "update T_FT_FundTransferRepayBill set FRecBillID = ? where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recBillID.toString(), fundTransRecID.toString()});
        } else {
            String sql = "update T_FT_FundTransferRepayBill set FRecBillID = null where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fundTransRecID.toString()});
        }
    }

    private void reverseLoanRepay(Context ctx, String LoanRepayID, String isCreate) throws BOSException, EASBizException {
        if (!StringUtil.isEmpty((String)LoanRepayID)) {
            String sql = "Update T_FIN_LoanRepaymentApply set FIsCreateRepayBill =? where Fid=?";
            FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, LoanRepayID});
        }
    }

    private void reverseFundTransferExtBill(Context ctx, FundTransferRepayBillInfo repayInfo) throws BOSException {
        String fundTransferBillId = repayInfo.getLoan().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("loan", (Object)fundTransferBillId));
        view.setFilter(filter);
        view.setSelector(sel);
        FundTransferExtBillCollection exBillColls = FundTransferExtBillFactory.getLocalInstance(ctx).getFundTransferExtBillCollection(view);
        if (exBillColls != null && exBillColls.size() > 0) {
            BigDecimal repayAmt = repayInfo.getRepayAmt();
            BigDecimal repayAmtLocal = repayInfo.getRepayAmtLocal();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            String sql = "update T_FT_FundTransferExtBill set FLoanBalance = FLoanBalance+?, FLoanBalanceLocal=FLoanBalanceLocal +?  where fid = ?";
            for (int i = 0; i < exBillColls.size(); ++i) {
                Object[] params = new Object[]{repayAmt, repayAmtLocal, exBillColls.get(i).getId().toString()};
                paramsList.add(params);
            }
            DbUtil.executeBatchAndReturn((Context)ctx, (String)sql, paramsList);
        }
    }

    protected void _audit(Context ctx, Set ids) throws BOSException, EASBizException {
        String id2 = null;
        for (String id2 : ids) {
            super.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
        }
    }

    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), true);
    }

    protected void _unAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        try {
            String id2 = null;
            String sql = null;
            for (String id2 : ids) {
                sql = "select 1 from t_bot_relation where fsrcobjectid = '" + id2 + "' and FDestEntityID <> 'ABE9A18C'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    throw new FMException(FMException.HASDESTBILLNOTUNAUDIT);
                }
                super.unAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), false);
    }

    protected void updateState(Context ctx, String id, boolean isAudit) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_FT_FundTransferRepayBill set fstate = ?, fauditorID = ?, fauditTime = ? where fid = ? and fstate = ?");
        if (isAudit) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{2, userInfo.getId().toString(), new Date(this.getCurrentDate().getTime()), id, 1});
        } else {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{1, null, null, id, 2});
        }
    }
}

