/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.InterestBaseBillInfo;
import com.kingdee.eas.fm.cl.LoanBaseBillInfo;
import com.kingdee.eas.fm.cl.RepayBaseBillInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import java.math.BigDecimal;
import java.util.Date;

public class InterestBizDTO {
    private InterestBaseBillInfo intInfo;
    private int modualValue;
    private String tableName_Loan;
    private String tableName_Interest;
    private String column_loanID;
    private LoanInterestInfo info;

    public InterestBizDTO(InterestBaseBillInfo intInfo) {
        this.intInfo = intInfo;
        if (intInfo instanceof ConsignLoanIntBillInfo) {
            this.modualValue = 0;
            this.tableName_Loan = " T_CL_ConsignmentLoanBill ";
            this.tableName_Interest = " T_CL_ConsignLoanIntBill ";
            this.column_loanID = " floanid ";
        } else if (intInfo instanceof FundTransferInterestBillInfo) {
            this.modualValue = 1;
            this.tableName_Loan = " T_FT_FundTransferBill ";
            this.tableName_Interest = " T_FT_FundTransferInterestBill ";
            this.column_loanID = " FTransBillID ";
        }
    }

    public int getModualValue() {
        return this.modualValue;
    }

    public IntCalTypeEnum getIntCalType() {
        return this.intInfo.getIntCalType();
    }

    public LoanBaseBillInfo getLoan() {
        if (this.intInfo instanceof ConsignLoanIntBillInfo) {
            return ((ConsignLoanIntBillInfo)this.intInfo).getLoan();
        }
        if (this.intInfo instanceof FundTransferInterestBillInfo) {
            return ((FundTransferInterestBillInfo)this.intInfo).getTransBill();
        }
        return null;
    }

    public RepayBaseBillInfo getRepaymentBill() {
        if (this.intInfo instanceof ConsignLoanIntBillInfo) {
            return ((ConsignLoanIntBillInfo)this.intInfo).getRepaymentBill();
        }
        if (this.intInfo instanceof FundTransferInterestBillInfo) {
            return ((FundTransferInterestBillInfo)this.intInfo).getRepayInfo();
        }
        return null;
    }

    public RepayBaseBillInfo getRelatedRepayInfo() {
        if (this.intInfo instanceof ConsignLoanIntBillInfo) {
            return ((ConsignLoanIntBillInfo)this.intInfo).getRepayBill();
        }
        if (this.intInfo instanceof FundTransferInterestBillInfo) {
            return ((FundTransferInterestBillInfo)this.intInfo).getTransRepay();
        }
        return null;
    }

    public String getId() {
        return this.intInfo.getId().toString();
    }

    public Date getStartDate() {
        return this.intInfo.getStartDate();
    }

    public Date getEndDate() {
        return this.intInfo.getEndDate();
    }

    public Date getLastSettleDate() {
        return this.intInfo.getLastSettleDate();
    }

    public String getTableName_Loan() {
        return this.tableName_Loan;
    }

    public String getTableName_Interest() {
        return this.tableName_Interest;
    }

    public String getColumn_loanID() {
        return this.column_loanID;
    }

    public Date getLastPreIntDate() {
        return this.intInfo.getLastPreIntDate();
    }

    public BigDecimal getShijiIntAmt() {
        return this.intInfo.getShijiIntAmt();
    }

    public BigDecimal getShijiPenaAmt() {
        return this.intInfo.getShijiPenaAmt();
    }

    public BigDecimal getHandleChargeAmt() {
        BigDecimal handleChargeAmt = Constants.ZERO;
        if (this.intInfo instanceof ConsignLoanIntBillInfo) {
            handleChargeAmt = ((ConsignLoanIntBillInfo)this.intInfo).getHandleChargeAmt();
        }
        return handleChargeAmt;
    }

    public BigDecimal getSalesTax() {
        BigDecimal salesTax = Constants.ZERO;
        if (this.intInfo instanceof ConsignLoanIntBillInfo) {
            salesTax = ((ConsignLoanIntBillInfo)this.intInfo).getSalesTax();
        }
        return salesTax;
    }

    public InterestBaseBillInfo getIntInfo() {
        return this.intInfo;
    }

    public void setLoanInterestInfo(LoanInterestInfo loanIntInfo) {
        this.info = loanIntInfo;
    }

    public LoanInterestInfo getLoanInterestInfo() {
        return this.info;
    }
}

