/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.CreditAssetsReturnOutInfo;
import com.kingdee.eas.fm.ibt.app.AbstractCreditAssetsReturnOutControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditAssetsReturnOutControllerBean
extends AbstractCreditAssetsReturnOutControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ibt.app.CreditAssetsReturnOutControllerBean");

    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditAssetsReturnOutInfo info = null;
        info = this.getCreditAssetsReturnOutInfo(ctx, pk);
        if (info.getBillType() == BillTypeEnum.Audit) {
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "update T_IBT_CreditAssRetOut set FBillType = ? , Fauditorid= ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"2", auditorId, pk.toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditAssetsReturnOutInfo info = null;
        info = this.getCreditAssetsReturnOutInfo(ctx, pk);
        if (info.getBillType() != BillTypeEnum.Audit) {
            throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        if (!(FinHelper.hasDeferRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasIntRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasRepaymentOfLoan((Context)ctx, (String)info.getId().toString()))) {
            throw new LoanException(LoanException.ANTIAUDIT_HASOTHER_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String sql = "update T_IBT_CreditAssRetOut set FBillType = ? , Fauditorid=null where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", pk.toString()});
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _reduceQuantum(Context ctx, BigDecimal creditAmount, BigDecimal balance, String creditLimitId, String billId) throws BOSException, EASBizException {
        ArrayList arrlist = new ArrayList();
        Object mid = null;
        if (creditAmount != null && creditLimitId != null) {
            String sqlOld = "select * from t_fin_creditlimit where fid='" + creditLimitId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlOld);
            BigDecimal fbalance = null;
            BigDecimal usedAm = null;
            BigDecimal usedcAm = null;
            BigDecimal usedcRet = null;
            String creditlimitid = null;
            try {
                if (rs.next()) {
                    creditlimitid = rs.getString("fid");
                    fbalance = rs.getBigDecimal("fbalance");
                    usedAm = rs.getBigDecimal("fusedamount");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (usedAm == null) {
                usedAm = Constants.ZERO;
            }
            if (fbalance == null) {
                fbalance = Constants.ZERO;
            }
            BigDecimal lastUsed = usedAm.add(creditAmount);
            BigDecimal lastBalance = fbalance.subtract(creditAmount);
            String sql = null;
            sql = lastBalance.compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimit set fusedamount=" + lastUsed + " , fbalance= 0 where fid='" + creditLimitId + "' " : " update t_fin_creditlimit set fusedamount=" + lastUsed + " , fbalance=" + lastBalance + " where fid='" + creditLimitId + "' ";
            if (creditlimitid != null) {
                String usedcsql = "select * from t_fin_creditlimitused where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                IRowSet ts = DbUtil.executeQuery((Context)ctx, (String)usedcsql);
                try {
                    while (ts.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        usedcAm = ts.getBigDecimal("fUsedQuota");
                        usedcRet = ts.getBigDecimal("freturnedquota");
                        if (usedcRet == null) {
                            usedcRet = Constants.ZERO;
                        }
                        map.put("usedcAm", usedcAm);
                        map.put("usedcRet", usedcRet);
                        map.put("fid", ts.getString("fid"));
                        arrlist.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (arrlist.size() <= 1) {
                    BigDecimal lastusedcRet = usedcRet.subtract(creditAmount);
                    String usedsql = null;
                    usedsql = lastusedcRet.compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimitused set freturnedquota= 0 where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'" : " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                    DbUtil.execute((Context)ctx, (String)usedsql);
                } else {
                    int b;
                    for (int i = b = arrlist.size() - 1; i >= 0; --i) {
                        Map mapS = (Map)arrlist.get(i);
                        if (Double.parseDouble(mapS.get("usedcRet").toString()) == 0.0) continue;
                        if (!(creditAmount.doubleValue() > 0.0)) break;
                        if (Double.parseDouble(mapS.get("usedcRet").toString()) < creditAmount.doubleValue()) {
                            double lastusedcRet = 0.0;
                            String usedsql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                            DbUtil.execute((Context)ctx, (String)usedsql);
                            creditAmount = creditAmount.subtract((BigDecimal)mapS.get("usedcRet"));
                            continue;
                        }
                        BigDecimal lastusedcRet = new BigDecimal(mapS.get("usedcRet").toString()).subtract(creditAmount);
                        String usedsql = null;
                        usedsql = lastusedcRet.compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimitused set freturnedquota= 0  where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'" : " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                        DbUtil.execute((Context)ctx, (String)usedsql);
                        break;
                    }
                }
            }
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected void _returnQuantum(Context ctx, BigDecimal creditAmount, BigDecimal balance, String creditLimitId, String billId) throws BOSException, EASBizException {
        ArrayList arrList = new ArrayList();
        Object mid = null;
        String ffinproid = null;
        String fcreditusageid = null;
        if (creditAmount != null && creditLimitId != null) {
            String sqlOld = "select * from t_fin_creditlimit where fid='" + creditLimitId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlOld);
            BigDecimal fbalance = null;
            BigDecimal usedAm = null;
            BigDecimal usedcAm = null;
            BigDecimal usedcRet = null;
            String creditlimitid = null;
            try {
                if (rs.next()) {
                    creditlimitid = rs.getString("fid");
                    fbalance = rs.getBigDecimal("fbalance");
                    usedAm = rs.getBigDecimal("fusedamount");
                    fcreditusageid = rs.getString("fcreditusageid");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (usedAm == null) {
                usedAm = Constants.ZERO;
            }
            if (fbalance == null) {
                fbalance = Constants.ZERO;
            }
            double lastUsed = Double.parseDouble(usedAm.toString()) - Double.parseDouble(creditAmount.toString());
            double lastBalance = Double.parseDouble(fbalance.toString()) + Double.parseDouble(creditAmount.toString());
            String sql = null;
            sql = usedAm.subtract(creditAmount).compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimit set fusedamount=0 , fbalance=" + fbalance.add(creditAmount) + " where fid='" + creditLimitId + "' " : " update t_fin_creditlimit set fusedamount=" + usedAm.subtract(creditAmount) + " , fbalance=" + fbalance.add(creditAmount) + " where fid='" + creditLimitId + "' ";
            if (creditlimitid != null) {
                String usedcsql = "select * from t_fin_creditlimitused where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                IRowSet ts = DbUtil.executeQuery((Context)ctx, (String)usedcsql);
                try {
                    while (ts.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        usedcAm = ts.getBigDecimal("fUsedQuota");
                        usedcRet = ts.getBigDecimal("freturnedquota");
                        ffinproid = ts.getString("ffinproid");
                        if (usedcAm == null) {
                            usedcAm = Constants.ZERO;
                        }
                        if (usedcRet == null) {
                            usedcRet = Constants.ZERO;
                        }
                        map.put("usedcAm", usedcAm);
                        map.put("usedcRet", usedcRet);
                        map.put("fid", ts.getString("fid"));
                        map.put("fproperty", ts.getString("fproperty"));
                        map.put("ffinproid", ts.getString("ffinproid"));
                        arrList.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (arrList.size() <= 1) {
                    BigDecimal lastusedcRet = usedcRet.add(creditAmount);
                    String usedsql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + "  where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                    DbUtil.execute((Context)ctx, (String)usedsql);
                } else {
                    int b;
                    for (int i = b = arrList.size() - 1; i >= 0; --i) {
                        String retsql;
                        String usedSql;
                        BigDecimal lastusedcRet;
                        Map mapS = (Map)arrList.get(i);
                        if (!mapS.get("fproperty").equals("1") || Double.parseDouble(mapS.get("usedcRet").toString()) >= Double.parseDouble(mapS.get("usedcAm").toString())) continue;
                        if (Double.parseDouble(creditAmount.toString()) >= Double.parseDouble(mapS.get("usedcAm").toString())) {
                            if (Double.parseDouble(creditAmount.toString()) <= Double.parseDouble(mapS.get("usedcAm").toString()) - Double.parseDouble(mapS.get("usedcRet").toString())) {
                                lastusedcRet = new BigDecimal(mapS.get("usedcRet").toString()).add(creditAmount);
                                usedSql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                                retsql = "update t_fin_creditlimitentry set fbanlance=(select fsharedamount from t_fin_creditlimitentry where ffinproid='" + mapS.get("ffinproid") + "' and fparentid='" + creditlimitid + "') where ffinproid='" + mapS.get("ffinproid") + "'and fparentid='" + creditlimitid + "'";
                                DbUtil.execute((Context)ctx, (String)retsql);
                                DbUtil.execute((Context)ctx, (String)usedSql);
                                continue;
                            }
                            lastusedcRet = new BigDecimal(mapS.get("usedcAm").toString());
                            creditAmount = new BigDecimal(creditAmount.doubleValue() - (Double.parseDouble(mapS.get("usedcAm").toString()) - Double.parseDouble(mapS.get("usedcRet").toString())));
                            usedSql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                            retsql = "update t_fin_creditlimitentry set fbanlance=(select fsharedamount from t_fin_creditlimitentry where ffinproid='" + mapS.get("ffinproid") + "' and fparentid='" + creditlimitid + "') where ffinproid='" + mapS.get("ffinproid") + "'and fparentid='" + creditlimitid + "'";
                            DbUtil.execute((Context)ctx, (String)retsql);
                            DbUtil.execute((Context)ctx, (String)usedSql);
                            continue;
                        }
                        lastusedcRet = new BigDecimal(mapS.get("usedcRet").toString()).add(creditAmount);
                        usedSql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                        retsql = "update t_fin_creditlimitentry set fbanlance=(select fsharedamount from t_fin_creditlimitentry where ffinproid='" + mapS.get("ffinproid") + "' and fparentid='" + creditlimitid + "') where ffinproid='" + mapS.get("ffinproid") + "'and fparentid='" + creditlimitid + "'";
                        DbUtil.execute((Context)ctx, (String)retsql);
                        DbUtil.execute((Context)ctx, (String)usedSql);
                        break;
                    }
                }
            }
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected boolean _turnWriteBalance(Context ctx, String billNum, BigDecimal balance) throws BOSException, EASBizException {
        String sql = null;
        BigDecimal big = new BigDecimal(balance.toString());
        sql = big.compareTo(new BigDecimal(0)) == 0 ? " update T_IBT_CredAsstTransOut set fbalance=0 where fid='" + billNum + "' " : " update T_IBT_CredAsstTransOut set fbalance=" + big + " where fid='" + billNum + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }

    @Override
    protected Map _getOldBillData(Context ctx, String sceBillNum) throws BOSException {
        HashMap<String, Comparable<BigDecimal>> dataMap = new HashMap<String, Comparable<BigDecimal>>();
        String sql = "select * from T_IBT_CredAsstTransOut a where a.fid='" + sceBillNum + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                dataMap.put("balance", rs.getBigDecimal("fbalance"));
                dataMap.put("bizDate", rs.getDate("fbizdate"));
                dataMap.put("endDate", rs.getDate("FEXPIREDDATE"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dataMap;
    }

    @Override
    protected Map _getOldCridit(Context ctx, String billNumber) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sql = "select * from T_IBT_CredAsstTransOut a where a.fid='" + billNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                String sqlc;
                IRowSet rt;
                map.put("yearRate", rs.getBigDecimal("fyearrate"));
                map.put("creditlimitid", rs.getString("FCreditLimitId"));
                map.put("balance", rs.getBigDecimal("fbalance"));
                map.put("isInCredit", rs.getString("fisincredit"));
                if (rs.getString("Fcreditlimitid") != null && (rt = DbUtil.executeQuery((Context)ctx, (String)(sqlc = "select * from t_fin_creditlimit where fid='" + rs.getString("fcreditlimitid") + "'"))).next()) {
                    map.put("creditUsage", rt.getString("fcreditusageid"));
                    map.put("shareType", rt.getString("fsharetype"));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected void _setIsInCredit(Context ctx, String pk, String isInCredit) throws BOSException, EASBizException {
        String sql = "update T_IBT_CredAsstTransOut set fisincredit=1 where fid='" + pk + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected BigDecimal _optionLimitAmt(Context ctx, String creditLimitId, String billId) throws BOSException, EASBizException {
        BigDecimal freturnBalance = null;
        BigDecimal usedAm = null;
        BigDecimal usedcAm = null;
        Object usedcRet = null;
        BigDecimal middBalance = null;
        if (creditLimitId != null) {
            String sqlOld = "select fUsedQuota,freturnedquota from t_fin_creditlimitused where (fcreditlimitid=select fid from t_fin_creditlimit where fid='" + creditLimitId + "') and fbillid='" + billId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlOld);
            try {
                while (rs.next()) {
                    usedAm = rs.getBigDecimal("fUsedQuota");
                    usedcAm = rs.getBigDecimal("freturnedquota");
                    if (usedAm != null && usedcAm != null) {
                        freturnBalance = usedAm.subtract(usedcAm);
                    }
                    if (middBalance != null) {
                        freturnBalance = freturnBalance.add(middBalance);
                    }
                    middBalance = freturnBalance;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return freturnBalance;
    }
}

