/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.CreditAssetsReturnOutFactory;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutInfo;
import com.kingdee.eas.fm.ibt.IbtException;
import com.kingdee.eas.fm.ibt.TransferModeEnum;
import com.kingdee.eas.fm.ibt.app.AbstractCreditAssetsTransferOutControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CreditAssetsTransferOutControllerBean
extends AbstractCreditAssetsTransferOutControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ibt.app.CreditAssetsTransferOutControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id;
        CreditAssetsTransferOutInfo info = this.getCreditAssetsTransferOutInfo(ctx, pk);
        if (BillTypeEnum.Submit.equals((Object)info.getBillType()) && (id = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()) != null) {
            String sql = "update T_IBT_CredAsstTransOut set FBillType = '2', fauditorid ='" + id + "' where fid = '" + info.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected void _anitAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditAssetsTransferOutInfo info = this.getCreditAssetsTransferOutInfo(ctx, pk);
        if (info.isIsReturnLimit()) {
            throw new IbtException(IbtException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"1_BillRediscountOutControllerBean", (Locale)ctx.getLocale())});
        }
        if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
            String sql = "update T_IBT_CredAsstTransOut set FBillType = '1',fauditorid=null where fid = '" + info.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected boolean _isRelatCreditReturn(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "select fid from T_IBT_CreditAssRetOut where fsourcebillId='" + id + "'";
        boolean flag = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected void _returnLimit(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int n = arrayPK.length;
        for (int i = 0; i < n; ++i) {
            this.returnLimit(ctx, arrayPK[i]);
        }
    }

    protected void returnLimit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditAssetsTransferOutInfo info = (CreditAssetsTransferOutInfo)this._getValue(ctx, pk);
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal((Context)ctx, (String)info.getId().toString());
        if (info.get("isInCredit").toString().equals("true") && info.get("isReturnLimit").toString().equals("false") && info.getTransferMode().equals((Object)TransferModeEnum.Monopoly) && info.getCreditLocalAmt() != null && info.getBalance() != null && info.getCreditLimit() != null && info.getBillType() == BillTypeEnum.Audit && info.getId() != null) {
            CreditAssetsReturnOutFactory.getLocalInstance(ctx).returnQuantum(info.getCreditLocalAmt(), info.getBalance(), info.getCreditLimit().getId().toString(), info.getId().toString());
            StringBuffer strsql = new StringBuffer();
            strsql.append(" update T_IBT_CredAsstTransOut set FIsReturnLimit=1 where fid='");
            strsql.append(info.getId());
            strsql.append("' ");
            DbUtil.execute((Context)ctx, (String)strsql.toString());
        }
    }

    @Override
    public void _reduceQuantum(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int n = arrayPK.length;
        for (int i = 0; i < n; ++i) {
            this.reduceQuantum(ctx, arrayPK[i]);
        }
    }

    protected void reduceQuantum(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditAssetsTransferOutInfo info = (CreditAssetsTransferOutInfo)this._getValue(ctx, pk);
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal((Context)ctx, (String)info.getId().toString());
        if (info.get("isInCredit").toString().equals("true") && info.get("isReturnLimit").toString().equals("true") && info.getTransferMode().equals((Object)TransferModeEnum.Monopoly) && info.getCreditLocalAmt() != null && info.getBalance() != null && info.getCreditLimit() != null && info.getBillType() == BillTypeEnum.Audit && info.getId() != null) {
            CreditAssetsReturnOutFactory.getLocalInstance(ctx).reduceQuantum(info.getCreditLocalAmt(), info.getBalance(), info.getCreditLimit().getId().toString(), info.getId().toString());
            StringBuffer strsql = new StringBuffer();
            strsql.append(" update T_IBT_CredAsstTransOut set FIsReturnLimit=0 where fid='");
            strsql.append(info.getId());
            strsql.append("' ");
            DbUtil.execute((Context)ctx, (String)strsql.toString());
        }
    }
}

