/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ivt.FinancingAccountCollection;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

public class FinancingaccountDisposer
implements IPaymentDisposer {
    private static final String RESOURCE = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        CoreBaseInfo destInfo = action.getDestBill();
        DisposerActionEnum actionType = action.getActionType();
        if (actionType == DisposerActionEnum.SUBMIT) {
            this.savedipose(ctx, destInfo);
        } else if (actionType == DisposerActionEnum.DELETE) {
            this.deletedipose(ctx, destInfo);
        }
    }

    private void deletedipose(Context ctx, CoreBaseInfo destInfo) throws BOSException {
        PaymentBillInfo payBill = (PaymentBillInfo)destInfo;
        PaymentBillEntryCollection entryColl = payBill.getEntries();
        String headerSourceBillId = payBill.getSourceBillId();
        HashSet<String> entrySourceSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            if (entryColl.get(i).getSourceBillId() == null || !FinancingAccountInfo.BOSTYPE.equals((Object)BOSUuid.read((String)entryColl.get(i).getSourceBillId()).getType())) continue;
            entrySourceSet.add(entryColl.get(i).getSourceBillId());
        }
        if (!EmptyUtil.isEmpty(entrySourceSet)) {
            String sql = "update T_IVT_FinancingAccount set FIsGenePayBill = 0 where FID IN " + FMHelper.setTran2String(entrySourceSet);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[0]);
        } else {
            String sql = "update T_IVT_FinancingAccount set FIsGenePayBill = 0 where FID= ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{headerSourceBillId});
        }
    }

    private void savedipose(Context ctx, CoreBaseInfo destInfo) throws EASBizException, BOSException {
        String sql;
        PaymentBillInfo payBill = (PaymentBillInfo)destInfo;
        PaymentBillEntryCollection entryColl = payBill.getEntries();
        BigDecimal payAmount = payBill.getActPayAmt();
        String headerSourceBillId = payBill.getSourceBillId();
        HashSet<String> entrySourceSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            if (entryColl.get(i).getSourceBillId() == null || !FinancingAccountInfo.BOSTYPE.equals((Object)BOSUuid.read((String)entryColl.get(i).getSourceBillId()).getType())) continue;
            entrySourceSet.add(entryColl.get(i).getSourceBillId());
        }
        BigDecimal finAmount = BigDecimal.ZERO;
        if (EmptyUtil.isEmpty(entrySourceSet)) {
            FinancingAccountInfo accountInfo = FinancingAccountFactory.getLocalInstance(ctx).getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(headerSourceBillId));
            finAmount = accountInfo.getFinanceAmount();
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", entrySourceSet, CompareType.INCLUDE));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("financeAmount");
            FinancingAccountCollection finColl = FinancingAccountFactory.getLocalInstance(ctx).getFinancingAccountCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, null));
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)finColl)) {
                for (int i = 0; i < finColl.size(); ++i) {
                    finAmount = finAmount.add(finColl.get(i).getFinanceAmount());
                }
            }
        }
        if (payAmount.compareTo(finAmount) == 1) {
            throw new EASBizException(new NumericExceptionSubItem("85", ResourceBase.getString((String)RESOURCE, (String)"018_OVERPAYAMOUNT", (Locale)ctx.getLocale())));
        }
        if (!EmptyUtil.isEmpty(entrySourceSet)) {
            sql = "update T_IVT_FinancingAccount set FIsGenePayBill =1 where FID IN " + FMHelper.setTran2String(entrySourceSet);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[0]);
        } else {
            sql = "update T_IVT_FinancingAccount set FIsGenePayBill =1 where FID= ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{headerSourceBillId});
        }
    }
}

