/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class RptFinancingInterestFilterParam
implements FilterParam {
    Set companyIdSet = null;
    Set bankIdSet = null;
    Set financeFinancingIdSet = null;
    Date dateFrom = null;
    Date dateTo = null;
    BigDecimal amount = null;
    int dimType = 0;
    AmountUnitEnum unit = null;

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Set getBankIdSet() {
        return this.bankIdSet;
    }

    public void setBankIdSet(Set bankIdSet) {
        this.bankIdSet = bankIdSet;
    }

    public Set getFinanceFinancingIdSet() {
        return this.financeFinancingIdSet;
    }

    public void setFinanceFinancingIdSet(Set financeFinancingIdSet) {
        this.financeFinancingIdSet = financeFinancingIdSet;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public int getDimType() {
        return this.dimType;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }

    public AmountUnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unit = unit;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer();
        int i = 0;
        if (this.getDateFrom() != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDate", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateTimeUtils.truncateDate((Date)DateUtil.getNextDay((Date)this.getDateFrom())), CompareType.GREATER_EQUALS));
            mask.append("((#0 and #1) or (#1 and #2)) ");
            i = 3;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("endDate", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)this.getDateTo(), CompareType.LESS));
            mask.append("(#0 or #1) ");
            i = 2;
        }
        if (this.getBankIdSet() != null && this.getBankIdSet().size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)this.getBankIdSet(), CompareType.INCLUDE));
            mask.append(" and #" + i++ + "");
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
            mask.append(" and #" + i++ + "");
        } else {
            CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString(), CompareType.EQUALS));
            mask.append(" and #" + i++ + "");
        }
        if (this.financeFinancingIdSet != null && this.getFinanceFinancingIdSet().size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("financeFinancing.id", (Object)this.getFinanceFinancingIdSet(), CompareType.INCLUDE));
            mask.append(" and #" + i++ + "");
        }
        if (this.getAmount() != null) {
            int intUnit = this.getUnit().getValue();
            BigDecimal bdUnit = new BigDecimal(String.valueOf(intUnit));
            filter.getFilterItems().add(new FilterItemInfo("financeAmount", (Object)this.getAmount().multiply(bdUnit), CompareType.GREATER_EQUALS));
            mask.append(" and #" + i++ + "");
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3), CompareType.EQUALS));
        mask.append(" and #" + i++ + "");
        filter.setMaskString(mask.toString());
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        switch (this.getDimType()) {
            case 1: {
                sorter.add(new SorterItemInfo("company.id"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("bank.id"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("financeFinancing.id"));
                break;
            }
            case 4: {
                sorter.add(new SorterItemInfo("Currency.id"));
                break;
            }
            case 5: {
                sorter.add(new SorterItemInfo("accountBank.id"));
                break;
            }
            default: {
                sorter.add(new SorterItemInfo("company.id"));
            }
        }
        return sorter;
    }
}

