/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IntRateBaseCollection;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillCollection;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillFactory;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillEntryCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillEntryInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.StrikeEnum;
import com.kingdee.eas.fm.ivt.app.PeneTypeYearDaysInfo;
import com.kingdee.eas.fm.ivt.app.PreIntCalStragety;
import com.kingdee.eas.fm.ivt.app.RecIntCalStragety;
import com.kingdee.eas.fm.ivt.app.RepayIntCalStragety;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractIntCalStragety {
    private static final BigDecimal ONE_HUNDRED = Constants.ONE_HUNDRED;
    private static final BigDecimal ONE_THOUSAND = Constants.ONE_THOUSAND;
    protected static final int TYPE_REPAY = 1;
    protected static final int TYPE_INTRATE = 2;
    protected static final int TYPE_LOANEX = 3;
    private static final int ROUND = 4;
    private static final int SCALE = 5;
    protected String currencyID;
    private BankInfo clearingHouse;

    public static AbstractIntCalStragety getInstance(IntCalTypeEnum intCalType) {
        switch (intCalType.getValue()) {
            case 0: {
                return new PreIntCalStragety();
            }
            case 1: {
                return new RecIntCalStragety();
            }
            case 2: {
                return new RepayIntCalStragety();
            }
        }
        return new PreIntCalStragety();
    }

    protected abstract IntCalTypeEnum getIntCalType();

    public LoanInterestBillInfo calInt(Context ctx, java.util.Date condBeginDate, java.util.Date condEndDate, String loanId, EntRepaymentBillInfo repayBillInfo, List allFirstExdDate, CHLoanExtendBillCollection byIDsExt, EntRepaymentBillCollection byIDsRepay, ChLoanInfo info) throws EASBizException, BOSException {
        java.util.Date endDate;
        this.clearingHouse = FSHelper.getClearingHouseInfo((Context)ctx, (String)ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString());
        ChLoanInfo loanInfo = info;
        this.currencyID = loanInfo.getCurrency().getId().toString();
        CHLoanExtendBillCollection loanExColl = byIDsExt;
        EntRepaymentBillCollection repayColl = byIDsRepay;
        IntRateBaseCollection intRateBaseColl = this.getIntRateBaseColl(ctx, loanInfo.getRateType(), this.currencyID);
        java.util.Date beginDate = this.getBeginDate(ctx, condBeginDate, loanInfo);
        if (beginDate.compareTo(endDate = this.getEndDate(condEndDate, repayBillInfo)) > 0) {
            throw new CHLoanException(CHLoanException.CACULATE_INTERST_ERROR);
        }
        boolean isAccordIntRate = loanInfo.getRateType().getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=");
        List subList = this.getSubBeginDateList(ctx, beginDate, endDate, loanId, isAccordIntRate, loanExColl, repayBillInfo, allFirstExdDate);
        java.util.Date subBeginDate = beginDate;
        java.util.Date subEndDate = endDate;
        BigDecimal intPrinciple = Constants.ZERO;
        BigDecimal intRate = Constants.ZERO;
        BigDecimal punishIntRate = Constants.ZERO;
        int convertDays = loanInfo.getYearDays();
        PenAccrualTypeEnum punishType = null;
        boolean isCalPunishInt = false;
        int seq = 0;
        LoanInterestBillInfo intInfo = new LoanInterestBillInfo();
        LoanInterestBillEntryInfo intEntryInfo = null;
        java.util.Date expiredDate = loanInfo.getEndDate();
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = null;
        int size = subList.size();
        for (int i = 0; i < size; ++i) {
            ++seq;
            subEndDate = DateUtil.getBeforeDay((java.util.Date)((java.util.Date)subList.get(i)));
            intPrinciple = this.getIntPrinciple(loanInfo.getLoanBalance(), loanInfo.getFloorAmt(), subBeginDate, repayColl, repayBillInfo);
            punishType = this.getSubPunishIntRateType(subBeginDate, subEndDate, loanInfo, loanExColl);
            intRate = this.getSubIntRate(subBeginDate, subEndDate, loanInfo, loanExColl, intRateBaseColl);
            convertDays = this.getSubConvertDays(subBeginDate, subEndDate, loanInfo, loanExColl, intRateBaseColl);
            intRateTypeExpressionEnum = this.etSubConvertDays(subBeginDate, subEndDate, loanInfo, loanExColl, intRateBaseColl);
            punishIntRate = this.getSubPunishIntRate(subBeginDate, subEndDate, loanInfo, loanExColl);
            isCalPunishInt = this.isCalPunishInt(subBeginDate, subEndDate, expiredDate, repayBillInfo);
            intEntryInfo = this.buildIntEntryInfo(seq, subBeginDate, subEndDate, expiredDate, intPrinciple, intRate, convertDays, punishIntRate, isCalPunishInt, punishType, intRateTypeExpressionEnum);
            intInfo.getEntrys().add(intEntryInfo);
            subBeginDate = (java.util.Date)subList.get(i);
        }
        ++seq;
        subEndDate = endDate;
        intPrinciple = this.getIntPrinciple(loanInfo.getLoanBalance(), loanInfo.getFloorAmt(), subBeginDate, repayColl, repayBillInfo);
        punishType = this.getSubPunishIntRateType(subBeginDate, subEndDate, loanInfo, loanExColl);
        intRate = this.getSubIntRate(subBeginDate, subEndDate, loanInfo, loanExColl, intRateBaseColl);
        convertDays = this.getSubConvertDays(subBeginDate, subEndDate, loanInfo, loanExColl, intRateBaseColl);
        punishIntRate = this.getSubPunishIntRate(subBeginDate, subEndDate, loanInfo, loanExColl);
        isCalPunishInt = this.isCalPunishInt(subBeginDate, subEndDate, expiredDate, repayBillInfo);
        intRateTypeExpressionEnum = this.etSubConvertDays(subBeginDate, subEndDate, loanInfo, loanExColl, intRateBaseColl);
        intEntryInfo = this.buildIntEntryInfo(seq, subBeginDate, subEndDate, expiredDate, intPrinciple, intRate, convertDays, punishIntRate, isCalPunishInt, punishType, intRateTypeExpressionEnum);
        intInfo.getEntrys().add(intEntryInfo);
        intInfo = this.buildIntInfo(ctx, beginDate, endDate, loanInfo, loanExColl, intInfo, repayBillInfo, intRateTypeExpressionEnum);
        return intInfo;
    }

    private ChLoanInfo getLoanInfo(Context ctx, String loanId) throws EASBizException, BOSException {
        return ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(loanId), this.getSelectors());
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        return sic;
    }

    private LoanInterestBillInfo buildIntInfo(Context ctx, java.util.Date beginDate, java.util.Date endDate, ChLoanInfo loanInfo, CHLoanExtendBillCollection loanExColl, LoanInterestBillInfo intInfo, EntRepaymentBillInfo repayBillInfo, IntRateTypeExpressionEnum intRateTypeExpressionEnum) throws EASBizException, BOSException {
        int precision = FMHelper.getPrecOfCurrency((Context)ctx, (String)loanInfo.getCurrency().getId().toString());
        intInfo.setEntRepaymentBillInfo(repayBillInfo);
        intInfo.setLoanInfo(loanInfo);
        int size = intInfo.getEntrys().size();
        if (repayBillInfo != null) {
            intInfo.setRepayment(repayBillInfo);
        }
        LoanInterestBillEntryInfo intEntryInfo = intInfo.getEntrys().get(size - 1);
        intInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        intInfo.setIntAccount(loanInfo.getLoanAccount());
        intInfo.setIntCalType(this.getIntCalType());
        intInfo.setLoanBill(loanInfo);
        intInfo.setBank(loanInfo.getBank());
        intInfo.setLoanCompany(loanInfo.getLoanAccount().getApplyUnit());
        intInfo.setCompany(ChLoanHelper.getInstance().getRelatedCompany(ctx, intInfo.getBank()));
        intInfo.setCurrency(loanInfo.getCurrency());
        if (repayBillInfo != null) {
            intInfo.setBizDate(repayBillInfo.getBizDate());
        } else {
            intInfo.setBizDate(DateTimeUtils.truncateDate((java.util.Date)this.clearingHouse.getSettleDate()));
        }
        intInfo.setBeginDate(DateTimeUtils.truncateDate((java.util.Date)beginDate));
        intInfo.setEndDate(DateTimeUtils.truncateDate((java.util.Date)endDate));
        intInfo.setDays(this.getDiffDays(beginDate, endDate));
        intInfo.setAmount(intEntryInfo.getAmount());
        intInfo.setYearIntRate(intEntryInfo.getYearIntRate());
        intInfo.setInterest(this.getTotalInterest(intInfo.getEntrys()));
        intInfo.setInterest(intInfo.getInterest().setScale(precision, 4));
        intInfo.setDaysOverdue(intEntryInfo.getDaysOverdue());
        intInfo.setPunishIntType(this.getPunishIntRateType(loanInfo, loanExColl));
        intInfo.setPunishIntRate(intEntryInfo.getPunishIntRate());
        intInfo.setPunishInterest(this.getTotalPunishInterest(intInfo.getEntrys()));
        intInfo.setPunishInterest(intInfo.getPunishInterest().setScale(precision, 4));
        intInfo.setInterestActual(intInfo.getInterest().add(intInfo.getPunishInterest()));
        intInfo.setInterestActual(intInfo.getInterestActual().setScale(precision, 4));
        if (intInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            intInfo.setUnVerifyAmount(Constants.ZERO);
            intInfo.setStrikeAmount(Constants.ZERO);
        } else {
            intInfo.setUnVerifyAmount(this.getUnVerifyAmount(ctx, intInfo));
            intInfo.setStrikeAmount(this.getStrikeAmount(ctx, intInfo, repayBillInfo));
        }
        intInfo.setStrikeStatus(StrikeEnum.NULL);
        intInfo.setFivouchered(false);
        intInfo.setPunishInterestActual(intInfo.getPunishInterest().setScale(precision, 4));
        intInfo.setInterestAcctual(intInfo.getInterest().setScale(precision, 4));
        intInfo.setIntRateTypeExpression(intRateTypeExpressionEnum);
        intInfo.setInterestToPay(intInfo.getPunishInterestActual().add(intInfo.getInterestAcctual()).setScale(precision, 4));
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        intInfo.setCreator(user);
        if (intInfo.getIntCalType().getValue() == 1) {
            intInfo.setLastIntDate(loanInfo.getLastSettleDate());
        } else if (intInfo.getIntCalType().getValue() == 2) {
            BigDecimal bal;
            BigDecimal rep = intInfo.getEntRepaymentBillInfo().getRepayAmt();
            if (rep.compareTo(bal = intInfo.getLoanInfo().getLoanBalance()) == 0) {
                intInfo.setLastIntDate(loanInfo.getLastSettleDate());
            }
        } else {
            intInfo.setLastIntDate(loanInfo.getLastPreIntDate());
        }
        intInfo.setDescription(this.getDefaultDescription(intInfo.getBeginDate(), intInfo.getEndDate(), intInfo.getLoanCompany()));
        intInfo.setEntRepaymentBillInfo(repayBillInfo);
        intInfo.setIsDownLoaded(false);
        intInfo.setBillStatus(IvtBillStatusEnum.SUBMIT);
        return intInfo;
    }

    private String getDefaultDescription(java.util.Date beginDate, java.util.Date endDate, CompanyOrgUnitInfo company) {
        String beginDateStr = Constants.FORMAT_DAY.format(beginDate);
        String endDateStr = Constants.FORMAT_DAY.format(endDate);
        StringBuffer msg = new StringBuffer();
        msg.append("received ").append(company.getName()).append(" ").append(beginDateStr).append(" - ").append(endDateStr).append(" interest on loan");
        return msg.toString();
    }

    private BigDecimal getStrikeAmount(Context ctx, LoanInterestBillInfo intInfo, EntRepaymentBillInfo repayBillInfo) throws EASBizException, BOSException {
        BigDecimal returnValue = Constants.ZERO;
        if (repayBillInfo != null && repayBillInfo.getRepayTotalAmt().compareTo(repayBillInfo.getChLoanInfo().getLoanTotalAmt()) != 0) {
            return returnValue;
        }
        returnValue = LoanInterestBillFactory.getLocalInstance(ctx).getStrikeAmount(intInfo);
        return returnValue;
    }

    private BigDecimal getUnVerifyAmount(Context ctx, LoanInterestBillInfo intInfo) throws EASBizException, BOSException {
        BigDecimal returnValue = Constants.ZERO;
        returnValue = LoanInterestBillFactory.getLocalInstance(ctx).getUnVerifyAmount(intInfo);
        return returnValue;
    }

    private BigDecimal getTotalInterest(LoanInterestBillEntryCollection intEntryColl) {
        BigDecimal totalInt = Constants.ZERO;
        int size = intEntryColl.size();
        for (int i = 0; i < size; ++i) {
            totalInt = totalInt.add(intEntryColl.get(i).getInterest());
        }
        return totalInt;
    }

    private BigDecimal getTotalPunishInterest(LoanInterestBillEntryCollection intEntryColl) {
        BigDecimal totalInt = Constants.ZERO;
        int size = intEntryColl.size();
        for (int i = 0; i < size; ++i) {
            totalInt = totalInt.add(intEntryColl.get(i).getPunishInterest());
        }
        return totalInt;
    }

    private LoanInterestBillEntryInfo buildIntEntryInfo(int seq, java.util.Date subBeginDate, java.util.Date subEndDate, java.util.Date expiredDate, BigDecimal intPrinciple, BigDecimal intRate, int convertDays, BigDecimal punishIntRate, boolean isCalPunishInt, PenAccrualTypeEnum punishType, IntRateTypeExpressionEnum rateTypeExpression) throws EASBizException {
        int days = this.getDiffDays(subBeginDate, subEndDate);
        LoanInterestBillEntryInfo intEntryInfo = new LoanInterestBillEntryInfo();
        intEntryInfo.setSeq(seq);
        intEntryInfo.setBeginDate(subBeginDate);
        intEntryInfo.setEndDate(subEndDate);
        intEntryInfo.setDays(days);
        intEntryInfo.setAmount(intPrinciple);
        intEntryInfo.setYearIntRate(intRate);
        if (subBeginDate.compareTo(subEndDate) > 0) {
            intEntryInfo.setInterest(Constants.ZERO);
        } else {
            intEntryInfo.setInterest(this.calIntertest(intPrinciple, intRate, convertDays, days, rateTypeExpression));
        }
        intEntryInfo.setYearDays(convertDays);
        intEntryInfo.setIntRateTypeExpression(rateTypeExpression);
        int overdueDays = 0;
        BigDecimal punishInterest = Constants.ZERO;
        if (isCalPunishInt) {
            if (subEndDate.compareTo(expiredDate) > 0) {
                overdueDays = this.getOverdueDays(subBeginDate, subEndDate, expiredDate);
                punishInterest = this.calPunishInt(intPrinciple, intRate, punishIntRate, overdueDays, convertDays, punishType, rateTypeExpression);
            } else {
                overdueDays = 0;
                punishInterest = Constants.ZERO;
            }
        }
        intEntryInfo.setDaysOverdue(overdueDays);
        intEntryInfo.setPunishIntRate(punishIntRate);
        intEntryInfo.setPunishInterest(punishInterest);
        return intEntryInfo;
    }

    private BigDecimal calIntertest(BigDecimal intPrinciple, BigDecimal intRate, int covertDays, int days, IntRateTypeExpressionEnum rateTypeExpression) {
        BigDecimal bConvertDay = new BigDecimal(String.valueOf(covertDays));
        BigDecimal bDays = new BigDecimal(String.valueOf(days));
        BigDecimal rst = intPrinciple.multiply(intRate).multiply(bDays);
        BigDecimal tmp = Constants.ZERO;
        tmp = rateTypeExpression == IntRateTypeExpressionEnum.YEAR ? bConvertDay.multiply(ONE_HUNDRED) : bConvertDay.multiply(ONE_THOUSAND);
        rst = rst.divide(tmp, 5, 4);
        return rst;
    }

    private BigDecimal calPunishInt(BigDecimal intPrinciple, BigDecimal intRate, BigDecimal punishIntRate, int overdueDays, int convertDays, PenAccrualTypeEnum punishType, IntRateTypeExpressionEnum rateTypeExpression) throws EASBizException {
        BigDecimal bOverdueDays = new BigDecimal(String.valueOf(overdueDays));
        BigDecimal bConvertDay = new BigDecimal(String.valueOf(convertDays));
        BigDecimal returnValue = Constants.ZERO;
        if (punishType == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"PenAccrualType"});
        }
        if (punishType.equals((Object)PenAccrualTypeEnum.ADD_PERCENT)) {
            returnValue = intPrinciple.multiply(intRate).multiply(punishIntRate).multiply(bOverdueDays).divide(bConvertDay.multiply(ONE_HUNDRED), 5, 4);
        } else if (punishType.equals((Object)PenAccrualTypeEnum.ADD_ACCRUAL)) {
            returnValue = intPrinciple.multiply(punishIntRate).multiply(bOverdueDays).divide(ONE_THOUSAND, 5, 4);
        }
        returnValue = rateTypeExpression == IntRateTypeExpressionEnum.YEAR ? returnValue.divide(ONE_HUNDRED, 5, 4) : returnValue.divide(ONE_THOUSAND, 5, 4);
        return returnValue;
    }

    private CHLoanExtendBillCollection getLoanExColl(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("chLoan.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("beforeExDate"));
        return CHLoanExtendBillFactory.getLocalInstance(ctx).getCHLoanExtendBillCollection(evi);
    }

    private IntRateBaseCollection getIntRateBaseColl(Context ctx, IntRateTypeInfo info, String currencyId) throws BOSException, EASBizException {
        if (!info.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=")) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)info.getId().toString()));
            String billState = IntRateStateEnum.AUDITED.getValue();
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)billState));
            if (null != currencyId && currencyId.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("effectiveDate"));
            IIntRateBase iIntRateBase = IntRateBaseFactory.getLocalInstance((Context)ctx);
            IntRateBaseCollection intRateBaseColl = iIntRateBase.getIntRateBaseCollection(evi);
            if (intRateBaseColl == null || intRateBaseColl.isEmpty()) {
                throw new CHLoanException(CHLoanException.NOBASERATE);
            }
            return intRateBaseColl;
        }
        return new IntRateBaseCollection();
    }

    private EntRepaymentBillCollection getRepayColl(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loanBillID.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("repayDate"));
        return EntRepaymentBillFactory.getLocalInstance(ctx).getEntRepaymentBillCollection(evi);
    }

    protected abstract java.util.Date getBeginDate(Context var1, java.util.Date var2, ChLoanInfo var3) throws EASBizException, BOSException;

    protected abstract java.util.Date getEndDate(java.util.Date var1, EntRepaymentBillInfo var2);

    protected abstract List getSubBeginDateList(Context var1, java.util.Date var2, java.util.Date var3, String var4, boolean var5, CHLoanExtendBillCollection var6, EntRepaymentBillInfo var7, List var8) throws EASBizException, BOSException;

    protected abstract BigDecimal getIntPrinciple(BigDecimal var1, BigDecimal var2, java.util.Date var3, EntRepaymentBillCollection var4, EntRepaymentBillInfo var5);

    protected BigDecimal getSubIntRate(java.util.Date beginDate, java.util.Date endDate, ChLoanInfo loanInfo, CHLoanExtendBillCollection loanExColl, IntRateBaseCollection intRateBaseColl) throws EASBizException {
        boolean isLessOrEqualsExtend = this.isLessOrEqualsFirstExtend(endDate, loanExColl);
        boolean isAccordIntRate = loanInfo.getRateType().getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=");
        if (isLessOrEqualsExtend && isAccordIntRate) {
            return loanInfo.getYearRate();
        }
        if (isLessOrEqualsExtend && !isAccordIntRate) {
            BigDecimal intRateBase = this.getIntRateBase(beginDate, intRateBaseColl);
            BigDecimal floating = loanInfo.getFloatPoint().divide(Constants.ONE_HUNDRED, 2, 0);
            BigDecimal tmp = FMHelper.add((BigDecimal)Constants.ONE, (BigDecimal)floating);
            return FMHelper.multiply((BigDecimal)intRateBase, (BigDecimal)tmp);
        }
        return this.getExtendRate(beginDate, loanExColl);
    }

    private PenAccrualTypeEnum getSubPunishIntRateType(java.util.Date subBeginDate, java.util.Date subEndDate, ChLoanInfo loanInfo, CHLoanExtendBillCollection loanExColl) {
        boolean isLessOrEqualsExtend = this.isLessOrEqualsFirstExtend(subEndDate, loanExColl);
        if (isLessOrEqualsExtend) {
            return loanInfo.getPenAccrualType();
        }
        return loanExColl.get(loanExColl.size() - 1).getPenaIntType();
    }

    private BigDecimal getSubPunishIntRate(java.util.Date subBeginDate, java.util.Date subEndDate, ChLoanInfo loanInfo, CHLoanExtendBillCollection loanExColl) {
        boolean isLessOrEqualsExtend = this.isLessOrEqualsFirstExtend(subEndDate, loanExColl);
        if (isLessOrEqualsExtend) {
            return loanInfo.getPenAccrualRate();
        }
        return this.getExtendPenaRate(subBeginDate, loanExColl, loanInfo);
    }

    private BigDecimal getExtendPenaRate(java.util.Date subBeginDate, CHLoanExtendBillCollection loanExColl, ChLoanInfo loanInfo) {
        if (loanExColl == null || loanExColl.isEmpty()) {
            return loanInfo.getPenAccrualRate();
        }
        CHLoanExtendBillInfo info = null;
        int size = loanExColl.size();
        for (int i = size - 1; i >= 0; --i) {
            info = loanExColl.get(i);
            if ((subBeginDate.compareTo(info.getBeforeExDate()) < 0 || subBeginDate.compareTo(info.getAfterExDate()) >= 0) && subBeginDate.compareTo(info.getAfterExDate()) < 0) continue;
            return info.getPeneIntRate();
        }
        return loanInfo.getPenAccrualRate();
    }

    private IntRateTypeExpressionEnum etSubConvertDays(java.util.Date subBeginDate, java.util.Date subEndDate, ChLoanInfo loanInfo, CHLoanExtendBillCollection loanExColl, IntRateBaseCollection intRateBaseColl) {
        boolean isLessOrEqualsExtend = this.isLessOrEqualsFirstExtend(subEndDate, loanExColl);
        if (isLessOrEqualsExtend) {
            return loanInfo.getIntRateTypeExpression();
        }
        return this.getExtendRateTypeExpression(subBeginDate, loanExColl, loanInfo);
    }

    private IntRateTypeExpressionEnum getExtendRateTypeExpression(java.util.Date subBeginDate, CHLoanExtendBillCollection loanExColl, ChLoanInfo loanInfo) {
        if (loanExColl == null || loanExColl.isEmpty()) {
            return loanInfo.getIntRateTypeExpression();
        }
        CHLoanExtendBillInfo info = null;
        int size = loanExColl.size();
        for (int i = size - 1; i >= 0; --i) {
            info = loanExColl.get(i);
            if ((subBeginDate.compareTo(info.getBeforeExDate()) < 0 || subBeginDate.compareTo(info.getAfterExDate()) >= 0) && subBeginDate.compareTo(info.getAfterExDate()) < 0) continue;
            return info.getRateExpression();
        }
        return loanInfo.getIntRateTypeExpression();
    }

    private int getSubConvertDays(java.util.Date subBeginDate, java.util.Date subEndDate, ChLoanInfo loanInfo, CHLoanExtendBillCollection loanExColl, IntRateBaseCollection intRateBaseColl) {
        boolean isLessOrEqualsExtend = this.isLessOrEqualsFirstExtend(subEndDate, loanExColl);
        if (isLessOrEqualsExtend) {
            return loanInfo.getYearDays();
        }
        return this.getExtendYearDays(subBeginDate, loanExColl, loanInfo);
    }

    private int getExtendYearDays(java.util.Date subBeginDate, CHLoanExtendBillCollection loanExColl, ChLoanInfo loanInfo) {
        if (loanExColl == null || loanExColl.isEmpty()) {
            return loanInfo.getYearDays();
        }
        CHLoanExtendBillInfo info = null;
        int size = loanExColl.size();
        for (int i = size - 1; i >= 0; --i) {
            info = loanExColl.get(i);
            if ((subBeginDate.compareTo(info.getBeforeExDate()) < 0 || subBeginDate.compareTo(info.getAfterExDate()) >= 0) && subBeginDate.compareTo(info.getAfterExDate()) < 0) continue;
            return info.getYearDays();
        }
        return loanInfo.getYearDays();
    }

    private BigDecimal getIntRateBase(java.util.Date beginDate, IntRateBaseCollection rateBaseColl) throws EASBizException {
        if (rateBaseColl == null || rateBaseColl.isEmpty()) {
            return null;
        }
        IntRateBaseInfo info = null;
        java.util.Date preDate = rateBaseColl.get(0).getEffectiveDate();
        BigDecimal yearRate = rateBaseColl.get(0).getYearRate();
        int size = rateBaseColl.size();
        for (int i = 1; i < size; ++i) {
            info = rateBaseColl.get(i);
            if (beginDate.compareTo(preDate) >= 0 && beginDate.compareTo(info.getEffectiveDate()) < 0) {
                return yearRate;
            }
            preDate = info.getEffectiveDate();
            yearRate = info.getYearRate();
        }
        if (beginDate.compareTo(preDate) >= 0) {
            return yearRate;
        }
        throw new CHLoanException(CHLoanException.NOT_INTRATEBASE_EXIST, new Object[]{DateTimeUtils.truncateDate((java.util.Date)beginDate).toLocaleString()});
    }

    private BigDecimal getExtendRate(java.util.Date beginDate, CHLoanExtendBillCollection extendBillColl) {
        int size;
        if (extendBillColl == null || extendBillColl.isEmpty()) {
            return Constants.ZERO;
        }
        CHLoanExtendBillInfo info = null;
        for (int i = size = extendBillColl.size() - 1; i >= 0; --i) {
            info = extendBillColl.get(i);
            if ((beginDate.compareTo(info.getBeforeExDate()) < 0 || beginDate.compareTo(info.getAfterExDate()) >= 0) && beginDate.compareTo(info.getAfterExDate()) < 0) continue;
            return info.getAfterExRate();
        }
        return Constants.ZERO;
    }

    protected boolean isLessOrEqualsFirstExtend(java.util.Date endDate, CHLoanExtendBillCollection extendBillColl) {
        if (extendBillColl == null || extendBillColl.isEmpty()) {
            return true;
        }
        return endDate.compareTo(extendBillColl.get(0).getBeforeExDate()) <= 0;
    }

    protected abstract boolean isCalPunishInt(java.util.Date var1, java.util.Date var2, java.util.Date var3, EntRepaymentBillInfo var4);

    private PenAccrualTypeEnum getPunishIntRateType(ChLoanInfo loanInfo, CHLoanExtendBillCollection loanExColl) {
        if (loanExColl == null || loanExColl.isEmpty()) {
            return loanInfo.getPenAccrualType();
        }
        int size = loanExColl.size();
        return loanExColl.get(size - 1).getPenaIntType();
    }

    private int getOverdueDays(java.util.Date beginDate, java.util.Date endDate, java.util.Date expiredDate) {
        java.util.Date bigDate = beginDate.compareTo(expiredDate) > 0 ? beginDate : expiredDate;
        return this.getDiffDays(bigDate, endDate);
    }

    protected int getDiffDays(java.util.Date beginDate, java.util.Date endDate) {
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue() + 1;
        return days;
    }

    public PeneTypeYearDaysInfo getPenTypeAndYearDays(Context ctx, String id, java.util.Date subDate, boolean isDedug) throws EASBizException, BOSException {
        StringBuffer sbSql = new StringBuffer("");
        sbSql.append("select \n");
        sbSql.append("(case(select count(*) from \n");
        sbSql.append("        ( \n");
        sbSql.append("         select d.fid from t_ivt_chloan d ,t_ivt_chloanextendbill f \n");
        if (isDedug) {
            sbSql.append("         where d.fid = f.fchloanid and d.FID  = '" + id + "' and  (select min(fbeforeexdate) from t_ivt_chloanextendbill where fchloanid = '" + id + "') < ? ) \n");
        } else {
            sbSql.append("         where d.fid = f.fchloanid and d.FID  = ? and  (select min(fbeforeexdate) from t_ivt_chloanextendbill where fchloanid = ?) < ? ) \n");
        }
        sbSql.append("         ) \n");
        sbSql.append("  when 0 \n");
        sbSql.append("  then dd.fpenaccrualtype  \n");
        sbSql.append("  else  \n");
        sbSql.append("    (select ex.fpenainttype from t_ivt_chloanextendbill ex,t_ivt_chloan ch \n");
        sbSql.append("     where ch.fid = ex.fchloanid \n");
        if (isDedug) {
            sbSql.append("     and FExtendSeq = (select max(FExtendSeq) from t_ivt_chloanextendbill where fchloanid = '" + id + "') \n");
            sbSql.append("     and ex.fchloanid = '" + id + "' \n");
        } else {
            sbSql.append("     and FExtendSeq = (select max(FExtendSeq) from t_ivt_chloanextendbill where fchloanid = ?) \n");
            sbSql.append("     and ex.fchloanid = ? \n");
        }
        sbSql.append("    ) \n");
        sbSql.append(" end) as penainttype, \n");
        sbSql.append("(case(select count(*) from \n");
        sbSql.append("             ( \n");
        sbSql.append("              select d.fid from t_ivt_chloan d ,t_ivt_chloanextendbill f \n");
        if (isDedug) {
            sbSql.append("              where d.fid = f.fchloanid and d.FID  = '" + id + "' and  (select min(fbeforeexdate) from t_ivt_chloanextendbill where fchloanid = '" + id + "') < ? ) \n");
        } else {
            sbSql.append("              where d.fid = f.fchloanid and d.FID  = ? and  (select min(fbeforeexdate) from t_ivt_chloanextendbill where fchloanid = ?) < ? ) \n");
        }
        sbSql.append("             ) \n");
        sbSql.append("  when 0 \n");
        sbSql.append("  then dd.fyeardays  \n");
        sbSql.append("  else  \n");
        sbSql.append("    (select ex.fyeardays from t_ivt_chloanextendbill ex,t_ivt_chloan ch \n");
        sbSql.append("     where ch.fid = ex.fchloanid \n");
        if (isDedug) {
            sbSql.append("     and FExtendSeq = (select max(FExtendSeq) from t_ivt_chloanextendbill where fchloanid = '" + id + "') \n");
            sbSql.append("     and ex.fchloanid = '" + id + "' \n");
        } else {
            sbSql.append("     and FExtendSeq = (select max(FExtendSeq) from t_ivt_chloanextendbill where fchloanid = ?) \n");
            sbSql.append("     and ex.fchloanid = ? \n");
        }
        sbSql.append("     ) \n");
        sbSql.append(" end) as yearDays, \n");
        sbSql.append(" (case(select count(*) from \n");
        sbSql.append("             ( \n");
        if (isDedug) {
            sbSql.append("              select d.fid from t_ivt_chloan d ,t_ivt_chloanextendbill f \n");
            sbSql.append("              where d.fid = f.fchloanid and d.FID  = '" + id + "' and  (select min(fbeforeexdate) from t_ivt_chloanextendbill where fchloanid = '" + id + "') < ? ) \n");
        } else {
            sbSql.append("              select d.fid from t_ivt_chloan d ,t_ivt_chloanextendbill f \n");
            sbSql.append("              where d.fid = f.fchloanid and d.FID  = ? and  (select min(fbeforeexdate) from t_ivt_chloanextendbill where fchloanid = ?) < ? ) \n");
        }
        sbSql.append("             ) \n");
        sbSql.append("  when 0 \n");
        sbSql.append("  then dd.fintratetypeexpression   \n");
        sbSql.append("  else   \n");
        sbSql.append("    (select ex.frateexpression from t_ivt_chloanextendbill ex,t_ivt_chloan ch \n");
        sbSql.append("     where ch.fid = ex.fchloanid  \n");
        if (isDedug) {
            sbSql.append("     and FExtendSeq = (select max(FExtendSeq) from t_ivt_chloanextendbill where fchloanid = '" + id + "') \n");
            sbSql.append("     and ex.fchloanid = '" + id + "' \n");
        } else {
            sbSql.append("     and FExtendSeq = (select max(FExtendSeq) from t_ivt_chloanextendbill where fchloanid = ?) \n");
            sbSql.append("     and ex.fchloanid =? \n");
        }
        sbSql.append("     ) \n");
        sbSql.append(" end) as rateExpression \n");
        sbSql.append("from t_ivt_chloan dd,  t_ivt_chloanextendbill ee \n");
        if (isDedug) {
            sbSql.append("where dd.fid = ee.fchloanid and dd.FID  = '" + id + "' \n");
        } else {
            sbSql.append("where dd.fid = ee.fchloanid and dd.FID  = ? \n");
        }
        Date datePram = new Date(subDate.getTime());
        Object[] params = null;
        params = isDedug ? new Object[]{datePram, datePram, datePram} : new Object[]{id, id, datePram, id, id, id, id, datePram, id, id, id, id, datePram, id, id, id};
        IRowSet rs = null;
        PeneTypeYearDaysInfo info = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            if (rs.next()) {
                info = new PeneTypeYearDaysInfo(rs.getString(1), rs.getInt(2), rs.getString(3));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return info;
    }
}

