/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.CreditorGroupCollection;
import com.kingdee.eas.fm.fin.CreditorGroupFactory;
import com.kingdee.eas.fm.fin.CreditorGroupInfo;
import com.kingdee.eas.fm.fin.ILoan;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanEntryInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.app.IvtSmartUtil;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChLoanSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.ChLoanSmartFilter");
    private String failMsg = null;

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String operatorNumber = busiInfo.getOperatorNumber();
        String queryOql = "";
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id,number where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("ChLoanSmartFilter============" + iexec.getSQL()));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL());
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"148_LoanInterestSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"149_LoanInterestSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(" ( ").append(filterSql).append(" ) ");
            }
        } else {
            result.append(" ( ").append(filterSql).append(" ) ");
        }
        Date todaydate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(todaydate.getTime());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.chloan_writeback_loan.getName().equals(operatorNumber)) {
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" loanBalance > 0 ");
            result.append(" and ").append(" effectedStatus = 2 ");
            result.append(" and ").append(" isDownLoaded = 0 ");
        }
        if (InterfaceTypeEnum.chloan_repay.getName().equals(operatorNumber)) {
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" loanBalance > 0 ");
            result.append(" and ").append(" effectedStatus = 2 ");
            result.append(" and ").append(" entrys.isExecute = 0 ");
            result.append(" and ").append(" entrys.returnDate ={" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "}");
        }
        if (InterfaceTypeEnum.chloan_overdue_repay.getName().equals(operatorNumber)) {
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" loanBalance > 0 ");
            result.append(" and ").append(" effectedStatus = 2 ");
            result.append(" and ").append("  endDate < {" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "}");
        }
        if (InterfaceTypeEnum.entrepay_writeback_repay.getName().equals(operatorNumber)) {
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" loanBalance > 0 ");
            result.append(" and ").append(" endDate <= {" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "}");
        }
        if (InterfaceTypeEnum.chloan_recint_due.getName().equals(operatorNumber)) {
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" loanBalance > 0 ");
            result.append(" and ").append(" effectedStatus = 2 ");
            result.append(" and ").append(" endDate <= {" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "}");
        }
        if (InterfaceTypeEnum.chloan_recint_overdue.getName().equals(operatorNumber)) {
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" loanBalance > 0 ");
            result.append(" and ").append(" endDate <= {" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "}");
            cal.set(5, cal.get(5) - 1);
            result.append(" and ").append(" ( lastSettleDate = null or  lastSettleDate <= {" + df.format(DateTimeUtils.truncateDate((Date)cal.getTime())) + "} ) ");
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            int i;
            Calendar cal;
            Date todaydate;
            HashMap<String, Object> repayamtMap;
            ChLoanInfo billInfo;
            IBOTMapping botMapping;
            BOTMappingInfo botInfo;
            HashMap<String, BOTMappingInfo> botMap;
            String operatorNumber = busiInfo.getOperatorNumber();
            ILoan biz = LoanFactory.getLocalInstance((Context)ctx);
            ChLoanCollection billColl = this.getBillColl(ctx, billList);
            if (InterfaceTypeEnum.chloan_writeback_loan.getName().equals(operatorNumber)) {
                botMap = new HashMap<String, BOTMappingInfo>();
                botInfo = null;
                botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                CreditorGroupCollection cgcoll = CreditorGroupFactory.getLocalInstance((Context)ctx).getCreditorGroupCollection();
                CreditorGroupInfo cgInfo = cgcoll.get(0);
                for (int i2 = 0; i2 < billColl.size(); ++i2) {
                    try {
                        billInfo = billColl.get(i2);
                        CoreBillBaseCollection srcColl = new CoreBillBaseCollection();
                        srcColl.add((CoreBillBaseInfo)billInfo);
                        if (botMap.containsKey(billInfo.getCompany().getId().toString())) {
                            botInfo = (BOTMappingInfo)botMap.get(billInfo.getCompany().getId().toString());
                        } else {
                            botInfo = ChLoanSmartFilter.getBotMappingInfo(ctx, billInfo.getCU(), billInfo.getBOSType().toString(), LoanInfo.BOSTYPE.toString(), botMapping, (CoreBillBaseInfo)billInfo);
                            botMap.put(billInfo.getCompany().getId().toString(), botInfo);
                            logger.error((Object)("\u516c\u53f8+name \uff1a" + billInfo.getCompany().getName() + "\uff0cID\uff1a" + billInfo.getCompany().getId().toString() + "\u5339\u914d\u7684botp\u89c4\u5219\u662f\uff1a" + botInfo.getAlias() + "\uff0c\u89c4\u5219ID\uff1a" + botInfo.getId().toString()));
                        }
                        this.transforBillForTranstation(ctx, srcColl, botInfo, cgInfo);
                        DbUtil.execute((Context)ctx, (String)(" update T_IVT_ChLoan set FSmartOperator= '" + operatorNumber + "' , FSmartState = 'success'  where fid = '" + billInfo.getId().toString() + "'"));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.chloan_repay.getName().equals(operatorNumber)) {
                botMap = new HashMap();
                botInfo = null;
                botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                repayamtMap = new HashMap<String, Object>();
                todaydate = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                cal = Calendar.getInstance();
                cal.setTimeInMillis(todaydate.getTime());
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                for (i = 0; i < billColl.size(); ++i) {
                    try {
                        billInfo = billColl.get(i);
                        ChLoanEntryInfo entryInfo = new ChLoanEntryInfo();
                        for (int j = 0; j < billInfo.getEntrys().size(); ++j) {
                            entryInfo = billInfo.getEntrys().get(j);
                            if (!df.format(entryInfo.getReturnDate()).equals(df.format(cal.getTime()))) continue;
                            repayamtMap.put(billInfo.getId().toString(), entryInfo.getSchemeReturnAmt());
                            repayamtMap.put(operatorNumber, entryInfo);
                            repayamtMap.put("operatorNumber", operatorNumber);
                            repayamtMap.put("chLoanEntryInfo", entryInfo);
                            break;
                        }
                        CoreBillBaseCollection srcColl = new CoreBillBaseCollection();
                        srcColl.add((CoreBillBaseInfo)billInfo);
                        if (botMap.containsKey(billInfo.getCompany().getId().toString())) {
                            botInfo = (BOTMappingInfo)botMap.get(billInfo.getCompany().getId().toString());
                        } else {
                            botInfo = ChLoanSmartFilter.getBotMappingInfo(ctx, billInfo.getCU(), billInfo.getBOSType().toString(), new EntRepaymentBillInfo().getBOSType().toString(), botMapping, (CoreBillBaseInfo)billInfo);
                            botMap.put(billInfo.getCompany().getId().toString(), botInfo);
                            logger.error((Object)("\u516c\u53f8+name \uff1a" + billInfo.getCompany().getName() + "\uff0cID\uff1a" + billInfo.getCompany().getId().toString() + "\u5339\u914d\u7684botp\u89c4\u5219\u662f\uff1a" + botInfo.getAlias() + "\uff0c\u89c4\u5219ID\uff1a" + botInfo.getId().toString()));
                        }
                        this.transforBillForEntRepay(ctx, srcColl, botInfo, repayamtMap);
                        DbUtil.execute((Context)ctx, (String)(" update T_IVT_ChLoan set FSmartOperator= '" + operatorNumber + "' , FSmartState = 'success'  where fid = '" + billInfo.getId().toString() + "'"));
                        if (entryInfo.getId() != null) {
                            DbUtil.execute((Context)ctx, (String)(" update T_IVT_ChLoanEntry set FIsExecute= 1 where fid = '" + entryInfo.getId().toString() + "'"));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.chloan_overdue_repay.getName().equals(operatorNumber)) {
                botMap = new HashMap();
                botInfo = null;
                botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                repayamtMap = new HashMap();
                todaydate = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                cal = Calendar.getInstance();
                cal.setTimeInMillis(todaydate.getTime());
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                for (i = 0; i < billColl.size(); ++i) {
                    try {
                        billInfo = billColl.get(i);
                        BigDecimal innerBalance = this.getBalanceByInner(ctx, billInfo.getCurrency(), billInfo.getLoanAccount());
                        BigDecimal loanBalance = billInfo.getLoanBalance();
                        BigDecimal balance = innerBalance.compareTo(loanBalance) < 0 ? innerBalance : loanBalance;
                        repayamtMap.put(billInfo.getId().toString(), balance);
                        repayamtMap.put("operatorNumber", operatorNumber);
                        CoreBillBaseCollection srcColl = new CoreBillBaseCollection();
                        srcColl.add((CoreBillBaseInfo)billInfo);
                        if (botMap.containsKey(billInfo.getCompany().getId().toString())) {
                            botInfo = (BOTMappingInfo)botMap.get(billInfo.getCompany().getId().toString());
                        } else {
                            botInfo = ChLoanSmartFilter.getBotMappingInfo(ctx, billInfo.getCU(), billInfo.getBOSType().toString(), new EntRepaymentBillInfo().getBOSType().toString(), botMapping, (CoreBillBaseInfo)billInfo);
                            botMap.put(billInfo.getCompany().getId().toString(), botInfo);
                            logger.error((Object)("\u516c\u53f8+name \uff1a" + billInfo.getCompany().getName() + "\uff0cID\uff1a" + billInfo.getCompany().getId().toString() + "\u5339\u914d\u7684botp\u89c4\u5219\u662f\uff1a" + botInfo.getAlias() + "\uff0c\u89c4\u5219ID\uff1a" + botInfo.getId().toString()));
                        }
                        this.transforBillForEntRepay(ctx, srcColl, botInfo, repayamtMap);
                        DbUtil.execute((Context)ctx, (String)(" update T_IVT_ChLoan set FSmartOperator= '" + operatorNumber + "' , FSmartState = 'success'  where fid = '" + billInfo.getId().toString() + "'"));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.entrepay_writeback_repay.getName().equals(operatorNumber)) {
                botMap = new HashMap();
                botInfo = null;
                botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                repayamtMap = new HashMap();
                for (int i3 = 0; i3 < billColl.size(); ++i3) {
                    try {
                        billInfo = billColl.get(i3);
                        CoreBillBaseCollection srcColl = new CoreBillBaseCollection();
                        srcColl.add((CoreBillBaseInfo)billInfo);
                        repayamtMap.put(billInfo.getId().toString(), billInfo.getLoanBalance());
                        repayamtMap.put("operatorNumber", operatorNumber);
                        if (botMap.containsKey(billInfo.getCompany().getId().toString())) {
                            botInfo = (BOTMappingInfo)botMap.get(billInfo.getCompany().getId().toString());
                        } else {
                            botInfo = ChLoanSmartFilter.getBotMappingInfo(ctx, billInfo.getCU(), billInfo.getBOSType().toString(), new EntRepaymentBillInfo().getBOSType().toString(), botMapping, (CoreBillBaseInfo)billInfo);
                            botMap.put(billInfo.getCompany().getId().toString(), botInfo);
                            logger.error((Object)("\u516c\u53f8+name \uff1a" + billInfo.getCompany().getName() + "\uff0cID\uff1a" + billInfo.getCompany().getId().toString() + "\u5339\u914d\u7684botp\u89c4\u5219\u662f\uff1a" + botInfo.getAlias() + "\uff0c\u89c4\u5219ID\uff1a" + botInfo.getId().toString()));
                        }
                        this.transforBillForEntRepay(ctx, srcColl, botInfo, repayamtMap);
                        DbUtil.execute((Context)ctx, (String)(" update T_IVT_ChLoan set FSmartOperator= '" + operatorNumber + "' , FSmartState = 'success'  where fid = '" + billInfo.getId().toString() + "'"));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.chloan_recint_due.getName().equals(operatorNumber)) {
                for (int i4 = 0; i4 < billColl.size(); ++i4) {
                    try {
                        billInfo = billColl.get(i4);
                        this.genLoanInterestBill(ctx, billInfo, billInfo.getEndDate());
                        DbUtil.execute((Context)ctx, (String)(" update T_IVT_ChLoan set FSmartOperator= '" + operatorNumber + "' , FSmartState = 'success'  where fid = '" + billInfo.getId().toString() + "'"));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.chloan_recint_overdue.getName().equals(operatorNumber)) {
                for (int i5 = 0; i5 < billColl.size(); ++i5) {
                    try {
                        billInfo = billColl.get(i5);
                        this.genLoanInterestBill(ctx, billInfo, new Date());
                        DbUtil.execute((Context)ctx, (String)(" update T_IVT_ChLoan set FSmartOperator= '" + operatorNumber + "' , FSmartState = 'success'  where fid = '" + billInfo.getId().toString() + "'"));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }

    private void genLoanInterestBill(Context ctx, ChLoanInfo billInfo, Date endDate) throws BOSException, EASBizException {
        HashSet<String> idset = new HashSet<String>();
        idset.add(billInfo.getId().toString());
        LoanInterestBillCollection intcoll = LoanInterestBillFactory.getLocalInstance(ctx).batchRecIntWithFpItem(idset, billInfo.getLastSettleDate(), endDate);
        for (int j = 0; j < intcoll.size(); ++j) {
            LoanInterestBillInfo intInfo = intcoll.get(j);
            intInfo.setInterestToPay(intInfo.getPunishInterestActual().add(intInfo.getInterestAcctual()));
            intInfo.setInterestActual(FMHelper.add((BigDecimal)intInfo.getInterestAcctual(), (BigDecimal)intInfo.getPunishInterestActual()));
            intInfo.setBizDate(new Date());
        }
        LoanInterestBillFactory.getLocalInstance(ctx).batchSubmitWithFmItem(intcoll, true);
    }

    private static BOTMappingInfo getBotMappingInfo(Context ctx, CtrlUnitInfo cu, String srcBosType, String destBosType, IBOTMapping botMapping, CoreBillBaseInfo billInfo) throws BOSException, BOTPException, FMException {
        BOTMappingInfo botMappingInfo;
        if (cu == null) {
            botMappingInfo = botMapping.getMapping(billInfo, destBosType, DefineSysEnum.BTP);
        } else {
            HashMap<String, CtrlUnitInfo> transmitContext = new HashMap<String, CtrlUnitInfo>();
            transmitContext.put("TRANSMITCU", cu);
            BOTMappingCollection btps = botMapping.getMappingCollectionForSelectUseRuleFilter(srcBosType, destBosType, DefineSysEnum.BTP, transmitContext, null, null, null, null);
            if (btps.size() == 0) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"418_ChLoanSmartFilter", (Locale)ctx.getLocale()) + cu.getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"419_ChLoanSmartFilter", (Locale)ctx.getLocale()) + srcBosType + ",destType=" + destBosType});
            }
            botMappingInfo = btps.get(0);
        }
        if (botMappingInfo == null) {
            throw new FMException(FMException.NODESTBILL);
        }
        return botMappingInfo;
    }

    private ChLoanCollection getBillColl(Context ctx, List billList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billList), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("loanAccount.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        view.setSelector(sic);
        ChLoanCollection coll = ChLoanFactory.getLocalInstance(ctx).getChLoanCollection(view);
        return coll;
    }

    public BTPTransformResult transforBillForTranstation(Context ctx, CoreBillBaseCollection srcColl, BOTMappingInfo botMapping, CreditorGroupInfo cgInfo) throws BOSException, EASBizException {
        BTPTransformResult btpResult = null;
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        btpResult = btp.transform(srcColl, botMapping);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
        int size = destBillCols.size();
        for (int i = 0; i < size; ++i) {
            LoanInfo info = (LoanInfo)destBillCols.getObject(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCreditorGroup())) {
                info.setCreditorGroup(cgInfo);
            }
            if (EmptyUtil.isEmpty((Object)info.getAmountLocalCur())) {
                info.setAmountLocalCur(FMHelper.multiply((BigDecimal)info.getAmount(), (BigDecimal)info.getLocalCurExRate()));
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getType()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getSource())) {
                info.setSource(info.getType().getFinancingSource());
            }
            btp.submitRelations((CoreBillBaseInfo)destBillCols.getObject(i), botRelateColl);
        }
        return btpResult;
    }

    public BTPTransformResult transforBillForEntRepay(Context ctx, CoreBillBaseCollection srcColl, BOTMappingInfo botMapping, Map entAmtMap) throws BOSException, EASBizException {
        Map srcInfoMap = IvtSmartUtil.getSrcInfoMap(srcColl);
        BTPTransformResult btpResult = null;
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        btpResult = btp.transform(srcColl, botMapping);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
        int size = destBillCols.size();
        for (int i = 0; i < size; ++i) {
            LoanInterestBillInfo intInfo = null;
            EntRepaymentBillInfo entrepayInfo = (EntRepaymentBillInfo)destBillCols.getObject(i);
            ChLoanInfo chLoanInfo = (ChLoanInfo)srcInfoMap.get(entrepayInfo.getLoanBillID().getId().toString());
            entrepayInfo.setRepayAmt((BigDecimal)entAmtMap.get(entrepayInfo.getLoanBillID().getId().toString()));
            entrepayInfo.setExchangeRate(chLoanInfo.getExchangeRate());
            entrepayInfo.setRepayTotalAmt(entrepayInfo.getRepayAmt().multiply(entrepayInfo.getExchangeRate()));
            entrepayInfo.setRemAmt(Constants.ZERO);
            entrepayInfo.setRepayDate(DateUtil.getDayBegin());
            entrepayInfo.setLoanCompany(chLoanInfo.getLoanAccount().getApplyUnit());
            entrepayInfo.setBank(chLoanInfo.getBank());
            entrepayInfo.setChLoanInfo(chLoanInfo);
            entrepayInfo.setLoanBillID(chLoanInfo);
            entrepayInfo.setCurrency(chLoanInfo.getCurrency());
            entrepayInfo.setReceiveBankAccount(chLoanInfo.getLoanAccount());
            entrepayInfo.setHandler(chLoanInfo.getHandler());
            entrepayInfo.setIsHistroyBill(false);
            entrepayInfo.setIsDownLoaded(false);
            entrepayInfo.setFivouchered(false);
            entrepayInfo.setPenaAmt(Constants.ZERO);
            entrepayInfo.setIntAmt(Constants.ZERO);
            entrepayInfo.setReceAmt(Constants.ZERO);
            if (!EmptyUtil.isEmpty(entAmtMap.get("operatorNumber"))) {
                if (entAmtMap.get("operatorNumber").equals("chloan_repay") && !EmptyUtil.isEmpty(entAmtMap.get("chLoanEntryInfo"))) {
                    ChLoanEntryInfo entryInfo = (ChLoanEntryInfo)entAmtMap.get("chLoanEntryInfo");
                    RepayIntTypeEnum repayIntType = entryInfo.getRepayIntType();
                    if (repayIntType.equals((Object)RepayIntTypeEnum.REPAY_INT)) {
                        entrepayInfo.setIsRepayWithAccrual(true);
                    } else {
                        entrepayInfo.setIsRepayWithAccrual(false);
                    }
                }
                if (entAmtMap.get("operatorNumber").equals("chloan_overdue_repay")) {
                    entrepayInfo.setIsRepayWithAccrual(true);
                }
            }
            entrepayInfo.setLoanInnerAccount(chLoanInfo.getDistributeAccou());
            entrepayInfo.setRepaySeq(this.initRepayRecord(ctx, chLoanInfo.getId().toString()));
            if (entrepayInfo.isIsRepayWithAccrual()) {
                Date startDate = this.getStartDate(entrepayInfo);
                Date endDate = this.getEndDate(entrepayInfo);
                if (entAmtMap.get("operatorNumber").equals("chloan_repay") && !EmptyUtil.isEmpty(entAmtMap.get("chLoanEntryInfo"))) {
                    ChLoanEntryInfo entryInfo = (ChLoanEntryInfo)entAmtMap.get("chLoanEntryInfo");
                    endDate = entryInfo.getReturnDate();
                }
                if ((intInfo = LoanInterestBillFactory.getLocalInstance(ctx).calInt(startDate, endDate, entrepayInfo)).getStrikeAmount() == null) {
                    intInfo.setStrikeAmount(Constants.ZERO);
                }
                intInfo.setIsDownLoaded(false);
                intInfo.setEntRepaymentBillInfo(entrepayInfo);
            }
            IObjectPK intPK = null;
            if (entrepayInfo.isIsRepayWithAccrual() && !EmptyUtil.isEmpty(intInfo)) {
                intPK = LoanInterestBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)intInfo);
                continue;
            }
            IObjectPK iObjectPK = btp.submitRelations((CoreBillBaseInfo)destBillCols.getObject(i), botRelateColl);
        }
        return btpResult;
    }

    private int initRepayRecord(Context ctx, String loanId) {
        Map repayRecord = null;
        try {
            repayRecord = EntRepaymentBillFactory.getLocalInstance(ctx).getInitEditData((IObjectPK)new ObjectUuidPK(loanId));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        Integer maxSeq = (Integer)repayRecord.get("maxseq");
        return maxSeq;
    }

    protected BigDecimal getBalanceByInner(Context ctx, CurrencyInfo currencyInfo, InnerAccountInfo innerAcctInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || innerAcctInfo == null) {
            return Constants.ZERO;
        }
        String key = innerAcctInfo.getId().toString() + currencyInfo.getId().toString();
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAcctInfo.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(chCompany.getId().toString());
        Date unSettleDate = clearingHouse.getSettleDate();
        BigDecimal balance = InAcctFactory.getLocalInstance((Context)ctx).inAcct(chCompany.getNumber(), innerAcctInfo.getNumber(), currencyInfo.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    private Date getStartDate(EntRepaymentBillInfo entRepayInfo) {
        Date loanStartDate = entRepayInfo.getLoanBillID().getStartDate();
        Date lastIntDate = entRepayInfo.getLoanBillID().getLastSettleDate();
        if (lastIntDate == null) {
            return loanStartDate;
        }
        return this.maxDate(loanStartDate, lastIntDate);
    }

    private Date maxDate(Date date1, Date date2) {
        int i = date1.compareTo(date2);
        switch (i) {
            case 1: {
                return date1;
            }
            case -1: {
                return date2;
            }
            case 0: {
                return date1;
            }
        }
        return date1;
    }

    private Date getEndDate(EntRepaymentBillInfo entRepayInfo) {
        if (entRepayInfo.getRepayDate().compareTo(entRepayInfo.getLoanBillID().getStartDate()) == 0) {
            return entRepayInfo.getRepayDate();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(entRepayInfo.getRepayDate());
        c.add(6, -1);
        return c.getTime();
    }
}

